![logo](_assets/AtroDAM_logo_color_250.png)

# What Is AtroDAM?

AtroDAM is an [open-source digital asset management system (DAM)](https://atrodam.com), developed by AtroCore UG (haftungsbeschränkt), which is based on the [AtroCore](https://github.com/atrocore/atrocore) software platform. AtroDAM (as well as AtroCore) is distributed under GPLv3 License and is free. It has a lot of features right out-of-the-box and thus is an excellent tool for managing media assets as well as different kinds of other digital assets and their derivatives.

AtroDAM is a single page application (SPA) with an API-centric and service-oriented architecture (SOA). It has a flexible data model based on entities and relations of all kinds among them.  AtroDAM allows you to gather, store, and organize all kinds of digital assets in one place.

![banner](_assets/atrodam-product-en.png)

## What Are the Advantages of AtroDAM?

- Many out-of-the-box features
- Free – 100% open source, licensed under GPLv3
- REST API
- Service-oriented architecture (SOA)
- Responsive and user friendly UI
- Configurable (entities, relations, layouts, labels, navigation, dashboards, etc.)
- Extensible with [modules](https://atrodam.com/product) 
- Includes advantages of [AtroCore](https://github.com/atrocore/atrocore).

## Features

AtroDAM comes with a lot of features directly out of the box, including:

- different types of media and other digital assets;
- private and public ownership of the digital assets;
- mass upload;
- advanced configuration and quality control;
- automatic check for duplicates;
- extracting of metadata information;
- taxonomies – asset categories and tagging;
- asset relations;
- content management;
- asset collections;
- automatic versioning and creation of renditions (additional [modules](https://atrodam.com/product) are needed); 
- and much more.

Want to learn more about the AtroDAM functions and its advantages for you? Please, visit our [website](https://atrodam.com/features)! 

## Technology

AtroCore is based on EspoCRM and uses PHP7, backbone.js, and Composer.

Want to know more about AtroDAM technology? Please, visit our [website](https://atrodam.com/features)!

## Integrations

AtroDAM has a REST API and can be integrated with any third-party system. The out-of-the-box AtroDAM is integrated with [AtroPIM](https://github.com/atrocore/atropim), which is our another open source application for Product Information Management.

Please, [ask](https://atrodam.com/contact), if you want to know more.

## Documentation
Please visit our Help Center: https://help.atrocore.com/

### Requirements

* Dedicated (virtual) Linux-based server with root permissions. 
* Ubuntu as Operating System is recommended but not required.
* PHP 7.4 (or above).
* MySQL 5.5.3 (or above) or PostgreSQL 14.9 (or above).

> Please note, system will definitely NOT work on a usual hosting, a managed server hosting should be checked on a case-by-case basis – with a high probability it will NOT work.


### Installation

Installation Guide is available [here](https://help.atrocore.com/atrocore/admin-guide/installation/).

### Demo
- URL: https://demo.atrodam.com/
- Login: admin
- Password: admin

## License

AtroDAM is published under the GNU GPLv3 [license](https://github.com/atrocore/atrodam/blob/master/LICENSE.txt).

## Support

- Report a Bug - https://github.com/atrocore/atrocore/issues/new
- Ask the Community - https://github.com/atrocore/atrocore/discussions
- Сontact us - https://atrocore.com/contact
