#!/bin/sh
#
# SPDX-License-Identifier: ISC
# SPDX-URL: https://spdx.org/licenses/ISC.html
#
# Copyright (C) 2009 Atheme Project (http://atheme.org/)
#
# atheme-services: A collection of minimalist IRC services
# mkhooktypes.sh: Code generator for type-safe hooks.
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.

if [ "$#" != 1 ]; then
	echo "Usage: $0 specfile >hfile" >&2
	exit 64
fi

echo "/* Generated by $0 from $1, do not edit! */"
echo '/* Type checking for hook functions */'
echo
echo '#ifndef ATHEME_INC_HOOKTYPES_H'
echo '#define ATHEME_INC_HOOKTYPES_H 1'
echo

while read hook type; do
	case $hook:$type in
	[#]*|:)
		continue
		;;
	*:void)
		echo "#define hook_call_$hook() hook_call_event(\"$hook\", NULL)"
		# Still require a dummy void * function parameter here.
		echo "#define hook_add_$hook(f) hook_add_hook(\"$hook\", f)"
		echo "#define hook_add_first_$hook(f) hook_add_hook_first(\"$hook\", f)"
		echo "#define hook_del_$hook(f) hook_del_hook(\"$hook\", f)"
		;;
	*)
		echo "#define hook_call_$hook(x) hook_call_event(\"$hook\", ENSURE_TYPE(x, $type))"
		echo "#define hook_add_$hook(f) hook_add_hook(\"$hook\", (void (*)(void *))ENSURE_TYPE(f, void (*)($type)))"
		echo "#define hook_add_first_$hook(f) hook_add_hook_first(\"$hook\", (void (*)(void *))ENSURE_TYPE(f, void (*)($type)))"
		echo "#define hook_del_$hook(f) hook_del_hook(\"$hook\", (void (*)(void *))ENSURE_TYPE(f, void (*)($type)))"
		;;
	esac
done < "$1"

echo
echo '#endif /* !ATHEME_INC_HOOKTYPES_H */'
