/**
 * Copyright (C) 2010 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.wicket.components.report;

import java.io.Serializable;

import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Instantiates a new report throwable bean for the wicket model that is used to report an exception
 * or error an a description from the affected user.
 */
@Getter
@Setter
@EqualsAndHashCode
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ReportThrowableModelBean implements Serializable
{

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;

	/** The affected username. */
	private String affectedUsername;

	/** The root username. */
	private String rootUsername;

	/** The stack trace. */
	private String stackTrace;

	/** The stack trace. */
	private String description;

	/** The response page. This page will be used to redirect on with setResponsePage method. */
	private Class<? extends IRequestablePage> responsePage;

	/** The throwable. */
	private Throwable throwable;

	/** The original response as {@link String} object from the {@link RequestCycle}. */
	private String originalResponse;

}
