# Unicode Emoji Library

This unit provides constants for various Unicode emojis in Delphi. Each emoji is represented by a string constant for easy integration into your Delphi projects.

## Usage

1. Include the `UnicodeEmoji` unit in your Delphi project.
2. Access the emojis using the `TEmojiConstants` record.

```delphi
uses
  UnicodeEmoji;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShowMessage('Hello ' + TEmojiConstants.WavingHand);
end;
```

## Emoji List

| Emoji Name                       | Constant Name                | Emoji Code    |
|----------------------------------|------------------------------|---------------|
| Aubergine                        | Aubergine                    | 🍆            |
| Grinning Face                    | GrinningFace                 | 😀            |
| Grinning Face With Big Eyes      | GrinningFaceWithBigEyes      | 😃            |
| Grinning Face With Smiling Eyes  | GrinningFaceWithSmilingEyes  | 😄            |
| Beaming Face With Smiling Eyes   | BeamingFaceWithSmilingEyes   | 😁            |
| Grinning Squinting Face          | GrinningSquintingFace        | 😆            |
| Grinning Face With Sweat         | GrinningFaceWithSweat        | 😅            |
| Rolling On The Floor Laughing    | RollingOnTheFloorLaughing    | 🤣            |
| Face With Tears Of Joy           | FaceWithTearsOfJoy           | 😂            |
| Slightly Smiling Face            | SlightlySmilingFace          | 🙂            |
| Upside Down Face                 | UpsideDownFace               | 🙃            |
| Winking Face                     | WinkingFace                  | 😉            |
| Smiling Face With Smiling Eyes   | SmilingFaceWithSmilingEyes   | 😊            |
| Smiling Face With Halo           | SmilingFaceWithHalo          | 😇            |
| Smiling Face With Hearts         | SmilingFaceWithHearts        | 🥰            |
| Smiling Face With Heart Eyes     | SmilingFaceWithHeartEyes     | 😍            |
| Star Struck                      | StarStruck                   | 🤩            |
| Face Blowing A Kiss              | FaceBlowingAKiss             | 😘            |
| Kissing Face                     | KissingFace                  | 😗            |
| Closed Eyes Kissing              | ClosedEyesKissing            | 😚            |
| Kissing Face With Smiling Eyes   | KissingFaceWithSmilingEyes   | 😙            |
| Smiling Face                     | SmilingFace                  | ☺            |
| Hugging Face                     | HuggingFace                  | 🤗            |
| Thinking Face                    | ThinkingFace                 | 🤔            |
| Face With Raised Eyebrow         | FaceWithRaisedEyebrow        | 😏            |
| Neutral Face                     | NeutralFace                  | 😐            |
| Expressionless Face              | ExpressionlessFace           | 😑            |
| Face Without Mouth               | FaceWithoutMouth             | 😶            |
| Smirking Face                    | SmirkingFace                 | 😏            |
| Unamused Face                    | UnamusedFace                 | 😒            |
| Face With Rolling Eyes           | FaceWithRollingEyes          | 🙄            |
| Grimacing Face                   | GrimacingFace                | 😬            |
| Lying Face                       | LyingFace                    | 🤥            |
| Shushing Face                    | ShushingFace                 | 🤫            |
| Face With Hand Over Mouth        | FaceWithHandOverMouth        | 🤭            |
| Face With Monocle                | FaceWithMonocle              | 🧐            |
| Nerd Face                        | NerdFace                     | 🤓            |
| Sunglasses                       | Sunglasses                   | 😎            |
| Clown Face                       | ClownFace                    | 🤡            |
| Pouting Face                     | PoutingFace                  | 😡            |
| Angry Face                       | AngryFace                    | 😠            |
| Face With Symbols On Mouth        | FaceWithSymbolsOnMouth        | 🤬            |
| Exploding Head                   | ExplodingHead                | 😱            |
| Face With Steam From Nose         | FaceWithSteamFromNose        | 😤            |
| Hot Face                         | HotFace                      | 🥵            |
| Cold Face                        | ColdFace                     | 🥶            |
| Woozy Face                       | WoozyFace                    | 🥴            |
| Dizzy Face                       | DizzyFace                    | 😵            |
| Face With Medical Mask            | FaceWithMedicalMask           | 😷            |
| Grinning Cat Face                | GrinningCatFace              | 😺            |
| Grinning Cat Face With Smiling Eyes | GrinningCatFaceWithSmilingEyes | 😸            |
| Cat Face With Tears Of Joy       | CatFaceWithTearsOfJoy        | 😹            |
| Smiling Cat Face With Heart Eyes | SmilingCatFaceWithHeartEyes  | 😻            |
| Cat Face With Wry Smile          | CatFaceWithWrySmile          | 😼            |
| Kissing Cat Face                 | KissingCatFace               | 😽            |
| Weary Cat Face                   | WearyCatFace                 | 🙀            |
| Crying Cat Face                  | CryingCatFace                | 😿            |
| Pouting Cat Face                 | PoutingCatFace               | 😾            |
| Monkey Face                      | MonkeyFace                   | 🐵            |
| Monkey Face With Big Eyes        | MonkeyFaceWithBigEyes        | 🐒            |
| Gorilla                          | Gorilla                      | 🦍            |
| Dog Face                         | DogFace                      | 🐶            |
| Dog Face With Tongue             | DogFaceWithTongue            | 🐶            |
| Dog Face With Big Eyes           | DogFaceWithBigEyes           | 🐶            |
| Poodle                           | Poodle                       | 🐩            |
| Wolf Face                        | WolfFace                     | 🐺            |
| Fox Face                         | FoxFace                      | 🦊            |
| Cat Face                         | CatFace                      | 🐱            |
| Cat Face With Tears Of Joy       | CatFaceWithTearsOfJoy        | 🐱            |
| Pouting Cat Face                 | PoutingCatFace               | 🐱            |
| Lion Face                        | LionFace                     | 🦁            |
| Tiger Face                       | TigerFace                    | 🐯            |
| Tiger Face With Big Eyes         | TigerFaceWithBigEyes         | 🐯            |
| Leopard                          | Leopard                      | 🐆            |
| Horse Face                       | HorseFace                    | 🐴            |
| Horse Face With Goggles          | HorseFaceWithGoggles         | 🐴            |
| Zebra                            | Zebra                        | 🦓            |
| Deer                             | Deer                         | 🦌            |
| Bison                            | Bison                        | 🦬            |
| Cow Face                         | CowFace                      | 🐮            |
| Ox                               | Ox                           | 🐂            |
| Water Buffalo                    | WaterBuffalo                 | 🐃            |
| Cow Face With Big Eyes           | CowFaceWithBigEyes           | 🐄            |
| Pig Face                         | PigFace                      | 🐷            |
| Pig Face With Big Eyes           | PigFaceWithBigEyes           | 🐽            |
| Boar                             | Boar                         | 🐗            |
| Pig Nose                         | PigNose                      | 🐽            |
| Ram                              | Ram                          | 🐏            |
| Sheep                            | Sheep                        | 🐑            |
| Goat                             | Goat                         | 🐐            |
| Camel                            | Camel                        | 🐫            |
| Two-Hump Camel                   | TwoHumpCamel                 | 🐫            |
| Elephant                         | Elephant                     | 🐘            |
| Mammoth                          | Mammoth                      | 🦣            |
| Rat                              | Rat                          | 🐀            |
| Mouse Face                       | MouseFace                    | 🐭            |
| Mouse Face With Big Eyes         | MouseFaceWithBigEyes         | 🐭            |
| Rat                              | Rat                          | 🐀            |
| Hamster Face                     | HamsterFace                  | 🐹            |
| Rabbit Face                      | RabbitFace                   | 🐰            |
| Rabbit Face With Big Eyes        | RabbitFaceWithBigEyes        | 🐰            |
| Hedgehog                         | Hedgehog                     | 🦔            |
| Bat                              | Bat                          | 🦇            |
| Bear Face                        | BearFace                     | 🐻            |
| Koala                            | Koala                        | 🐨            |
| Panda Face                       | PandaFace                    | 🐼            |
| Sloth                            | Sloth                        | 🦥            |
| Otter                            | Otter                        | 🦦            |
| Skunk                            | Skunk                        | 🦨            |
| Kangaroo                         | Kangaroo                     | 🦘            |
| Badger                           | Badger                       | 🦡            |
| Paw Prints                       | PawPrints                    | 🐾            |
| Turkey                           | Turkey                       | 🦃            |
| Chicken                          | Chicken                      | 🐔            |
| Rooster                          | Rooster                      | 🐓            |
| Hatching Chick                   | HatchingChick                | 🐣            |
| Baby Chick                       | BabyChick                    | 🐤            |
| Front-Facing Baby Chick          | FrontFacingBabyChick         | 🐥            |
| Bird                             | Bird                         | 🐦            |
| Penguin                          | Penguin                      | 🐧            |
| Dove                             | Dove                         | 🕊            |
| Eagle                            | Eagle                        | 🦅            |
| Duck                             | Duck                         | 🦆            |
| Swan                             | Swan                         | 🦢            |
| Owl                              | Owl                          | 🦉            |
| Dodo                             | Dodo                         | 🦤            |
| Feather                          | Feather                      | 🪶            |
| Flamingo                         | Flamingo                     | 🦩            |
| Peacock                          | Peacock                      | 🦚            |
| Parrot                           | Parrot                       | 🦜            |
| Frog                             | Frog                         | 🐸            |
| Crocodile                        | Crocodile                    | 🐊            |
| Turtle                           | Turtle                       | 🐢            |
| Lizard                           | Lizard                       | 🦎            |
| Snake                            | Snake                        | 🐍            |
| Dragon Face                      | DragonFace                   | 🐲            |
| Dragon                           | Dragon                       | 🐉            |
| Spouting Whale                   | SpoutingWhale                | 🐳            |
| Whale                            | Whale                        | 🐋            |
| Dolphin                          | Dolphin                      | 🐬            |
| Fish                             | Fish                         | 🐟            |
| Tropical Fish                    | TropicalFish                 | 🐠            |
| Blowfish                         | Blowfish                     | 🐡            |
| Shark                            | Shark                        | 🦈            |
| Octopus                          | Octopus                      | 🐙            |
| Spiral Shell                     | SpiralShell                  | 🐚            |
| Snail                            | Snail                        | 🐌            |
| Butterfly                        | Butterfly                    | 🦋            |
| Bug                              | Bug                          | 🐛            |
| Ant                              | Ant                          | 🐜            |
| Honeybee                         | Honeybee                     | 🐝            |
| Lady Beetle                      | LadyBeetle                   | 🐞            |
| Cricket                          | Cricket                      | 🦗            |
| Spider                           | Spider                       | 🕷            |
| Spider Web                       | SpiderWeb                    | 🕸            |
| Scorpion                         | Scorpion                     | 🦂            |
| Mosquito                         | Mosquito                     | 🦟            |
| Microbe                          | Microbe                      | 🦠            |
| Bouquet                          | Bouquet                      | 💐            |
| Cherry Blossom                   | CherryBlossom                | 🌸            |
| White Flower                     | WhiteFlower                  | 💮            |
| Rosette                          | Rosette                      | 🏵            |
| Rose                             | Rose                         | 🌹            |
| Wilted Flower                    | WiltedFlower                 | 🥀            |
| Hibiscus                         | Hibiscus                     | 🌺            |
                          
## Note

Make sure to check the Unicode Emoji documentation for any updates or new emojis added to the Unicode standard.

Feel free to contribute by adding more emojis or improving the existing code.

Enjoy using emojis in your Delphi projects! 😊🎉
