/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

class ObjectReaderImplMapTyped
implements ObjectReader {
    final Class mapType;
    final Class instanceType;
    final Type keyType;
    final Type valueType;
    final Class valueClass;
    final long features;
    final Function builder;
    final Constructor defaultConstructor;
    ObjectReader valueObjectReader;
    ObjectReader keyObjectReader;

    public ObjectReaderImplMapTyped(Class mapType, Class instanceType, Type keyType, Type valueType, long features, Function builder) {
        Constructor<?>[] constructors;
        if (keyType == Object.class) {
            keyType = null;
        }
        this.mapType = mapType;
        this.instanceType = instanceType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.valueClass = TypeUtils.getClass(valueType);
        this.features = features;
        this.builder = builder;
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : constructors = this.instanceType.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0 || Modifier.isPublic(constructor.getModifiers())) continue;
            constructor.setAccessible(true);
            defaultConstructor = constructor;
            break;
        }
        this.defaultConstructor = defaultConstructor;
    }

    public Class getObjectClass() {
        return this.mapType;
    }

    public Object createInstance(Map input, long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Map object = (Map)this.createInstance();
        for (Map.Entry entry : input.entrySet()) {
            String fieldName = entry.getKey().toString();
            Object fieldValue = entry.getValue();
            Object value = fieldValue;
            if (value != null) {
                Class<?> valueClass = value.getClass();
                Function typeConvert = provider.getTypeConvert(valueClass, this.valueType);
                if (typeConvert != null) {
                    value = typeConvert.apply(value);
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    if (this.valueObjectReader == null) {
                        this.valueObjectReader = provider.getObjectReader(this.valueType);
                    }
                    value = this.valueObjectReader.createInstance(map, features);
                } else if (value instanceof Collection) {
                    if (this.valueObjectReader == null) {
                        this.valueObjectReader = provider.getObjectReader(this.valueType);
                    }
                    value = this.valueObjectReader.createInstance((Collection)value);
                } else if (!valueClass.isInstance(value)) {
                    throw new JSONException("can not convert from " + valueClass + " to " + this.valueType);
                }
            }
            object.put(fieldName, value);
        }
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }

    public Object createInstance(long features) {
        if (this.instanceType != null && !this.instanceType.isInterface()) {
            try {
                if (this.defaultConstructor != null) {
                    return this.defaultConstructor.newInstance(new Object[0]);
                }
                return this.instanceType.newInstance();
            }
            catch (Exception e) {
                throw new JSONException("create map error", e);
            }
        }
        return new HashMap();
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        byte firstType;
        ObjectReader objectReader = null;
        Function builder = this.builder;
        if (jsonReader.getType() == -110 && (objectReader = jsonReader.checkAutoType(this.mapType, 0L, this.features | features)) != null && objectReader != this) {
            builder = objectReader.getBuildFunction();
            if (!(objectReader instanceof ObjectReaderImplMap) && !(objectReader instanceof ObjectReaderImplMapTyped)) {
                return objectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
            }
        }
        if ((firstType = jsonReader.getType()) == -81) {
            jsonReader.next();
            return null;
        }
        if (firstType == -90) {
            jsonReader.next();
        }
        JSONReader.Context context = jsonReader.getContext();
        long contextFeatures = features | context.getFeatures();
        Map<Object, Map<Object, Object>> object = objectReader != null ? (Map<Object, Map<Object, Object>>)objectReader.createInstance(contextFeatures) : (this.instanceType == HashMap.class ? new HashMap() : (Map)this.createInstance());
        int i = 0;
        while (true) {
            String reference;
            Object name;
            byte type;
            if ((type = jsonReader.getType()) == -91) break;
            if (this.keyType == String.class || jsonReader.isString()) {
                name = jsonReader.readFieldName();
            } else if (jsonReader.isReference()) {
                reference = jsonReader.readReference();
                name = new ReferenceKey(i);
                jsonReader.addResolveTask(object, name, JSONPath.of(reference));
            } else {
                if (this.keyObjectReader == null && this.keyType != null) {
                    this.keyObjectReader = jsonReader.getObjectReader(this.keyType);
                }
                name = this.keyObjectReader == null ? jsonReader.readAny() : this.keyObjectReader.readJSONBObject(jsonReader, null, null, features);
            }
            if (jsonReader.isReference()) {
                reference = jsonReader.readReference();
                if ("..".equals(reference)) {
                    object.put(name, object);
                } else {
                    jsonReader.addResolveTask(object, name, JSONPath.of(reference));
                    if (!(object instanceof ConcurrentMap)) {
                        object.put(name, null);
                    }
                }
            } else if (jsonReader.nextIfNull()) {
                object.put(name, null);
            } else {
                Object value;
                if (this.valueType == Object.class) {
                    value = jsonReader.readAny();
                } else {
                    ObjectReader autoTypeValueReader = jsonReader.checkAutoType(this.valueClass, 0L, features);
                    if (autoTypeValueReader != null) {
                        value = autoTypeValueReader.readJSONBObject(jsonReader, this.valueType, name, features);
                    } else {
                        if (this.valueObjectReader == null) {
                            this.valueObjectReader = jsonReader.getObjectReader(this.valueType);
                        }
                        value = this.valueObjectReader.readJSONBObject(jsonReader, this.valueType, name, features);
                    }
                }
                object.put(name, (Map<Object, Object>)value);
            }
            ++i;
        }
        jsonReader.next();
        if (builder != null) {
            return builder.apply(object);
        }
        return object;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Map object;
        boolean match = jsonReader.nextIfMatch('{');
        if (!match) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            throw new JSONException(jsonReader.info("expect '{', but '['"));
        }
        JSONReader.Context context = jsonReader.getContext();
        long contextFeatures = context.getFeatures() | features;
        Map innerMap = null;
        if (this.instanceType == HashMap.class) {
            Supplier<Map> objectSupplier = context.getObjectSupplier();
            if (this.mapType == Map.class && objectSupplier != null) {
                object = objectSupplier.get();
                innerMap = TypeUtils.getInnerMap(object);
            } else {
                object = new HashMap();
            }
        } else {
            object = (HashMap)this.createInstance(contextFeatures);
        }
        int i = 0;
        while (!jsonReader.nextIfMatch('}') && !jsonReader.isEnd()) {
            block28: {
                String name;
                block25: {
                    block29: {
                        block30: {
                            String typeName;
                            ObjectReader objectReaderAutoType;
                            block26: {
                                block27: {
                                    block24: {
                                        if (!jsonReader.nextIfNull()) break block24;
                                        if (!jsonReader.nextIfMatch(':')) {
                                            throw new JSONException(jsonReader.info("illegal json"));
                                        }
                                        name = null;
                                        break block25;
                                    }
                                    if (this.keyType != String.class) break block26;
                                    name = jsonReader.readFieldName();
                                    if (i != 0 || (contextFeatures & JSONReader.Feature.SupportAutoType.mask) == 0L || !name.equals(this.getTypeKey())) break block27;
                                    long typeHashCode = jsonReader.readTypeHashCode();
                                    objectReaderAutoType = context.getObjectReaderAutoType(typeHashCode);
                                    if (objectReaderAutoType == null) {
                                        typeName = jsonReader.getString();
                                        objectReaderAutoType = context.getObjectReaderAutoType(typeName, this.mapType, features);
                                    }
                                    if (objectReaderAutoType != null && objectReaderAutoType instanceof ObjectReaderImplMap && !object.getClass().equals(((ObjectReaderImplMap)objectReaderAutoType).instanceType)) {
                                        object = (Map)objectReaderAutoType.createInstance(features);
                                    }
                                    break block28;
                                }
                                if (name == null) {
                                    name = jsonReader.readString();
                                    if (!jsonReader.nextIfMatch(':')) {
                                        throw new JSONException(jsonReader.info("illegal json"));
                                    }
                                }
                                break block25;
                            }
                            if (i != 0 || !jsonReader.isEnabled(JSONReader.Feature.SupportAutoType) || jsonReader.current() != '\"') break block29;
                            name = jsonReader.readFieldName();
                            if (!name.equals(this.getTypeKey())) break block30;
                            long typeHashCode = jsonReader.readTypeHashCode();
                            objectReaderAutoType = context.getObjectReaderAutoType(typeHashCode);
                            if (objectReaderAutoType == null) {
                                typeName = jsonReader.getString();
                                objectReaderAutoType = context.getObjectReaderAutoType(typeName, this.mapType, features);
                            }
                            if (objectReaderAutoType != null && objectReaderAutoType instanceof ObjectReaderImplMap && !object.getClass().equals(((ObjectReaderImplMap)objectReaderAutoType).instanceType)) {
                                object = (Map)objectReaderAutoType.createInstance(features);
                            }
                            break block28;
                        }
                        throw new JSONException("not support name " + name);
                    }
                    name = this.keyObjectReader != null ? this.keyObjectReader.readObject(jsonReader, null, null, 0L) : jsonReader.read(this.keyType);
                    if (i == 0 && (contextFeatures & JSONReader.Feature.SupportAutoType.mask) != 0L && name.equals(this.getTypeKey())) break block28;
                    jsonReader.nextIfMatch(':');
                }
                if (this.valueObjectReader == null) {
                    this.valueObjectReader = jsonReader.getObjectReader(this.valueType);
                }
                Object value = this.valueObjectReader.readObject(jsonReader, fieldType, fieldName, 0L);
                Object origin = innerMap != null ? innerMap.put(name, value) : object.put(name, value);
                if (origin != null && (contextFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value);
                        object.put(name, origin);
                    } else {
                        JSONArray array = JSONArray.of(origin, value);
                        object.put(name, array);
                    }
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }
}

