/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderPrimitive;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

final class ObjectReaderImplFloatArray
extends ObjectReaderPrimitive {
    static final ObjectReaderImplFloatArray INSTANCE = new ObjectReaderImplFloatArray();

    ObjectReaderImplFloatArray() {
        super(Float[].class);
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfMatch('[')) {
            Float[] values2 = new Float[16];
            int size = 0;
            while (!jsonReader.nextIfMatch(']')) {
                if (jsonReader.isEnd()) {
                    throw new JSONException(jsonReader.info("input end"));
                }
                int minCapacity = size + 1;
                if (minCapacity - values2.length > 0) {
                    int oldCapacity = values2.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity - minCapacity < 0) {
                        newCapacity = minCapacity;
                    }
                    values2 = Arrays.copyOf(values2, newCapacity);
                }
                values2[size++] = jsonReader.readFloat();
            }
            jsonReader.nextIfMatch(',');
            return Arrays.copyOf(values2, size);
        }
        if (jsonReader.isString()) {
            String str = jsonReader.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw new JSONException(jsonReader.info("not support input " + str));
        }
        throw new JSONException(jsonReader.info("TODO"));
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        int entryCnt = jsonReader.startArray();
        if (entryCnt == -1) {
            return null;
        }
        Float[] array = new Float[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            array[i] = jsonReader.readFloat();
        }
        return array;
    }

    @Override
    public Object createInstance(Collection collection) {
        Float[] array = new Float[collection.size()];
        int i = 0;
        for (Object item : collection) {
            Float value;
            if (item == null) {
                value = null;
            } else if (item instanceof Number) {
                value = Float.valueOf(((Number)item).floatValue());
            } else {
                Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(item.getClass(), (Type)((Object)Float.class));
                if (typeConvert == null) {
                    throw new JSONException("can not cast to Float " + item.getClass());
                }
                value = (Float)typeConvert.apply(item);
            }
            array[i++] = value;
        }
        return array;
    }
}

