/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegmentName;
import com.alibaba.fastjson2.JSONPathSingle;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

final class JSONPathSingleName
extends JSONPathSingle {
    final long nameHashCode;
    final String name;

    public JSONPathSingleName(String path, JSONPathSegmentName segment, JSONPath.Feature ... features) {
        super(segment, path, features);
        this.name = segment.name;
        this.nameHashCode = segment.nameHashCode;
    }

    @Override
    public Object eval(Object root) {
        Object value;
        if (root instanceof Map) {
            Map map = (Map)root;
            value = map.get(this.name);
            if (value == null) {
                boolean isNum = IOUtils.isNumber(this.name);
                Long longValue = null;
                for (Map.Entry o : map.entrySet()) {
                    Map.Entry entry = o;
                    Object entryKey = entry.getKey();
                    if (entryKey instanceof Enum && ((Enum)entryKey).name().equals(this.name)) {
                        value = entry.getValue();
                    } else {
                        if (!(entryKey instanceof Long)) continue;
                        if (longValue == null && isNum) {
                            longValue = Long.parseLong(this.name);
                        }
                        if (!entryKey.equals(longValue)) continue;
                        value = entry.getValue();
                    }
                    break;
                }
            }
        } else {
            JSONWriter.Context writerContext = this.getWriterContext();
            ObjectWriter<?> objectWriter = writerContext.getObjectWriter(root.getClass());
            if (objectWriter == null) {
                return null;
            }
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldWriter == null) {
                return null;
            }
            value = fieldWriter.getFieldValue(root);
        }
        if ((this.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L) {
            value = value == null ? new JSONArray() : JSONArray.of(value);
        }
        return value;
    }

    @Override
    public boolean remove(Object root) {
        if (root == null) {
            return false;
        }
        if (root instanceof Map) {
            return ((Map)root).remove(this.name) != null;
        }
        ObjectReaderProvider provider = this.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(root.getClass());
        if (objectReader == null) {
            return false;
        }
        FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
        if (fieldReader == null) {
            return false;
        }
        try {
            fieldReader.accept(root, null);
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public boolean contains(Object root) {
        if (root instanceof Map) {
            return ((Map)root).containsKey(this.name);
        }
        ObjectWriterProvider provider = this.getWriterContext().provider;
        ObjectWriter objectWriter = provider.getObjectWriter(root.getClass());
        if (objectWriter == null) {
            return false;
        }
        FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
        if (fieldWriter == null) {
            return false;
        }
        return fieldWriter.getFieldValue(root) != null;
    }

    @Override
    public void set(Object rootObject, Object value) {
        if (rootObject instanceof Map) {
            Map map = (Map)rootObject;
            map.put(this.name, value);
            return;
        }
        ObjectReaderProvider provider = this.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(rootObject.getClass());
        FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
        if (fieldReader != null) {
            if (value != null) {
                Function typeConvert;
                Class<?> valueClass = value.getClass();
                Class fieldClass = fieldReader.fieldClass;
                if (!fieldReader.supportAcceptType(valueClass) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                    value = typeConvert.apply(value);
                }
            }
            fieldReader.accept(rootObject, value);
        } else if (objectReader instanceof ObjectReaderBean) {
            ((ObjectReaderBean)objectReader).acceptExtra(rootObject, this.name, value);
        }
    }

    @Override
    public void set(Object rootObject, Object value, JSONReader.Feature ... readerFeatures) {
        Function typeConvert;
        Class fieldClass;
        Class<?> valueClass;
        if (rootObject instanceof Map) {
            Map map = (Map)rootObject;
            Object origin = map.put(this.name, value);
            if (origin != null) {
                boolean duplicateKeyValueAsArray = false;
                for (JSONReader.Feature feature : readerFeatures) {
                    if (feature != JSONReader.Feature.DuplicateKeyValueAsArray) continue;
                    duplicateKeyValueAsArray = true;
                    break;
                }
                if (duplicateKeyValueAsArray) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value);
                        map.put(this.name, value);
                    } else {
                        JSONArray array = JSONArray.of(origin, value);
                        map.put(this.name, array);
                    }
                }
            }
            return;
        }
        ObjectReaderProvider provider = this.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(rootObject.getClass());
        FieldReader fieldReader = objectReader.getFieldReader(this.nameHashCode);
        if (value != null && (valueClass = value.getClass()) != (fieldClass = fieldReader.fieldClass) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
            value = typeConvert.apply(value);
        }
        fieldReader.accept(rootObject, value);
    }

    @Override
    public void setCallback(Object object, BiFunction callback) {
        if (object instanceof Map) {
            Map map = (Map)object;
            Object originValue = map.get(this.name);
            if (originValue != null || map.containsKey(this.name)) {
                map.put(this.name, callback.apply(map, originValue));
            }
            return;
        }
        Class<?> objectClass = object.getClass();
        if (this.readerContext == null) {
            this.readerContext = JSONFactory.createReadContext();
        }
        FieldReader fieldReader = this.readerContext.provider.getObjectReader(objectClass).getFieldReader(this.nameHashCode);
        if (this.writerContext == null) {
            this.writerContext = JSONFactory.createWriteContext();
        }
        FieldWriter fieldWriter = this.writerContext.provider.getObjectWriter(objectClass).getFieldWriter(this.nameHashCode);
        if (fieldReader != null && fieldWriter != null) {
            Object fieldValue = fieldWriter.getFieldValue(object);
            Object value = callback.apply(object, fieldValue);
            fieldReader.accept(object, value);
        }
    }

    @Override
    public void setInt(Object obejct, int value) {
        if (obejct instanceof Map) {
            ((Map)obejct).put(this.name, value);
            return;
        }
        ObjectReaderProvider provider = this.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(obejct.getClass());
        objectReader.setFieldValue(obejct, this.name, this.nameHashCode, value);
    }

    @Override
    public void setLong(Object object, long value) {
        if (object instanceof Map) {
            ((Map)object).put(this.name, value);
            return;
        }
        ObjectReaderProvider provider = this.getReaderContext().getProvider();
        ObjectReader objectReader = provider.getObjectReader(object.getClass());
        objectReader.setFieldValue(object, this.name, this.nameHashCode, value);
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        if (jsonReader.isJSONB()) {
            if (jsonReader.nextIfObjectStart()) {
                while (!jsonReader.nextIfObjectEnd()) {
                    boolean match;
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    if (nameHashCode == 0L) continue;
                    boolean bl = match = nameHashCode == this.nameHashCode;
                    if (!(match || jsonReader.isObject() || jsonReader.isArray())) {
                        jsonReader.skipValue();
                        continue;
                    }
                    if (jsonReader.isNumber()) {
                        return jsonReader.readNumber();
                    }
                    throw new JSONException("TODO");
                }
            }
            if ((this.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L) {
                return new JSONArray();
            }
            return null;
        }
        if (jsonReader.nextIfObjectStart()) {
            while (!jsonReader.nextIfObjectEnd()) {
                Object val;
                boolean match;
                long nameHashCode = jsonReader.readFieldNameHashCode();
                boolean bl = match = nameHashCode == this.nameHashCode;
                if (!match) {
                    jsonReader.skipValue();
                    continue;
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        val = jsonReader.readNumber();
                        break;
                    }
                    case '[': {
                        val = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        val = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val = null;
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
                if ((this.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L) {
                    val = val == null ? new JSONArray() : JSONArray.of(val);
                }
                return val;
            }
        }
        if ((this.features & JSONPath.Feature.AlwaysReturnList.mask) != 0L) {
            return new JSONArray();
        }
        return null;
    }

    @Override
    public String extractScalar(JSONReader jsonReader) {
        block11: {
            if (jsonReader.nextIfObjectStart()) {
                Object val;
                while (true) {
                    if (jsonReader.ch == '}') {
                        jsonReader.next();
                        break block11;
                    }
                    long nameHashCode = jsonReader.readFieldNameHashCode();
                    boolean match = nameHashCode == this.nameHashCode;
                    char ch = jsonReader.ch;
                    if (match || ch == '{' || ch == '[') break;
                    jsonReader.skipValue();
                }
                switch (jsonReader.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        val = jsonReader.readNumber();
                        break;
                    }
                    case '[': {
                        val = jsonReader.readArray();
                        break;
                    }
                    case '{': {
                        val = jsonReader.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = jsonReader.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = jsonReader.readBoolValue();
                        break;
                    }
                    case 'n': {
                        jsonReader.readNull();
                        val = null;
                        break;
                    }
                    default: {
                        throw new JSONException("TODO : " + jsonReader.ch);
                    }
                }
                return JSON.toJSONString(val);
            }
        }
        return null;
    }

    @Override
    public long extractInt64Value(JSONReader jsonReader) {
        if (jsonReader.nextIfObjectStart()) {
            while (true) {
                boolean match;
                if (jsonReader.ch == '}') {
                    jsonReader.wasNull = true;
                    return 0L;
                }
                long nameHashCode = jsonReader.readFieldNameHashCode();
                boolean bl = match = nameHashCode == this.nameHashCode;
                if (match) break;
                jsonReader.skipValue();
            }
            switch (jsonReader.ch) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return jsonReader.readInt64Value();
                }
                case '[': 
                case '{': {
                    Map<String, Object> object = jsonReader.readObject();
                    return jsonReader.toLong(object);
                }
                case '\"': 
                case '\'': {
                    String str = jsonReader.readString();
                    return Long.parseLong(str);
                }
                case 'f': 
                case 't': {
                    boolean booleanValue = jsonReader.readBoolValue();
                    return booleanValue ? 1L : 0L;
                }
                case 'n': {
                    jsonReader.readNull();
                    jsonReader.wasNull = true;
                    return 0L;
                }
                case ']': {
                    jsonReader.next();
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + jsonReader.ch);
                }
            }
        }
        jsonReader.wasNull = true;
        return 0L;
    }

    @Override
    public int extractInt32Value(JSONReader jsonReader) {
        if (jsonReader.nextIfObjectStart()) {
            while (true) {
                boolean match;
                if (jsonReader.ch == '}') {
                    jsonReader.wasNull = true;
                    return 0;
                }
                long nameHashCode = jsonReader.readFieldNameHashCode();
                boolean bl = match = nameHashCode == this.nameHashCode;
                if (match) break;
                jsonReader.skipValue();
            }
            switch (jsonReader.ch) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return jsonReader.readInt32Value();
                }
                case '\"': 
                case '\'': {
                    String str = jsonReader.readString();
                    return Integer.parseInt(str);
                }
                case 'f': 
                case 't': {
                    boolean booleanValue = jsonReader.readBoolValue();
                    return booleanValue ? 1 : 0;
                }
                case 'n': {
                    jsonReader.readNull();
                    jsonReader.wasNull = true;
                    return 0;
                }
                case ']': {
                    jsonReader.next();
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + jsonReader.ch);
                }
            }
        }
        jsonReader.wasNull = true;
        return 0;
    }

    @Override
    public void extractScalar(JSONReader jsonReader, ValueConsumer consumer) {
        if (jsonReader.nextIfObjectStart()) {
            while (true) {
                boolean match;
                if (jsonReader.ch == '}') {
                    consumer.acceptNull();
                    return;
                }
                long nameHashCode = jsonReader.readFieldNameHashCode();
                boolean bl = match = nameHashCode == this.nameHashCode;
                if (match) break;
                jsonReader.skipValue();
            }
            switch (jsonReader.ch) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    jsonReader.readNumber(consumer, false);
                    return;
                }
                case '[': {
                    List array = jsonReader.readArray();
                    consumer.accept(array);
                    return;
                }
                case '{': {
                    Map<String, Object> object = jsonReader.readObject();
                    consumer.accept(object);
                    return;
                }
                case '\"': 
                case '\'': {
                    jsonReader.readString(consumer, false);
                    return;
                }
                case 'f': 
                case 't': {
                    consumer.accept(jsonReader.readBoolValue());
                    return;
                }
                case 'n': {
                    jsonReader.readNull();
                    consumer.acceptNull();
                    return;
                }
                case ']': {
                    jsonReader.next();
                    break;
                }
                default: {
                    throw new JSONException("TODO : " + jsonReader.ch);
                }
            }
        }
        consumer.acceptNull();
    }

    @Override
    public void extract(JSONReader jsonReader, ValueConsumer consumer) {
        if (jsonReader.nextIfObjectStart()) {
            while (true) {
                boolean match;
                if (jsonReader.ch == '}') {
                    consumer.acceptNull();
                    return;
                }
                long nameHashCode = jsonReader.readFieldNameHashCode();
                boolean bl = match = nameHashCode == this.nameHashCode;
                if (match) break;
                jsonReader.skipValue();
            }
            switch (jsonReader.ch) {
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    jsonReader.readNumber(consumer, true);
                    return;
                }
                case '[': {
                    List array = jsonReader.readArray();
                    consumer.accept(array);
                    return;
                }
                case '{': {
                    Map<String, Object> object = jsonReader.readObject();
                    consumer.accept(object);
                    return;
                }
                case '\"': 
                case '\'': {
                    jsonReader.readString(consumer, true);
                    return;
                }
                case 'f': 
                case 't': {
                    consumer.accept(jsonReader.readBoolValue());
                    return;
                }
                case 'n': {
                    jsonReader.readNull();
                    consumer.acceptNull();
                    return;
                }
            }
            throw new JSONException("TODO : " + jsonReader.ch);
        }
        consumer.acceptNull();
    }
}

