/*
 * Decompiled with CFR 0.152.
 */
package cn.zhouyafeng.itchat4j.utils.tools;

import cn.zhouyafeng.itchat4j.utils.Config;
import cn.zhouyafeng.itchat4j.utils.enums.OsNameEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.vdurmont.emoji.EmojiParser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CommonTools {
    public static boolean printQr(String qrPath) {
        switch (Config.getOsNameEnum()) {
            case WINDOWS: {
                if (!Config.getOsNameEnum().equals((Object)OsNameEnum.WINDOWS)) break;
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.exec("cmd /c start " + qrPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case MAC: {
                if (!Config.getOsNameEnum().equals((Object)OsNameEnum.MAC)) break;
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.exec("open " + qrPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return true;
    }

    public static boolean clearScreen() {
        switch (Config.getOsNameEnum()) {
            case WINDOWS: {
                if (!Config.getOsNameEnum().equals((Object)OsNameEnum.WINDOWS)) break;
                Runtime runtime = Runtime.getRuntime();
                try {
                    runtime.exec("cmd /c cls");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return true;
    }

    public static Matcher getMatcher(String regEx, String text) {
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(text);
        return matcher;
    }

    public static Document xmlParser(String text) {
        Document doc = null;
        StringReader sr = new StringReader(text);
        InputSource is = new InputSource(sr);
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory2.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static JSONObject structFriendInfo(JSONObject userObj) {
        HashMap<String, Object> friendInfoTemplate = new HashMap<String, Object>();
        friendInfoTemplate.put("UserName", "");
        friendInfoTemplate.put("City", "");
        friendInfoTemplate.put("DisplayName", "");
        friendInfoTemplate.put("PYQuanPin", "");
        friendInfoTemplate.put("RemarkPYInitial", "");
        friendInfoTemplate.put("Province", "");
        friendInfoTemplate.put("KeyWord", "");
        friendInfoTemplate.put("RemarkName", "");
        friendInfoTemplate.put("PYInitial", "");
        friendInfoTemplate.put("EncryChatRoomId", "");
        friendInfoTemplate.put("Alias", "");
        friendInfoTemplate.put("Signature", "");
        friendInfoTemplate.put("NickName", "");
        friendInfoTemplate.put("RemarkPYQuanPin", "");
        friendInfoTemplate.put("HeadImgUrl", "");
        friendInfoTemplate.put("UniFriend", 0);
        friendInfoTemplate.put("Sex", 0);
        friendInfoTemplate.put("AppAccountFlag", 0);
        friendInfoTemplate.put("VerifyFlag", 0);
        friendInfoTemplate.put("ChatRoomId", 0);
        friendInfoTemplate.put("HideInputBarFlag", 0);
        friendInfoTemplate.put("AttrStatus", 0);
        friendInfoTemplate.put("SnsFlag", 0);
        friendInfoTemplate.put("MemberCount", 0);
        friendInfoTemplate.put("OwnerUin", 0);
        friendInfoTemplate.put("ContactFlag", 0);
        friendInfoTemplate.put("Uin", 0);
        friendInfoTemplate.put("StarFriend", 0);
        friendInfoTemplate.put("Statues", 0);
        friendInfoTemplate.put("MemberList", new ArrayList());
        JSONObject r = new JSONObject();
        Set keySet = friendInfoTemplate.keySet();
        for (String key : keySet) {
            if (userObj.containsKey(key)) {
                r.put(key, userObj.get(key));
                continue;
            }
            r.put(key, friendInfoTemplate.get(key));
        }
        return r;
    }

    public static String getSynckey(JSONObject obj) {
        JSONArray obj2 = obj.getJSONArray("List");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < obj2.size(); ++i) {
            JSONObject obj3 = (JSONObject)JSON.toJSON(obj2.get(i));
            sb.append(obj3.get("Val") + "|");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static JSONObject searchDictList(List<JSONObject> list, String key, String value) {
        JSONObject r = null;
        for (JSONObject i : list) {
            if (!i.getString(key).equals(value)) continue;
            r = i;
            break;
        }
        return r;
    }

    public static void emojiFormatter(JSONObject d, String k) {
        Matcher matcher = CommonTools.getMatcher("<span class=\"emoji emoji(.{1,10})\"></span>", d.getString(k));
        StringBuilder sb = new StringBuilder();
        String content = d.getString(k);
        int lastStart = 0;
        while (matcher.find()) {
            String str = matcher.group(1);
            if (str.length() == 6 || str.length() == 10) continue;
            str = "&#x" + str + ";";
            String tmp = content.substring(lastStart, matcher.start());
            sb.append(tmp + str);
            lastStart = matcher.end();
        }
        if (lastStart < content.length()) {
            sb.append(content.substring(lastStart));
        }
        if (sb.length() != 0) {
            d.put(k, (Object)EmojiParser.parseToUnicode(sb.toString()));
        } else {
            d.put(k, (Object)content);
        }
    }

    public static void msgFormatter(JSONObject d, String k) {
        d.put(k, (Object)d.getString(k).replace("<br/>", "\n"));
        CommonTools.emojiFormatter(d, k);
    }
}

