/*
 * Decompiled with CFR 0.152.
 */
package cn.zhouyafeng.itchat4j.service.impl;

import cn.zhouyafeng.itchat4j.beans.BaseMsg;
import cn.zhouyafeng.itchat4j.core.Core;
import cn.zhouyafeng.itchat4j.core.MsgCenter;
import cn.zhouyafeng.itchat4j.service.ILoginService;
import cn.zhouyafeng.itchat4j.utils.Config;
import cn.zhouyafeng.itchat4j.utils.MyHttpClient;
import cn.zhouyafeng.itchat4j.utils.SleepUtils;
import cn.zhouyafeng.itchat4j.utils.enums.ResultEnum;
import cn.zhouyafeng.itchat4j.utils.enums.RetCodeEnum;
import cn.zhouyafeng.itchat4j.utils.enums.StorageLoginInfoEnum;
import cn.zhouyafeng.itchat4j.utils.enums.URLEnum;
import cn.zhouyafeng.itchat4j.utils.enums.parameters.BaseParaEnum;
import cn.zhouyafeng.itchat4j.utils.enums.parameters.LoginParaEnum;
import cn.zhouyafeng.itchat4j.utils.enums.parameters.StatusNotifyParaEnum;
import cn.zhouyafeng.itchat4j.utils.enums.parameters.UUIDParaEnum;
import cn.zhouyafeng.itchat4j.utils.tools.CommonTools;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class LoginServiceImpl
implements ILoginService {
    private static Logger LOG = LoggerFactory.getLogger(LoginServiceImpl.class);
    private Core core = Core.getInstance();
    private MyHttpClient httpClient = this.core.getMyHttpClient();
    private MyHttpClient myHttpClient = this.core.getMyHttpClient();

    @Override
    public boolean login() {
        boolean isLogin = false;
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(LoginParaEnum.LOGIN_ICON.para(), LoginParaEnum.LOGIN_ICON.value()));
        params.add(new BasicNameValuePair(LoginParaEnum.UUID.para(), this.core.getUuid()));
        params.add(new BasicNameValuePair(LoginParaEnum.TIP.para(), LoginParaEnum.TIP.value()));
        while (!isLogin) {
            long millis = System.currentTimeMillis();
            params.add(new BasicNameValuePair(LoginParaEnum.R.para(), String.valueOf(millis / 1579L)));
            params.add(new BasicNameValuePair(LoginParaEnum._.para(), String.valueOf(millis)));
            HttpEntity entity = this.httpClient.doGet(URLEnum.LOGIN_URL.getUrl(), params, true, null);
            try {
                String result = EntityUtils.toString(entity);
                String status = this.checklogin(result);
                if (ResultEnum.SUCCESS.getCode().equals(status)) {
                    this.processLoginInfo(result);
                    isLogin = true;
                    this.core.setAlive(isLogin);
                    break;
                }
                if (!ResultEnum.WAIT_CONFIRM.getCode().equals(status)) continue;
                LOG.info("\u8bf7\u70b9\u51fb\u5fae\u4fe1\u786e\u8ba4\u6309\u94ae\uff0c\u8fdb\u884c\u767b\u9646");
            }
            catch (Exception e) {
                LOG.error("\u5fae\u4fe1\u767b\u9646\u5f02\u5e38\uff01", e);
            }
        }
        return isLogin;
    }

    @Override
    public String getUuid() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(UUIDParaEnum.APP_ID.para(), UUIDParaEnum.APP_ID.value()));
        params.add(new BasicNameValuePair(UUIDParaEnum.REDIRECT_URL.para(), UUIDParaEnum.REDIRECT_URL.value()));
        params.add(new BasicNameValuePair(UUIDParaEnum.FUN.para(), UUIDParaEnum.FUN.value()));
        params.add(new BasicNameValuePair(UUIDParaEnum.LANG.para(), UUIDParaEnum.LANG.value()));
        params.add(new BasicNameValuePair(UUIDParaEnum._.para(), String.valueOf(System.currentTimeMillis())));
        HttpEntity entity = this.httpClient.doGet(URLEnum.UUID_URL.getUrl(), params, true, null);
        try {
            String result = EntityUtils.toString(entity);
            String regEx = "window.QRLogin.code = (\\d+); window.QRLogin.uuid = \"(\\S+?)\";";
            Matcher matcher = CommonTools.getMatcher(regEx, result);
            if (matcher.find() && ResultEnum.SUCCESS.getCode().equals(matcher.group(1))) {
                this.core.setUuid(matcher.group(2));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        return this.core.getUuid();
    }

    @Override
    public boolean getQR(String qrPath) {
        qrPath = qrPath + File.separator + "QR.jpg";
        String qrUrl = URLEnum.QRCODE_URL.getUrl() + this.core.getUuid();
        HttpEntity entity = this.myHttpClient.doGet(qrUrl, null, true, null);
        try {
            FileOutputStream out = new FileOutputStream(qrPath);
            byte[] bytes = EntityUtils.toByteArray(entity);
            ((OutputStream)out).write(bytes);
            out.flush();
            ((OutputStream)out).close();
            try {
                CommonTools.printQr(qrPath);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean webWxInit() {
        this.core.setAlive(true);
        this.core.setLastNormalRetcodeTime(System.currentTimeMillis());
        String url = String.format(URLEnum.INIT_URL.getUrl(), this.core.getLoginInfo().get(StorageLoginInfoEnum.url.getKey()), String.valueOf(System.currentTimeMillis() / 3158L), this.core.getLoginInfo().get(StorageLoginInfoEnum.pass_ticket.getKey()));
        Map<String, Object> paramMap = this.core.getParamMap();
        HttpEntity entity = this.httpClient.doPost(url, JSON.toJSONString(paramMap));
        try {
            String result = EntityUtils.toString(entity, Consts.UTF_8);
            JSONObject obj = JSON.parseObject(result);
            JSONObject user = obj.getJSONObject(StorageLoginInfoEnum.User.getKey());
            JSONObject syncKey = obj.getJSONObject(StorageLoginInfoEnum.SyncKey.getKey());
            this.core.getLoginInfo().put(StorageLoginInfoEnum.InviteStartCount.getKey(), obj.getInteger(StorageLoginInfoEnum.InviteStartCount.getKey()));
            this.core.getLoginInfo().put(StorageLoginInfoEnum.SyncKey.getKey(), syncKey);
            JSONArray syncArray = syncKey.getJSONArray("List");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < syncArray.size(); ++i) {
                sb.append(syncArray.getJSONObject(i).getString("Key") + "_" + syncArray.getJSONObject(i).getString("Val") + "|");
            }
            String synckey = sb.toString();
            this.core.getLoginInfo().put(StorageLoginInfoEnum.synckey.getKey(), synckey.substring(0, synckey.length() - 1));
            this.core.setUserName(user.getString("UserName"));
            this.core.setNickName(user.getString("NickName"));
            this.core.setUserSelf(obj.getJSONObject("User"));
            String chatSet = obj.getString("ChatSet");
            String[] chatSetArray = chatSet.split(",");
            for (int i = 0; i < chatSetArray.length; ++i) {
                if (chatSetArray[i].indexOf("@@") == -1) continue;
                this.core.getGroupIdList().add(chatSetArray[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void wxStatusNotify() {
        String url = String.format(URLEnum.STATUS_NOTIFY_URL.getUrl(), this.core.getLoginInfo().get(StorageLoginInfoEnum.pass_ticket.getKey()));
        Map<String, Object> paramMap = this.core.getParamMap();
        paramMap.put(StatusNotifyParaEnum.CODE.para(), StatusNotifyParaEnum.CODE.value());
        paramMap.put(StatusNotifyParaEnum.FROM_USERNAME.para(), this.core.getUserName());
        paramMap.put(StatusNotifyParaEnum.TO_USERNAME.para(), this.core.getUserName());
        paramMap.put(StatusNotifyParaEnum.CLIENT_MSG_ID.para(), System.currentTimeMillis());
        String paramStr = JSON.toJSONString(paramMap);
        try {
            HttpEntity entity = this.httpClient.doPost(url, paramStr);
            EntityUtils.toString(entity, Consts.UTF_8);
        }
        catch (Exception e) {
            LOG.error("\u5fae\u4fe1\u72b6\u6001\u901a\u77e5\u63a5\u53e3\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void startReceiving() {
        this.core.setAlive(true);
        new Thread(new Runnable(){
            int retryCount = 0;

            @Override
            public void run() {
                while (LoginServiceImpl.this.core.isAlive()) {
                    try {
                        Map resultMap = LoginServiceImpl.this.syncCheck();
                        LOG.info(JSONObject.toJSONString(resultMap));
                        String retcode = (String)resultMap.get("retcode");
                        String selector = (String)resultMap.get("selector");
                        if (retcode.equals(RetCodeEnum.UNKOWN.getCode())) {
                            LOG.info(RetCodeEnum.UNKOWN.getType());
                            continue;
                        }
                        if (retcode.equals(RetCodeEnum.LOGIN_OUT.getCode())) {
                            LOG.info(RetCodeEnum.LOGIN_OUT.getType());
                            break;
                        }
                        if (retcode.equals(RetCodeEnum.LOGIN_OTHERWHERE.getCode())) {
                            LOG.info(RetCodeEnum.LOGIN_OTHERWHERE.getType());
                            break;
                        }
                        if (retcode.equals(RetCodeEnum.MOBILE_LOGIN_OUT.getCode())) {
                            LOG.info(RetCodeEnum.MOBILE_LOGIN_OUT.getType());
                            break;
                        }
                        if (retcode.equals(RetCodeEnum.NORMAL.getCode())) {
                            JSONArray msgList;
                            LoginServiceImpl.this.core.setLastNormalRetcodeTime(System.currentTimeMillis());
                            JSONObject msgObj = LoginServiceImpl.this.webWxSync();
                            if (selector.equals("2")) {
                                if (msgObj == null) continue;
                                try {
                                    msgList = new JSONArray();
                                    msgList = msgObj.getJSONArray("AddMsgList");
                                    msgList = MsgCenter.produceMsg(msgList);
                                    for (int j = 0; j < msgList.size(); ++j) {
                                        BaseMsg baseMsg = JSON.toJavaObject(msgList.getJSONObject(j), BaseMsg.class);
                                        LoginServiceImpl.this.core.getMsgList().add(baseMsg);
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    LOG.info(e.getMessage());
                                    continue;
                                }
                            }
                            if (selector.equals("7")) {
                                LoginServiceImpl.this.webWxSync();
                                continue;
                            }
                            if (selector.equals("4") || selector.equals("3") || !selector.equals("6") || msgObj == null) continue;
                            try {
                                msgList = new JSONArray();
                                msgList = msgObj.getJSONArray("AddMsgList");
                                JSONArray modContactList = msgObj.getJSONArray("ModContactList");
                                msgList = MsgCenter.produceMsg(msgList);
                                for (int j = 0; j < msgList.size(); ++j) {
                                    JSONObject userInfo = modContactList.getJSONObject(j);
                                    LoginServiceImpl.this.core.getContactList().add(userInfo);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                LOG.info(e.getMessage());
                                continue;
                            }
                        }
                        JSONObject jSONObject = LoginServiceImpl.this.webWxSync();
                    }
                    catch (Exception e) {
                        LOG.info(e.getMessage());
                        ++this.retryCount;
                        if (LoginServiceImpl.this.core.getReceivingRetryCount() < this.retryCount) {
                            LoginServiceImpl.this.core.setAlive(false);
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            LOG.info(e.getMessage());
                        }
                    }
                }
            }
        }).start();
    }

    @Override
    public void webWxGetContact() {
        String url = String.format(URLEnum.WEB_WX_GET_CONTACT.getUrl(), this.core.getLoginInfo().get(StorageLoginInfoEnum.url.getKey()));
        Map<String, Object> paramMap = this.core.getParamMap();
        HttpEntity entity = this.httpClient.doPost(url, JSON.toJSONString(paramMap));
        try {
            String result = EntityUtils.toString(entity, Consts.UTF_8);
            JSONObject fullFriendsJsonList = JSON.parseObject(result);
            long seq = 0L;
            long currentTime = 0L;
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (fullFriendsJsonList.get("Seq") != null) {
                seq = fullFriendsJsonList.getLong("Seq");
                currentTime = new Date().getTime();
            }
            this.core.setMemberCount(fullFriendsJsonList.getInteger(StorageLoginInfoEnum.MemberCount.getKey()));
            JSONArray member = fullFriendsJsonList.getJSONArray(StorageLoginInfoEnum.MemberList.getKey());
            while (seq > 0L) {
                params.add(new BasicNameValuePair("r", String.valueOf(currentTime)));
                params.add(new BasicNameValuePair("seq", String.valueOf(seq)));
                entity = this.httpClient.doGet(url, params, false, null);
                params.remove(new BasicNameValuePair("r", String.valueOf(currentTime)));
                params.remove(new BasicNameValuePair("seq", String.valueOf(seq)));
                result = EntityUtils.toString(entity, Consts.UTF_8);
                fullFriendsJsonList = JSON.parseObject(result);
                if (fullFriendsJsonList.get("Seq") != null) {
                    seq = fullFriendsJsonList.getLong("Seq");
                    currentTime = new Date().getTime();
                }
                member.addAll((Collection)fullFriendsJsonList.getJSONArray(StorageLoginInfoEnum.MemberList.getKey()));
            }
            this.core.setMemberCount(member.size());
            for (JSONObject o : member) {
                if ((o.getInteger("VerifyFlag") & 8) != 0) {
                    this.core.getPublicUsersList().add(o);
                    continue;
                }
                if (Config.API_SPECIAL_USER.contains(o.getString("UserName"))) {
                    this.core.getSpecialUsersList().add(o);
                    continue;
                }
                if (o.getString("UserName").indexOf("@@") != -1) {
                    if (this.core.getGroupIdList().contains(o.getString("UserName"))) continue;
                    this.core.getGroupNickNameList().add(o.getString("NickName"));
                    this.core.getGroupIdList().add(o.getString("UserName"));
                    this.core.getGroupList().add(o);
                    continue;
                }
                if (o.getString("UserName").equals(this.core.getUserSelf().getString("UserName"))) {
                    this.core.getContactList().remove(o);
                    continue;
                }
                this.core.getContactList().add(o);
            }
            return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return;
        }
    }

    @Override
    public void WebWxBatchGetContact() {
        String url = String.format(URLEnum.WEB_WX_BATCH_GET_CONTACT.getUrl(), this.core.getLoginInfo().get(StorageLoginInfoEnum.url.getKey()), new Date().getTime(), this.core.getLoginInfo().get(StorageLoginInfoEnum.pass_ticket.getKey()));
        Map<String, Object> paramMap = this.core.getParamMap();
        paramMap.put("Count", this.core.getGroupIdList().size());
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.core.getGroupIdList().size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("UserName", this.core.getGroupIdList().get(i));
            map.put("EncryChatRoomId", "");
            list.add(map);
        }
        paramMap.put("List", list);
        HttpEntity entity = this.httpClient.doPost(url, JSON.toJSONString(paramMap));
        try {
            String text = EntityUtils.toString(entity, Consts.UTF_8);
            JSONObject obj = JSON.parseObject(text);
            JSONArray contactList = obj.getJSONArray("ContactList");
            for (int i = 0; i < contactList.size(); ++i) {
                if (contactList.getJSONObject(i).getString("UserName").indexOf("@@") <= -1) continue;
                this.core.getGroupNickNameList().add(contactList.getJSONObject(i).getString("NickName"));
                this.core.getGroupList().add(contactList.getJSONObject(i));
                this.core.getGroupMemeberMap().put(contactList.getJSONObject(i).getString("UserName"), contactList.getJSONObject(i).getJSONArray("MemberList"));
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public String checklogin(String result) {
        String regEx = "window.code=(\\d+)";
        Matcher matcher = CommonTools.getMatcher(regEx, result);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private void processLoginInfo(String loginContent) {
        String regEx = "window.redirect_uri=\"(\\S+)\";";
        Matcher matcher = CommonTools.getMatcher(regEx, loginContent);
        if (matcher.find()) {
            Document doc;
            String originalUrl = matcher.group(1);
            String url = originalUrl.substring(0, originalUrl.lastIndexOf(47));
            this.core.getLoginInfo().put("url", url);
            Map<String, List<String>> possibleUrlMap = this.getPossibleUrlMap();
            for (Map.Entry<String, List<String>> entry : possibleUrlMap.entrySet()) {
                String indexUrl = entry.getKey();
                String fileUrl = "https://" + entry.getValue().get(0) + "/cgi-bin/mmwebwx-bin";
                String syncUrl = "https://" + entry.getValue().get(1) + "/cgi-bin/mmwebwx-bin";
                if (!this.core.getLoginInfo().get("url").toString().contains(indexUrl)) continue;
                this.core.setIndexUrl(indexUrl);
                this.core.getLoginInfo().put("fileUrl", fileUrl);
                this.core.getLoginInfo().put("syncUrl", syncUrl);
                break;
            }
            if (this.core.getLoginInfo().get("fileUrl") == null && this.core.getLoginInfo().get("syncUrl") == null) {
                this.core.getLoginInfo().put("fileUrl", url);
                this.core.getLoginInfo().put("syncUrl", url);
            }
            this.core.getLoginInfo().put("deviceid", "e" + String.valueOf(new Random().nextLong()).substring(1, 16));
            this.core.getLoginInfo().put("BaseRequest", new ArrayList());
            String text = "";
            try {
                HttpEntity entity = this.myHttpClient.doGet(originalUrl, null, false, null);
                text = EntityUtils.toString(entity);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
                return;
            }
            String msg = this.getLoginMessage(text);
            if (!"".equals(msg)) {
                LOG.info(msg);
                System.exit(0);
            }
            if ((doc = CommonTools.xmlParser(text)) != null) {
                this.core.getLoginInfo().put(StorageLoginInfoEnum.skey.getKey(), doc.getElementsByTagName(StorageLoginInfoEnum.skey.getKey()).item(0).getFirstChild().getNodeValue());
                this.core.getLoginInfo().put(StorageLoginInfoEnum.wxsid.getKey(), doc.getElementsByTagName(StorageLoginInfoEnum.wxsid.getKey()).item(0).getFirstChild().getNodeValue());
                this.core.getLoginInfo().put(StorageLoginInfoEnum.wxuin.getKey(), doc.getElementsByTagName(StorageLoginInfoEnum.wxuin.getKey()).item(0).getFirstChild().getNodeValue());
                this.core.getLoginInfo().put(StorageLoginInfoEnum.pass_ticket.getKey(), doc.getElementsByTagName(StorageLoginInfoEnum.pass_ticket.getKey()).item(0).getFirstChild().getNodeValue());
            }
        }
    }

    private Map<String, List<String>> getPossibleUrlMap() {
        HashMap<String, List<String>> possibleUrlMap = new HashMap<String, List<String>>();
        possibleUrlMap.put("wx.qq.com", new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("file.wx.qq.com");
                this.add("webpush.wx.qq.com");
            }
        });
        possibleUrlMap.put("wx2.qq.com", new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("file.wx2.qq.com");
                this.add("webpush.wx2.qq.com");
            }
        });
        possibleUrlMap.put("wx8.qq.com", new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("file.wx8.qq.com");
                this.add("webpush.wx8.qq.com");
            }
        });
        possibleUrlMap.put("web2.wechat.com", new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("file.web2.wechat.com");
                this.add("webpush.web2.wechat.com");
            }
        });
        possibleUrlMap.put("wechat.com", new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("file.web.wechat.com");
                this.add("webpush.web.wechat.com");
            }
        });
        return possibleUrlMap;
    }

    private JSONObject webWxSync() {
        JSONObject result = null;
        String url = String.format(URLEnum.WEB_WX_SYNC_URL.getUrl(), this.core.getLoginInfo().get(StorageLoginInfoEnum.url.getKey()), this.core.getLoginInfo().get(StorageLoginInfoEnum.wxsid.getKey()), this.core.getLoginInfo().get(StorageLoginInfoEnum.skey.getKey()), this.core.getLoginInfo().get(StorageLoginInfoEnum.pass_ticket.getKey()));
        Map<String, Object> paramMap = this.core.getParamMap();
        paramMap.put(StorageLoginInfoEnum.SyncKey.getKey(), this.core.getLoginInfo().get(StorageLoginInfoEnum.SyncKey.getKey()));
        paramMap.put("rr", -new Date().getTime() / 1000L);
        String paramStr = JSON.toJSONString(paramMap);
        try {
            HttpEntity entity = this.myHttpClient.doPost(url, paramStr);
            String text = EntityUtils.toString(entity, Consts.UTF_8);
            JSONObject obj = JSON.parseObject(text);
            if (obj.getJSONObject("BaseResponse").getInteger("Ret") != 0) {
                result = null;
            } else {
                result = obj;
                this.core.getLoginInfo().put(StorageLoginInfoEnum.SyncKey.getKey(), obj.getJSONObject("SyncCheckKey"));
                JSONArray syncArray = obj.getJSONObject(StorageLoginInfoEnum.SyncKey.getKey()).getJSONArray("List");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < syncArray.size(); ++i) {
                    sb.append(syncArray.getJSONObject(i).getString("Key") + "_" + syncArray.getJSONObject(i).getString("Val") + "|");
                }
                String synckey = sb.toString();
                this.core.getLoginInfo().put(StorageLoginInfoEnum.synckey.getKey(), synckey.substring(0, synckey.length() - 1));
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
        return result;
    }

    private Map<String, String> syncCheck() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String url = this.core.getLoginInfo().get(StorageLoginInfoEnum.syncUrl.getKey()) + URLEnum.SYNC_CHECK_URL.getUrl();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (BaseParaEnum baseRequest : BaseParaEnum.values()) {
            params.add(new BasicNameValuePair(baseRequest.para().toLowerCase(), this.core.getLoginInfo().get(baseRequest.value()).toString()));
        }
        params.add(new BasicNameValuePair("r", String.valueOf(new Date().getTime())));
        params.add(new BasicNameValuePair("synckey", (String)this.core.getLoginInfo().get("synckey")));
        params.add(new BasicNameValuePair("_", String.valueOf(new Date().getTime())));
        SleepUtils.sleep(7L);
        try {
            HttpEntity entity = this.myHttpClient.doGet(url, params, true, null);
            if (entity == null) {
                resultMap.put("retcode", "9999");
                resultMap.put("selector", "9999");
                return resultMap;
            }
            String regEx = "window.synccheck=\\{retcode:\"(\\d+)\",selector:\"(\\d+)\"\\}";
            String text = EntityUtils.toString(entity);
            Matcher matcher = CommonTools.getMatcher(regEx, text);
            if (!matcher.find() || matcher.group(1).equals("2")) {
                LOG.info(String.format("Unexpected sync check result: %s", text));
            } else {
                resultMap.put("retcode", matcher.group(1));
                resultMap.put("selector", matcher.group(2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public String getLoginMessage(String result) {
        String[] strArr = result.split("<message>");
        String[] rs = strArr[1].split("</message>");
        if (rs != null && rs.length > 1) {
            return rs[0];
        }
        return "";
    }
}

