/*
 * Decompiled with CFR 0.152.
 */
package cn.zhouyafeng.itchat4j.core;

import cn.zhouyafeng.itchat4j.api.MessageTools;
import cn.zhouyafeng.itchat4j.beans.BaseMsg;
import cn.zhouyafeng.itchat4j.core.Core;
import cn.zhouyafeng.itchat4j.face.IMsgHandlerFace;
import cn.zhouyafeng.itchat4j.utils.enums.MsgCodeEnum;
import cn.zhouyafeng.itchat4j.utils.enums.MsgTypeEnum;
import cn.zhouyafeng.itchat4j.utils.tools.CommonTools;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgCenter {
    private static Logger LOG = LoggerFactory.getLogger(MsgCenter.class);
    private static Core core = Core.getInstance();

    public static JSONArray produceMsg(JSONArray msgList) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < msgList.size(); ++i) {
            JSONObject msg = new JSONObject();
            JSONObject m = msgList.getJSONObject(i);
            m.put("groupMsg", (Object)false);
            if (m.getString("FromUserName").contains("@@") || m.getString("ToUserName").contains("@@")) {
                if (m.getString("FromUserName").contains("@@") && !core.getGroupIdList().contains(m.getString("FromUserName"))) {
                    core.getGroupIdList().add(m.getString("FromUserName"));
                } else if (m.getString("ToUserName").contains("@@") && !core.getGroupIdList().contains(m.getString("ToUserName"))) {
                    core.getGroupIdList().add(m.getString("ToUserName"));
                }
                if (m.getString("Content").contains("<br/>")) {
                    String content = m.getString("Content").substring(m.getString("Content").indexOf("<br/>") + 5);
                    m.put("Content", (Object)content);
                    m.put("groupMsg", (Object)true);
                }
            } else {
                CommonTools.msgFormatter(m, "Content");
            }
            if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_TEXT.getCode())) {
                if (m.getString("Url").length() != 0) {
                    String regEx = "(.+?\\(.+?\\))";
                    Matcher matcher = CommonTools.getMatcher(regEx, m.getString("Content"));
                    String data = "Map";
                    if (matcher.find()) {
                        data = matcher.group(1);
                    }
                    msg.put("Type", (Object)"Map");
                    msg.put("Text", (Object)data);
                } else {
                    msg.put("Type", (Object)MsgTypeEnum.TEXT.getType());
                    msg.put("Text", (Object)m.getString("Content"));
                }
                m.put("Type", (Object)msg.getString("Type"));
                m.put("Text", (Object)msg.getString("Text"));
            } else if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_IMAGE.getCode()) || m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_EMOTICON.getCode())) {
                m.put("Type", (Object)MsgTypeEnum.PIC.getType());
            } else if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_VOICE.getCode())) {
                m.put("Type", (Object)MsgTypeEnum.VOICE.getType());
            } else if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_VERIFYMSG.getCode())) {
                m.put("Type", (Object)MsgTypeEnum.VERIFYMSG.getType());
            } else if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_SHARECARD.getCode())) {
                m.put("Type", (Object)MsgTypeEnum.NAMECARD.getType());
            } else if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_VIDEO.getCode()) || m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_MICROVIDEO.getCode())) {
                m.put("Type", (Object)MsgTypeEnum.VIEDO.getType());
            } else if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_MEDIA.getCode())) {
                m.put("Type", (Object)MsgTypeEnum.MEDIA.getType());
            } else if (!m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_STATUSNOTIFY.getCode())) {
                if (m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_SYS.getCode())) {
                    m.put("Type", (Object)MsgTypeEnum.SYS.getType());
                } else if (!m.getInteger("MsgType").equals(MsgCodeEnum.MSGTYPE_RECALLED.getCode())) {
                    LOG.info("Useless msg");
                }
            }
            LOG.info("\u6536\u5230\u6d88\u606f\u4e00\u6761\uff0c\u6765\u81ea: " + m.getString("FromUserName"));
            result.add(m);
        }
        return result;
    }

    public static void handleMsg(IMsgHandlerFace msgHandler) {
        while (true) {
            if (core.getMsgList().size() > 0 && core.getMsgList().get(0).getContent() != null) {
                BaseMsg msg;
                if (core.getMsgList().get(0).getContent().length() > 0 && (msg = core.getMsgList().get(0)).getType() != null) {
                    try {
                        String result;
                        if (msg.getType().equals(MsgTypeEnum.TEXT.getType())) {
                            result = msgHandler.textMsgHandle(msg);
                            MessageTools.sendMsgById(result, core.getMsgList().get(0).getFromUserName());
                        } else if (msg.getType().equals(MsgTypeEnum.PIC.getType())) {
                            result = msgHandler.picMsgHandle(msg);
                            MessageTools.sendMsgById(result, core.getMsgList().get(0).getFromUserName());
                        } else if (msg.getType().equals(MsgTypeEnum.VOICE.getType())) {
                            result = msgHandler.voiceMsgHandle(msg);
                            MessageTools.sendMsgById(result, core.getMsgList().get(0).getFromUserName());
                        } else if (msg.getType().equals(MsgTypeEnum.VIEDO.getType())) {
                            result = msgHandler.viedoMsgHandle(msg);
                            MessageTools.sendMsgById(result, core.getMsgList().get(0).getFromUserName());
                        } else if (msg.getType().equals(MsgTypeEnum.NAMECARD.getType())) {
                            result = msgHandler.nameCardMsgHandle(msg);
                            MessageTools.sendMsgById(result, core.getMsgList().get(0).getFromUserName());
                        } else if (msg.getType().equals(MsgTypeEnum.SYS.getType())) {
                            msgHandler.sysMsgHandle(msg);
                        } else if (msg.getType().equals(MsgTypeEnum.VERIFYMSG.getType())) {
                            result = msgHandler.verifyAddFriendMsgHandle(msg);
                            MessageTools.sendMsgById(result, core.getMsgList().get(0).getRecommendInfo().getUserName());
                        } else if (msg.getType().equals(MsgTypeEnum.MEDIA.getType())) {
                            result = msgHandler.mediaMsgHandle(msg);
                            MessageTools.sendMsgById(result, core.getMsgList().get(0).getFromUserName());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                core.getMsgList().remove(0);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

