/*
 * Decompiled with CFR 0.152.
 */
package cn.zhouyafeng.itchat4j.api;

import cn.zhouyafeng.itchat4j.api.MessageTools;
import cn.zhouyafeng.itchat4j.core.Core;
import cn.zhouyafeng.itchat4j.utils.enums.StorageLoginInfoEnum;
import cn.zhouyafeng.itchat4j.utils.enums.URLEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatTools {
    private static Logger LOG = LoggerFactory.getLogger(WechatTools.class);
    private static Core core = Core.getInstance();

    public static void sendMsgByUserName(String msg, String toUserName) {
        MessageTools.sendMsgById(msg, toUserName);
    }

    public static String getUserNameByNickName(String nickName) {
        for (JSONObject o : core.getContactList()) {
            if (!o.getString("NickName").equals(nickName)) continue;
            return o.getString("UserName");
        }
        return null;
    }

    public static List<String> getContactNickNameList() {
        ArrayList<String> contactNickNameList = new ArrayList<String>();
        for (JSONObject o : core.getContactList()) {
            contactNickNameList.add(o.getString("NickName"));
        }
        return contactNickNameList;
    }

    public static List<JSONObject> getContactList() {
        return core.getContactList();
    }

    public static List<JSONObject> getGroupList() {
        return core.getGroupList();
    }

    public static List<String> getGroupIdList() {
        return core.getGroupIdList();
    }

    public static List<String> getGroupNickNameList() {
        return core.getGroupNickNameList();
    }

    public static JSONArray getMemberListByGroupId(String groupId) {
        return core.getGroupMemeberMap().get(groupId);
    }

    public static void logout() {
        WechatTools.webWxLogout();
    }

    private static boolean webWxLogout() {
        String url = String.format(URLEnum.WEB_WX_LOGOUT.getUrl(), core.getLoginInfo().get(StorageLoginInfoEnum.url.getKey()));
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("redirect", "1"));
        params.add(new BasicNameValuePair("type", "1"));
        params.add(new BasicNameValuePair("skey", (String)core.getLoginInfo().get(StorageLoginInfoEnum.skey.getKey())));
        try {
            HttpEntity entity = core.getMyHttpClient().doGet(url, params, false, null);
            String text = EntityUtils.toString(entity, Consts.UTF_8);
            return true;
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
            return false;
        }
    }

    public static void setUserInfo() {
        for (JSONObject o : core.getContactList()) {
            core.getUserInfoMap().put(o.getString("NickName"), o);
            core.getUserInfoMap().put(o.getString("UserName"), o);
        }
    }

    public static void remarkNameByNickName(String nickName, String remName) {
        String url = String.format(URLEnum.WEB_WX_REMARKNAME.getUrl(), core.getLoginInfo().get("url"), core.getLoginInfo().get(StorageLoginInfoEnum.pass_ticket.getKey()));
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        HashMap<String, Object> msgMap_BaseRequest = new HashMap<String, Object>();
        msgMap.put("CmdId", 2);
        msgMap.put("RemarkName", remName);
        msgMap.put("UserName", core.getUserInfoMap().get(nickName).get("UserName"));
        msgMap_BaseRequest.put("Uin", core.getLoginInfo().get(StorageLoginInfoEnum.wxuin.getKey()));
        msgMap_BaseRequest.put("Sid", core.getLoginInfo().get(StorageLoginInfoEnum.wxsid.getKey()));
        msgMap_BaseRequest.put("Skey", core.getLoginInfo().get(StorageLoginInfoEnum.skey.getKey()));
        msgMap_BaseRequest.put("DeviceID", core.getLoginInfo().get(StorageLoginInfoEnum.deviceid.getKey()));
        msgMap.put("BaseRequest", msgMap_BaseRequest);
        try {
            String paramStr = JSON.toJSONString(msgMap);
            HttpEntity entity = core.getMyHttpClient().doPost(url, paramStr);
            LOG.info("\u4fee\u6539\u5907\u6ce8" + remName);
        }
        catch (Exception e) {
            LOG.error("remarkNameByUserName", e);
        }
    }

    public static boolean getWechatStatus() {
        return core.isAlive();
    }
}

