/*
 * Decompiled with CFR 0.152.
 */
package cn.zhouyafeng.itchat4j.api;

import cn.zhouyafeng.itchat4j.api.WechatTools;
import cn.zhouyafeng.itchat4j.beans.BaseMsg;
import cn.zhouyafeng.itchat4j.beans.RecommendInfo;
import cn.zhouyafeng.itchat4j.core.Core;
import cn.zhouyafeng.itchat4j.utils.MyHttpClient;
import cn.zhouyafeng.itchat4j.utils.enums.StorageLoginInfoEnum;
import cn.zhouyafeng.itchat4j.utils.enums.URLEnum;
import cn.zhouyafeng.itchat4j.utils.enums.VerifyFriendEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTools {
    private static Logger LOG = LoggerFactory.getLogger(MessageTools.class);
    private static Core core = Core.getInstance();
    private static MyHttpClient myHttpClient = core.getMyHttpClient();

    private static void sendMsg(String text, String toUserName) {
        if (text == null) {
            return;
        }
        LOG.info(String.format("\u53d1\u9001\u6d88\u606f %s: %s", toUserName, text));
        MessageTools.webWxSendMsg(1, text, toUserName);
    }

    public static void sendMsgById(String text, String id) {
        if (text == null) {
            return;
        }
        MessageTools.sendMsg(text, id);
    }

    public static boolean sendMsgByNickName(String text, String nickName) {
        String toUserName;
        if (nickName != null && (toUserName = WechatTools.getUserNameByNickName(nickName)) != null) {
            MessageTools.webWxSendMsg(1, text, toUserName);
            return true;
        }
        return false;
    }

    public static void webWxSendMsg(int msgType, String content, String toUserName) {
        String url = String.format(URLEnum.WEB_WX_SEND_MSG.getUrl(), core.getLoginInfo().get("url"));
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("Type", msgType);
        msgMap.put("Content", content);
        msgMap.put("FromUserName", core.getUserName());
        msgMap.put("ToUserName", toUserName == null ? core.getUserName() : toUserName);
        msgMap.put("LocalID", new Date().getTime() * 10L);
        msgMap.put("ClientMsgId", new Date().getTime() * 10L);
        Map<String, Object> paramMap = core.getParamMap();
        paramMap.put("Msg", msgMap);
        paramMap.put("Scene", 0);
        try {
            String paramStr = JSON.toJSONString(paramMap);
            HttpEntity entity = myHttpClient.doPost(url, paramStr);
            EntityUtils.toString(entity, Consts.UTF_8);
        }
        catch (Exception e) {
            LOG.error("webWxSendMsg", e);
        }
    }

    private static JSONObject webWxUploadMedia(String filePath) {
        File f = new File(filePath);
        if (!f.exists() && f.isFile()) {
            LOG.info("file is not exist");
            return null;
        }
        String url = String.format(URLEnum.WEB_WX_UPLOAD_MEDIA.getUrl(), core.getLoginInfo().get("fileUrl"));
        String mimeType = new MimetypesFileTypeMap().getContentType(f);
        String mediaType = "";
        if (mimeType == null) {
            mimeType = "text/plain";
        } else {
            mediaType = mimeType.split("/")[0].equals("image") ? "pic" : "doc";
        }
        String lastModifieDate = new SimpleDateFormat("yyyy MM dd HH:mm:ss").format(new Date());
        long fileSize = f.length();
        String passTicket = (String)core.getLoginInfo().get("pass_ticket");
        String clientMediaId = String.valueOf(new Date().getTime()) + String.valueOf(new Random().nextLong()).substring(0, 4);
        String webwxDataTicket = MyHttpClient.getCookie("webwx_data_ticket");
        if (webwxDataTicket == null) {
            LOG.error("get cookie webwx_data_ticket error");
            return null;
        }
        Map<String, Object> paramMap = core.getParamMap();
        paramMap.put("ClientMediaId", clientMediaId);
        paramMap.put("TotalLen", fileSize);
        paramMap.put("StartPos", 0);
        paramMap.put("DataLen", fileSize);
        paramMap.put("MediaType", 4);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addTextBody("id", "WU_FILE_0", ContentType.TEXT_PLAIN);
        builder.addTextBody("name", filePath, ContentType.TEXT_PLAIN);
        builder.addTextBody("type", mimeType, ContentType.TEXT_PLAIN);
        builder.addTextBody("lastModifieDate", lastModifieDate, ContentType.TEXT_PLAIN);
        builder.addTextBody("size", String.valueOf(fileSize), ContentType.TEXT_PLAIN);
        builder.addTextBody("mediatype", mediaType, ContentType.TEXT_PLAIN);
        builder.addTextBody("uploadmediarequest", JSON.toJSONString(paramMap), ContentType.TEXT_PLAIN);
        builder.addTextBody("webwx_data_ticket", webwxDataTicket, ContentType.TEXT_PLAIN);
        builder.addTextBody("pass_ticket", passTicket, ContentType.TEXT_PLAIN);
        builder.addBinaryBody("filename", f, ContentType.create(mimeType), filePath);
        HttpEntity reqEntity = builder.build();
        HttpEntity entity = myHttpClient.doPostFile(url, reqEntity);
        if (entity != null) {
            try {
                String result = EntityUtils.toString(entity, Consts.UTF_8);
                return JSON.parseObject(result);
            }
            catch (Exception e) {
                LOG.error("webWxUploadMedia \u9519\u8bef\uff1a ", e);
            }
        }
        return null;
    }

    public static boolean sendPicMsgByNickName(String nickName, String filePath) {
        String toUserName = WechatTools.getUserNameByNickName(nickName);
        if (toUserName != null) {
            return MessageTools.sendPicMsgByUserId(toUserName, filePath);
        }
        return false;
    }

    public static boolean sendPicMsgByUserId(String userId, String filePath) {
        String mediaId;
        JSONObject responseObj = MessageTools.webWxUploadMedia(filePath);
        if (responseObj != null && (mediaId = responseObj.getString("MediaId")) != null) {
            return MessageTools.webWxSendMsgImg(userId, mediaId);
        }
        return false;
    }

    private static boolean webWxSendMsgImg(String userId, String mediaId) {
        String url = String.format("%s/webwxsendmsgimg?fun=async&f=json&pass_ticket=%s", core.getLoginInfo().get("url"), core.getLoginInfo().get("pass_ticket"));
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("Type", 3);
        msgMap.put("MediaId", mediaId);
        msgMap.put("FromUserName", core.getUserSelf().getString("UserName"));
        msgMap.put("ToUserName", userId);
        String clientMsgId = String.valueOf(new Date().getTime()) + String.valueOf(new Random().nextLong()).substring(1, 5);
        msgMap.put("LocalID", clientMsgId);
        msgMap.put("ClientMsgId", clientMsgId);
        Map<String, Object> paramMap = core.getParamMap();
        paramMap.put("BaseRequest", core.getParamMap().get("BaseRequest"));
        paramMap.put("Msg", msgMap);
        String paramStr = JSON.toJSONString(paramMap);
        HttpEntity entity = myHttpClient.doPost(url, paramStr);
        if (entity != null) {
            try {
                String result = EntityUtils.toString(entity, Consts.UTF_8);
                return JSON.parseObject(result).getJSONObject("BaseResponse").getInteger("Ret") == 0;
            }
            catch (Exception e) {
                LOG.error("webWxSendMsgImg \u9519\u8bef\uff1a ", e);
            }
        }
        return false;
    }

    public static boolean sendFileMsgByUserId(String userId, String filePath) {
        String title = new File(filePath).getName();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("appid", "API_WXAPPID");
        data.put("title", title);
        data.put("totallen", "");
        data.put("attachid", "");
        data.put("type", "6");
        data.put("fileext", title.split("\\.")[1]);
        JSONObject responseObj = MessageTools.webWxUploadMedia(filePath);
        if (responseObj != null) {
            data.put("totallen", responseObj.getString("StartPos"));
            data.put("attachid", responseObj.getString("MediaId"));
        } else {
            LOG.error("sednFileMsgByUserId \u9519\u8bef: ", (Object)data);
        }
        return MessageTools.webWxSendAppMsg(userId, data);
    }

    public static boolean sendFileMsgByNickName(String nickName, String filePath) {
        String toUserName = WechatTools.getUserNameByNickName(nickName);
        if (toUserName != null) {
            return MessageTools.sendFileMsgByUserId(toUserName, filePath);
        }
        return false;
    }

    private static boolean webWxSendAppMsg(String userId, Map<String, String> data) {
        String url = String.format("%s/webwxsendappmsg?fun=async&f=json&pass_ticket=%s", core.getLoginInfo().get("url"), core.getLoginInfo().get("pass_ticket"));
        String clientMsgId = String.valueOf(new Date().getTime()) + String.valueOf(new Random().nextLong()).substring(1, 5);
        String content = "<appmsg appid='wxeb7ec651dd0aefa9' sdkver=''><title>" + data.get("title") + "</title><des></des><action></action><type>6</type><content></content><url></url><lowurl></lowurl><appattach><totallen>" + data.get("totallen") + "</totallen><attachid>" + data.get("attachid") + "</attachid><fileext>" + data.get("fileext") + "</fileext></appattach><extinfo></extinfo></appmsg>";
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("Type", data.get("type"));
        msgMap.put("Content", content);
        msgMap.put("FromUserName", core.getUserSelf().getString("UserName"));
        msgMap.put("ToUserName", userId);
        msgMap.put("LocalID", clientMsgId);
        msgMap.put("ClientMsgId", clientMsgId);
        Map<String, Object> paramMap = core.getParamMap();
        paramMap.put("Msg", msgMap);
        paramMap.put("Scene", 0);
        String paramStr = JSON.toJSONString(paramMap);
        HttpEntity entity = myHttpClient.doPost(url, paramStr);
        if (entity != null) {
            try {
                String result = EntityUtils.toString(entity, Consts.UTF_8);
                return JSON.parseObject(result).getJSONObject("BaseResponse").getInteger("Ret") == 0;
            }
            catch (Exception e) {
                LOG.error("\u9519\u8bef: ", e);
            }
        }
        return false;
    }

    public static void addFriend(BaseMsg msg, boolean accept) {
        if (!accept) {
            return;
        }
        int status = VerifyFriendEnum.ACCEPT.getCode();
        RecommendInfo recommendInfo = msg.getRecommendInfo();
        String userName = recommendInfo.getUserName();
        String ticket = recommendInfo.getTicket();
        String url = String.format(URLEnum.WEB_WX_VERIFYUSER.getUrl(), core.getLoginInfo().get("url"), String.valueOf(System.currentTimeMillis() / 3158L), core.getLoginInfo().get("pass_ticket"));
        ArrayList verifyUserList = new ArrayList();
        HashMap<String, String> verifyUser = new HashMap<String, String>();
        verifyUser.put("Value", userName);
        verifyUser.put("VerifyUserTicket", ticket);
        verifyUserList.add(verifyUser);
        ArrayList<Integer> sceneList = new ArrayList<Integer>();
        sceneList.add(33);
        JSONObject body = new JSONObject();
        body.put("BaseRequest", core.getParamMap().get("BaseRequest"));
        body.put("Opcode", (Object)status);
        body.put("VerifyUserListSize", (Object)1);
        body.put("VerifyUserList", (Object)verifyUserList);
        body.put("VerifyContent", (Object)"");
        body.put("SceneListCount", (Object)1);
        body.put("SceneList", (Object)sceneList);
        body.put("skey", core.getLoginInfo().get(StorageLoginInfoEnum.skey.getKey()));
        String result = null;
        try {
            String paramStr = JSON.toJSONString(body);
            HttpEntity entity = myHttpClient.doPost(url, paramStr);
            result = EntityUtils.toString(entity, Consts.UTF_8);
        }
        catch (Exception e) {
            LOG.error("webWxSendMsg", e);
        }
        if (StringUtils.isBlank(result)) {
            LOG.error("\u88ab\u52a8\u6dfb\u52a0\u597d\u53cb\u5931\u8d25");
        }
        LOG.debug(result);
    }
}

