const PROPS = {
  TEXT_COLOR: 1,
  BACKGROUND_COLOR: 2,
  FONT_SIZE: 3,
  PADDING: 4,
  MARGIN: 5,
  WIDTH: 6,
  HEIGHT: 7,
  MAX_WIDTH: 8,
  MAX_HEIGHT: 9,
  MIN_WIDTH: 10,
  MIN_HEIGHT: 11,
  IMAGE_URL: 12,
  TOGGLE: 13,
  TEXT_CASE: 14,
  BACKGROUND_PATTERN: 15,
  BORDER: 16,
  BORDER_RADIUS: 17,
};

const elements = {
  logo: {
    id: 'logo',
    title: 'Logo Image',
    cssSelector: 'aside .logo img',
    tooltipAlign: 'top',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.IMAGE_URL, PROPS.WIDTH, PROPS.MAX_WIDTH, PROPS.HEIGHT, PROPS.MAX_HEIGHT, PROPS.MARGIN, PROPS.PADDING],
    values: {
      [PROPS.IMAGE_URL]: { value: '' },
      [PROPS.MAX_WIDTH]: { value: 150 },
      [PROPS.WIDTH]: { value: 'auto' },
      [PROPS.MAX_HEIGHT]: { value: 150 },
      [PROPS.HEIGHT]: { value: 'auto' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  sidebar: {
    id: 'sidebar',
    props: [PROPS.BACKGROUND_PATTERN],
    title: 'Sibebar',
    tooltipAlign: 'right',
    align: 'top right',
    distance: { x: 10, y: 100 },
    cssSelector: 'aside::before',
    injectableSelector: 'aside',
    values: { [PROPS.BACKGROUND_PATTERN]: { isActive: true, opacity: 80, pattern: '5.svg' } },
  },
  sidebarMenuItem: {
    id: 'sidebarMenuItem',
    title: 'Sidebar Menu Item',
    cssSelector: 'aside .uk-nav-default > li > a',
    tooltipAlign: 'right',
    align: 'top right',
    distance: { x: 40, y: -20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 10, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 5, left: 0, right: 0, bottom: 5, unit: 'px' },
    },
  },
  sidebarMenuItemActive: {
    id: 'sidebarMenuItemActive',
    title: 'Sidebar Menu Item Active',
    cssSelector: 'aside .uk-nav-default > li.uk-active > a',
    tooltipAlign: 'right',
    align: 'top right',
    distance: { x: 40, y: -20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 10, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 5, left: 0, right: 0, bottom: 5, unit: 'px' },
    },
  },
  sidebarSubMenuItem: {
    id: 'sidebarSubMenuItem',
    title: 'Sidebar Sub Menu Item',
    cssSelector: 'aside .uk-nav-default .uk-nav-sub a',
    tooltipAlign: 'right',
    align: 'top right',
    distance: { x: 40, y: -200 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 14, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: -15, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 8, left: 25, right: 0, bottom: 8, unit: 'px' },
    },
  },
  sidebarSubMenuItemActive: {
    id: 'sidebarSubMenuItemActive',
    title: 'Sidebar Sub Menu Item Active',
    cssSelector: 'aside .uk-nav-default .uk-nav-sub .uk-active a',
    tooltipAlign: 'right',
    align: 'top right',
    distance: { x: 40, y: -20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 14, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: -15, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 8, left: 25, right: 0, bottom: 8, unit: 'px' },
    },
  },
  sidebarMethodName: {
    id: 'sidebarMethodName',
    title: 'Method Name',
    cssSelector: 'aside .api-method',
    tooltipAlign: 'right',
    align: 'top right',
    distance: { x: 50, y: -20 },
    props: [PROPS.FONT_SIZE, PROPS.BORDER_RADIUS, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 11, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.BORDER_RADIUS]: { top: 20, left: 20, right: 20, bottom: 20, unit: 'px' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 2, left: 6, right: 6, bottom: 2, unit: 'px' },
    },
  },
  headerMenuItem: {
    id: 'headerMenuItem',
    title: 'Header Menu Item',
    cssSelector: 'header .links a',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#999999' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 40, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  headerSearchInput: {
    id: 'headerSearchInput',
    title: 'Search Box',
    cssSelector: 'header .search input',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.HEIGHT, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER_RADIUS, PROPS.TEXT_COLOR],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#666' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 6, right: 40, bottom: 0, unit: 'px' },
      [PROPS.HEIGHT]: { value: 40 },
      [PROPS.BORDER_RADIUS]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  headerSearchResultBox: {
    id: 'headerSearchResultBox',
    title: 'Search Result Container',
    distance: { y: 20 },
    cssSelector: 'header .search-result a',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    props: [PROPS.BACKGROUND_COLOR, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER_RADIUS],
    values: {
      [PROPS.BACKGROUND_COLOR]: { value: '#f8f8f8' },
      [PROPS.MARGIN]: { top: 5, left: 0, right: 0, bottom: 5, unit: 'px' },
      [PROPS.PADDING]: { top: 4, left: 8, right: 8, bottom: 4, unit: 'px' },
      [PROPS.BORDER_RADIUS]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  headerSearchResultHeader: {
    id: 'headerSearchResultHeader',
    title: 'Search Result Title',
    cssSelector: '.search-result a > strong',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#333' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  headerSearchResultPath: {
    id: 'headerSearchResultPath',
    title: 'Search Result Path',
    cssSelector: '.search-result a > span',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#333' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  headerSearchResultMethod: {
    id: 'headerSearchResultMethod',
    title: 'Search Result Method',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    cssSelector: 'header .api-method',
    props: [PROPS.FONT_SIZE, PROPS.BORDER_RADIUS, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 11, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.BORDER_RADIUS]: { top: 20, left: 20, right: 20, bottom: 20, unit: 'px' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 2, left: 6, right: 6, bottom: 2, unit: 'px' },
    },
  },
  projectName: {
    id: 'projectName',
    title: 'Project Name',
    cssSelector: 'main > #project-name',
    tooltipAlign: 'right',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 42, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 20, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  projectDetails: {
    id: 'projectDetails',
    title: 'Project Description',
    cssSelector: 'main > .project-details',
    tooltipAlign: 'right',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 18, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#2d3c41' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 20, left: 0, right: 0, bottom: 20, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  projectType: {
    id: 'projectType',
    title: 'Source Type',
    cssSelector: '.encoding-type-name',
    tooltipAlign: 'right',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER, PROPS.BORDER_RADIUS, PROPS.TEXT_COLOR, PROPS.BACKGROUND_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 10, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'capitalize' },
      [PROPS.BORDER_RADIUS]: { top: 15, left: 15, right: 15, bottom: 15, unit: 'px' },
      [PROPS.MARGIN]: { top: 20, left: 0, right: 0, bottom: 20, unit: 'px' },
      [PROPS.PADDING]: { top: 3, left: 7, right: 7, bottom: 3, unit: 'px' },
      [PROPS.BORDER]: { top: 1, right: 1, bottom: 1, left: 1, unit: 'px', type: 'solid', color: window.color.base },
      [PROPS.BACKGROUND_COLOR]: { value: window.color.base, hint: 'This is the base color, which will be converted to the color you provide in the main api-html form while generating HTML from your api-spec. If you change this color then the changed color will be used instead of base color.' },
    },
  },
  projectSource: {
    id: 'projectSource',
    title: 'Source Url',
    cssSelector: '.encoding-type-file',
    tooltipAlign: 'right',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.TEXT_COLOR, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER, PROPS.BORDER_RADIUS, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 10, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_CASE]: { value: 'capitalize' },
      [PROPS.BORDER_RADIUS]: { top: 15, left: 15, right: 15, bottom: 15, unit: 'px' },
      [PROPS.MARGIN]: { top: 20, left: 0, right: 0, bottom: 20, unit: 'px' },
      [PROPS.PADDING]: { top: 3, left: 7, right: 7, bottom: 3, unit: 'px' },
      [PROPS.BORDER]: { top: 1, right: 1, bottom: 1, left: 1, unit: 'px', type: 'solid', color: '#fca130' },
      [PROPS.TEXT_COLOR]: { value: '#fca130' },
    },
  },
  tagTitle: {
    id: 'tagTitle',
    title: 'Tag Title',
    cssSelector: 'main > h2',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 5 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 32, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 40, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathTitle: {
    id: 'pathTitle',
    title: 'Path Title',
    cssSelector: '.path > h3',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 5 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 24, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 20, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathDetails: {
    id: 'pathDetails',
    title: 'Path Description',
    cssSelector: '.path > p',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 5 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#666' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 20, left: 0, right: 0, bottom: 20, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathUrlBox: {
    id: 'pathUrlBox',
    title: 'Url Box',
    distance: { y: 5 },
    cssSelector: '.path .path-url',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    props: [PROPS.BACKGROUND_COLOR, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER_RADIUS],
    values: {
      [PROPS.BACKGROUND_COLOR]: { value: '#f8f8f8' },
      [PROPS.MARGIN]: { top: 30, left: 0, right: 0, bottom: 30, unit: 'px' },
      [PROPS.PADDING]: { top: 10, left: 15, right: 15, bottom: 10, unit: 'px' },
      [PROPS.BORDER_RADIUS]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathUrlMethod: {
    id: 'pathUrlMethod',
    title: 'Path Method',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    cssSelector: '.path .path-url .api-method',
    props: [PROPS.FONT_SIZE, PROPS.BORDER_RADIUS, PROPS.PADDING, PROPS.MARGIN, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 11, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'white' },
      [PROPS.TEXT_CASE]: { value: 'uppercase' },
      [PROPS.BORDER_RADIUS]: { top: 20, left: 20, right: 20, bottom: 20, unit: 'px' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 2, left: 6, right: 6, bottom: 2, unit: 'px' },
    },
  },
  pathUrlRoot: {
    id: 'pathUrlRoot',
    title: 'Path Root Url',
    cssSelector: '.path .path-url .root',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#666' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 10, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathUrlPath: {
    id: 'pathUrlPath',
    title: 'Url Path',
    cssSelector: '.path .path-url .link',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#10b3d6' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: -2, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathUrlTry: {
    id: 'pathUrlTry',
    title: 'Tryout Button',
    cssSelector: '.path .path-url > a',
    tooltipAlign: 'bottom',
    align: 'bottom left',
    distance: { y: 15, x: 60 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: window.color.base, hint: 'This is the base color, which will be converted to the color you provide in the main api-html form while generating HTML from your api-spec. If you change this color then the changed color will be used instead of base color.' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathTab: {
    id: 'pathTab',
    title: 'Tab not active',
    cssSelector: '.path-tabs li > a',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 5 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 14, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#999' },
      [PROPS.TEXT_CASE]: { value: 'uppercase' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 2, unit: 'px' },
      [PROPS.PADDING]: { top: 5, left: 10, right: 10, bottom: 5, unit: 'px' },
    },
  },
  pathTabActive: {
    id: 'pathTabActive',
    title: 'Tab Active',
    cssSelector: '.path-tabs li.uk-active > a',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 5 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.BORDER, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 14, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#333' },
      [PROPS.TEXT_CASE]: { value: 'uppercase' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 2, unit: 'px' },
      [PROPS.PADDING]: { top: 5, left: 10, right: 10, bottom: 5, unit: 'px' },
      [PROPS.BORDER]: { bottom: 2, color: window.color.base },
    },
  },
  pathRequestContainer: {
    id: 'pathRequestContainer',
    title: 'Request Container',
    distance: { y: 5 },
    cssSelector: '.path .path-tab',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    props: [PROPS.BACKGROUND_COLOR, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER_RADIUS],
    values: {
      [PROPS.BACKGROUND_COLOR]: { value: '#f8f8f8' },
      [PROPS.MARGIN]: { top: -20, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 15, left: 20, right: 20, bottom: 15, unit: 'px' },
      [PROPS.BORDER_RADIUS]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestHeader: {
    id: 'pathRequestHeader',
    title: 'Request Title',
    cssSelector: '.path-tab-request > p',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#666' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestBlock: {
    id: 'pathRequestBlock',
    title: 'Request Block',
    distance: { y: 5 },
    cssSelector: '.path-tab-request .blocks-block',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    props: [PROPS.BACKGROUND_COLOR, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER_RADIUS],
    values: {
      [PROPS.BACKGROUND_COLOR]: { value: '#f8f8f8' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 10, left: 10, right: 10, bottom: 10, unit: 'px' },
      [PROPS.BORDER_RADIUS]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestParamName: {
    id: 'pathRequestParamName',
    title: 'Request Param Name',
    cssSelector: '.path-tab-request .blocks-block-info-col > span:not(.attr)',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 20 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#666666' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestParamOptional: {
    id: 'pathRequestParamOptional',
    title: 'Request Param Optional',
    cssSelector: '.path-tab-request .blocks-block-info-col > .uk-text-meta',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 14, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#999' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestParamRequired: {
    id: 'pathRequestParamRequired',
    title: 'Request Param Required',
    cssSelector: '.path-tab-request .blocks-block-info-col > .red',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 14, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#f44336' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestParamDatatype: {
    id: 'pathRequestParamDatatype',
    title: 'Request Param Datatype',
    cssSelector: '.path .keyword',
    tooltipAlign: 'bottom',
    align: 'bottom center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#7ec699' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestParamDesc: {
    id: 'pathRequestParamDesc',
    title: 'Request Param Description',
    cssSelector: '.path .blocks .blocks-block .blocks-block-desc-col .details',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#847d7d' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestParamDefault: {
    id: 'pathRequestParamDefault',
    title: 'Request Param Default',
    cssSelector: '.path .blocks .blocks-block .blocks-block-desc-col .default',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#666' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathRequestParamDefaultValue: {
    id: 'pathRequestParamDefaultValue',
    title: 'Request Param Default Value',
    cssSelector: '.path .blocks .blocks-block .blocks-block-desc-col .default-value',
    tooltipAlign: 'left',
    align: 'bottom center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#847d7d' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathResponseHeader: {
    id: 'pathResponseHeader',
    title: 'Response Header',
    cssSelector: '.path-tab-response > h4',
    tooltipAlign: 'right',
    align: 'above center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 20, isBold: true, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: 'black' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 20, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathResponseDesc: {
    id: 'pathResponseDesc',
    title: 'Response Description',
    cssSelector: '.path-tab-response .blocks .blocks-block .blocks-block-desc-col .details',
    tooltipAlign: 'top',
    align: 'above center',
    distance: { y: 10 },
    props: [PROPS.FONT_SIZE, PROPS.PADDING, PROPS.TEXT_COLOR, PROPS.TEXT_CASE],
    values: {
      [PROPS.FONT_SIZE]: { value: 16, isBold: false, isItalic: false, isUnderline: false },
      [PROPS.TEXT_COLOR]: { value: '#847d7d' },
      [PROPS.TEXT_CASE]: { value: 'none' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathResponseBlock: {
    id: 'pathResponseBlock',
    title: 'Request Code Container',
    distance: { y: 10 },
    cssSelector: '.path .path-tab-response .blocks .blocks-block .blocks-block-desc-col',
    tooltipAlign: 'top',
    align: 'above center',
    props: [PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER_RADIUS],
    values: {
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 0, left: 5, right: 5, bottom: 0, unit: 'px' },
      [PROPS.BORDER_RADIUS]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  pathResponseCodeBox: {
    id: 'pathResponseCodeBox',
    title: 'Codebox ',
    distance: { y: 20 },
    cssSelector: '.path .path-tab-response .blocks .blocks-block .language-javascript',
    tooltipAlign: 'top',
    align: 'above center',
    props: [PROPS.BACKGROUND_COLOR, PROPS.PADDING, PROPS.MARGIN, PROPS.BORDER_RADIUS],
    values: {
      [PROPS.BACKGROUND_COLOR]: { value: '#011627' },
      [PROPS.MARGIN]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
      [PROPS.PADDING]: { top: 15, left: 20, right: 20, bottom: 15, unit: 'px' },
      [PROPS.BORDER_RADIUS]: { top: 0, left: 0, right: 0, bottom: 0, unit: 'px' },
    },
  },
  globalOptions: {
    id: '',
    props: [],
    title: ''
  }
};
