阿里百秀

基础URL：http://localhost:3000

## 1. 用户管理

### 1.1 创建用户

| 请求地址 | 请求方式 |
| -------- | -------- |
| /users   | POST     |

| 参数名称 | 是否必选 | 参数说明                                    |
| -------- | -------- | ------------------------------------------- |
| nickName | 是       | 用户昵称                                    |
| email    | 是       | 邮件地址                                    |
| password | 是       | 登录密码                                    |
| role     | 是       | 角色  [admin 超级管理员]  [normal 普通用户] |
| avatar   | 否       | 头像                                        |
| status   | 是       | 状态  [0 未激活] [1 激活]                   |

```json
{
    "_id": "5c8d0bd652ae3d26686b8601", // 用户id
    "email": "coder@itcast.cn",        // 邮箱地址
    "nickName": "coder",               // 昵称
    "role": "admin",                   // 角色
    "avatar": null,                    // 头像
    "createTime": "2019-03-16T14:44:38.896Z", // 创建时间
    "status": 1                        // 状态
}
```

### 1.2 用户登录

| 请求地址 | 请求方式 |
| -------- | -------- |
| /login   | POST     |

| 参数名称 | 是否必选 | 参数说明 |
| -------- | -------- | -------- |
| email    | 是       | 邮箱地址 |
| password | 是       | 登录密码 |

```json
{
    "nickName": "coder",
    "email": "coder@itcast.cn",
    "role": "admin",
    "avatar": null,
    "_id": "5c8d0bd652ae3d26686b8601",
    "status": 1,
    "createTime": "2019-03-16T14:44:38.896Z"
}
```

### 1.3 退出登录

| 请求地址 | 请求方式 |
| -------- | -------- |
| /logout  | POST     |

```json
{
    "message": "退出成功"
}
```

### 1.4 操作用户

#### 1.4.1 获取用户登录状态

| 请求地址      | 请求方式 |
| ------------- | -------- |
| /login/status | GET      |

```json
var isLogin = true;
var userId = "5c8d0bd652ae3d26686b8601";
```

#### 1.4.2 获取用户列表

| 请求地址 | 请求方式 |
| -------- | -------- |
| /users   | GET      |

```json
[
    {
        "role": "admin",
        "avatar": null,
        "status": 1,
        "_id": "5c8d0bd652ae3d26686b8601",
        "nickName": "coder",
        "email": "coder@itcast.cn",
        "createTime": "2019-03-16T14:44:38.896Z"
    }
]
```

#### 1.4.3 根据 id 查询用户

|  请求地址  | 请求方式 |
| :--------: | :------: |
| /users/:id |   GET    |

```json
{
    "role": "admin",
    "avatar": null,
    "status": 1,
    "_id": "5c8d17530306b9157040e03a",
    "nickName": "coder123",
    "email": "coder@itcast.cn",
    "createTime": "2019-03-16T15:33:39.785Z"
}
```

#### 1.4.4 根据 id 修改用户

|  请求地址  | 请求方式 |
| :--------: | :------: |
| /users/:id |   PUT    |

| 参数名称 | 是否必选 | 参数说明 |
| :------: | :------: | :------: |
| nickName |    是    | 用户昵称 |
|  status  |    否    | 用户状态 |
|   role   |    否    | 用户角色 |
|  avatar  |    否    | 用户头像 |

```json
{
    "role": "admin",
    "avatar": null,
    "status": 1,
    "_id": "5c8d17530306b9157040e03a",
    "nickName": "coder123",
    "email": "coder@itcast.cn",
    "createTime": "2019-03-16T15:33:39.785Z"
}
```



#### 1.4.5 根据 id 删除用户

| 请求地址   | 请求方式 | 说明                                            |
| ---------- | -------- | ----------------------------------------------- |
| /users/:id | DELETE   | 批量删除，多个id用-隔开，例如：/users/:id-id-id |

```json
{
    "role": "admin",
    "avatar": null,
    "status": 1,
    "_id": "5c8d0bd652ae3d26686b8601",
    "nickName": "coder",
    "password": "$2b$10$M22/fYGmCkK7baXsfA0ZZur3RuatZEDXkujfvZ1j1T73HDdDBwXIG",
    "email": "coder@itcast.cn",
    "createTime": "2019-03-16T14:44:38.896Z"
}
```

```json
[
    {
        "role": "admin",
        "avatar": null,
        "status": 1,
        "_id": "5c8d17530306b9157040e03a",
        "nickName": "coder123",
        "email": "coder@itcast.cn",
        "password": "$2b$10$doXV67Nn1kxsgCjoY/BBd.6kUfta7GJvcYZG6c/kdLly1GlK0ZUa2",
        "createTime": "2019-03-16T15:33:39.785Z"
    }
]
```

#### 1.4.6 修改用户密码

| 请求地址        | 请求方式 |
| --------------- | -------- |
| /users/password | PUT      |

| 参数名称    | 是否必选 | 参数说明 |
| ----------- | -------- | -------- |
| userPass    | 是       | 原密码   |
| newPass     | 是       | 新密码   |
| confirmPass | 是       | 确认密码 |

```json
{
    message: '密码修改成功'
}
```

#### 1.4.7 根据邮箱查找用户

|      请求地址       | 请求方式 |
| :-----------------: | :------: |
| /users/email/:email |   GET    |

```json
{
    "role": "admin",
    "avatar": null,
    "status": 1,
    "_id": "5c8d0bd652ae3d26686b8601",
    "nickName": "coder",
    "password": "$2b$10$M22/fYGmCkK7baXsfA0ZZur3RuatZEDXkujfvZ1j1T73HDdDBwXIG",
    "email": "coder@itcast.cn",
    "createTime": "2019-03-16T14:44:38.896Z"
}
```



## 2. 分类管理

### 2.1 添加分类

| 请求地址    | 请求方式 |
| ----------- | -------- |
| /categories | POST     |

| 参数名称  | 是否必选 | 参数说明     |
| --------- | -------- | ------------ |
| title     | 是       | 分类名称     |
| className | 是       | 分类图标类名 |

```json
{
    "className": "fa-glass",
    "_id": "5c8dbc2ded67612f8837e0db",
    "title": "奇趣事",
    "createAt": "2019-03-17T03:17:01.733Z"
}
```

### 2.2 查询分类

#### 2.2.1 根据 id 查询分类

|    请求地址     | 请求方式 |
| :-------------: | :------: |
| /categories/:id |   GET    |

```json
{
    "className": "fa-glass",
    "_id": "5c8dbd8f67d2a02ea076555e",
    "title": "奇趣事100",
    "createAt": "2019-03-17T03:22:55.066Z"
}
```



#### 2.2.2 查询分类列表

| 请求地址    | 请求方式 |
| ----------- | -------- |
| /categories | GET      |

```json
[
    {
        "className": "fa-glass",
        "_id": "5c8dbc2ded67612f8837e0db",
        "title": "奇趣事",
        "createAt": "2019-03-17T03:17:01.733Z"
    },
    {
        "className": "fa-glass",
        "_id": "5c8dbd8f67d2a02ea076555e",
        "title": "奇趣事4",
        "createAt": "2019-03-17T03:22:55.066Z"
    }
]
```

#### 2.2.3 查询分类数量

|     请求地址      | 请求方式 |
| :---------------: | :------: |
| /categories/count |   GET    |

```json
{
    "categoryCount": 2
}
```



### 2.5 根据 id 修改分类

|    请求地址     | 请求方式 |
| :-------------: | :------: |
| /categories/:id |   PUT    |

| 参数名称  | 是否必选 |   参数说明   |
| :-------: | :------: | :----------: |
|   title   |    否    |   分类名称   |
| className |    否    | 分类图标类名 |

```json
{
    "className": "fa-glass",
    "_id": "5c8dbd8f67d2a02ea076555e",
    "title": "奇趣事100",
    "createAt": "2019-03-17T03:22:55.066Z"
}
```

### 2.6 根据 id 删除分类

|    请求地址     | 请求方式 |                         说明                         |
| :-------------: | :------: | :--------------------------------------------------: |
| /categories/:id |  DELETE  | 批量删除，多个id用-隔开，例如：/categories/:id-id-id |

```json
{
    "className": "fa-glass",
    "_id": "5c8dbd8667d2a02ea076555b",
    "title": "奇趣事1",
    "createAt": "2019-03-17T03:22:46.456Z"
}
```

```json
[
    {
        "className": "fa-glass",
        "_id": "5c8dbd8867d2a02ea076555c",
        "title": "奇趣事2",
        "createAt": "2019-03-17T03:22:48.369Z"
    }
]
```



## 3. 文章管理

### 3.1 创建文章

| 请求地址 | 请求方式 |
| -------- | -------- |
| /posts   | POST     |

| 参数名称  | 是否必选 | 参数说明                   |
| --------- | -------- | -------------------------- |
| title     | 是       | 文章标题                   |
| state     | 是       | 文章状态 [0 草稿] [1 发布] |
| content   | 是       | 文章内容                   |
| category  | 是       | 文章所属分类               |
| thumbnail | 否       | 文章缩略图                 |
| createAt  | 是       | 文章发布时间               |

```json	
{
    "meta": {
        "views": 0,
        "likes": 0,
        "comments": 0
    },
    "state": 1,
    "content": "测试内容",
    "thumbnail": null,
    "_id": "5c8dcd3a2346ad087cf957bf",
    "title": "测试文章",
    "category": "5c8dbc2ded67612f8837e0db",
    "author": "5c8dcd072346ad087cf957be",
    "createAt": "2019-03-17T04:29:46.212Z",
    "updateAt": "2019-03-17T04:29:46.212Z"
}
```

### 3.2 查询文章

#### 3.2.1 根据 id 获取文章

|  请求地址  | 请求方式 |
| :--------: | :------: |
| /posts/:id |   GET    |

```json
{
    "meta": {
        "views": 0,
        "likes": 0,
        "comments": 0
    },
    "state": 1,
    "content": "测试内容",
    "thumbnail": null,
    "_id": "5c8dcf3a5fcbf1100c276648",
    "title": "测试文章",
    "category": "5c8dbc2ded67612f8837e0db",
    "author": "5c8dcd072346ad087cf957be",
    "createAt": "2019-03-17T04:29:46.212Z",
    "updateAt": "2019-03-17T04:29:46.212Z"
}
```

#### 3.2.2 查询文章列表

| 请求地址 | 请求方式 |
| -------- | -------- |
| /posts   | GET      |

| 参数名称 | 是否必选 | 参数说明                   |
| -------- | -------- | -------------------------- |
| category | 否       | 文章所属分类               |
| state    | 否       | 文章状态 [0 草稿] [1 发布] |
| page     | 否       | 文章页码                   |

```json
{
    "page": 1,
    "size": 10,
    "total": 4,
    "records": [
        {
            "state": 1,
            "thumbnail": null,
            "_id": "5c8dcf3a5fcbf1100c276648",
            "title": "测试文章",
            "category": {
                "className": "fa-glass",
                "_id": "5c8dbc2ded67612f8837e0db",
                "title": "奇趣事",
                "createAt": "2019-03-17T03:17:01.733Z"
            },
            "author": {
                "role": "admin",
                "avatar": null,
                "status": 1,
                "_id": "5c8dcd072346ad087cf957be",
                "nickName": "coder",
                "email": "coder@itcast.cn",
                "createTime": "2019-03-17T04:28:55.780Z"
            },
            "createAt": "2019-03-17T04:29:46.212Z",
            "updateAt": "2019-03-17T04:29:46.212Z"
        }
    ],
    "pages": 1,
    "display": [
        1
    ]
}
```

#### 3.2.3 根据分类获取文章列表

|      请求地址       | 请求方式 |
| :-----------------: | :------: |
| /posts/category/:id |   GET    |

```json
[
    {
        "meta": {
            "views": 0,
            "likes": 0,
            "comments": 0
        },
        "state": 1,
        "content": "测试内容",
        "thumbnail": null,
        "_id": "5c8dcf3a5fcbf1100c276648",
        "title": "是单独发顺丰",
        "category": "5c8dbc2ded67612f8837e0db",
        "author": "5c8dcd072346ad087cf957be",
        "createAt": "2019-03-17T04:29:46.212Z",
        "updateAt": "2019-03-17T04:29:46.212Z"
    }
]
```



#### 3.2.4 查询文章数量

|   请求地址   | 请求方式 |
| :----------: | :------: |
| /posts/count |   GET    |

```json
{
    "postCount": 4,
    "draftCount": 0
}
```

#### 3.2.5 获取最新发布文章

|   请求地址    | 请求方式 |
| :-----------: | :------: |
| /posts/lasted |   GET    |

```json
[
    {
        "state": 1,
        "thumbnail": null,
        "_id": "5c8dcf415fcbf1100c27664b",
        "title": "测试文章",
        "category": {
            "className": "fa-glass",
            "_id": "5c8dbc2ded67612f8837e0db",
            "title": "奇趣事",
            "createAt": "2019-03-17T03:17:01.733Z"
        },
        "author": {
            "role": "admin",
            "avatar": null,
            "status": 1,
            "_id": "5c8dcd072346ad087cf957be",
            "nickName": "coder",
            "email": "coder@itcast.cn",
            "createTime": "2019-03-17T04:28:55.780Z"
        },
        "createAt": "2019-03-20T04:29:46.212Z",
        "updateAt": "2019-03-20T04:29:46.212Z"
    }
]
```

#### 3.2.6 获取热门推荐

|     请求地址     | 请求方式 |
| :--------------: | :------: |
| /posts/recommend |   GET    |

```json
[
    {
        "meta": {
            "views": 0,
            "likes": 0,
            "comments": 3
        },
        "state": 1,
        "thumbnail": null,
        "_id": "5c8dcf3f5fcbf1100c27664a",
        "title": "测试文章",
        "category": "5c8dbc2ded67612f8837e0db",
        "author": "5c8dcd072346ad087cf957be",
        "createAt": "2019-03-19T04:29:46.212Z",
        "updateAt": "2019-03-19T04:29:46.212Z"
    }
]
```

#### 3.2.7 获取随机推荐

|   请求地址    | 请求方式 |
| :-----------: | :------: |
| /posts/random |   GET    |

```json
[
    {
        "meta": {
            "views": 0,
            "likes": 0,
            "comments": 0
        },
        "state": 1,
        "content": "测试内容",
        "thumbnail": null,
        "_id": "5c8dcf3a5fcbf1100c276648",
        "title": "是单独发顺丰",
        "category": "5c8dbc2ded67612f8837e0db",
        "author": "5c8dcd072346ad087cf957be",
        "createAt": "2019-03-17T04:29:46.212Z",
        "updateAt": "2019-03-17T04:29:46.212Z"
    }
]
```



### 3.3 根据 id 修改文章

| 请求地址   | 请求方式 |
| ---------- | -------- |
| /posts/:id | PUT      |

| 参数名称  | 是否必选 | 参数说明                   |
| --------- | -------- | -------------------------- |
| title     | 否       | 文章标题                   |
| state     | 否       | 文章状态 [0 草稿] [1 发布] |
| content   | 否       | 文章内容                   |
| category  | 否       | 文章所属分类               |
| thumbnail | 否       | 文章缩略图                 |

```json
{
    "meta": {
        "views": 0,
        "likes": 0,
        "comments": 0
    },
    "state": 1,
    "content": "测试内容",
    "thumbnail": null,
    "_id": "5c8dcf3a5fcbf1100c276648",
    "title": "是单独发顺丰",
    "category": "5c8dbc2ded67612f8837e0db",
    "author": "5c8dcd072346ad087cf957be",
    "createAt": "2019-03-17T04:29:46.212Z",
    "updateAt": "2019-03-17T04:29:46.212Z"
}
```

### 3.4 根据 id 删除文章

|  请求地址  | 请求方式 |
| :--------: | :------: |
| /posts/:id |  DELETE  |

```json
{
    "meta": {
        "views": 0,
        "likes": 0,
        "comments": 0
    },
    "state": 1,
    "content": "测试内容",
    "thumbnail": null,
    "_id": "5c8dcd3a2346ad087cf957bf",
    "title": "测试文章",
    "category": "5c8dbc2ded67612f8837e0db",
    "author": "5c8dcd072346ad087cf957be",
    "createAt": "2019-03-17T04:29:46.212Z",
    "updateAt": "2019-03-17T04:29:46.212Z"
}
```



### 3.5 文章点赞

| 请求地址            | 请求方式 |
| ------------------- | -------- |
| /posts/fabulous/:id | POST     |

```json
{
    "meta": {
        "views": 0,
        "likes": 4,
        "comments": 0
    },
    "_id": "5c8dcf3a5fcbf1100c276648"
}
```

### 3.6 文章搜索

| 请求地址           | 请求方式 |
| ------------------ | -------- |
| /posts/search/:key | GET      |

```json
[
    {
        "meta": {
            "views": 0,
            "likes": 0,
            "comments": 0
        },
        "state": 1,
        "content": "测试内容",
        "thumbnail": null,
        "_id": "5c8dcf3a5fcbf1100c276648",
        "title": "是单独发顺丰",
        "category": "5c8dbc2ded67612f8837e0db",
        "author": "5c8dcd072346ad087cf957be",
        "createAt": "2019-03-17T04:29:46.212Z",
        "updateAt": "2019-03-17T04:29:46.212Z"
    }
]
```

## 4. 评论管理

### 4.1 创建评论

| 请求地址  | 请求方式 |
| --------- | -------- |
| /comments | POST     |

| 参数名称 | 是否必选 | 参数说明   |
| -------- | -------- | ---------- |
| content  | 是       | 评论内容   |
| post     | 是       | 评论文章id |
| state    | 是       | 评论状态   |

```json
{
    "state": 0,
    "_id": "5c8dee68f4ce931c2c4a0cc3",
    "author": "5c8dcd072346ad087cf957be",
    "content": "文章很精彩",
    "post": "5c8dcf3a5fcbf1100c276648",
    "createAt": "2019-03-17T06:51:20.552Z"
}
```

### 4.2 获取评论列表

| 请求地址  | 请求方式 |
| --------- | -------- |
| /comments | GET      |

| 参数名称 | 是否必选 | 参数说明 |
| -------- | -------- | -------- |
| page     | 否       | 页码     |

```json
{
    "page": 1,
    "size": 10,
    "total": 1,
    "records": [
        {
            "state": 1,
            "_id": "5c8deda9481a8a3070377305",
            "author": {
                "role": "admin",
                "avatar": null,
                "status": 1,
                "_id": "5c8dcd072346ad087cf957be",
                "nickName": "coder",
                "email": "coder@itcast.cn",
                "createTime": "2019-03-17T04:28:55.780Z"
            },
            "content": "文章很精彩",
            "post": {
                "state": 1,
                "thumbnail": null,
                "_id": "5c8dcf3a5fcbf1100c276648",
                "title": "是单独发顺丰",
                "category": "5c8dbc2ded67612f8837e0db",
                "author": "5c8dcd072346ad087cf957be",
                "createAt": "2019-03-17T04:29:46.212Z",
                "updateAt": "2019-03-17T04:29:46.212Z"
            },
            "createAt": "2019-03-17T06:48:09.954Z"
        }
    ],
    "pages": 1,
    "display": [
        1
    ]
}
```

### 4.3 更改评论状态

| 请求地址      | 请求方式 |
| ------------- | -------- |
| /comments/:id | PUT      |

| 参数名称 | 是否必选 | 参数说明 |
| -------- | -------- | -------- |
| state    | 是       | 0或1     |

```json
{
    "state": 0,
    "_id": "5c8deda9481a8a3070377305",
    "author": "5c8dcd072346ad087cf957be",
    "content": "文章很精彩",
    "post": "5c8dcf3a5fcbf1100c276648",
    "createAt": "2019-03-17T06:48:09.954Z"
}
```

### 4.4 查询评论数量

| 请求地址        | 请求方式 |
| --------------- | -------- |
| /comments/count | GET      |

```json
{
    "commentCount": 12,
    "draftCount":2
}
```

### 4.5 获取最新评论

| 请求地址         | 请求方式 |
| ---------------- | -------- |
| /comments/lasted | GET      |

```json
[
    {
        "state": 0,
        "_id": "5c8f2e5f5cd7da32e093c506",
        "author": {
            "role": "admin",
            "avatar": null,
            "status": 1,
            "_id": "5c8dcd072346ad087cf957be",
            "nickName": "coder",
            "email": "coder@itcast.cn",
            "createTime": "2019-03-17T04:28:55.780Z"
        },
        "content": "万分精彩！！！！",
        "post": "5c8dcf3f5fcbf1100c27664a",
        "createAt": "2019-03-19T05:36:31.187Z"
    }
]
```

### 4.6 根据 id 删除评论

|   请求地址    | 请求方式 |
| :-----------: | :------: |
| /comments/:id |  DELETE  |

```json
{
    "state": 0,
    "_id": "5c8dee68f4ce931c2c4a0cc3",
    "author": "5c8dcd072346ad087cf957be",
    "content": "文章很精彩",
    "post": "5c8dcf3a5fcbf1100c276648",
    "createAt": "2019-03-17T06:51:20.552Z"
}
```

### 4.7 根据文章id获取文章评论

|      请求地址      | 请求方式 |
| :----------------: | :------: |
| /comments?pId=:pid |   GET    |

```json
[
  {
    state: 0,
    _id: 5ef9f19c351a184694277490,
    content: '我来评论了',
    post: {
      state: 1,
      thumbnail: '\\uploads\\upload_41d045da01a686b2b1b690e9eaa2b9c7.jpg',
      _id: 5ef844dfd76d6428d498f85a,
      title: '我是小白自己写代码',
      category: 5ef7fb766bc74204a0efe193,
      createAt: 2020-06-28T07:20:00.000Z,
      author: 5ef6aa607bf23125909b0932,
      updateAt: 2020-06-28T07:21:03.723Z
    },
    author: {
      role: 'normal',
      avatar: '\\uploads\\upload_921cfaf4db9920fd34517747f9734da1.jpg',
      status: 1,
      _id: 5ef9d6f538a21f4454c63195,
      email: '123456@aa.com',
      nickName: 'xiaobai',
      createTime: 2020-06-29T11:56:37.831Z
    },
    createAt: 2020-06-29T13:50:20.960Z
  }
]
```



## 5. 网站设置

### 5.1 添加轮播图片

| 请求地址 | 请求方式 |
| -------- | -------- |
| /slides  | POST     |

| 参数名称 | 是否必选 | 参数说明   |
| -------- | -------- | ---------- |
| title    | 是       | 轮播图标题 |
| image    | 是       | 轮播图片   |
| link     | 否       | 图片链接   |

```json
{
    "image": "\\uploads\\upload_569f9bc4b04b4979c98a0264fbcff4de.jpg",
    "link": "#",
    "_id": "5c8e5b459a03f139683b3f53",
    "title": "测试标题"
}
```

### 5.2 获取轮播图列表

| 请求地址 | 请求方式 |
| -------- | -------- |
| /slides  | GET      |

```json
[
    {
        "image": "null",
        "link": "#",
        "_id": "5c8f1a16b332631efc6fc310",
        "title": "轮播图测试标题"
    }
]
```

### 5.3 删除轮播图片

|  请求地址   | 请求方式 |
| :---------: | :------: |
| /slides/:id |  DELETE  |

```json
{
    "image": "/uploads/upload_5c84659382fdbe2cc505ff1c3ef0c134.jpg",
    "link": "#",
    "_id": "5c8e5e33ba71a93314d3c1eb",
    "title": "测试标题"
}
```



### 5.4 网站配置

| 请求地址  | 请求方式 |
| --------- | -------- |
| /settings | POST     |

| 参数名称 | 是否必选 | 参数说明             |
| -------- | -------- | -------------------- |
| title    | 是       | 站点名称             |
| comment  | 是       | 是否开启评论功能     |
| review   | 是       | 评论必须经过人工审核 |
| logo     | 否       | 网站图标             |

```json
{
    "logo": null,
    "comment": true,
    "review": true,
    "_id": "5c8ed3e7c7f0701c34a63589",
    "title": "测试站点标题"
}
```

### 5.5 获取网站配置

| 请求地址  | 请求方式 |
| --------- | -------- |
| /settings | GET      |

```json
{
    "logo": null,
    "comment": true,
    "review": true,
    "_id": "5c8ed3e7c7f0701c34a63589",
    "title": "测试站点标题"
}
```

## 6. 其他功能

### 图片文件上传

| 请求地址 | 请求方式 |
| -------- | -------- |
| /upload  | POST     |

| 参数名称 | 是否必选 | 参数说明 |
| -------- | -------- | -------- |
| avatar   | 是       | 图片文件 |

```json
[
    {
        "avatar": "\\uploads\\upload_569f9bc4b04b4979c98a0264fbcff4de.jpg"
    }
]
```