package com.spring.webadmin;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@ComponentScan(basePackages = {"com.spring"})
@MapperScan("com.spring.common.mybatis")
@RestController
@EnableSwagger2
@EnableScheduling   // 2.开启定时任务
@EnableAsync
public class WebadminApplication {

    public static void main(String[] args) {
        SpringApplication.run(WebadminApplication.class, args);
    }

}
