# 100ProjectsOfCode
A list of practical knowledge-building projects. As the projects are aimed to increase your knowledge base, they are somewhat challenging. However, there are a few easy ones too. Many of them are even worthy enough to showcase on your portfolio.   
The projects are divided into multiple categories and tagged with some suggested languages and frameworks/tools (I'm still working on this part) to get you started.

## Getting Started
To get started with the project ideas:
1. Pick a project from the list
2. Create a GitHub repository for the project
3. Start working, possibly from scratch (reinvent the wheel if you have to!)
4. When done, test it, and share with the tag #100ProjectsOfCode somewhere in the README of the repo
5. Fork this repo
6. Check the completed item, and repeat with another project idea

## Categories

### General Web & Networking Projects  
General Web projects, from building a simple website to building tools for complex and difficult networking tasks like packet sniffing.  
  - [ ] [FTP Client](#ftp-client)
  - [ ] [HTTP Server](#http-server)
  - [ ] [Web Scraper](#web-scraper)
  - [ ] [Port Scanner](#port-scanner)
  - [ ] [Packet Sniffer](#packet-sniffer)
  - [ ] [P2P File Sharing](#p2p-file-sharing)
  - [ ] [Web Search Engine](#search-engine)
  - [ ] [Bandwidth Monitor](#bandwidth-monitor)
  - [ ] [Product Landing Page](#product-landing-page)
  - [ ] [Create Your Own Blog](#blog)
  - [ ] [Your Portfolio Website](#portfolio-website)
  - [ ] [Animated Navigation Toggle](#animated-navigation-toggle)
  - [ ] [Country Lookup using IP address](#country-lookup-using-ip-address)
### Bots  
Building automated bots is something you really want to try out at some point in your career/life.  
  - [ ] [Chatbot](#chatbot)
  - [ ] [Slack Bot](#slack-bot)
  - [ ] [Twitter Bot](#twitter-bot)
  - [ ] [Messenger Bot](#messenger-bot)
  - [ ] [WhatsApp Butler](#whatsapp-butler)
### Software & Apps  
Proper software or application suggestions that you may even end up using in your daily life, like a simple text editor or a custom music player.  
  - [ ] [Quiz App](#quiz-app)
  - [ ] [Firewall](#firewall)
  - [ ] [ToDo List](#todo-list)
  - [ ] [Text Editor](#text-editor)
  - [ ] [App Builder](#application-builder)
  - [ ] [Drawing App](#drawing-app)
  - [ ] [Survey App](#survey-app)
  - [ ] [Web Browser](#web-browser)
  - [ ] [Weather App](#weather-app)
  - [ ] [Math Editor](#math-editor)
  - [ ] [Music Player](#music-player)
  - [ ] [Stopwatch App](#stopwatch-app)
  - [ ] [URL Shortener](#url-shortener)
  - [ ] [Payment System](#payment-system)
  - [ ] [Meme Generator](#meme-generator)
  - [ ] [Pomodoro Clock](#pomodoro-clock)
  - [ ] [Typing Practice](#typing-practice)
  - [ ] [Grammar Checker](#grammar-checker)
  - [ ] [News Aggregator](#news-aggregator)
  - [ ] [Calorie Counter](#calorie-counter)
  - [ ] [Traffic Notifier](#traffic-notifier)
  - [ ] [Virtual Assistant](#virtual-assistant)
  - [ ] [Antivirus Software](#antivirus-software)
  - [ ] [Video Call Application](#video-call-application)
  - [ ] [Library Management System](#library-management-system)
  - [ ] [Relational Database Management System](#relational-database-management-system)
### Artificial Intelligence  
Projects that mostly deal with Artificial Intelligence or Machine Learning. Ideal to showcase on your portfolio if you are thinking of apply for any AI related jobs or programs.  
  - [ ] [Face Tracking](#face-tracker)
  - [ ] [Spam Classifier](#spam-classifier)
  - [ ] [Spoiler Blocker](#spoiler-blocker)
  - [ ] [Music Suggestor](#music-suggestor)
  - [ ] [Machine Translator](#machine-translator)
  - [ ] [Hand Gesture Recognition](#hand-gesture-recognition)
  - [ ] [Video Subtitle Generator](#video-subtitle-generator)
  - [ ] [Automatic Logo Generator](#automatic-logo-generator)
  - [ ] [Movie Recommendation System](#movie-recommendation-system)
  - [ ] [Audio to Sign Language Translator](#audio-to-sign-laguage-translator)
### Theoretical Computer Science  
Projects that provide a deeper insight into the inner workings of many CS related stuff that you may be using knowingly or unknowingly in your daily life.  
  - [ ] [Build an OS](#build-an-os)
  - [ ] [Shuffle Deck](#shuffle-deck)
  - [ ] [Sorting Visualizer](#sorting-visualizer)
  - [ ] [Static Code Analyzer](#static-code-analyzer)
  - [ ] [Command Line Terminal](#command-line-terminal)
  - [ ] [UML Diagram Generator](#uml-diagram-generator)
  - [ ] [Pathfinding Visualizer](#pathfinding-visualizer)
  - [ ] [Version Control System](#version-control-system)
  - [ ] [Code a Programming Language](#programming-language)
### Cryptography  
Projects that involve dealing with encryption/decryption or in general computer security.  
  - [ ] [Codec Software](#codec-software)
  - [ ] [Password Manager](#password-manager)
  - [ ] [Password Generator](#password-generator)
  - [ ] [Folder Encrypter/Locker](#folder-encrypter)
  - [ ] [Password Strength Checker](#password-strength-checker)
### Simulations, Games and Game AI  
All work and no play makes jack a dull boy! Games are a must to enjoy and learn many of the concepts of programming including OOPS.  
  - [ ] [Pong](#pong)
  - [ ] [Pong AI](#pong-ai)
  - [ ] [Risk](#risk)
  - [ ] [Chess](#chess)
  - [ ] [Snake](#snake)
  - [ ] [Tetris](#tetris)
  - [ ] [Chess AI](#chess-ai)
  - [ ] [Snake AI](#snake-ai)
  - [ ] [Map Maker](#map-maker)
  - [ ] [Battleship](#battleship)
  - [ ] [Flappy Bird](#flappy-bird)
  - [ ] [Tic-Tac-Toe](#tic-tac-toe)
  - [ ] [Memory Puzzle](#memory-puzzle)
  - [ ] [Physics Engine](#physics-engine)
  - [ ] [Flappy Bird AI](#flappy-bird-ai)
  - [ ] [Tic-Tac-Toe AI](#tic-tac-toe-ai)
  - [ ] [Elevator Simulator](#elevator-simulator)
  - [ ] [Simulate the World](#simulate-the-world)
  - [ ] [Character Generator](#character-generator)
  - [ ] [Conway's Game of Life](#game-of-life)
### Miscellaneous  
These were alone in their own categories and I didn't want them to feel alone, so I pooled them together.  
  - [ ] [Deal Finder](#deal-finder)
  - [ ] [Expense Tracker](#expense-tracker)
  - [ ] [Recipe Generator](#recipe-generator)
  - [ ] [Emoji Translator](#emoji-translator)
  - [ ] [Regex Query Tool](#regex-query-tool)
  - [ ] [Currency Converter](#currency-converter)
  - [ ] [Pixel Art Generator](#pixel-art-generator)
  - [ ] [Directory Tree Generator](#directory-tree-generator)
  - [ ] [Random username Generator](#random-username-generator)
  - [ ] [Roman to Decimal Converter](#roman-to-decimal-converter)
### Coding Challenges  
Some recommended channels to work on more problems and sharpen your coding skills.  
  - [ ] [Project Euler](#project-euler)
  - [ ] [Advent-Of-Code](#advent-of-code)
  - [ ] [Kaggle's Titanic Challenge](#kaggle-titanic-challenge)


<!--
Template
## Title

Description

**Suggested Language**:
**Suggested Frameworks/Tools**:
**Example Implementation**:
-->

## General Web & Networking Projects  

### FTP Client

A simple File Transfer client that uses the FTP (File Transfer Protocol). As a bonus challenge, add support for secure file transfer. It can be a web, desktop, or CLI app.  
You can try to first implement TFTP (Trivial File Transfer Protocol) as it's easier.

**Suggested Language**: C/C++  
**Suggested Frameworks/Tools**: Use [Wireshark](https://github.com/wireshark/wireshark) to observe packets and debug them  
**Example Implementation**: [Filezilla](https://filezilla-project.org/sourcecode.php) is extremely complete, [here](https://github.com/jlaffaye/ftp) is a simple Go implementation  

### HTTP Server

To understand HTTP better, you need to build an HTTP server. It's not much difficult now a days (with the wealth of information around us).

**Suggested Language**: Python (or any other language you want to master)  
**Suggested Frameworks/Tools**: socket (Python Library)  
**Example Implementation**: [Blog Post by Ruslan](https://ruslanspivak.com/lsbaws-part1/)  

### Web Scraper

Build a web scraper that takes in a URL/Keyword as input and returns matching results from the web related to the input. You can also build a product searcher or something like that.

**Suggested Language**: Python (or any other language you want to master)  
**Suggested Frameworks/Tools**: Beautifulsoup (Python Library)  
**Example Implementation**:

### Port Scanner

Build a port scanner application that can probe a server or host for open ports. You will need some technical knowledge regarding how networks work and how you can scan for ports or classify them.

**Suggested Language**: Java, C++, Python  
**Suggested Frameworks/Tools**: [socket](https://docs.python.org/3/library/socket.html) Python library  
**Example Implementation**: [piescan](https://github.com/m57/piescan) is a Python implementation

### Packet Sniffer

A packet sniffer is used to monitor network traffic by examining streams of data packets that flow between computers on a network. To start with the project, study network protocols properly. Then dive into implementing an application that tracks down network packets and parses its content in a human readable form.

**Suggested Language**: Java, C++  
**Suggested Frameworks/Tools**:  
**Example Implementation**: [Wireshark](https://github.com/wireshark/wireshark) is an extremely complete packet sniffer, [herbivore](https://github.com/samatt/herbivore) is a simpler implementation.

### P2P File Sharing

Build an app that will allow for peer-to-peer file sharing securely over the internet. This will help you transfer files securely from one location to another or send something to your friend.

**Suggested Language**: Java, C++  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Search Engine

Build a Web Search Engine like Google or Bing. Don't copy from them though :wink:

**Suggested Language**: web languages. The real work will happen on the backend side with languages like Python, PHP, SQL, Node... Use anything you want for the frontend : HTML, CSS, Javascript...  
**Suggested Frameworks/Tools**: Django if you use Python, MySQL for the databases if you need one  
**Example Implementation**: [searX](https://github.com/searx/searx) is an open-source search engine coded mostly in Python and Javascript

### Bandwidth Monitor

Build a tool to track how much data you have downloaded or uploaded to the internet. Have it email you weekly reports of your usage (or notify you when you get above a specified usage limit). As a bonus challenge, predict peak usage times.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Product Landing Page

Build the ideal product landing page according to you. Choose a product, build a page and showcase that on your portfolio.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Blog

A blog is a must have for everyone (according to me). Combine that fact with the fact that you learn a lot of things while building your own blog from scratch, and voila!

**Suggested Language**: JavaScript, Python, Ruby  
**Suggested Frameworks/Tools**: Jekyll (for Ruby), Django/Flask (Python)  
**Example Implementation**:

### Portfolio Website

If you are ever interested in showcasing the things you have built, build a portfolio website! Building a website to display all the stuff will teach you a lot about website design in general (if you've never built a website before).

**Suggested Language**: JavaScript, HTML, CSS  
**Suggested Frameworks/Tools**: GatsbyJS  
**Example Implementation**:

### Animated Navigation Toggle

Although it may seem like a small task, building an animated navigation toggle will teach you a lot about web development. Explore all the ideas that you can play with and see if you can build something truly fascinating!

**Suggested Language**: JavaScript, CSS  
**Suggested Frameworks/Tools**: -  
**Example Implementation**:

### Country Lookup using IP address

Can you find the country from a provided IP address? Write a script that can help you with this. For bonus points, try to figure out a more local location from the IP address.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

## Bots  

### Chatbot

Build a chatbot that you can talk to when bored. For bonus points use machine learning/AI to make it smart. I suggest you to implement it as a simple CLI application.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Slack Bot

Description

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Twitter Bot

Build a bot that will either
- follow people that follow the bot
- retweet tweets containing some specific keywords related to a topic
- retweet tweets containing a specific hashtag

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Messenger Bot

Build a bot for messenger that can do some menial tasks too like flip a coin, roll a dice, present the news, and chat with you when bored.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### WhatsApp Butler

Build a bot for WhatsApp that can scrape information from the internet like news, wikipedia entries, and other things. Make it able to keep track of some events like your/someone else's birthday and send an automatic message wishing you/the other person.

**Suggested Language**:
**Suggested Frameworks/Tools**:
**Example Implementation**:

## Software & Apps  

### Quiz App

The user chooses a category and gets a random set of questions from the given category. Implement a Multiple choice Quiz app to prevent more complications.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Firewall

Build a firewall software that can regulate the network connections for the user and also block/notify of any suspicious action from any website/internal software/external agent.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### ToDo List

Build a To Do app that can track the various stages of a given work (todo, ongoing, completed). For bonus points, make it work with recurring tasks and incorporate task scheduling (when to do what/a deadline for tasks).

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Text Editor

Build a simple text editor that can help you open, read from and write to text files. For bonus points incorporate features like the find tool and regex search and replace.

**Suggested Language**: JavaScript, Java  
**Suggested Frameworks/Tools**: Electron (JavaScript framework)  
**Example Implementation**: Atom Editor, Notepad++

### Application Builder

This is probably the hardest one on the list and the most vague one too. Design a system that takes in text input and generates applications (or at least application interfaces) based on the text description. You can also use a drag-and-drop like feature to let users build the app.

**Suggested Language**: -  
**Suggested Frameworks/Tools**: -  
**Example Implementation**: [AppGyver](https://www.appgyver.com/) is a good example of no code app builder

### Drawing App

Build an app that lets the user draw anything and save it as an image. For extra points, add colouring and other cool things like animations.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Survey App

Build an app/web app that will let anyone create survey questions and circulate it via email to record responses and then analyze the data collected.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Web Browser

Build a piece of software that will help you browse any HTML page. For bonus points, add additional features like those in Chrome and Firefox.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Weather App

Build an app that gets the weather at your location in the current time. You can either use a web scraper in the background to collect the data or use a weather API.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Math Editor

Build an app that will properly format equations that a user inputs. I personally find it really inconvenient to work with a special software to just write and display equations properly like Latex, thus, if you build something that can convert plain English text to properly formatted equations, ping me!

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Music Player

Build a music player app that can play music from mp3 files and also have functionality for forward, rewind, pause, and play.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Stopwatch App

Build a stopwatch app/web app. It should also be able to lap time.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### URL Shortener

Build a web app that can shorten any URL that the user provides. You can either code an algorithm that shortens and stores the user provide URL or use an API.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Payment System

Build a payment interface that can deal with fake cash (better if you can deal with real currency, although I don't know if you have to take extra steps for that). Users should be able to receive and send money, and also check their current balance.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### MEME Generator

Build an app/web app that will overlay text over an image, so that users can build memes.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Pomodoro Clock

Build a Pomodoro timer that will help you take breaks at proper times while doing a task. For bonus points include different Pomodoro timer formats.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Typing Practice

Build an app that lets you practice typing. Make it generate random sentences and see how fast you can type the sentences. Typing is something that many developers completely ignore, but it is one of the most important skills that someone working with computers should have.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Grammar Checker

Build a software that will spell check and check simple grammatical errors in any text you write. For additional points/complexity, try to guess the mood (happy text, formal letter, etc) of the text and suggest appropriate changes.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### News Aggregator

Build an app that will present you daily news from credible sources. Make sure you pool unique information about a given news headline from different sites to remove any bias that may be present in a given source.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Calorie Counter

Build an app that will track the amount of calories that you eat everyday. Try to also incorporate information about other macro and micro nutrients to provide a more complete picture.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Traffic Notifier

Build an app (phone app will be better) that finds how congested one route is and then suggests you a better route to take to your destination.

**Suggested Language**: Java, Kotlin, Swift  
**Suggested Frameworks/Tools**: Android Studio  
**Example Implementation**:

### Virtual Assistant

Build a virtual assistant that will help you carry out tasks like calling people, scheduling tasks, creating todo lists, taking notes, .. you get the point.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Antivirus Software

Build an antivirus software that will protect you from viruses and other computer worms and stuff. Make sure you update it frequently to deal with the newer viruses.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Video Call Application

Build an app that can let you video call anyone anywhere over the internet.

**Suggested Language**: Python, Java, C++ for a desktop app  
**Suggested Frameworks/Tools**:  
**Example Implementation**: [Nextcloud Talk](https://github.com/nextcloud/spreed) and [Jitsi](https://github.com/jitsi/jitsi-meet) are open-source video call software

### Library Management System

Build an app for a hypothetical (or better, a real one near you) library that will help in management. You need to keep track of books you have, books to order, people with access to the library, books borrowed, returned and other related tasks.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Relational Database Management System

Build your own database management system like MySQL or PostgreSQL. It doesn't have to be compatible with them, but it does need to help users manage their data efficiently and create relational tables.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

## Artificial Intelligence  

### Face Tracker

Build a piece of software that will analyse pictures (or better, live cam feed) and tag faces in the images as face or with a box.

**Suggested Language**: Python (or any other language you want to learn)  
**Suggested Frameworks/Tools**: OpenCV  
**Example Implementation**:

### Spam Classifier

Build a spam classifier that filters ads and other unrequired emails from people that you don't really want to look at.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Spoiler Blocker

Build a browser extension that blocks movie spoilers on websites. I put it in AI as you have to think of a changing algorithm that should be smart enough to identify spoilers from a piece of text.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Music Suggestor

Bored of the same songs but don't know what to try next? Build an AI to suggest you music based on your taste that you are more likely to like.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Machine Translator

Build an app to translate text from one language to another. For bonus points include an image translator that can get text from image and translate it.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Hand Gesture Recognition

Build a piece of software that can recognise gestures from a camera video and then carry out certain tasks based on the gesture.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Video Subtitle Generator

Input a video and get a subtitle! Build a software that automatically creates subtitles from a provided video. It may seem difficult in the beginning, but look up Natural Language Processing to see how far machines already are with regard to understanding human language.

**Suggested Language**:  Python (As it would be really easy to implement with available libraries)  
**Suggested Frameworks/Tools**:  [autosub](https://pypi.org/project/autosub/)  
**Example Implementation**: You can refer the documentation [here](https://github.com/agermanidis/autosub/wiki) or can check the steps provided [here](http://alttechn.blogspot.com/2018/04/blog-post.html).

### Automatic Logo Generator

Build a software that takes in a company name and some related keywords to generate a brand new logo for the user. Make the logo editable so the user can make any changes if they don't like the generated output.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Movie Recommendation System

Build a recommendation system that lets you or any users choose the next movie that you want to watch. Instead of copying an existing movie recommender with a well studied algorithm, try to come up with your own algorithm and test it out.

**Suggested Language**: Python (or any other language you are comfortable with)  
**Suggested Frameworks/Tools**: -  
**Example Implementation**: There are many, [Netflix](https://www.netflix.com/) recommender system, [Movie lens](https://movielens.org/), etc

### Audio to Sign Language Translator

Similar to the video translator, but now you need to translate an audio to sign language. The sign language part can be in the form of a series of images or a video.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

## Theoretical Computer Science  

### Build an OS

This project will be technically challenging and will deepen your understanding of how computers and operating systems work. Building an OS from the ground up is a really daunting task but you will surely find a way to do it.

**Suggested Language**: low-level languages like C/C++.  
**Suggested Frameworks/Tools**: -  
**Example Implementation**: [LFS](http://www.linuxfromscratch.org/) is a project that explain every step to create a Linux OS  

### Shuffle Deck

Build a web app to visualize the different shuffling algorithms that can be used to shuffle a standard deck of cards.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Sorting Visualizer

Build a webpage/video that will visualize the different sorting algorithms. You can use different kinds of visualizations: dots, bars, colour bars, circularly scattered points, and so on.

**Suggested Language**: Processing, JavaScript  
**Suggested Frameworks/Tools**: P5.js (JavaScript)  
**Example Implementation**:

### Static Code Analyzer

Make a software that will go through your code (without executing it) and check for any inconsistencies or errors (syntax errors, indentation, etc) that may cause any problems during execution.

**Suggested Language**: Any language you feel comfortable with
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Command Line Terminal

If you are building the Operating System, you will surely need a Command Line Terminal. Try to clone the bash shell or Windows PowerShell as an independent project to make it easier while you build your own OS.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### UML Diagram Generator

Write a script that goes through your OOPS code and creates a well-formatted UML diagram for your code.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Pathfinding Visualizer

Make a visualizer for the different pathfinding algorithms. Add this to a maze maker and you have a program that can generate and solve mazes.

**Suggested Language**: Processing, JavaScript  
**Suggested Frameworks/Tools**: P5.js (JavaScript)  
**Example Implementation**:

### Version Control System

Make a proper version control system like git that can keep track of any changes that you make to your project.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Programming Language

Code a programming language from scratch. This project will give you great insights into why languages are structured the way they are and which languages suit which tasks better. There are quite a few programming languages, thus, incorporate some really weird (or helpful) features to make your language stand out (e.g. check out [brainfuck](https://en.wikipedia.org/wiki/Brainfuck)).

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

## Cryptography  

### Codec Software

Build a software that will encrypt and decrypt text for you. Incorporate quite a few algorithms to provide flexibility to the user.

**Suggested Language**: C, C++, Java, Python  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Password Manager

Build a software that can manage the different passwords that you use on different websites. For bonus points incorporate a random password generator.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Folder Encrypter

Build a piece of software that can encrypt and lock a selected folder. The contents of the folder should not be accessible/copied/moved without the correct password.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Password Strength Checker

Build a website/app that will check how strong a given password is. To make it more fancy, incorporate a good metric of how strong a password is (check out the example).

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**: [How secure is my Password?](https://howsecureismypassword.net/)

## Simulations, Games and Game AI  

### Pong

Code the game of [pong](https://en.wikipedia.org/wiki/Pong). Make it multiplayer and visually appealing.

**Suggested Language**: Python (or any other language of choice)  
**Suggested Frameworks/Tools**: Pygame (Python)  
**Example Implementation**:

### Pong AI

Add to the Pong program you created above. Create an AI opponent to play against in a single player mode.

**Suggested Language**: Python (or any other language of choice)  
**Suggested Frameworks/Tools**: TensorFlow, PyTorch, openai/gym  
**Example Implementation**:

### Risk

Try coding the classic board game of [Risk](https://en.wikipedia.org/wiki/Risk_(game)). Make sure you know all the rules and understand the game properly before you code it.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Chess

Code the game of chess from the ground up. Build a board, the pieces (you can use images for this part). Code in the rules and make sure you allow no invalid moves.

**Suggested Language**: JavaScript, Python, any other language you want to master  
**Suggested Frameworks/Tools**:  
**Example Implementation**: [Chessboard.js](https://chessboardjs.com/)

### Snake

This is one of the simplest items on the list. For an additional challenge, try generating different maps to play in.

**Suggested Language**: Any language that you feel comfortable with  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Tetris

Code the game of Tetris starting from the Tetrominoes to the game interface. A web app is better as it will let you play from anywhere. For additional challenge try to implement a simple HTML and JavaScript version without any additional frameworks or libraries to help.

**Suggested Language**: JavaScript, HTML  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Chess AI

Now that you have most likely built the chess game, build an AI that you can play against. For inspiration look into the examples provided. The challenge here is to make an AI that is fast enough to play against. Most simple AIs for chess are just really slow (take about a minute or more for a move). Make your chess engine interface with other programs such via the [Universal Chess Interface](https://en.wikipedia.org/wiki/Universal_Chess_Interface). Then you can test it out against other bots/players online.

**Suggested Language**: Python, JavaScript  
**Suggested Frameworks/Tools**: Chessboard.js (JavaScript)
**Example Implementation**: [Stockfish AI](https://stockfishchess.org/), [Leela Chess Zero](https://lczero.org/)

### Snake AI

Build a simple snake AI that plays snake. For an added challenge, generate random maps and then train your AI to play in any random map that you generate.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Map Maker

Build a simple program that will generate random terrain maps through [procedural generation](https://en.wikipedia.org/wiki/Procedural_generation) with a user supplied seed.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Battleship

Build the classic game of battleship. You can build a CLI app or a much better app with graphics using any 2D graphics module.

**Suggested Language**: Python (or any language you want to learn)  
**Suggested Frameworks/Tools**: Pygame (Python)  
**Example Implementation**:

### Flappy Bird

This is one of the simplest difficult games that you can build. You can use images for pipes and the bird or generate your own custom bird and pipes for the project.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Tic Tac Toe

Build a CLI app for tic-tac-toe or a graphical interface. One of the interesting ideas is to let the user draw Xs and Os and then let the machine automatically identify if you drew an X or an O.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Memory Puzzle

Implement a classic memory puzzle where the user has to click on two similar cards to eliminate them. Shuffle the cards randomly in the beginning and give the user a fixed number of chances or a fixed time to clear the board.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Physics Engine

Video Games work on [physics engines](https://en.wikipedia.org/wiki/Physics_engine). Build your own. You can later use this engine to build games or carry out simulations. Try building a 2D or 3D physics engine that can handle collision, movement, acceleration, gravity, and other forces in the system. You may need to first understand a bit of physics to be able to build something, so take your time for this one.

**Suggested Language**: Processing (any other language that you feel comfortable with works too)  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Flappy Bird AI

Design an AI for the flappy bird game. Try out a few learning algorithms to train your network - Q-Learning, NEAT, etc. Build the perfect AI that will play flappy bird better than you (or anyone else) ever can.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Tic Tac Toe AI

Build an AI that is unbeatable (either wins always or at least draws) in tic-tac-toe. Instead of just hardcoding what move to play when, build an AI that learns how to play and then devises strategies to win.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Elevator Simulator

Build a simulation for an elevator. This may seem like a random simulation, but you need to think a lot before implementing something regarding this, which floor to go to when two buttons are pressed? Is there any change if you add a preference for going up or going down? and so on.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Simulate the World

Build a simulation of the whole world. Try to be as detailed as you can. Keep it simple when you feel stuck and slowly improve on it. Treat it as a self-sustaining game if it makes things easier. For bonus points, add an AI to the system to let it work on its own.

**Suggested Language**: C++ (or C - you will need a fast language for the simulation)  
**Suggested Frameworks/Tools**: Unity (Good for visualizations)  
**Example Implementation**: [The Bibites](https://www.youtube.com/watch?v=myJ7YOZGkv0&ab_channel=TheBibites), [Simulating Ecosystem](https://www.youtube.com/watch?v=r_It_X7v-1E&ab_channel=SebastianLague) by Sebastian Lague

### Character Generator

Build a tool that will generate random characters for games that you play/build like Pathfinder or Divinity: Original Sin. First implement a random character generator and then tweak it to make characters that you will like (add an AI).

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Game of Life

[Conway's Game of Life](https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life) simulates the lives of simple cells that obey algorithmic laws. You can read the algorithmic rules from the wikipedia page and implement them. Make the program capable of graphical rendering to display the end product.

**Suggested Language**: Processing, JavaScript  
**Suggested Frameworks/Tools**: P5.js (JavaScript)  
**Example Implementation**:

## Miscellaneous  

### Deal Finder

Build a simple web app to notify you when an item you covet goes on sale for a good price. You can use a web scraper to pull the item's product page and notify you of any price changes.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Expense Tracker

Create a simple interface (web app/phone app) you can use to add and categorize your expense. Generate monthly reports based on the inputs and write custom alerts for things like, "spending too much on coffee... as always".

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Recipe Generator

The app (or service) should generate new recipes/scrapes recipes from the web. So when you cook by its recipe, you rate it to tell it how good the recipe was.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Emoji Translator

Build a browser extension that will translate any provided sentence into a combination of emojis. You can use the extension to automatically change texts that a user sends via messaging or email or even use it to aid in writing blog posts.

**Suggested Language**: JavaScript  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Regex Query Tool

Build a search tool that implements Regular Expressions. With it you can easily search for text matching a pattern in websites or documents that you may be writing or browsing.

**Suggested Language**: JavaScript  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Currency Converter

Code a script that scrapes the currency conversion rate and then converts from a given currency to another suing the current market rate.

**Suggested Language**: Python, JavaScript  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Pixel Art Generator

Code a script that takes in a picture and then creates the Pixel Art from the image. You can achieve this by downsizing the image. You should also be able to generate random art using this script.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Directory Tree Generator

Generate a tree like structure using the directories present in a given path by the user. This allows you to see the positioning of files and directories. We are visual animals and thus, visual depictions of directories are more understandable.

**Suggested Language**:  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

### Random Username Generator

Write a script to generate random usernames that you can use in games or various other places.

**Suggested Language**: Python or any other language  
**Suggested Frameworks/Tools**: Random (Python Library)  
**Example Implementation**:

### Roman to Decimal Converter

Write a script that converts decimal numbers to roman numerals and vice versa. This may seem like an easy task but I assure you its not that easy. Give it a try.

**Suggested Language**: Python or any other language  
**Suggested Frameworks/Tools**:  
**Example Implementation**:

## Coding Challenges  

### Project Euler

[Project Euler](https://projecteuler.net/) contains mathematical challenges that require programming tools to be solved. There are over 700 problems that you can solve, I urge you to document each solution in a properly organized way (probably build a repo for the solutions) so that you can showcase them online.

**Suggested Language**: Any language you want to practice  

### Advent of Code

[Advent of Code](https://adventofcode.com/) challenges occur every year in the days leading up to Christmas. They include lots of fun programming challenges that can help you develop your chops in a programming language that you want to master.

**Suggested Language**: Any language you want to master  

### Kaggle Titanic Challenge

Kaggle offers fascinating challenges to introduce you to the basics of machine learning with Python or R: Use a real dataset from the [Titanic passenger log](https://www.kaggle.com/c/titanic) to predict which passengers were most likely to survive the disaster.

**Suggested Language**: Python or R  


## References
- [40 Side Project ideas for Software Engineers](https://www.codementor.io/@npostolovski/40-side-project-ideas-for-software-engineers-g8xckyxef)
- [42 Projects to Practice Programming Skills](https://itnext.io/42-projects-to-practice-programming-skills-6f5acc10fec0)
- [More project ideas to improve your coding skills](https://www.freecodecamp.org/news/more-project-ideas-to-improve-your-coding-skills-99f48d09bb4b/)
- [Computer Science Projects](https://www.geeksforgeeks.org/computer-science-projects/)
- [13 Project Ideas for Intermediate Python Developers](https://realpython.com/intermediate-python-project-ideas/)
- [florinpop17/app-ideas](https://github.com/florinpop17/app-ideas)
- [49 Ideas for Game Clones to Code](https://inventwithpython.com/blog/2012/02/20/i-need-practice-programming-49-ideas-for-game-clones-to-code/)
