# Learning Resources

Apart from the list of projects to code, the most common other query that people have is **where can I learn coding from?**  
This file is my attempt to compile a list of resources (tagged with languages/frameworks) that will help you learn how to code and hone your skills. Currently, the list is haphazard, but I'll soon arrange it in some fashion (either alphabetically, or by languages).

## What language to learn

Here is a table adapted from [r/learnprogramming](https://www.reddit.com/r/learnprogramming/wiki/faq#wiki_which_programming_language_should_i_start_with.3F) to help you choose which language best suits your needs and then proceed accordingly.

| I want to Learn how to... | Consider Learning... |
|---------------------------|----------------------|
| ...make iPhone Apps | Swift and Objective-C |
| ...make Android Apps | Kotlin or Java |
| ...build a website | JavaScript, CSS, HTML |
| ...write Windows desktop applications | C# |
| ...make 2D or 3D games | JavaScript, C# or C++ |
| ...program Arduinos/micro-controllers/robots | C |
| ...do scientific/mathematical computing or data analysis | Julia, Python, R, or MATLAB |
| ...do automation and scripting | Many languages (Python, Ruby, Bash, PowerShell, AutoHotKey, ...) |
| ...build dynamic webpages | HTML, CSS, JavaScript, Ruby on Rails, PHP |
| ...build and manage databases | SQL |

<!--
Template
## Resource

Description

**Free/Paid:**  
**Languages/Frameworks:**  
-->

### MDN (Mozilla Developer Network)

[MDN](https://developer.mozilla.org/en-US/) is THE resource for anything related to web. It is a massive resource that covers languages and topics like CSS, HTML, web standards, protocols, JavaScript, and other things. Their tutorials are great for beginners to learn the basics, and their references are great for experienced developers when they need a quick find.

**Free/Paid:** Free  
**Languages/Frameworks:** CSS, HTML, JavaScript, and almost everything related to the web.  

### CSS-Tricks

[CSS-Tricks](https://css-tricks.com/) is a fantastic resource for CSS (and Design considerations). They have many in-depth guides you can check out. On top of being a great place to learn, they also have a newsletter worth checking out. They're a high quality resource, and if you spend anytime doing front end development they're a resource that will pop up.

**Free/Paid:** Free  
**Languages/Frameworks:** CSS  

### Marksheet.io

[Marksheet.io](https://marksheet.io/) is a succinct and straight forward site to refresh your memory about CSS and HTML. IT has good graphic illustrations that will help you visualize what is going on. It is a recommended straight to the point no bullshit resource.

**Free/Paid:** Free  
**Languages/Frameworks:** HTML & CSS  

### Interneting is Hard

[Interneting is Hard](https://www.internetingishard.com/) aims to help beginners learn about HTML & CSS with an emphasis on design. It is a detailed and hands on resource. It stresses the importance of writing code, and how that helps you understand what you're doing. If you like getting your hands dirty and really seeing how things work this is a great place to start.

**Free/Paid:** Free  
**Languages/Frameworks:** HTML & CSS  

### CSS Essential Training

[CSS Essential Training](https://www.lynda.com/CSS-tutorials/Styling-documents-consistently/5038219/2249020-4.html) is a video course available on lynda, and aimed at teaching the basics of CSS. It is a great CSS 101 learning resource.

**Free/Paid:** Paid  
**Languages/Frameworks:** CSS  

### The Odin Project

[The Odin Project](https://theodinproject.com/) is an open source effort to teach web development for free. It has some great projects that you can build and showcase on your GitHub profile. The website is meant to be 'the' resource for web developers and even offers a final course on how to apply for jobs and get hired.

**Free/Paid:** Free  
**Languages/Frameworks:** JavaScript, Node.js, Ruby on Rails, Front end too (HTML, CSS)  

### Full Stack Open

[Full Stack Open](https://fullstackopen.com/en/) serves as an introduction to modern web app development with JavaScript. It mainly focuses on building single page applications with ReactJS using REST APIs and Node.js. The course is the same as the course at the Department of Computer Science at the University of Helsinki and also has an associated capstone project.

**Free/Paid:** Free  
**Languages/Frameworks:** ReactJS, JavaScript, TypeScript, MongoDB, Node.js, GraphQL, MERN  

### App Academy

[App Academy](https://open.appacademy.io/) boasts to be the #1 coding bootcamp in the US. It has a fair amount of free material (about 1500 hours worth of material) and an engaged community. Focus is on getting people placed at different companies. It also has a mentorship track to make things easier at your end for a price.

**Free/Paid:** Free / Paid (Mentorship Plan at $29.99)  
**Languages/Frameworks:** Ruby on Rails, MERN, JavaScript  

### Solo Learn

[Solo Learn](https://www.sololearn.com/) offers short courses that will help you gain a basic understanding of different languages. The courses are ideal for refreshing your memory for a given language or to learn them from the ground up. It also offers short quizzes in between that will help you test your knowledge along the way.

**Free/Paid:** Free  
**Languages/Frameworks:** A *Lot* of languages  

### Free Code Camp

[Free Code Camp](https://www.freecodecamp.org/) offers a path to software development even for beginners. The courses take you through interactive code that will help you get a sense of what is happening when you change something in the code. It also has material for coding interview preparation that will help you prepare for interviews.

**Free/Paid:** Free  
**Languages/Frameworks:** Python, JavaScript, Node.js, MongoDB, HTML, CSS  

### Python Programming

[Python Programming](https://pythonprogramming.net/) exclusively deals with Python. But it provides a lot of paths to take in order to specialize in a given niche. It starts from the fundamentals of Python and offers courses in Game Development, Quantum Computing, Machine Learning and many other things.

**Free/Paid:** Free  
**Languages/Frameworks:** Python  

### Devoted Learner

[Devoted Learner](https://devotedlearner.com/how-to-become-a-machine-learning-engineer/#Introduction) is kind of like a blog. It contains blog posts with resources and tips on how to become a Machine Learning Engineer. A good resource for beginners.

**Free/Paid:** Free  
**Languages/Frameworks:** Python  

### Python Principles

[Python Principles](https://pythonprinciples.com/) offers the basics of Python for beginners. It is a well built resource with lots of examples and challenges that will help you understand and put to use the very basics of Python.

**Free/Paid:** Free / Paid (Pro at $29)  
**Languages/Frameworks:** Python  

### Learn X in Y minutes

[Learn X in Y minutes](https://learnxinyminutes.com/) is a valuable library of syntax for many different languages. Recommended cheat sheet for languages.

**Free/Paid:** Free  
**Languages/Frameworks:** A *lot* of languages  

### Rosettacode

[Rosettacode](http://rosettacode.org/wiki/Rosetta_Code) is a programming [chrestomathy](https://en.wikipedia.org/wiki/Chrestomathy) site. It aims to answer a given question with many different languages to demonstrate how languages are similar and different, and how different languages can lead to different approaches for the same problems.

**Free/Paid:** Free  
**Languages/Frameworks:** A *lot* of languages  

## References
- [The 5 Resources that helped me become a CSS master - Reddit](https://www.reddit.com/r/learnprogramming/comments/in3jvg/the_5_resources_that_helped_me_become_a_css/)
- [Resources I wish I knew about long ago! - Reddit](https://www.reddit.com/r/learnprogramming/comments/icr9ac/resources_i_wish_i_knew_about_long_ago/)
- [r/learnprogramming FAQs](https://www.reddit.com/r/learnprogramming/wiki/faq)
