use crate::test::snapshot_inner;
use test_case::test_case;
#[test_case(r#####"tw`form-radio`"#####, r#####"({
  appearance: "none",
  padding: "0",
  printColorAdjust: "exact",
  display: "inline-block",
  verticalAlign: "middle",
  backgroundOrigin: "border-box",
  userSelect: "none",
  flexShrink: "0",
  height: "1rem",
  width: "1rem",
  color: "#2563eb",
  backgroundColor: "#fff",
  borderColor: "#6b7280",
  borderWidth: "1px",
  "--tw-shadow": "0 0 #0000",
  borderRadius: "100%",
  ":focus": {
    outline: "2px solid transparent",
    outlineOffset: "2px",
    "--tw-ring-inset": "var(--tw-empty,/*!*/ /*!*/)",
    "--tw-ring-offset-width": "2px",
    "--tw-ring-offset-color": "#fff",
    "--tw-ring-color": "#2563eb",
    "--tw-ring-offset-shadow":
      "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)",
    "--tw-ring-shadow":
      "var(--tw-ring-inset) 0 0 0 calc(2px + var(--tw-ring-offset-width)) var(--tw-ring-color)",
    boxShadow:
      "var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow)",
  },
  ":checked": {
    borderColor: "transparent",
    backgroundColor: "currentColor",
    backgroundSize: "100% 100%",
    backgroundPosition: "center",
    backgroundRepeat: "no-repeat",
    backgroundImage:
      "url(\"data:image/svg+xml,%3csvg viewBox='0 0 16 16' fill='white' xmlns='http://www.w3.org/2000/svg'%3e%3ccircle cx='8' cy='8' r='3'/%3e%3c/svg%3e\")",
  },
  ":checked:hover,:checked:focus": {
    borderColor: "transparent",
    backgroundColor: "currentColor",
  },
})
;"##### ; "0")]
#[test_case(r#####"tw`form-select`"#####, r#####"({
  appearance: "none",
  backgroundColor: "#fff",
  borderColor: "#6b7280",
  borderWidth: "1px",
  borderRadius: "0px",
  paddingTop: "0.5rem",
  paddingRight: "2.5rem",
  paddingBottom: "0.5rem",
  paddingLeft: "0.75rem",
  fontSize: "1rem",
  lineHeight: "1.5rem",
  "--tw-shadow": "0 0 #0000",
  ":focus": {
    outline: "2px solid transparent",
    outlineOffset: "2px",
    "--tw-ring-inset": "var(--tw-empty,/*!*/ /*!*/)",
    "--tw-ring-offset-width": "0px",
    "--tw-ring-offset-color": "#fff",
    "--tw-ring-color": "#2563eb",
    "--tw-ring-offset-shadow":
      "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)",
    "--tw-ring-shadow":
      "var(--tw-ring-inset) 0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color)",
    boxShadow:
      "var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow)",
    borderColor: "#2563eb",
  },
  backgroundImage:
    "url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3e%3c/svg%3e\")",
  backgroundPosition: "right 0.5rem center",
  backgroundRepeat: "no-repeat",
  backgroundSize: "1.5em 1.5em",
  printColorAdjust: "exact",
})
;"##### ; "1")]
#[test_case(r#####"tw`form-checkbox`"#####, r#####"({
  appearance: "none",
  padding: "0",
  printColorAdjust: "exact",
  display: "inline-block",
  verticalAlign: "middle",
  backgroundOrigin: "border-box",
  userSelect: "none",
  flexShrink: "0",
  height: "1rem",
  width: "1rem",
  color: "#2563eb",
  backgroundColor: "#fff",
  borderColor: "#6b7280",
  borderWidth: "1px",
  "--tw-shadow": "0 0 #0000",
  borderRadius: "0px",
  ":focus": {
    outline: "2px solid transparent",
    outlineOffset: "2px",
    "--tw-ring-inset": "var(--tw-empty,/*!*/ /*!*/)",
    "--tw-ring-offset-width": "2px",
    "--tw-ring-offset-color": "#fff",
    "--tw-ring-color": "#2563eb",
    "--tw-ring-offset-shadow":
      "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)",
    "--tw-ring-shadow":
      "var(--tw-ring-inset) 0 0 0 calc(2px + var(--tw-ring-offset-width)) var(--tw-ring-color)",
    boxShadow:
      "var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow)",
  },
  ":checked": {
    borderColor: "transparent",
    backgroundColor: "currentColor",
    backgroundSize: "100% 100%",
    backgroundPosition: "center",
    backgroundRepeat: "no-repeat",
    backgroundImage:
      "url(\"data:image/svg+xml,%3csvg viewBox='0 0 16 16' fill='white' xmlns='http://www.w3.org/2000/svg'%3e%3cpath d='M12.207 4.793a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0l-2-2a1 1 0 011.414-1.414L6.5 9.086l4.293-4.293a1 1 0 011.414 0z'/%3e%3c/svg%3e\")",
  },
  ":checked:hover,:checked:focus": {
    borderColor: "transparent",
    backgroundColor: "currentColor",
  },
  ":indeterminate": {
    backgroundImage:
      "url(\"data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 16 16'%3e%3cpath stroke='white' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M4 8h8'/%3e%3c/svg%3e\")",
    borderColor: "transparent",
    backgroundColor: "currentColor",
    backgroundSize: "100% 100%",
    backgroundPosition: "center",
    backgroundRepeat: "no-repeat",
  },
  ":indeterminate:hover,:indeterminate:focus": {
    borderColor: "transparent",
    backgroundColor: "currentColor",
  },
})
;"##### ; "2")]
#[test_case(r#####"tw`form-input`"#####, r#####"({
  appearance: "none",
  backgroundColor: "#fff",
  borderColor: "#6b7280",
  borderWidth: "1px",
  borderRadius: "0px",
  paddingTop: "0.5rem",
  paddingRight: "0.75rem",
  paddingBottom: "0.5rem",
  paddingLeft: "0.75rem",
  fontSize: "1rem",
  lineHeight: "1.5rem",
  "--tw-shadow": "0 0 #0000",
  ":focus": {
    outline: "2px solid transparent",
    outlineOffset: "2px",
    "--tw-ring-inset": "var(--tw-empty,/*!*/ /*!*/)",
    "--tw-ring-offset-width": "0px",
    "--tw-ring-offset-color": "#fff",
    "--tw-ring-color": "#2563eb",
    "--tw-ring-offset-shadow":
      "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)",
    "--tw-ring-shadow":
      "var(--tw-ring-inset) 0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color)",
    boxShadow:
      "var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow)",
    borderColor: "#2563eb",
  },
  "::placeholder": {
    color: "#6b7280",
    opacity: "1",
  },
  "::-webkit-datetime-edit-fields-wrapper": {
    padding: "0",
  },
  "::-webkit-date-and-time-value": {
    minHeight: "1.5em",
  },
  "::-webkit-datetime-edit,::-webkit-datetime-edit-year-field,::-webkit-datetime-edit-month-field,::-webkit-datetime-edit-day-field,::-webkit-datetime-edit-hour-field,::-webkit-datetime-edit-minute-field,::-webkit-datetime-edit-second-field,::-webkit-datetime-edit-millisecond-field,::-webkit-datetime-edit-meridiem-field":
    {
      paddingTop: "0",
      paddingBottom: "0",
    },
})
;"##### ; "3")]
#[test_case(r#####"tw`form-textarea`"#####, r#####"({
  appearance: "none",
  backgroundColor: "#fff",
  borderColor: "#6b7280",
  borderWidth: "1px",
  borderRadius: "0px",
  paddingTop: "0.5rem",
  paddingRight: "0.75rem",
  paddingBottom: "0.5rem",
  paddingLeft: "0.75rem",
  fontSize: "1rem",
  lineHeight: "1.5rem",
  "--tw-shadow": "0 0 #0000",
  ":focus": {
    outline: "2px solid transparent",
    outlineOffset: "2px",
    "--tw-ring-inset": "var(--tw-empty,/*!*/ /*!*/)",
    "--tw-ring-offset-width": "0px",
    "--tw-ring-offset-color": "#fff",
    "--tw-ring-color": "#2563eb",
    "--tw-ring-offset-shadow":
      "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)",
    "--tw-ring-shadow":
      "var(--tw-ring-inset) 0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color)",
    boxShadow:
      "var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow)",
    borderColor: "#2563eb",
  },
  "::placeholder": {
    color: "#6b7280",
    opacity: "1",
  },
})
;"##### ; "4")]
#[test_case(r#####"tw`form-multiselect`"#####, r#####"({
  appearance: "none",
  backgroundColor: "#fff",
  borderColor: "#6b7280",
  borderWidth: "1px",
  borderRadius: "0px",
  paddingTop: "0.5rem",
  paddingRight: "0.75rem",
  paddingBottom: "0.5rem",
  paddingLeft: "0.75rem",
  fontSize: "1rem",
  lineHeight: "1.5rem",
  "--tw-shadow": "0 0 #0000",
  ":focus": {
    outline: "2px solid transparent",
    outlineOffset: "2px",
    "--tw-ring-inset": "var(--tw-empty,/*!*/ /*!*/)",
    "--tw-ring-offset-width": "0px",
    "--tw-ring-offset-color": "#fff",
    "--tw-ring-color": "#2563eb",
    "--tw-ring-offset-shadow":
      "var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)",
    "--tw-ring-shadow":
      "var(--tw-ring-inset) 0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color)",
    boxShadow:
      "var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow)",
    borderColor: "#2563eb",
  },
})"##### ; "5")]
fn test(input: &str, output: &str) {
    snapshot_inner(input, output)
}
