# Zauberhaft - Astro template

![Snyk Vulnerabilities for GitHub Repo](https://img.shields.io/snyk/vulnerabilities/github/ariqnrnns/zauberhaft-astro)
[![Build CI](https://github.com/ariqnrnns/zauberhaft-astro/actions/workflows/build.yml/badge.svg)](https://github.com/ariqnrnns/zauberhaft-astro/actions/workflows/build.yml)
![GitHub last commit](https://img.shields.io/github/last-commit/ariqnrnns/zauberhaft-astro)
[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![zauberhaft.ravenbright.design](https://img.shields.io/website-up-down-green-red/http/shields.io.svg)](https://zauberhaft.ravenbright.design)

<p align="center">
<img src="https://raw.githubusercontent.com/ariqnrnns/zauberhaft-astro/main/src/Zauberhaft-banner.jpg" alt="Zauberhaft Banner">

<img src="https://raw.githubusercontent.com/ariqnrnns/zauberhaft-astro/main/src/Zauberhaft-stats.jpg" alt="Zauberhaft Stats">
</p>

## Free, customizable, modern & Lightning fast Astro agency website template

Build modern & unique portfolio website that convert with	Zauberhaft.

Easily customize the template with utility classes & CSS custom properties. Get started quickly & supercharge your online presence with Zauberhaft HTML template.

## 👉 Demo

[View demo](https://zauberhaft.ravenbright.design)

## ✅ Why Zauberhaft?

- 👌 Totally free to use with Apache License 2.0
- 😎 Stunning User Interface
- 🎨 Everything is customizable. You can use [Ravenbright CSS](https://ravenbrightcss.com) utility classes or CSS variables to modify the styles
- ⚡ High performing static sites. 98/100 scores both for mobile & desktop in Pagespeed Insights
- ♿ Accessible - comply with WCAG 2.1. Measured by Pagespeed Insights, WAVE & Tota11y
- 📰 Included with Open Graph tags
- 📱 Fully Responsive & mobile-friendly landing page
- 👌 Comes with & smooth animations

## 🚀 Getting started

1. Download the source code from Github Releases
2. `cd` into the folder & run `npm install`
3. After that, run `npm run dev` to start the local development server
4. Customize the website
5. Deploy into your favorite hosting
6. It's done!

## 🎨 Customization

Zauberhaft is built with Ravenbright CSS library. You can customize the template with using either:

- [Utility classes](https://ravenbrightcss.com/docs/utilities/background)
- [CSS variables](https://ravenbrightcss.com/docs/customize/cssvariables)

## ⚙️ Development

1. Type `npm run dev` on CLI
2. Open `localhost:3000` to view the website

## ✅ Build process

1. Type `npm run build` on CLI
2. Run `npm run preview` to see the build result. Finally, it's done 🎉. Your website is ready to deploy 🚀

## ☁️ Deploy

### Deploy to Netlify

Clone this repository and deploy to Netlify:

[![Netlify Deploy button](https://www.netlify.com/img/deploy/button.svg)](https://app.netlify.com/start/deploy?repository=https://github.com/ariqnrnns/zauberhaft-astro)


## 🤝 Credits & attributions

- Post-processor tool: [PostCSS](https://postcss.org)
- Web framework tool: [Astro](https://astro.build)
- Photos are courtesy of [Unsplash](https://unsplash.com)
- Typeface: `Satoshi` by [Indian Type Foundry](https://www.fontshare.com/fonts/satoshi)
- Placeholder Logo are courtesy of [Logoipsum](https://logoipsum.com)
- Icons are courtesy of [Tabler](https://tabler-icons.io/) and [Akar Icons](akaricons.com/)

## 📝 License

Zauberhaft HTML template is licensed under the [Apache License 2.0](https://github.com/ariqnrnns/zauberhaft-astro/blob/main/LICENSE.md)
