# Pomodoro Timer App

This is a **Pomodoro focus app** designed to improve productivity with a customizable timer. The app includes focus, short break, and long break modes, along with the ability to review your weekly focus stats. The project is built using HTML, CSS, and JavaScript.

## Live Demo

Check out the live version [here](https://arianimmen.github.io/Pomodoro-Timer-App/public/index.html).

## Features

- **Focus Modes**: Includes focus, short break, and long break modes.
- **Custom Timer**: Adjust the focus duration, break lengths, and set how many focus sessions before a long break.
- **Dark & Light Themes**: Switch between dark and light modes for better comfort.
- **Weekly Review**: View your daily focus hours and total focus time for each week. The data resets at the start of each new week.
- **Local Storage**: Your settings and weekly stats are saved in the browser’s local storage.

## Design Inspiration

The design of this app is inspired by a Pomodoro Timer UI kit on Figma. You can view the original design [here](https://www.figma.com/design/I1lOcj8fxEZ8gwqHgmWWZ1/%E2%8F%B0-Pomo---Pomodoro-Timer-App-Prototype-(v-0.1.0)-(Community)?node-id=1-10071&node-type=canvas&t=2016bT3Fl2SjvD7G-0).

## Technologies Used

- **HTML**: Structure of the web app.
- **CSS**: Styling and responsive design.
- **JavaScript**: Functionality, timer, settings management, and data persistence.

## How to Run the Project Locally

1. Clone this repository:
   ```bash
   git clone https://github.com/arianimmen/Pomodoro-Timer-App.git
   ```
2. Navigate to the project directory:
   ```bash
   cd Pomodoro-Timer-App
   ```
3. Open `public/index.html` in your browser to start the app.

## Contributions

Contributions are welcome! Feel free to fork the repository and submit pull requests.
