/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.KQueueArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;

class KQueueSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    KQueueArrayWrapper kqueueWrapper;
    private int totalChannels;
    private HashMap<Integer, MapEntry> fdMap;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;
    private long updateCount;

    KQueueSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        long l = IOUtil.makePipe(false);
        this.fd0 = (int)(l >>> 32);
        this.fd1 = (int)l;
        this.kqueueWrapper = new KQueueArrayWrapper();
        this.kqueueWrapper.initInterrupt(this.fd0, this.fd1);
        this.fdMap = new HashMap();
        this.totalChannels = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long l) throws IOException {
        int n = 0;
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            n = this.kqueueWrapper.poll(l);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        return this.updateSelectedKeys(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateSelectedKeys(int n) throws IOException {
        int n2 = 0;
        boolean bl = false;
        ++this.updateCount;
        for (int i = 0; i < n; ++i) {
            int n3 = this.kqueueWrapper.getDescriptor(i);
            if (n3 == this.fd0) {
                bl = true;
                continue;
            }
            MapEntry mapEntry = this.fdMap.get(n3);
            if (mapEntry == null) continue;
            int n4 = this.kqueueWrapper.getReventOps(i);
            SelectionKeyImpl selectionKeyImpl = mapEntry.ski;
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (mapEntry.updateCount != this.updateCount) {
                    if (!selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl)) continue;
                    ++n2;
                    mapEntry.updateCount = this.updateCount;
                    continue;
                }
                selectionKeyImpl.channel.translateAndUpdateReadyOps(n4, selectionKeyImpl);
                continue;
            }
            selectionKeyImpl.channel.translateAndSetReadyOps(n4, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            ++n2;
            mapEntry.updateCount = this.updateCount;
        }
        if (bl) {
            Object object = this.interruptLock;
            synchronized (object) {
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Iterator iterator = this.interruptLock;
            synchronized (iterator) {
                this.interruptTriggered = true;
            }
            FileDispatcherImpl.closeIntFD(this.fd0);
            FileDispatcherImpl.closeIntFD(this.fd1);
            if (this.kqueueWrapper != null) {
                this.kqueueWrapper.close();
                this.kqueueWrapper = null;
                this.selectedKeys = null;
                iterator = this.keys.iterator();
                while (iterator.hasNext()) {
                    SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                    this.deregister(selectionKeyImpl);
                    SelectableChannel selectableChannel = selectionKeyImpl.channel();
                    if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                        ((SelChImpl)((Object)selectableChannel)).kill();
                    }
                    iterator.remove();
                }
                this.totalChannels = 0;
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    @Override
    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        int n = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.fdMap.put(n, new MapEntry(selectionKeyImpl));
        ++this.totalChannels;
        this.keys.add(selectionKeyImpl);
    }

    @Override
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        int n = selectionKeyImpl.channel.getFDVal();
        this.fdMap.remove(n);
        this.kqueueWrapper.release(selectionKeyImpl.channel);
        --this.totalChannels;
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((SelChImpl)((Object)selectableChannel)).kill();
        }
    }

    @Override
    public void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.kqueueWrapper.setInterest(selectionKeyImpl.channel, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.kqueueWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    private static class MapEntry {
        SelectionKeyImpl ski;
        long updateCount;

        MapEntry(SelectionKeyImpl selectionKeyImpl) {
            this.ski = selectionKeyImpl;
        }
    }
}

