/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;

public class AquaScrollBarUI
extends ScrollBarUI {
    private static final int kInitialDelay = 300;
    private static final int kNormalDelay = 100;
    static final int MIN_ARROW_COLLAPSE_SIZE = 64;
    protected boolean fIsDragging;
    protected Timer fScrollTimer;
    protected ScrollListener fScrollListener;
    protected TrackListener fTrackListener;
    protected JRSUIConstants.Hit fTrackHighlight = JRSUIConstants.Hit.NONE;
    protected JRSUIConstants.Hit fMousePart = JRSUIConstants.Hit.NONE;
    protected JScrollBar fScrollBar;
    protected ModelListener fModelListener;
    protected PropertyChangeListener fPropertyChangeListener;
    protected final AquaPainter<JRSUIState.ScrollBarState> painter = AquaPainter.create(JRSUIStateFactory.getScrollBar());
    static final AquaUtils.RecyclableSingleton<Map<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart>> hitToPressedPartMap = new AquaUtils.RecyclableSingleton<Map<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart>>(){

        @Override
        protected Map<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart> getInstance() {
            HashMap<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart> hashMap = new HashMap<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart>(7);
            hashMap.put(JRSUIConstants.ScrollBarHit.ARROW_MAX, JRSUIConstants.ScrollBarPart.ARROW_MAX);
            hashMap.put(JRSUIConstants.ScrollBarHit.ARROW_MIN, JRSUIConstants.ScrollBarPart.ARROW_MIN);
            hashMap.put(JRSUIConstants.ScrollBarHit.ARROW_MAX_INSIDE, JRSUIConstants.ScrollBarPart.ARROW_MAX_INSIDE);
            hashMap.put(JRSUIConstants.ScrollBarHit.ARROW_MIN_INSIDE, JRSUIConstants.ScrollBarPart.ARROW_MIN_INSIDE);
            hashMap.put(JRSUIConstants.ScrollBarHit.TRACK_MAX, JRSUIConstants.ScrollBarPart.TRACK_MAX);
            hashMap.put(JRSUIConstants.ScrollBarHit.TRACK_MIN, JRSUIConstants.ScrollBarPart.TRACK_MIN);
            hashMap.put(JRSUIConstants.ScrollBarHit.THUMB, JRSUIConstants.ScrollBarPart.THUMB);
            return hashMap;
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaScrollBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.fScrollBar = (JScrollBar)jComponent;
        this.installListeners();
        this.configureScrollBarColors();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.fScrollBar = null;
    }

    protected void configureScrollBarColors() {
        LookAndFeel.installColors(this.fScrollBar, "ScrollBar.background", "ScrollBar.foreground");
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected void installListeners() {
        this.fTrackListener = this.createTrackListener();
        this.fModelListener = this.createModelListener();
        this.fPropertyChangeListener = this.createPropertyChangeListener();
        this.fScrollBar.addMouseListener(this.fTrackListener);
        this.fScrollBar.addMouseMotionListener(this.fTrackListener);
        this.fScrollBar.getModel().addChangeListener(this.fModelListener);
        this.fScrollBar.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fScrollListener = this.createScrollListener();
        this.fScrollTimer = new Timer(100, this.fScrollListener);
        this.fScrollTimer.setInitialDelay(300);
    }

    protected void uninstallListeners() {
        this.fScrollTimer.stop();
        this.fScrollTimer = null;
        this.fScrollBar.getModel().removeChangeListener(this.fModelListener);
        this.fScrollBar.removeMouseListener(this.fTrackListener);
        this.fScrollBar.removeMouseMotionListener(this.fTrackListener);
        this.fScrollBar.removePropertyChangeListener(this.fPropertyChangeListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    protected void syncState(JComponent jComponent) {
        JRSUIState.ScrollBarState scrollBarState = (JRSUIState.ScrollBarState)this.painter.state;
        scrollBarState.set(this.isHorizontal() ? JRSUIConstants.Orientation.HORIZONTAL : JRSUIConstants.Orientation.VERTICAL);
        float f = this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum() - this.fScrollBar.getModel().getExtent();
        if (f <= 0.0f) {
            scrollBarState.set(JRSUIConstants.NothingToScroll.YES);
            return;
        }
        JRSUIConstants.ScrollBarPart scrollBarPart = this.getPressedPart();
        scrollBarState.set(scrollBarPart);
        scrollBarState.set(this.getState(jComponent, scrollBarPart));
        scrollBarState.set(JRSUIConstants.NothingToScroll.NO);
        scrollBarState.setValue((float)(this.fScrollBar.getValue() - this.fScrollBar.getMinimum()) / f);
        scrollBarState.setThumbStart(this.getThumbStart());
        scrollBarState.setThumbPercent(this.getThumbPercent());
        scrollBarState.set(this.shouldShowArrows() ? JRSUIConstants.ShowArrows.YES : JRSUIConstants.ShowArrows.NO);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.syncState(jComponent);
        this.painter.paint(graphics, jComponent, 0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected JRSUIConstants.State getState(JComponent jComponent, JRSUIConstants.ScrollBarPart scrollBarPart) {
        if (!AquaFocusHandler.isActive(jComponent)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!jComponent.isEnabled()) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (scrollBarPart != JRSUIConstants.ScrollBarPart.NONE) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected JRSUIConstants.ScrollBarPart getPressedPart() {
        if (!this.fTrackListener.fInArrows || !this.fTrackListener.fStillInArrow) {
            return JRSUIConstants.ScrollBarPart.NONE;
        }
        JRSUIConstants.ScrollBarPart scrollBarPart = hitToPressedPartMap.get().get(this.fMousePart);
        if (scrollBarPart == null) {
            return JRSUIConstants.ScrollBarPart.NONE;
        }
        return scrollBarPart;
    }

    protected boolean shouldShowArrows() {
        return 64 < (this.isHorizontal() ? this.fScrollBar.getWidth() : this.fScrollBar.getHeight());
    }

    public void layoutContainer(Container container) {
        this.fScrollBar.repaint();
        this.fScrollBar.revalidate();
    }

    protected Rectangle getTrackBounds() {
        return new Rectangle(0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected Rectangle getDragBounds() {
        return new Rectangle(0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected void startTimer(boolean bl) {
        this.fScrollTimer.setInitialDelay(bl ? 300 : 100);
        this.fScrollTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByBlock(int n) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int n2 = this.fScrollBar.getValue();
            int n3 = this.fScrollBar.getBlockIncrement(n);
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.fScrollBar.setValue(n2 + n4);
            this.fTrackHighlight = n > 0 ? JRSUIConstants.ScrollBarHit.TRACK_MAX : JRSUIConstants.ScrollBarHit.TRACK_MIN;
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(n);
            this.fScrollListener.setScrollByBlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByUnit(int n) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int n2 = this.fScrollBar.getUnitIncrement(n);
            if (n <= 0) {
                n2 = -n2;
            }
            this.fScrollBar.setValue(n2 + this.fScrollBar.getValue());
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(n);
            this.fScrollListener.setScrollByBlock(false);
        }
    }

    protected JRSUIConstants.Hit getPartHit(int n, int n2) {
        this.syncState(this.fScrollBar);
        return JRSUIUtils.HitDetection.getHitForPoint(this.painter.getControl(), 0.0, 0.0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight(), n, n2);
    }

    float getThumbStart() {
        int n;
        int n2 = this.fScrollBar.getMaximum();
        int n3 = n2 - (n = this.fScrollBar.getMinimum());
        if (n3 <= 0) {
            return 0.0f;
        }
        return (float)(this.fScrollBar.getValue() - this.fScrollBar.getMinimum()) / (float)n3;
    }

    float getThumbPercent() {
        int n;
        int n2 = this.fScrollBar.getVisibleAmount();
        int n3 = this.fScrollBar.getMaximum();
        int n4 = n3 - (n = this.fScrollBar.getMinimum());
        if (n4 <= 0) {
            return 0.0f;
        }
        return (float)n2 / (float)n4;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.isHorizontal() ? new Dimension(96, 15) : new Dimension(15, 96);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.isHorizontal() ? new Dimension(54, 15) : new Dimension(15, 54);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    boolean isHorizontal() {
        return this.fScrollBar.getOrientation() == 0;
    }

    Point getScrollToHereStartPoint(int n, int n2) {
        Rectangle rectangle = this.getDragBounds();
        this.syncState(this.fScrollBar);
        double[] dArray = new double[4];
        JRSUIUtils.ScrollBar.getPartBounds(dArray, this.painter.getControl(), 0.0, 0.0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight(), JRSUIConstants.ScrollBarPart.THUMB);
        Rectangle rectangle2 = new Rectangle((int)dArray[0], (int)dArray[1], (int)dArray[2], (int)dArray[3]);
        Point point = new Point(n, n2);
        if (this.isHorizontal()) {
            int n3 = rectangle2.width / 2;
            int n4 = rectangle.x + rectangle.width;
            point.x = n + n3 > n4 ? rectangle2.x + rectangle2.width - n4 - n - 1 : (n - n3 < rectangle.x ? rectangle2.x + n - rectangle.x : rectangle2.x + n3);
            point.y = (rectangle2.y + rectangle2.height) / 2;
            return point;
        }
        int n5 = rectangle2.height / 2;
        int n6 = rectangle.y + rectangle.height;
        point.y = n2 + n5 > n6 ? rectangle2.y + rectangle2.height - n6 - n2 - 1 : (n2 - n5 < rectangle.y ? rectangle2.y + n2 - rectangle.y : rectangle2.y + n5);
        point.x = (rectangle2.x + rectangle2.width) / 2;
        return point;
    }

    static class HitUtil {
        HitUtil() {
        }

        static boolean isIncrement(JRSUIConstants.Hit hit) {
            return hit == JRSUIConstants.ScrollBarHit.ARROW_MAX || hit == JRSUIConstants.ScrollBarHit.ARROW_MAX_INSIDE;
        }

        static boolean isDecrement(JRSUIConstants.Hit hit) {
            return hit == JRSUIConstants.ScrollBarHit.ARROW_MIN || hit == JRSUIConstants.ScrollBarHit.ARROW_MIN_INSIDE;
        }

        static boolean isArrow(JRSUIConstants.Hit hit) {
            return HitUtil.isIncrement(hit) || HitUtil.isDecrement(hit);
        }

        static boolean isTrack(JRSUIConstants.Hit hit) {
            return hit == JRSUIConstants.ScrollBarHit.TRACK_MAX || hit == JRSUIConstants.ScrollBarHit.TRACK_MIN;
        }
    }

    protected class ScrollListener
    implements ActionListener {
        boolean fUseBlockIncrement;
        int fDirection = 1;

        protected ScrollListener() {
        }

        void setDirection(int n) {
            this.fDirection = n;
        }

        void setScrollByBlock(boolean bl) {
            this.fUseBlockIncrement = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fUseBlockIncrement) {
                JRSUIConstants.Hit hit = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (hit == JRSUIConstants.ScrollBarHit.TRACK_MIN || hit == JRSUIConstants.ScrollBarHit.TRACK_MAX) {
                    int n;
                    int n2 = n = hit == JRSUIConstants.ScrollBarHit.TRACK_MAX ? 1 : -1;
                    if (this.fDirection != n) {
                        this.fDirection = n;
                    }
                }
                AquaScrollBarUI.this.scrollByBlock(this.fDirection);
                hit = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (hit == JRSUIConstants.ScrollBarHit.THUMB) {
                    ((Timer)actionEvent.getSource()).stop();
                }
            } else {
                AquaScrollBarUI.this.scrollByUnit(this.fDirection);
            }
            if (this.fDirection > 0 && AquaScrollBarUI.this.fScrollBar.getValue() + AquaScrollBarUI.this.fScrollBar.getVisibleAmount() >= AquaScrollBarUI.this.fScrollBar.getMaximum()) {
                ((Timer)actionEvent.getSource()).stop();
            } else if (this.fDirection < 0 && AquaScrollBarUI.this.fScrollBar.getValue() <= AquaScrollBarUI.this.fScrollBar.getMinimum()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int fCurrentMouseX;
        protected transient int fCurrentMouseY;
        protected transient boolean fInArrows;
        protected transient boolean fStillInArrow = false;
        protected transient boolean fStillInTrack = false;
        protected transient int fFirstMouseX;
        protected transient int fFirstMouseY;
        protected transient int fFirstValue;

        protected TrackListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseReleasedInArrows(mouseEvent);
            } else {
                this.mouseReleasedInTrack(mouseEvent);
            }
            this.fInArrows = false;
            this.fStillInArrow = false;
            this.fStillInTrack = false;
            AquaScrollBarUI.this.fScrollBar.repaint();
            AquaScrollBarUI.this.fScrollBar.revalidate();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            JRSUIConstants.Hit hit = AquaScrollBarUI.this.getPartHit(mouseEvent.getX(), mouseEvent.getY());
            this.fInArrows = HitUtil.isArrow(hit);
            if (this.fInArrows) {
                this.mousePressedInArrows(mouseEvent, hit);
            } else if (hit == JRSUIConstants.Hit.NONE) {
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.Hit.NONE;
            } else {
                this.mousePressedInTrack(mouseEvent, hit);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseDraggedInArrows(mouseEvent);
            } else if (AquaScrollBarUI.this.fIsDragging) {
                this.mouseDraggedInTrack(mouseEvent);
            } else {
                JRSUIConstants.Hit hit = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
                if (!HitUtil.isTrack(hit)) {
                    this.fStillInTrack = false;
                }
                this.fCurrentMouseX = mouseEvent.getX();
                this.fCurrentMouseY = mouseEvent.getY();
                JRSUIConstants.Hit hit2 = AquaScrollBarUI.this.getPartHit(mouseEvent.getX(), mouseEvent.getY());
                boolean bl = HitUtil.isTrack(hit2);
                if (bl == this.fStillInTrack) {
                    return;
                }
                this.fStillInTrack = bl;
                if (!this.fStillInTrack) {
                    AquaScrollBarUI.this.fScrollTimer.stop();
                } else {
                    AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                    AquaScrollBarUI.this.startTimer(false);
                }
            }
        }

        int getValueFromOffset(int n, int n2, int n3) {
            boolean bl = AquaScrollBarUI.this.isHorizontal();
            int n4 = bl ? n : n2;
            int n5 = AquaScrollBarUI.this.fScrollBar.getVisibleAmount();
            int n6 = AquaScrollBarUI.this.fScrollBar.getMaximum();
            int n7 = AquaScrollBarUI.this.fScrollBar.getMinimum();
            int n8 = n6 - n7;
            AquaScrollBarUI.this.syncState(AquaScrollBarUI.this.fScrollBar);
            double d = JRSUIUtils.ScrollBar.getNativeOffsetChange(AquaScrollBarUI.this.painter.getControl(), 0.0, 0.0, AquaScrollBarUI.this.fScrollBar.getWidth(), AquaScrollBarUI.this.fScrollBar.getHeight(), n4, n5, n8);
            int n9 = n8 - n5;
            int n10 = (int)(d * (double)n9);
            int n11 = n3 + n10;
            n11 = Math.max(n7, n11);
            n11 = Math.min(n6 - n5, n11);
            return n11;
        }

        void mousePressedInArrows(MouseEvent mouseEvent, JRSUIConstants.Hit hit) {
            int n = HitUtil.isIncrement(hit) ? 1 : -1;
            this.fStillInArrow = true;
            AquaScrollBarUI.this.scrollByUnit(n);
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollListener.setDirection(n);
            AquaScrollBarUI.this.fScrollListener.setScrollByBlock(false);
            AquaScrollBarUI.this.fMousePart = hit;
            AquaScrollBarUI.this.startTimer(true);
        }

        void mouseReleasedInArrows(MouseEvent mouseEvent) {
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fMousePart = JRSUIConstants.Hit.NONE;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mouseDraggedInArrows(MouseEvent mouseEvent) {
            JRSUIConstants.Hit hit = AquaScrollBarUI.this.getPartHit(mouseEvent.getX(), mouseEvent.getY());
            if (AquaScrollBarUI.this.fMousePart == hit && this.fStillInArrow) {
                return;
            }
            if (AquaScrollBarUI.this.fMousePart != hit && !HitUtil.isArrow(hit)) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                this.fStillInArrow = false;
                AquaScrollBarUI.this.fScrollBar.repaint();
            } else {
                AquaScrollBarUI.this.fMousePart = hit;
                AquaScrollBarUI.this.fScrollListener.setDirection(HitUtil.isIncrement(hit) ? 1 : -1);
                this.fStillInArrow = true;
                AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                AquaScrollBarUI.this.startTimer(false);
            }
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        void mouseReleasedInTrack(MouseEvent mouseEvent) {
            if (AquaScrollBarUI.this.fTrackHighlight != JRSUIConstants.Hit.NONE) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
            AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.Hit.NONE;
            AquaScrollBarUI.this.fIsDragging = false;
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mousePressedInTrack(MouseEvent mouseEvent, JRSUIConstants.Hit hit) {
            boolean bl;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(true);
            boolean bl2 = bl = hit != JRSUIConstants.ScrollBarHit.THUMB && JRSUIUtils.ScrollBar.useScrollToClick();
            if (mouseEvent.isAltDown()) {
                boolean bl3 = bl = !bl;
            }
            if (bl) {
                Point point = AquaScrollBarUI.this.getScrollToHereStartPoint(mouseEvent.getX(), mouseEvent.getY());
                this.fFirstMouseX = point.x;
                this.fFirstMouseY = point.y;
                this.fFirstValue = AquaScrollBarUI.this.fScrollBar.getValue();
                this.moveToMouse(mouseEvent);
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            this.fCurrentMouseX = mouseEvent.getX();
            this.fCurrentMouseY = mouseEvent.getY();
            int n = 0;
            if (hit == JRSUIConstants.ScrollBarHit.TRACK_MIN) {
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.TRACK_MIN;
                n = -1;
            } else if (hit == JRSUIConstants.ScrollBarHit.TRACK_MAX) {
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.TRACK_MAX;
                n = 1;
            } else {
                this.fFirstValue = AquaScrollBarUI.this.fScrollBar.getValue();
                this.fFirstMouseX = this.fCurrentMouseX;
                this.fFirstMouseY = this.fCurrentMouseY;
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            AquaScrollBarUI.this.fIsDragging = false;
            this.fStillInTrack = true;
            AquaScrollBarUI.this.scrollByBlock(n);
            JRSUIConstants.Hit hit2 = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
            if (hit2 == JRSUIConstants.ScrollBarHit.TRACK_MIN || hit2 == JRSUIConstants.ScrollBarHit.TRACK_MAX) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                AquaScrollBarUI.this.fScrollListener.setDirection(hit2 == JRSUIConstants.ScrollBarHit.TRACK_MAX ? 1 : -1);
                AquaScrollBarUI.this.fScrollListener.setScrollByBlock(true);
                AquaScrollBarUI.this.startTimer(true);
            }
        }

        void mouseDraggedInTrack(MouseEvent mouseEvent) {
            this.moveToMouse(mouseEvent);
        }

        void moveToMouse(MouseEvent mouseEvent) {
            this.fCurrentMouseX = mouseEvent.getX();
            this.fCurrentMouseY = mouseEvent.getY();
            int n = AquaScrollBarUI.this.fScrollBar.getValue();
            int n2 = this.getValueFromOffset(this.fCurrentMouseX - this.fFirstMouseX, this.fCurrentMouseY - this.fFirstMouseY, this.fFirstValue);
            if (n2 == n) {
                return;
            }
            AquaScrollBarUI.this.fScrollBar.setValue(n2);
            Rectangle rectangle = AquaScrollBarUI.this.getTrackBounds();
            AquaScrollBarUI.this.fScrollBar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AquaScrollBarUI.this.layoutContainer(AquaScrollBarUI.this.fScrollBar);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("model".equals(string)) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                BoundedRangeModel boundedRangeModel2 = (BoundedRangeModel)propertyChangeEvent.getNewValue();
                boundedRangeModel.removeChangeListener(AquaScrollBarUI.this.fModelListener);
                boundedRangeModel2.addChangeListener(AquaScrollBarUI.this.fModelListener);
                AquaScrollBarUI.this.fScrollBar.repaint();
                AquaScrollBarUI.this.fScrollBar.revalidate();
            } else if ("Frame.active".equals(string)) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
        }
    }
}

