# Contributing

Thank you for your interest in contributing! 

## Reporting Bugs

Please report bugs by creating [Github issues](https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues).
To help the community understand the bug and get it fixed faster, please provide the following information when creating a new issue:
- A clear and descriptive title
- The exact steps to reproduce the bug
- The observed behavior and expected behavior

If possible, also include payloads, commands, screenshots, etc to help the community identify the problem. Do not include any personal or sensitive data.

## Suggesting Improvements

You can suggest improvements also by creating Github issues.
When creating a new suggestion, please provide the following information:
- A clear and descriptive title
- A description of the proposed improvement in as many details as possible
- Explain why the improvement is important

## Documentation Contribution

Documentation contribution will make it easier for the community to work on the project.
You may add README/diagrams to the components, or improve the existing docs. For major doc changes, we encourage you to create issues before contributing. Let us know what you are planning to change before the contribution. 

## Code Contribution

For minor changes (like small bug fixes or typo correction), feel free to open up a PR directly.
For new features or major changes, we encourage you to create a Github issue first, and get agreement before starting on the implementation. This is to save you time in case there's duplicate effort or unforeseen risk.

## Project Licensing

All contributions (including Pull Requests) to this project are provided under the terms of the project’s [LICENSE](LICENSE.txt)