---
authors:
  - jlipps
date: 2024-05-14
---

# Announcing Appium's Sponsorship Program

Over the last several months, the Appium team has been working on a sponsorship program that is
designed to help give back to Appium's contributors as well as to recognize important partner
individuals or companies in the industry. This program is now officially launching! Let's dive into
some of the details.

<!-- more -->

First of all, the details and fine print will always be available at Appium's [Governance
document](https://github.com/appium/appium/blob/master/GOVERNANCE.md), which outlines how the
project is run, who makes project decisions, etc... This document will be kept up to date with the
latest details of the program, so that's the place to bookmark for reference!

As of now, Appium has opened up sponsorship opportunities via our [OpenCollective
page](https://opencollective.com/appium). OpenCollective is a service which allows people to donate
to open source groups. We've defined a number of giving tiers for donations, within a very wide
range, and welcome any financial amount with gratitude! Based on the donation tier, sponsorship
comes with a variety of benefits, including recognition at different places in the Appium repo,
docs, and website. In addition to financial sponsorship, the project has decided to recognize
significant donations of project leadership and maintenance efforts from companies who have
invested heavily into Appium with their employees' time (we call these "Development Partners").

What will the project do with the funds raised through this sponsorship program? We aim to give it
all back to the Appium community! With the details again available at our [Governance document](https://github.com/appium/appium/blob/master/GOVERNANCE.md),
we have implemented a scheme very much inspired by our friends at [WebdriverIO](https://webdriver.io/blog/2024/02/15/new-contributor-stipend-program) (thanks WDIO
friends!) There are three groups of contributors to Appium that this scheme supports: (1) project
maintainers (those who devote consistent time to leading the project), (2) project contributors
(anyone in the wider community that contributes code or documentation), and (3) upstream projects
(other open source projects Appium relies heavily on to work well). Each month, the funds raised
via sponsorship will be distributed in different amounts to each of these groups. So if you
make a valuable contribution to Appium moving forward, you'll be eligible to get some cash as
a thank-you! (You'll need to have your own OpenCollective account in good standing to receive
funds).

We're very excited about this new program, and hope that it helps existing and new contributors to
feel even better about donating their time to making Appium better. And of course, none of this
would be possible without the amazing Partners and Sponsors we hope to attract! On that note, stay
tuned over the next few weeks as we unveil some of our initial program launch Partners! And if you
or your company would like to participate by supporting Appium financially, you are most welcome.
Just head over to our OpenCollective page and choose the tier that reflects your desired
contribution level.
