# [Static Site](https://appseed.us/static-site) - [Eleventy Ethereal](https://appseed.us/static-site/eleventy-html5up-ethereal)

Static Site prototyped on top of [Eleventy](https://www.11ty.io/) SSG and Ethereal Design. Boilerplate features:

- Design: HTML5up Ethereal
- SSG: [11ty](https://www.11ty.io/)
- Webpack, Babel
- Light-server - for browser refresh
- PostCSS, Sass/SCSS, CSSnano
- Autoprefixer

<br />

**Links**

- [Eleventy Ethereal](https://appseed.us/static-site/eleventy-html5up-ethereal) - the product page
- [Eleventy Ethereal - Demo](https://eleventy-html5up-ethereal.appseed.us/) - the product page
- [Eleventy Ethereal - Sources](https://github.com/app-generator/eleventy-html5up-ethereal) - the product page

<br />

## Want more? Go PRO!

PRO versions include **Premium UI Kits**, Lifetime updates and **24/7 LIVE Support** (via [Discord](https://discord.gg/fZC6hup)) 

| [Eleventy Material Kit PRO](https://appseed.us/static-site/eleventy-material-kit-pro) | [Eleventy Paper Kit PRO](https://appseed.us/static-site/eleventy-paper-kit-pro) | [Eleventy Now UI Kit PRO](https://appseed.us/static-site/eleventy-now-ui-kit-pro) |
| --- | --- | --- |
| [![Eleventy Material Kit PRO](https://raw.githubusercontent.com/app-generator/static/master/products/eleventy-material-kit-pro-screen.png)](https://appseed.us/static-site/eleventy-material-kit-pro)  | [![Eleventy Paper Kit PRO](https://raw.githubusercontent.com/app-generator/static/master/products/eleventy-paper-kit-pro-screen.png)](https://appseed.us/static-site/eleventy-paper-kit-pro) | [![Eleventy Now UI Kit PRO](https://raw.githubusercontent.com/app-generator/static/master/products/eleventy-now-ui-kit-pro-screen.png)](https://appseed.us/static-site/eleventy-now-ui-kit-pro)

<br />
<br />

![Eleventy Html5UP Ethereal - Static Site built in Eleventy.](https://raw.githubusercontent.com/app-generator/eleventy-html5up-ethereal/master/media/eleventy-html5up-ethereal-screen.png)

<br />

## How to use it

```bash
$ # clone the sources
$ git clone https://github.com/app-generator/eleventy-html5up-ethereal.git
$ cd eleventy-html5up-ethereal
$
$ # install modules
$ yarn
$
$ # start the project in development mode
$ yarn dev
$ # app is running on http://localhost:4000
$
$ # build the project for production
$ yarn build
```

<br />

## Project Structure

The boilerplate code is built with a modular structure that follows the recommended pattern used by many open-source projects. The most important files / directories are listed bellow:

- [.eleventy.js](https://github.com/app-generator/eleventy-html5up-ethereal/blob/master/.eleventy.js)
- [package.json](https://github.com/app-generator/eleventy-html5up-ethereal/blob/master/package.json)
- [src /](https://github.com/app-generator/eleventy-html5up-ethereal/tree/master/src)
- [src / _includes](https://github.com/app-generator/eleventy-html5up-ethereal/tree/master/src/_includes)
- [src / assets](https://github.com/app-generator/eleventy-html5up-ethereal/tree/master/src/assets)
- [src / data / data.json](https://github.com/app-generator/eleventy-html5up-ethereal/blob/master/src/_data/data.json)
- [src / index.njk](https://github.com/app-generator/eleventy-html5up-ethereal/blob/master/src/index.njk)

<br />

```bash
< ROOT > - Eleventy Ethereal      # project root folder
    |
    |--- src/                     # website source folder  
    |--- src/_includes            # website partials (footer, header)  
    |--- src/assets               # website assets (scss, javascript files)
    |--- src/index.njk            # index page in NJK format
    |  
    |--- .eleventy.js             # Eleventy (11ty) config file
    |--- package.json             # main script executed by Yarn, Npm
    |
    |-----------------------------
```

<br />

## Support

- Free support via eMail < [support @ appseed.us](https://appseed.us/support) > and [Github](https://github.com/app-generator/flask-argon-dashboard/issues/)
- 24/7 Live Support via [Discord](https://discord.gg/fZC6hup) for paid plans and commercial products.

<br />

## Resources

- [Eleventy Ethereal](https://appseed.us/static-site/eleventy-html5up-ethereal) - Product page
- [Eleventy Ethereal](https://eleventy-html5up-ethereal.appseed.us) - Live DEMO

<br />

## License & Credits

- [CCY 3.0](https://html5up.net/license) - inherited from Html5Up
- [Deventy](https://github.com/ianrose/deventy) - the initial starter 

<br />

---
[Static Site Eleventy Ethereal](https://appseed.us/static-site/eleventy-html5up-ethereal) - provided by **AppSeed**
