# Airbnb-Inspired Full-Stack Web Application 🚀

#live link

## Table of Contents
1. [Project Overview](#project-overview)
2. [Technologies & Packages Used](#technologies--packages-used)
3. [Key Features](#key-features)
4. [Live Demo](#live-demo)
5. [Thank You](#thank-you)

## Project Overview
Excited to share my journey of developing a feature-rich full-stack web application inspired by Airbnb. This project leverages MongoDB, Express.js, and Node.js to create a dynamic and scalable platform for managing listings and user interactions.

## Technologies & Packages Used

### Backend
- **MongoDB**: NoSQL database for flexible and scalable data storage.
- **Express.js**: Web application framework for Node.js, providing robust features for web and mobile applications.
- **Node.js**: JavaScript runtime for server-side development.

### Authentication
- **Passport.js**: Middleware for user authentication, supporting various strategies.
- **Dotenv**: Environment variable management for secure configuration.

### Image Storage
- **Cloudinary**: Cloud-based image and video management solution.

### Maps
- **Mapbox**: Platform for custom maps and location-based experiences.

### Frontend
- **EJS**: Embedded JavaScript templates for dynamic content rendering.

### Session Management
- **Connect Flash**: Middleware for flash messages.
- **Connect Mongo**: MongoDB session store for Express.js.
- **Cookie Parser**: Middleware for parsing cookies.

### Validation
- **Joi**: Library for data validation.

### Object Modeling
- **Mongoose**: MongoDB object modeling for Node.js.

### File Uploads
- **Multer**: Middleware for handling file uploads.

## Key Features
- **User Authentication**: Login, Logout, and User Profile Section.
- **CRUD Operations**: Add, Edit, and Delete Listings.
- **Review System**: Add and Delete Reviews.
- **Account Management**: Update User Account and Password.
- **User Data Security**: Password Hashing and Encryption.
- **Interactive Maps**: Leveraging Mapbox for Location Visualization.
- **Login with Google**: Authenticate with your Google account for a seamless experience.
- **Login with Facebook**: Easily log in using your Facebook credentials.
- **Login with Email**: Traditional email login for user convenience.

- - ## Live Demo
Check out the live demo of the application here: [Render Deployment](https://airbnb-412m.onrender.com)

## Thank You
Thank you for exploring Airbnb! Your feedback is valuable. If you have any suggestions or thoughts, feel free to share them with us. 😊

