/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.apache.kylin.cube.kv;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;

/**
 * 
 * @author xjiang
 * 
 */
public class FuzzyKeyEncoder extends RowKeyEncoder {

    public FuzzyKeyEncoder(CubeSegment seg, Cuboid cuboid) {
        super(seg, cuboid);
    }

    @Override
    protected short calculateShard(byte[] key) {
        if (enableSharding) {
            return 0;
        } else {
            throw new RuntimeException("If enableSharding false, you should never calculate shard");
        }
    }

    @Override
    protected byte defaultValue() {
        return RowConstants.BYTE_ZERO;
    }
}
