/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_28bab1d.core.internal.instr;

import org.jacoco.agent.rt.internal_28bab1d.asm.ClassReader;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.BytecodeVersion;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.flow.ClassProbesAdapter;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.instr.ClassFieldProbeArrayStrategy;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.instr.InstrSupport;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.instr.InterfaceFieldProbeArrayStrategy;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.instr.LocalProbeArrayStrategy;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.instr.NoneProbeArrayStrategy;
import org.jacoco.agent.rt.internal_28bab1d.core.internal.instr.ProbeCounter;
import org.jacoco.agent.rt.internal_28bab1d.core.runtime.IExecutionDataAccessorGenerator;

public final class ProbeArrayStrategyFactory {
    private ProbeArrayStrategyFactory() {
    }

    public static IProbeArrayStrategy createFor(long classId, ClassReader reader, IExecutionDataAccessorGenerator accessorGenerator) {
        String className = reader.getClassName();
        int version = BytecodeVersion.get(reader.b);
        if (ProbeArrayStrategyFactory.isInterfaceOrModule(reader)) {
            ProbeCounter counter = ProbeArrayStrategyFactory.getProbeCounter(reader);
            if (counter.getCount() == 0) {
                return new NoneProbeArrayStrategy();
            }
            if (version >= 52 && counter.hasMethods()) {
                return new InterfaceFieldProbeArrayStrategy(className, classId, counter.getCount(), accessorGenerator);
            }
            return new LocalProbeArrayStrategy(className, classId, counter.getCount(), accessorGenerator);
        }
        return new ClassFieldProbeArrayStrategy(className, classId, InstrSupport.needsFrames(version), accessorGenerator);
    }

    private static boolean isInterfaceOrModule(ClassReader reader) {
        return (reader.getAccess() & 0x8200) != 0;
    }

    private static ProbeCounter getProbeCounter(ClassReader reader) {
        ProbeCounter counter = new ProbeCounter();
        reader.accept(new ClassProbesAdapter(counter, false), 0);
        return counter;
    }
}

