
#include <sys/mman.h>
#include <unistd.h>
#include <err.h>
#include <mach/vm_param.h>
#include <string.h>

void nullderef() {
    char * ptr = 0;
    ptr[0] = 0;
}

int main() {
    //currently there's no enforcement of W^X if the program explicitly maps in a page with W|X perms.
    //create an executable buffer with code that does a null deref.  This should be considered exploitable
    //if the CW_EXPLOITABLE_JIT environment variable is set
    //since it's running outside of a known function.
    char * buf = mmap(NULL, PAGE_SIZE, PROT_READ | PROT_WRITE | PROT_EXEC, MAP_ANON | MAP_PRIVATE, -1, 0);
    if (buf == MAP_FAILED) {
        err(-1, "mmap");
    }
    memcpy(buf, nullderef, PAGE_SIZE);
    void (*fp)() = (void(*)())buf;
    (*fp)();
}