PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE instructions (platform TEXT, mnem TEXT, description TEXT);
INSERT INTO "instructions" VALUES('ARM','ADC','Add with carry: Rd = Rn + Rm + C       (C6.6.1)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9             5 4              0
    sf 0 0 1 1 0 1 0 0 0 0                  Rm         0 0 0 0 0 0              Rn              Rd
       op S


32-bit variant

Applies when sf = 0.

ADC <Wd>, <Wn>, <Wm>


64-bit variant

Applies when sf = 1.

ADC <Xd>, <Xn>, <Xm>


Decode for all variants of this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  integer datasize = if sf == ''1'' then 64 else 32;
  boolean sub_op = (op == ''1'');
  boolean setflags = (S == ''1'');


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.


Operation

  bits(datasize) result;
  bits(datasize) operand1 = X[n];
  bits(datasize) operand2 = X[m];
  bits(4) nzcv;

  if sub_op then
       operand2 = NOT(operand2);

  (result, nzcv) = AddWithCarry(operand1, operand2, PSTATE.C);

  if setflags then
       PSTATE.<N,Z,C,V> = nzcv;

  X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ADCS','Add with carry, setting the condition flags: Rd = Rn + Rm + C       (C6.6.2)




  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9              5 4              0
  sf 0 1 1 1 0 1 0 0 0 0                   Rm         0 0 0 0 0 0              Rn              Rd
     op S


32-bit variant

Applies when sf = 0.

ADCS <Wd>, <Wn>, <Wm>


64-bit variant

Applies when sf = 1.

ADCS <Xd>, <Xn>, <Xm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean sub_op = (op == ''1'');
 boolean setflags = (S == ''1'');


Assembler symbols

<Wd>           Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>           Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>           Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>           Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>           Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>           Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.


Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];
 bits(4) nzcv;

 if sub_op then
     operand2 = NOT(operand2);

 (result, nzcv) = AddWithCarry(operand1, operand2, PSTATE.C);

 if setflags then
     PSTATE.<N,Z,C,V> = nzcv;

 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ADD','       Add (extended register): Rd = Rn + LSL(extend(Rm), amount)       (C6.6.3)




           31 30 29 28 27 26 25 24 23 22 21 20            16 15     13 12      10 9            5 4            0
           sf 0 0 0 1 0 1 1 0 0 1                  Rm          option    imm3           Rn              Rd
              op S


       32-bit variant

       Applies when sf = 0.

       ADD <Wd|WSP>, <Wn|WSP>, <Wm>{, <extend> {#<amount>}}


       64-bit variant

       Applies when sf = 1.

       ADD <Xd|SP>, <Xn|SP>, <R><m>{, <extend> {#<amount>}}


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer datasize = if sf == ''1'' then 64 else 32;
         boolean sub_op = (op == ''1'');
         boolean setflags = (S == ''1'');
         ExtendType extend_type = DecodeRegExtend(option);
         integer shift = UInt(imm3);
         if shift > 4 then ReservedValue();


       Assembler symbols

       <Wd|WSP>        Is the 32-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
                       field.

       <Wn|WSP>        Is the 32-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                       field.

       <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <Xd|SP>         Is the 64-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
                       field.

       <Xn|SP>         Is the 64-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                       field.

       <R>             Is a width specifier, encoded in the "option" field. It can have the following values:

                       W           when option = 00x

                       W           when option = 010

                       X           when option = x11

                       W           when option = 10x

                       W           when option = 110

       <m>             Is the number [0-30] of the second general-purpose source register or the name ZR (31), encoded in
                       the "Rm" field.
<extend>      For the 32-bit variant: is the extension to be applied to the second source operand, encoded in the
              "option" field. It can have the following values:

              UXTB         when option = 000

              UXTH         when option = 001

              LSL|UXTW     when option = 010

              UXTX         when option = 011

              SXTB         when option = 100

              SXTH         when option = 101

              SXTW         when option = 110

              SXTX         when option = 111

              If "Rd" or "Rn" is ''11111'' (WSP) and "option" is ''010'' then LSL is preferred, but may be omitted
              when "imm3" is ''000''. In all other cases <extend> is required and must be UXTW when "option" is
              ''010''.

              For the 64-bit variant: is the extension to be applied to the second source operand, encoded in the
              "option" field. It can have the following values:

              UXTB         when option = 000

              UXTH         when option = 001

              UXTW         when option = 010

              LSL|UXTX     when option = 011

              SXTB         when option = 100

              SXTH         when option = 101

              SXTW         when option = 110

              SXTX         when option = 111

              If "Rd" or "Rn" is ''11111'' (SP) and "option" is ''011'' then LSL is preferred, but may be omitted when
              "imm3" is ''000''. In all other cases <extend> is required and must be UXTX when "option" is ''011''.

<amount>      Is the left shift amount to be applied after extension in the range 0 to 4, defaulting to 0, encoded in
              the "imm3" field. It must be absent when <extend> is absent, is required when <extend> is LSL,
              and is optional when <extend> is present but not LSL.


Operation

 bits(datasize) result;
 bits(datasize) operand1 = if n == 31 then SP[] else X[n];
 bits(datasize) operand2 = ExtendReg(m, extend_type, shift);
 bits(4) nzcv;
 bit carry_in;

 if sub_op then
     operand2 = NOT(operand2);
     carry_in = ''1'';
 else
     carry_in = ''0'';

 (result, nzcv) = AddWithCarry(operand1, operand2, carry_in);

 if setflags then
     PSTATE.<N,Z,C,V> = nzcv;

 if d == 31 && !setflags then
     SP[] = result;
 else
     X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ADDS','       Add (extended register), setting the condition flags: Rd = Rn + LSL(extend(Rm), amount)       (C6.6.6)

       This instruction is used by the alias CMN (extended register). See the Alias conditions table for details of when each
       alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20             16 15     13 12      10 9            5 4             0
           sf 0 1 0 1 0 1 1 0 0 1                   Rm          option    imm3           Rn              Rd
              op S


       32-bit variant

       Applies when sf = 0.

       ADDS <Wd>, <Wn|WSP>, <Wm>{, <extend> {#<amount>}}


       64-bit variant

       Applies when sf = 1.

       ADDS <Xd>, <Xn|SP>, <R><m>{, <extend> {#<amount>}}


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer datasize = if sf == ''1'' then 64 else 32;
         boolean sub_op = (op == ''1'');
         boolean setflags = (S == ''1'');
         ExtendType extend_type = DecodeRegExtend(option);
         integer shift = UInt(imm3);
         if shift > 4 then ReservedValue();


       Alias conditions


                             Alias                     is preferred when

                             CMN (extended             Rd == ''11111''
                             register)


       Assembler symbols

       <Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn|WSP>         Is the 32-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                        field.

       <Wm>             Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn|SP>          Is the 64-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                        field.

       <R>              Is a width specifier, encoded in the "option" field. It can have the following values:

                        W           when option = 00x
              W            when option = 010

              X            when option = x11

              W            when option = 10x

              W            when option = 110

<m>           Is the number [0-30] of the second general-purpose source register or the name ZR (31), encoded in
              the "Rm" field.

<extend>      For the 32-bit variant: is the extension to be applied to the second source operand, encoded in the
              "option" field. It can have the following values:

              UXTB         when option = 000

              UXTH         when option = 001

              LSL|UXTW     when option = 010

              UXTX         when option = 011

              SXTB         when option = 100

              SXTH         when option = 101

              SXTW         when option = 110

              SXTX         when option = 111

              If "Rn" is ''11111'' (WSP) and "option" is ''010'' then LSL is preferred, but may be omitted when
              "imm3" is ''000''. In all other cases <extend> is required and must be UXTW when "option" is ''010''.

              For the 64-bit variant: is the extension to be applied to the second source operand, encoded in the
              "option" field. It can have the following values:

              UXTB         when option = 000

              UXTH         when option = 001

              UXTW         when option = 010

              LSL|UXTX     when option = 011

              SXTB         when option = 100

              SXTH         when option = 101

              SXTW         when option = 110

              SXTX         when option = 111

              If "Rn" is ''11111'' (SP) and "option" is ''011'' then LSL is preferred, but may be omitted when "imm3"
              is ''000''. In all other cases <extend> is required and must be UXTX when "option" is ''011''.

<amount>      Is the left shift amount to be applied after extension in the range 0 to 4, defaulting to 0, encoded in
              the "imm3" field. It must be absent when <extend> is absent, is required when <extend> is LSL,
              and is optional when <extend> is present but not LSL.


Operation

 bits(datasize) result;
 bits(datasize) operand1 = if n == 31 then SP[] else X[n];
 bits(datasize) operand2 = ExtendReg(m, extend_type, shift);
 bits(4) nzcv;
 bit carry_in;

 if sub_op then
     operand2 = NOT(operand2);
     carry_in = ''1'';
 else
     carry_in = ''0'';

 (result, nzcv) = AddWithCarry(operand1, operand2, carry_in);

 if setflags then
              PSTATE.<N,Z,C,V> = nzcv;

         if d == 31 && !setflags then
              SP[] = result;
         else
              X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ADR','Address of label at a PC-relative offset       (C6.6.9)




  31 30 29 28 27 26 25 24 23                                                           5 4              0
  0 immlo 1 0 0 0 0                                   immhi                                     Rd
  op


Literal variant

ADR <Xd>, <label>


Decode for this encoding

 integer d = UInt(Rd);
 boolean page = (op == ''1'');
 bits(64) imm;

 if page then
     imm = SignExtend(immhi:immlo:Zeros(12), 64);
 else
     imm = SignExtend(immhi:immlo, 64);


Assembler symbols

<Xd>           Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<label>        Is the program label whose address is to be calculated. Its offset from the address of this instruction,
               in the range +/-1MB, is encoded in "immhi:immlo".


Operation

 bits(64) base = PC[];

 if page then
     base<11:0> = Zeros(12);

 X[d] = base + imm;');
INSERT INTO "instructions" VALUES('ARM','ADRP','Address of 4KB page at a PC-relative offset       (C6.6.10)




    31 30 29 28 27 26 25 24 23                                                        5 4             0
    1 immlo 1 0 0 0 0                                   immhi                                  Rd
    op


Literal variant

ADRP <Xd>, <label>


Decode for this encoding

  integer d = UInt(Rd);
  boolean page = (op == ''1'');
  bits(64) imm;

  if page then
       imm = SignExtend(immhi:immlo:Zeros(12), 64);
  else
       imm = SignExtend(immhi:immlo, 64);


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<label>         Is the program label whose 4KB page address is to be calculated. Its offset from the page address of
                this instruction, in the range +/-4GB, is encoded as "immhi:immlo" times 4096.


Operation

  bits(64) base = PC[];

  if page then
       base<11:0> = Zeros(12);

  X[d] = base + imm;');
INSERT INTO "instructions" VALUES('ARM','AND','Bitwise AND (immediate): Rd = Rn AND imm       (C6.6.11)




  31 30 29 28 27 26 25 24 23 22 21               16 15             10 9             5 4              0
  sf 0 0 1 0 0 1 0 0 N                 immr               imms               Rn               Rd
     opc


32-bit variant

Applies when sf = 0 && N = 0.

AND <Wd|WSP>, <Wn>, #<imm>


64-bit variant

Applies when sf = 1.

AND <Xd|SP>, <Xn>, #<imm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean setflags;
 LogicalOp op;
 case opc of
     when ''00'' op = LogicalOp_AND; setflags = FALSE;
     when ''01'' op = LogicalOp_ORR; setflags = FALSE;
     when ''10'' op = LogicalOp_EOR; setflags = FALSE;
     when ''11'' op = LogicalOp_AND; setflags = TRUE;

 bits(datasize) imm;
 if sf == ''0'' && N != ''0'' then ReservedValue();
 (imm, -) = DecodeBitMasks(N, imms, immr, TRUE);


Assembler symbols

<Wd|WSP>      Is the 32-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
              field.

<Wn>          Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd|SP>       Is the 64-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
              field.

<Xn>          Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<imm>         Is the bitmask immediate, encoded in "N:imms:immr".


Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = imm;

 case op of
     when LogicalOp_AND result = operand1 AND operand2;
     when LogicalOp_ORR result = operand1 OR     operand2;
     when LogicalOp_EOR result = operand1 EOR operand2;

         if setflags then
              PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

         if d == 31 && !setflags then
              SP[] = result;
         else
              X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ANDS','Bitwise AND (immediate), setting the condition flags: Rd = Rn AND imm       (C6.6.13)

This instruction is used by the alias TST (immediate). See the Alias conditions table for details of when each alias
is preferred.




  31 30 29 28 27 26 25 24 23 22 21                16 15              10 9             5 4              0
   sf 1 1 1 0 0 1 0 0 N                  immr              imms                Rn              Rd
       opc


32-bit variant

Applies when sf = 0 && N = 0.

ANDS <Wd>, <Wn>, #<imm>


64-bit variant

Applies when sf = 1.

ANDS <Xd>, <Xn>, #<imm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean setflags;
 LogicalOp op;
 case opc of
     when ''00'' op = LogicalOp_AND; setflags = FALSE;
     when ''01'' op = LogicalOp_ORR; setflags = FALSE;
     when ''10'' op = LogicalOp_EOR; setflags = FALSE;
     when ''11'' op = LogicalOp_AND; setflags = TRUE;

 bits(datasize) imm;
 if sf == ''0'' && N != ''0'' then ReservedValue();
 (imm, -) = DecodeBitMasks(N, imms, immr, TRUE);


Alias conditions


                     Alias                   is preferred when

                     TST (immediate)         Rd == ''11111''



Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<imm>           Is the bitmask immediate, encoded in "N:imms:immr".
       Operation

         bits(datasize) result;
         bits(datasize) operand1 = X[n];
         bits(datasize) operand2 = imm;

         case op of
              when LogicalOp_AND result = operand1 AND operand2;
              when LogicalOp_ORR result = operand1 OR  operand2;
              when LogicalOp_EOR result = operand1 EOR operand2;

         if setflags then
              PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

         if d == 31 && !setflags then
              SP[] = result;
         else
              X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ASR','Arithmetic shift right (register): Rd = ASR(Rn, Rm)       (C6.6.15)

This instruction is an alias of the ASRV instruction. This means that:

.      The encodings in this description are named to match the encodings of ASRV.

.      The description of ASRV gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9              5 4              0
   sf 0 0 1 1 0 1 0 1 1 0                   Rm         0 0 1 0 1 0              Rn              Rd
                                                                   op2


32-bit variant

Applies when sf = 0.

ASR <Wd>, <Wn>, <Wm>

is equivalent to

ASRV <Wd>, <Wn>, <Wm>

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

ASR <Xd>, <Xn>, <Xm>

is equivalent to

ASRV <Xd>, <Xn>, <Xm>

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding a shift amount from 0 to
                31 in its bottom 5 bits, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding a shift amount from 0 to
                63 in its bottom 6 bits, encoded in the "Rm" field.


Operation

The description of ASRV gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','ASRV','Arithmetic shift right variable : Rd = ASR(Rn, Rm)       (C6.6.17)

This instruction is used by the alias ASR (register). The alias is always the preferred disassembly.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9              5 4              0
  sf 0 0 1 1 0 1 0 1 1 0                    Rm         0 0 1 0 1 0              Rn              Rd
                                                                     op2


32-bit variant

Applies when sf = 0.

ASRV <Wd>, <Wn>, <Wm>


64-bit variant

Applies when sf = 1.

ASRV <Xd>, <Xn>, <Xm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 ShiftType shift_type = DecodeShift(op2);


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding a shift amount from 0 to
                31 in its bottom 5 bits, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding a shift amount from 0 to
                63 in its bottom 6 bits, encoded in the "Rm" field.


Operation

 bits(datasize) result;
 bits(datasize) operand2 = X[m];

 result = ShiftReg(n, shift_type, UInt(operand2) MOD datasize);
 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','AT','Address translate       (C6.6.18)

This instruction is an alias of the SYS instruction. This means that:

.       The encodings in this description are named to match the encodings of SYS.

.       The description of SYS gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20 19 18      16 15       12 11        8 7      5 4             0
    1 1 0 1 0 1 0 1 0 0 0 0 1                  op1     0 1 1 1 1 0 0 0           op2           Rt
                                    L                     CRn         CRm


System variant

AT <at_op>, <Xt>

is equivalent to

SYS #<op1>, C7, C8, #<op2>, <Xt>

and is the preferred disassembly when SysOp(op1,''0111'',''1000'',op2) == Sys_AT.


Assembler symbols

<at_op>         Is an AT operation name, as listed for the AT system operation group, encoded in the "op1:op2"
                field. It can have the following values:

                S1E1R        when op1 = 000, op2 = 000

                S1E1W        when op1 = 000, op2 = 001

                S1E0R        when op1 = 000, op2 = 010

                S1E0W        when op1 = 000, op2 = 011

                S1E2R        when op1 = 100, op2 = 000

                S1E2W        when op1 = 100, op2 = 001

                S12E1R       when op1 = 100, op2 = 100

                S12E1W       when op1 = 100, op2 = 101

                S12E0R       when op1 = 100, op2 = 110

                S12E0W       when op1 = 100, op2 = 111

                S1E3R        when op1 = 110, op2 = 000

                S1E3W        when op1 = 110, op2 = 001

<op1>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op1" field.

<op2>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op2" field.

<Xt>            Is the 64-bit name of the general-purpose source register, encoded in the "Rt" field.


Operation

The description of SYS gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','B.cond','Branch conditionally to a label at a PC-relative offset, with a hint that this is not a subroutine call or return.       (C6.6.19)




  31 30 29 28 27 26 25 24 23                                                              5 4 3            0
  0 1 0 1 0 1 0 0                                      imm19                                 0     cond




19-bit signed PC-relative branch offset variant

B.<cond> <label>


Decode for this encoding

 bits(64) offset = SignExtend(imm19:''00'', 64);
 bits(4) condition = cond;


Assembler symbols

<cond>        Is one of the standard conditions, encoded in the "cond" field in the standard way.

<label>       Is the program label to be conditionally branched to. Its offset from the address of this instruction,
              in the range +/-1MB, is encoded as "imm19" times 4.


Operation

 if ConditionHolds(condition) then
     BranchTo(PC[] + offset, BranchType_JMP);');
INSERT INTO "instructions" VALUES('ARM','B','Branch causes an unconditional branch to a label at a PC-relative offset, with a hint that this is not a subroutine call       (C6.6.20)
or return.




    31 30 29 28 27 26 25                                                                                  0
    0 0 0 1 0 1                                            imm26
    op


26-bit signed PC-relative branch offset variant

B <label>


Decode for this encoding

  BranchType branch_type = if op == ''1'' then BranchType_CALL else BranchType_JMP;
  bits(64) offset = SignExtend(imm26:''00'', 64);


Assembler symbols

<label>         Is the program label to be unconditionally branched to. Its offset from the address of this instruction,
                in the range +/-128MB, is encoded as "imm26" times 4.


Operation

  if branch_type == BranchType_CALL then X[30] = PC[] + 4;

  BranchTo(PC[] + offset, branch_type);');
INSERT INTO "instructions" VALUES('ARM','BFI','Bitfield insert, leaving other bits unchanged       (C6.6.21)

This instruction is an alias of the BFM instruction. This means that:

.      The encodings in this description are named to match the encodings of BFM.

.      The description of BFM gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                    16 15                10 9            5 4               0
   sf 0 1 1 0 0 1 1 0 N                     immr                imms                Rn               Rd
      opc


32-bit variant

Applies when sf = 0 && N = 0.

BFI <Wd>, <Wn>, #<lsb>, #<width>

is equivalent to

BFM  <Wd>, <Wn>, #(-<lsb> MOD 32), #(<width>-1)

and is the preferred disassembly when UInt(imms) < UInt(immr).

64-bit variant

Applies when sf = 1 && N = 1.

BFI <Xd>, <Xn>, #<lsb>, #<width>

is equivalent to

BFM  <Xd>, <Xn>, #(-<lsb> MOD 64), #(<width>-1)

and is the preferred disassembly when UInt(imms) < UInt(immr).


Assembler symbols

<Wd>              Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>              Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>              Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>              Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<lsb>             For the 32-bit variant: is the bit number of the lsb of the destination bitfield, in the range 0 to 31.

                  For the 64-bit variant: is the bit number of the lsb of the destination bitfield, in the range 0 to 63.

<width>           For the 32-bit variant: is the width of the bitfield, in the range 1 to 32-<lsb>.

                  For the 64-bit variant: is the width of the bitfield, in the range 1 to 64-<lsb>.


Operation

The description of BFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','BFM','       Bitfield move, leaving other bits unchanged       (C6.6.22)

       This instruction is used by the aliases BFI and BFXIL. See the Alias conditions on page C6-433 table for details of
       when each alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21              16 15              10 9            5 4            0
           sf 0 1 1 0 0 1 1 0 N                 immr               imms              Rn            Rd
               opc


       32-bit variant

       Applies when sf = 0 && N = 0.

       BFM <Wd>, <Wn>, #<immr>, #<imms>


       64-bit variant

       Applies when sf = 1 && N = 1.

       BFM <Xd>, <Xn>, #<immr>, #<imms>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer datasize = if sf == ''1'' then 64 else 32;

         boolean inzero;
         boolean extend;
         integer R;
         integer S;
         bits(datasize) wmask;
         bits(datasize) tmask;

         case opc of
              when ''00'' inzero = TRUE;    extend = TRUE;      // SBFM
              when ''01'' inzero = FALSE; extend = FALSE;       // BFM
              when ''10'' inzero = TRUE;    extend = FALSE;     // UBFM
              when ''11'' UnallocatedEncoding();

         if sf == ''1'' && N != ''1'' then ReservedValue();
         if sf == ''0'' && (N != ''0'' || immr<5> != ''0'' || imms<5> != ''0'') then ReservedValue();

         R = UInt(immr);
         S = UInt(imms);
         (wmask, tmask) = DecodeBitMasks(N, imms, immr, FALSE);
Alias conditions


                   Alias                      is preferred when

                   BFI                        UInt(imms) < UInt(immr)

                   BFXIL                      UInt(imms) >= UInt(immr)



Assembler symbols

<Wd>          Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>          Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>          Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>          Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<immr>        For the 32-bit variant: is the right rotate amount, in the range 0 to 31, encoded in the "immr" field.

              For the 64-bit variant: is the right rotate amount, in the range 0 to 63, encoded in the "immr" field.

<imms>        For the 32-bit variant: is the leftmost bit number to be moved from the source, in the range 0 to 31,
              encoded in the "imms" field.

              For the 64-bit variant: is the leftmost bit number to be moved from the source, in the range 0 to 63,
              encoded in the "imms" field.


Operation

 bits(datasize) dst = if inzero then Zeros() else X[d];
 bits(datasize) src = X[n];

 // perform bitfield move on low bits
 bits(datasize) bot = (dst AND NOT(wmask)) OR (ROR(src, R) AND wmask);

 // determine extension bits (sign, zero or dest register)
 bits(datasize) top = if extend then Replicate(src<S>) else dst;

 // combine extension bits and result bits
 X[d] = (top AND NOT(tmask)) OR (bot AND tmask);');
INSERT INTO "instructions" VALUES('ARM','BFXIL','Bitfield extract and insert at low end, leaving other bits unchanged       (C6.6.23)

This instruction is an alias of the BFM instruction. This means that:

.       The encodings in this description are named to match the encodings of BFM.

.       The description of BFM gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21                 16 15                10 9            5 4              0
    sf 0 1 1 0 0 1 1 0 N                   immr                imms                Rn              Rd
        opc


32-bit variant

Applies when sf = 0 && N = 0.

BFXIL <Wd>, <Wn>, #<lsb>, #<width>

is equivalent to

BFM    <Wd>, <Wn>, #<lsb>, #(<lsb>+<width>-1)

and is the preferred disassembly when UInt(imms) >= UInt(immr).

64-bit variant

Applies when sf = 1 && N = 1.

BFXIL <Xd>, <Xn>, #<lsb>, #<width>

is equivalent to

BFM    <Xd>, <Xn>, #<lsb>, #(<lsb>+<width>-1)

and is the preferred disassembly when UInt(imms) >= UInt(immr).


Assembler symbols

<Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>             Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>             Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<lsb>            For the 32-bit variant: is the bit number of the lsb of the source bitfield, in the range 0 to 31.

                 For the 64-bit variant: is the bit number of the lsb of the source bitfield, in the range 0 to 63.

<width>          For the 32-bit variant: is the width of the bitfield, in the range 1 to 32-<lsb>.

                 For the 64-bit variant: is the width of the bitfield, in the range 1 to 64-<lsb>.


Operation

The description of BFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','BIC','Bitwise bit clear (shifted register): Rd = Rn AND NOT shift(Rm, amount)       (C6.6.24)




  31 30 29 28 27 26 25 24 23 22 21 20               16 15               10 9             5 4             0
  sf 0 0 0 1 0 1 0 shift 1                   Rm               imm6                Rn            Rd
     opc                            N


32-bit variant

Applies when sf = 0.

BIC <Wd>, <Wn>, <Wm>{, <shift> #<amount>}


64-bit variant

Applies when sf = 1.

BIC <Xd>, <Xn>, <Xm>{, <shift> #<amount>}


Decode for all variants of this encoding

integer d = UInt(Rd);
integer n = UInt(Rn);
integer m = UInt(Rm);
integer datasize = if sf == ''1'' then 64 else 32;
boolean setflags;
 LogicalOp op;
case opc of
     when ''00'' op = LogicalOp_AND; setflags = FALSE;
     when ''01'' op = LogicalOp_ORR; setflags = FALSE;
     when ''10'' op = LogicalOp_EOR; setflags = FALSE;
     when ''11'' op = LogicalOp_AND; setflags = TRUE;

if sf == ''0'' && imm6<5> == ''1'' then ReservedValue();

 ShiftType shift_type = DecodeShift(shift);
integer shift_amount = UInt(imm6);
boolean invert = (N == ''1'');


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

<shift>         Is the optional shift to be applied to the final source, defaulting to LSL and encoded in the "shift"
                field. It can have the following values:

                LSL          when shift = 00

                LSR          when shift = 01

                ASR          when shift = 10

                ROR          when shift = 11
      <amount>        For the 32-bit variant: is the shift amount, in the range 0 to 31, defaulting to 0 and encoded in the
                      "imm6" field.

                      For the 64-bit variant: is the shift amount, in the range 0 to 63, defaulting to 0 and encoded in the
                      "imm6" field.


      Operation

        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = ShiftReg(m, shift_type, shift_amount);

        if invert then operand2 = NOT(operand2);

        case op of
             when LogicalOp_AND result = operand1 AND operand2;
             when LogicalOp_ORR result = operand1 OR       operand2;
             when LogicalOp_EOR result = operand1 EOR operand2;

        if setflags then
             PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

        X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','BICS','Bitwise bit clear (shifted register), setting the condition flags: Rd = Rn AND NOT shift(Rm, amount)       (C6.6.25)




  31 30 29 28 27 26 25 24 23 22 21 20                16 15              10 9             5 4             0
  sf 1 1 0 1 0 1 0 shift 1                    Rm               imm6               Rn            Rd
     opc                            N


32-bit variant

Applies when sf = 0.

BICS <Wd>, <Wn>, <Wm>{, <shift> #<amount>}


64-bit variant

Applies when sf = 1.

BICS <Xd>, <Xn>, <Xm>{, <shift> #<amount>}


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean setflags;
 LogicalOp op;
 case opc of
     when ''00'' op = LogicalOp_AND; setflags = FALSE;
     when ''01'' op = LogicalOp_ORR; setflags = FALSE;
     when ''10'' op = LogicalOp_EOR; setflags = FALSE;
     when ''11'' op = LogicalOp_AND; setflags = TRUE;

 if sf == ''0'' && imm6<5> == ''1'' then ReservedValue();

 ShiftType shift_type = DecodeShift(shift);
 integer shift_amount = UInt(imm6);
 boolean invert = (N == ''1'');


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

<shift>         Is the optional shift to be applied to the final source, defaulting to LSL and encoded in the "shift"
                field. It can have the following values:

                LSL          when shift = 00

                LSR          when shift = 01

                ASR          when shift = 10

                ROR          when shift = 11
       <amount>        For the 32-bit variant: is the shift amount, in the range 0 to 31, defaulting to 0 and encoded in the
                       "imm6" field.

                       For the 64-bit variant: is the shift amount, in the range 0 to 63, defaulting to 0 and encoded in the
                       "imm6" field.


       Operation

         bits(datasize) operand1 = X[n];
         bits(datasize) operand2 = ShiftReg(m, shift_type, shift_amount);

         if invert then operand2 = NOT(operand2);

         case op of
              when LogicalOp_AND result = operand1 AND operand2;
              when LogicalOp_ORR result = operand1 OR       operand2;
              when LogicalOp_EOR result = operand1 EOR operand2;

         if setflags then
              PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

         X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','BL','Branch with Link calls a subroutine at a PC-relative offset, setting the register X30 to PC+4. It provides a hint that       (C6.6.26)
this is not a subroutine call or return.




  31 30 29 28 27 26 25                                                                                    0
   1 0 0 1 0 1                                              imm26
  op


26-bit signed PC-relative branch offset variant

BL <label>


Decode for this encoding

 BranchType branch_type = if op == ''1'' then BranchType_CALL else BranchType_JMP;
 bits(64) offset = SignExtend(imm26:''00'', 64);


Assembler symbols

<label>          Is the program label to be unconditionally branched to. Its offset from the address of this instruction,
                 in the range +/-128MB, is encoded as "imm26" times 4.


Operation

 if branch_type == BranchType_CALL then X[30] = PC[] + 4;

 BranchTo(PC[] + offset, branch_type);');
INSERT INTO "instructions" VALUES('ARM','BLR','Branch with Link to Register calls a subroutine at an address in a register, setting register X30 to PC+4.       (C6.6.27)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                5 4 3 2 1 0
    1 1 0 1 0 1 1 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0                                 Rn         0 0 0 0 0
                                op


Integer variant

BLR <Xn>


Decode for this encoding

  integer n = UInt(Rn);
  BranchType branch_type;

  case op of
       when ''00'' branch_type = BranchType_JMP;
       when ''01'' branch_type = BranchType_CALL;
       when ''10'' branch_type = BranchType_RET;
       otherwise UnallocatedEncoding();


Assembler symbols

<Xn>            Is the 64-bit name of the general-purpose register holding the address to be branched to, encoded in
                the "Rn" field.


Operation

  bits(64) target = X[n];

  if branch_type == BranchType_CALL then X[30] = PC[] + 4;
  BranchTo(target, branch_type);');
INSERT INTO "instructions" VALUES('ARM','BR','Branch to Register branches unconditionally to an address in a register, with a hint that this is not a subroutine return.       (C6.6.28)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4 3 2 1 0
  1 1 0 1 0 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0                                   Rn           0 0 0 0 0
                               op


Integer variant

BR <Xn>


Decode for this encoding

 integer n = UInt(Rn);
 BranchType branch_type;

 case op of
     when ''00'' branch_type = BranchType_JMP;
     when ''01'' branch_type = BranchType_CALL;
     when ''10'' branch_type = BranchType_RET;
     otherwise UnallocatedEncoding();


Assembler symbols

<Xn>          Is the 64-bit name of the general-purpose register holding the address to be branched to, encoded in
              the "Rn" field.


Operation

 bits(64) target = X[n];

 if branch_type == BranchType_CALL then X[30] = PC[] + 4;
 BranchTo(target, branch_type);');
INSERT INTO "instructions" VALUES('ARM','BRK','Self-hosted debug breakpoint       (C6.6.29)




    31 30 29 28 27 26 25 24 23 22 21 20                                              5 4 3 2 1 0
    1 1 0 1 0 1 0 0 0 0 1                                 imm16                         0 0 0 0 0




System variant

BRK #<imm>


Decode for this encoding

  bits(16) comment = imm16;


Assembler symbols

<imm>           Is a 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.


Operation

  AArch64.SoftwareBreakpoint(comment);');
INSERT INTO "instructions" VALUES('ARM','CBNZ','Compare and Branch on Nonzero compares the value in a register with zero, and conditionally branches to a label       (C6.6.30)
at a PC-relative offset if the comparison is not equal. It provides a hint that this is not a subroutine call or return.
This instruction does not affect the condition flags.




  31 30 29 28 27 26 25 24 23                                                              5 4             0
   sf 0 1 1 0 1 0 1                                     imm19                                      Rt
                          op


32-bit variant

Applies when sf = 0.

CBNZ <Wt>, <label>


64-bit variant

Applies when sf = 1.

CBNZ <Xt>, <label>


Decode for all variants of this encoding

 integer t = UInt(Rt);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean iszero = (op == ''0'');
 bits(64) offset = SignExtend(imm19:''00'', 64);


Assembler symbols

<Wt>            Is the 32-bit name of the general-purpose register to be tested, encoded in the "Rt" field.

<Xt>            Is the 64-bit name of the general-purpose register to be tested, encoded in the "Rt" field.

<label>         Is the program label to be conditionally branched to. Its offset from the address of this instruction,
                in the range +/-1MB, is encoded as "imm19" times 4.


Operation

 bits(datasize) operand1 = X[t];

 if IsZero(operand1) == iszero then
     BranchTo(PC[] + offset, BranchType_JMP);');
INSERT INTO "instructions" VALUES('ARM','CBZ','Compare and Branch on Zero compares the value in a register with zero, and conditionally branches to a label at a       (C6.6.31)
PC-relative offset if the comparison is equal. It provides a hint that this is not a subroutine call or return. This
instruction does not affect condition flags.




    31 30 29 28 27 26 25 24 23                                                           5 4               0
    sf 0 1 1 0 1 0 0                                   imm19                                       Rt
                          op


32-bit variant

Applies when sf = 0.

CBZ <Wt>, <label>


64-bit variant

Applies when sf = 1.

CBZ <Xt>, <label>


Decode for all variants of this encoding

  integer t = UInt(Rt);
  integer datasize = if sf == ''1'' then 64 else 32;
  boolean iszero = (op == ''0'');
  bits(64) offset = SignExtend(imm19:''00'', 64);


Assembler symbols

<Wt>            Is the 32-bit name of the general-purpose register to be tested, encoded in the "Rt" field.

<Xt>            Is the 64-bit name of the general-purpose register to be tested, encoded in the "Rt" field.

<label>         Is the program label to be conditionally branched to. Its offset from the address of this instruction,
                in the range +/-1MB, is encoded as "imm19" times 4.


Operation

  bits(datasize) operand1 = X[t];

  if IsZero(operand1) == iszero then
       BranchTo(PC[] + offset, BranchType_JMP);');
INSERT INTO "instructions" VALUES('ARM','CCMN','Conditional compare negative (immediate), setting condition flags to result of comparison or an immediate value:       (C6.6.32)
flags = if cond then compare(Rn, #-imm) else #nzcv




  31 30 29 28 27 26 25 24 23 22 21 20            16 15         12 11 10 9             5 4 3            0
  sf 0 1 1 1 0 1 0 0 1 0                  imm5           cond     1 0          Rn         0     nzcv
     op


32-bit variant

Applies when sf = 0.

CCMN <Wn>, #<imm>, #<nzcv>, <cond>


64-bit variant

Applies when sf = 1.

CCMN <Xn>, #<imm>, #<nzcv>, <cond>


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean sub_op = (op == ''1'');
 bits(4) condition = cond;
 bits(4) flags = nzcv;
 bits(datasize) imm = ZeroExtend(imm5, datasize);


Assembler symbols

<Wn>          Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xn>          Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<imm>         Is a five bit unsigned (positive) immediate encoded in the "imm5" field.

<nzcv>        Is the flag bit specifier, an immediate in the range 0 to 15, giving the alternative state for the 4-bit
              NZCV condition flags, encoded in the "nzcv" field.

<cond>        Is one of the standard conditions, encoded in the "cond" field in the standard way.


Operation

 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = imm;
 bit carry_in = ''0'';

 if ConditionHolds(condition) then
     if sub_op then
         operand2 = NOT(operand2);
         carry_in = ''1'';
     (-, flags) = AddWithCarry(operand1, operand2, carry_in);
 PSTATE.<N,Z,C,V> = flags;');
INSERT INTO "instructions" VALUES('ARM','CCMP','Conditional compare (immediate), setting condition flags to result of comparison or an immediate value: flags =       (C6.6.34)
if cond then compare(Rn, #imm) else #nzcv




  31 30 29 28 27 26 25 24 23 22 21 20            16 15         12 11 10 9             5 4 3            0
  sf 1 1 1 1 0 1 0 0 1 0                  imm5           cond     1 0          Rn         0     nzcv
     op


32-bit variant

Applies when sf = 0.

CCMP <Wn>, #<imm>, #<nzcv>, <cond>


64-bit variant

Applies when sf = 1.

CCMP <Xn>, #<imm>, #<nzcv>, <cond>


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean sub_op = (op == ''1'');
 bits(4) condition = cond;
 bits(4) flags = nzcv;
 bits(datasize) imm = ZeroExtend(imm5, datasize);


Assembler symbols

<Wn>          Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xn>          Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<imm>         Is a five bit unsigned (positive) immediate encoded in the "imm5" field.

<nzcv>        Is the flag bit specifier, an immediate in the range 0 to 15, giving the alternative state for the 4-bit
              NZCV condition flags, encoded in the "nzcv" field.

<cond>        Is one of the standard conditions, encoded in the "cond" field in the standard way.


Operation

 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = imm;
 bit carry_in = ''0'';

 if ConditionHolds(condition) then
     if sub_op then
         operand2 = NOT(operand2);
         carry_in = ''1'';
     (-, flags) = AddWithCarry(operand1, operand2, carry_in);
 PSTATE.<N,Z,C,V> = flags;');
INSERT INTO "instructions" VALUES('ARM','CINC','Conditional increment: Rd = if cond then Rn+1 else Rn       (C6.6.36)

This instruction is an alias of the CSINC instruction. This means that:

.      The encodings in this description are named to match the encodings of CSINC.

.      The description of CSINC gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15      12 11 10 9              5 4              0
   sf 0 0 1 1 0 1 0 1 0 0                !=11111        !=111x    0 1       !=11111            Rd
     op                                    Rm            cond        o2        Rn


32-bit variant

Applies when sf = 0.

CINC <Wd>, <Wn>, <cond>

is equivalent to

CSINC <Wd>, <Wn>, <Wn>, invert(<cond>)

and is the preferred disassembly when Rn == Rm.

64-bit variant

Applies when sf = 1.

CINC <Xd>, <Xn>, <cond>

is equivalent to

CSINC <Xd>, <Xn>, <Xn>, invert(<cond>)

and is the preferred disassembly when Rn == Rm.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<cond>          Is one of the standard conditions, excluding AL and NV, encoded in the "cond" field with its least
                significant bit inverted.


Operation

The description of CSINC gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','CINV','Conditional invert: Rd = if cond then NOT(Rn) else Rn       (C6.6.37)

This instruction is an alias of the CSINV instruction. This means that:

.       The encodings in this description are named to match the encodings of CSINV.

.       The description of CSINV gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20           16 15       12 11 10 9             5 4              0
    sf 1 0 1 1 0 1 0 1 0 0                !=11111       !=111x    0 0       !=11111            Rd
       op                                   Rm           cond       o2         Rn


32-bit variant

Applies when sf = 0.

CINV <Wd>, <Wn>, <cond>

is equivalent to

CSINV <Wd>, <Wn>, <Wn>, invert(<cond>)

and is the preferred disassembly when Rn == Rm.

64-bit variant

Applies when sf = 1.

CINV <Xd>, <Xn>, <cond>

is equivalent to

CSINV <Xd>, <Xn>, <Xn>, invert(<cond>)

and is the preferred disassembly when Rn == Rm.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<cond>          Is one of the standard conditions, excluding AL and NV, encoded in the "cond" field with its least
                significant bit inverted.


Operation

The description of CSINV gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','CLREX','Clear exclusive monitor       (C6.6.38)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11           8 7 6 5 4 3 2 1 0
  1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1                           CRm       0 1 0 1 1 1 1 1




System variant

CLREX {#<imm>}


Decode for this encoding

 // CRm field is ignored


Assembler symbols

<imm>          Is an optional 4-bit unsigned immediate, in the range 0 to 15, defaulting to 15 and encoded in the
               "CRm" field.


Operation

 ClearExclusiveLocal(ProcessorID());');
INSERT INTO "instructions" VALUES('ARM','CLS','Count leading sign bits: Rd = CLS(Rn)       (C6.6.39)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9              5 4              0
    sf 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 1                               Rn              Rd
                                                                    op


32-bit variant

Applies when sf = 0.

CLS <Wd>, <Wn>


64-bit variant

Applies when sf = 1.

CLS <Xd>, <Xn>


Decode for all variants of this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer datasize = if sf == ''1'' then 64 else 32;
  CountOp opcode = if op == ''0'' then CountOp_CLZ else CountOp_CLS;


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

  integer result;
  bits(datasize) operand1 = X[n];

  if opcode == CountOp_CLZ then
       result = CountLeadingZeroBits(operand1);
  else
       result = CountLeadingSignBits(operand1);

  X[d] = result<datasize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','CLZ','Count leading zero bits: Rd = CLZ(Rn)       (C6.6.40)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9               5 4              0
  sf 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 1 0 0                               Rn              Rd
                                                                  op


32-bit variant

Applies when sf = 0.

CLZ <Wd>, <Wn>


64-bit variant

Applies when sf = 1.

CLZ <Xd>, <Xn>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;
 CountOp opcode = if op == ''0'' then CountOp_CLZ else CountOp_CLS;


Assembler symbols

<Wd>          Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>          Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>          Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>          Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

 integer result;
 bits(datasize) operand1 = X[n];

 if opcode == CountOp_CLZ then
     result = CountLeadingZeroBits(operand1);
 else
     result = CountLeadingSignBits(operand1);

 X[d] = result<datasize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','CMN','       Compare negative (extended register), setting the condition flags and discarding the result: Rn + LSL(extend(Rm),       (C6.6.41)
       amount)

       This instruction is an alias of the ADDS (extended register) instruction. This means that:

       .       The encodings in this description are named to match the encodings of ADDS (extended register).

       .       The description of ADDS (extended register) gives the operational pseudocode for this instruction.




           31 30 29 28 27 26 25 24 23 22 21 20            16 15     13 12      10 9            5 4            0
           sf 0 1 0 1 0 1 1 0 0 1                  Rm          option    imm3           Rn        1 1 1 1 1
              op S                                                                                      Rd


       32-bit variant

       Applies when sf = 0.

       CMN <Wn|WSP>, <Wm>{, <extend> {#<amount>}}

       is equivalent to

       ADDS WZR, <Wn|WSP>, <Wm>{, <extend> {#<amount>}}

       and is always the preferred disassembly.

       64-bit variant

       Applies when sf = 1.

       CMN <Xn|SP>, <R><m>{, <extend> {#<amount>}}

       is equivalent to

       ADDS XZR, <Xn|SP>, <R><m>{, <extend> {#<amount>}}

       and is always the preferred disassembly.


       Assembler symbols

       <Wn|WSP>        Is the 32-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                       field.

       <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <Xn|SP>         Is the 64-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                       field.

       <R>             Is a width specifier, encoded in the "option" field. It can have the following values:

                       W            when option = 00x

                       W            when option = 010

                       X            when option = x11

                       W            when option = 10x

                       W            when option = 110

       <m>             Is the number [0-30] of the second general-purpose source register or the name ZR (31), encoded in
                       the "Rm" field.
<extend>       For the 32-bit variant: is the extension to be applied to the second source operand, encoded in the
               "option" field. It can have the following values:

               UXTB         when option = 000

               UXTH         when option = 001

               LSL|UXTW     when option = 010

               UXTX         when option = 011

               SXTB         when option = 100

               SXTH         when option = 101

               SXTW         when option = 110

               SXTX         when option = 111

               If "Rn" is ''11111'' (WSP) and "option" is ''010'' then LSL is preferred, but may be omitted when
               "imm3" is ''000''. In all other cases <extend> is required and must be UXTW when "option" is ''010''.

               For the 64-bit variant: is the extension to be applied to the second source operand, encoded in the
               "option" field. It can have the following values:

               UXTB         when option = 000

               UXTH         when option = 001

               UXTW         when option = 010

               LSL|UXTX     when option = 011

               SXTB         when option = 100

               SXTH         when option = 101

               SXTW         when option = 110

               SXTX         when option = 111

               If "Rn" is ''11111'' (SP) and "option" is ''011'' then LSL is preferred, but may be omitted when "imm3"
               is ''000''. In all other cases <extend> is required and must be UXTX when "option" is ''011''.

<amount>       Is the left shift amount to be applied after extension in the range 0 to 4, defaulting to 0, encoded in
               the "imm3" field. It must be absent when <extend> is absent, is required when <extend> is LSL,
               and is optional when <extend> is present but not LSL.


Operation

The description of ADDS (extended register) gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','CMP','Compare (extended register), setting the condition flags and discarding the result: Rn - LSL(extend(Rm), amount)       (C6.6.44)

This instruction is an alias of the SUBS (extended register) instruction. This means that:

.      The encodings in this description are named to match the encodings of SUBS (extended register).

.      The description of SUBS (extended register) gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15     13 12      10 9            5 4             0
   sf 1 1 0 1 0 1 1 0 0 1                   Rm          option    imm3           Rn        1 1 1 1 1
     op S                                                                                        Rd


32-bit variant

Applies when sf = 0.

CMP <Wn|WSP>, <Wm>{, <extend> {#<amount>}}

is equivalent to

SUBS WZR, <Wn|WSP>, <Wm>{, <extend> {#<amount>}}

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

CMP <Xn|SP>, <R><m>{, <extend> {#<amount>}}

is equivalent to

SUBS XZR, <Xn|SP>, <R><m>{, <extend> {#<amount>}}

and is always the preferred disassembly.


Assembler symbols

<Wn|WSP>        Is the 32-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                field.

<Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xn|SP>         Is the 64-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                field.

<R>             Is a width specifier, encoded in the "option" field. It can have the following values:

                W            when option = 00x

                W            when option = 010

                X            when option = x11

                W            when option = 10x

                W            when option = 110

<m>             Is the number [0-30] of the second general-purpose source register or the name ZR (31), encoded in
                the "Rm" field.
       <extend>        For the 32-bit variant: is the extension to be applied to the second source operand, encoded in the
                       "option" field. It can have the following values:

                       UXTB         when option = 000

                       UXTH         when option = 001

                       LSL|UXTW     when option = 010

                       UXTX         when option = 011

                       SXTB         when option = 100

                       SXTH         when option = 101

                       SXTW         when option = 110

                       SXTX         when option = 111

                       If "Rn" is ''11111'' (WSP) and "option" is ''010'' then LSL is preferred, but may be omitted when
                       "imm3" is ''000''. In all other cases <extend> is required and must be UXTW when "option" is ''010''.

                       For the 64-bit variant: is the extension to be applied to the second source operand, encoded in the
                       "option" field. It can have the following values:

                       UXTB         when option = 000

                       UXTH         when option = 001

                       UXTW         when option = 010

                       LSL|UXTX     when option = 011

                       SXTB         when option = 100

                       SXTH         when option = 101

                       SXTW         when option = 110

                       SXTX         when option = 111

                       If "Rn" is ''11111'' (SP) and "option" is ''011'' then LSL is preferred, but may be omitted when "imm3"
                       is ''000''. In all other cases <extend> is required and must be UXTX when "option" is ''011''.

       <amount>        Is the left shift amount to be applied after extension in the range 0 to 4, defaulting to 0, encoded in
                       the "imm3" field. It must be absent when <extend> is absent, is required when <extend> is LSL,
                       and is optional when <extend> is present but not LSL.


       Operation

       The description of SUBS (extended register) gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','CNEG','Conditional negate: Rd = if cond then -Rn else Rn       (C6.6.47)

This instruction is an alias of the CSNEG instruction. This means that:

.       The encodings in this description are named to match the encodings of CSNEG.

.       The description of CSNEG gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20           16 15       12 11 10 9             5 4              0
    sf 1 0 1 1 0 1 0 1 0 0                  Rm          !=111x    0 1          Rn              Rd
       op                                                cond       o2


32-bit variant

Applies when sf = 0.

CNEG <Wd>, <Wn>, <cond>

is equivalent to

CSNEG <Wd>, <Wn>, <Wn>, invert(<cond>)

and is the preferred disassembly when Rn == Rm.

64-bit variant

Applies when sf = 1.

CNEG <Xd>, <Xn>, <cond>

is equivalent to

CSNEG <Xd>, <Xn>, <Xn>, invert(<cond>)

and is the preferred disassembly when Rn == Rm.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<cond>          Is one of the standard conditions, excluding AL and NV, encoded in the "cond" field with its least
                significant bit inverted.


Operation

The description of CSNEG gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','CRC32B','CRC-32 checksum from byte, halfword, word or doubleword: Wd = CRC32(Wn, Rm<n:0>) // n = 7, 15, 31, 63       (C6.6.48)




  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9             5 4              0
  sf 0 0 1 1 0 1 0 1 1 0                 Rm        0 1 0 0       sz          Rn              Rd
                                                             C


CRC32B variant

Applies when sf = 0 && sz = 00.

CRC32B <Wd>, <Wn>, <Wm>


CRC32H variant

Applies when sf = 0 && sz = 01.

CRC32H <Wd>, <Wn>, <Wm>


CRC32W variant

Applies when sf = 0 && sz = 10.

CRC32W <Wd>, <Wn>, <Wm>


CRC32X variant

Applies when sf = 1 && sz = 11.

CRC32X <Wd>, <Wn>, <Xm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sf == ''1'' && sz != ''11'' then UnallocatedEncoding();
 if sf == ''0'' && sz == ''11'' then UnallocatedEncoding();
 integer size = 8 << UInt(sz);   // 2-bit size field -> 8, 16, 32, 64
 boolean crc32c = (C == ''1'');


Assembler symbols

<Wd>          Is the 32-bit name of the general-purpose accumulator output register, encoded in the "Rd" field.

<Wn>          Is the 32-bit name of the general-purpose accumulator input register, encoded in the "Rn" field.

<Xm>          Is the 64-bit name of the general-purpose data source register, encoded in the "Rm" field.

<Wm>          Is the 32-bit name of the general-purpose data source register, encoded in the "Rm" field.


Operation

 if !HaveCRCExt() then
     UnallocatedEncoding();

 bits(32)      acc     = X[n];   // accumulator
 bits(size)    val     = X[m];   // input value
 bits(32)      poly    = (if crc32c then 0x1EDC6F41 else 0x04C11DB7)<31:0>;
         bits(32+size) tempacc = BitReverse(acc) : Zeros(size);
         bits(size+32) tempval = BitReverse(val) : Zeros(32);

         // Poly32Mod2 on a bitstring does a polynomial Modulus over {0,1} operation
         X[d] = BitReverse(Poly32Mod2(tempacc EOR tempval, poly));');
INSERT INTO "instructions" VALUES('ARM','CRC32H','-R:CRC32B');
INSERT INTO "instructions" VALUES('ARM','CRC32W','-R:CRC32B');
INSERT INTO "instructions" VALUES('ARM','CRC32X','-R:CRC32B');
INSERT INTO "instructions" VALUES('ARM','CRC32CB','CRC-32C checksum from byte, halfword, word, or doubleword: Wd = CRC32C(Wn, Rm<n:0>) // n = 7, 15, 31, 63       (C6.6.49)




  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9             5 4              0
  sf 0 0 1 1 0 1 0 1 1 0                 Rm        0 1 0 1       sz          Rn              Rd
                                                             C


CRC32CB variant

Applies when sf = 0 && sz = 00.

CRC32CB <Wd>, <Wn>, <Wm>


CRC32CH variant

Applies when sf = 0 && sz = 01.

CRC32CH <Wd>, <Wn>, <Wm>


CRC32CW variant

Applies when sf = 0 && sz = 10.

CRC32CW <Wd>, <Wn>, <Wm>


CRC32CX variant

Applies when sf = 1 && sz = 11.

CRC32CX <Wd>, <Wn>, <Xm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sf == ''1'' && sz != ''11'' then UnallocatedEncoding();
 if sf == ''0'' && sz == ''11'' then UnallocatedEncoding();
 integer size = 8 << UInt(sz);   // 2-bit size field -> 8, 16, 32, 64
 boolean crc32c = (C == ''1'');


Assembler symbols

<Wd>          Is the 32-bit name of the general-purpose accumulator output register, encoded in the "Rd" field.

<Wn>          Is the 32-bit name of the general-purpose accumulator input register, encoded in the "Rn" field.

<Xm>          Is the 64-bit name of the general-purpose data source register, encoded in the "Rm" field.

<Wm>          Is the 32-bit name of the general-purpose data source register, encoded in the "Rm" field.


Operation

 if !HaveCRCExt() then
     UnallocatedEncoding();

 bits(32)      acc     = X[n];   // accumulator
 bits(size)    val     = X[m];   // input value
 bits(32)      poly    = (if crc32c then 0x1EDC6F41 else 0x04C11DB7)<31:0>;
         bits(32+size) tempacc = BitReverse(acc) : Zeros(size);
         bits(size+32) tempval = BitReverse(val) : Zeros(32);

         // Poly32Mod2 on a bitstring does a polynomial Modulus over {0,1} operation
         X[d] = BitReverse(Poly32Mod2(tempacc EOR tempval, poly));');
INSERT INTO "instructions" VALUES('ARM','CRC32CH','-R:CRC32CB');
INSERT INTO "instructions" VALUES('ARM','CRC32CW','-R:CRC32CB');
INSERT INTO "instructions" VALUES('ARM','CRC32CX','-R:CRC32CB');
INSERT INTO "instructions" VALUES('ARM','CSEL','Conditional select, returning the first or second input: Rd = if cond then Rn else Rm       (C6.6.50)




  31 30 29 28 27 26 25 24 23 22 21 20              16 15        12 11 10 9            5 4              0
  sf 0 0 1 1 0 1 0 1 0 0                     Rm           cond     0 0         Rn              Rd
     op                                                               o2


32-bit variant

Applies when sf = 0.

CSEL <Wd>, <Wn>, <Wm>, <cond>


64-bit variant

Applies when sf = 1.

CSEL <Xd>, <Xn>, <Xm>, <cond>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 bits(4) condition = cond;
 boolean else_inv = (op == ''1'');
 boolean else_inc = (o2 == ''1'');


Assembler symbols

<Wd>           Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>           Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>           Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>           Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>           Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>           Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

<cond>         Is one of the standard conditions, encoded in the "cond" field in the standard way.


Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];

 if ConditionHolds(condition) then
     result = operand1;
 else
     result = operand2;
     if else_inv then result = NOT(result);
     if else_inc then result = result + 1;

 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CSET','Conditional set: Rd = if cond then 1 else 0       (C6.6.51)

This instruction is an alias of the CSINC instruction. This means that:

.       The encodings in this description are named to match the encodings of CSINC.

.       The description of CSINC gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20            16 15      12 11 10 9             5 4              0
    sf 0 0 1 1 0 1 0 1 0 0 1 1 1 1 1                    !=111x    0 1 1 1 1 1 1                Rd
       op                                   Rm           cond        o2        Rn


32-bit variant

Applies when sf = 0.

CSET <Wd>, <cond>

is equivalent to

CSINC <Wd>, WZR, WZR, invert(<cond>)

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

CSET <Xd>, <cond>

is equivalent to

CSINC <Xd>, XZR, XZR, invert(<cond>)

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<cond>          Is one of the standard conditions, excluding AL and NV, encoded in the "cond" field with its least
                significant bit inverted.


Operation

The description of CSINC gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','CSETM','Conditional set mask: Rd = if cond then -1 else 0       (C6.6.52)

This instruction is an alias of the CSINV instruction. This means that:

.      The encodings in this description are named to match the encodings of CSINV.

.      The description of CSINV gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20             16 15       12 11 10 9              5 4              0
   sf 1 0 1 1 0 1 0 1 0 0 1 1 1 1 1                     !=111x    0 0 1 1 1 1 1                Rd
     op                                    Rm            cond       o2         Rn


32-bit variant

Applies when sf = 0.

CSETM <Wd>, <cond>

is equivalent to

CSINV <Wd>, WZR, WZR, invert(<cond>)

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

CSETM <Xd>, <cond>

is equivalent to

CSINV <Xd>, XZR, XZR, invert(<cond>)

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<cond>          Is one of the standard conditions, excluding AL and NV, encoded in the "cond" field with its least
                significant bit inverted.


Operation

The description of CSINV gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','CSINC','       Conditional select increment, returning the first input or incremented second input: Rd = if cond then Rn else (Rm       (C6.6.53)
       + 1)

       This instruction is used by the aliases CINC and CSET. See the Alias conditions table for details of when each alias
       is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20            16 15        12 11 10 9             5 4             0
           sf 0 0 1 1 0 1 0 1 0 0                  Rm             cond    0 1          Rn              Rd
              op                                                             o2


       32-bit variant

       Applies when sf = 0.

       CSINC <Wd>, <Wn>, <Wm>, <cond>


       64-bit variant

       Applies when sf = 1.

       CSINC <Xd>, <Xn>, <Xm>, <cond>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer datasize = if sf == ''1'' then 64 else 32;
         bits(4) condition = cond;
         boolean else_inv = (op == ''1'');
         boolean else_inc = (o2 == ''1'');


       Alias conditions


                            Alias                     is preferred when

                            CINC                      Rm != ''11111'' && cond != ''111x'' && Rn != ''11111'' && Rn == Rm

                            CSET                      Rm == ''11111'' && cond != ''111x'' && Rn == ''11111''



       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

       <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

       <Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <cond>          Is one of the standard conditions, encoded in the "cond" field in the standard way.
Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];

 if ConditionHolds(condition) then
    result = operand1;
 else
    result = operand2;
    if else_inv then result = NOT(result);
    if else_inc then result = result + 1;

 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CSINV','       Conditional select inversion, returning the first input or inverted second input: Rd = if cond then Rn else NOT (Rm)       (C6.6.54)

       This instruction is used by the aliases CINV and CSETM. See the Alias conditions table for details of when each
       alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20             16 15        12 11 10 9             5 4             0
           sf 1 0 1 1 0 1 0 1 0 0                   Rm            cond      0 0         Rn              Rd
              op                                                              o2


       32-bit variant

       Applies when sf = 0.

       CSINV <Wd>, <Wn>, <Wm>, <cond>


       64-bit variant

       Applies when sf = 1.

       CSINV <Xd>, <Xn>, <Xm>, <cond>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer datasize = if sf == ''1'' then 64 else 32;
         bits(4) condition = cond;
         boolean else_inv = (op == ''1'');
         boolean else_inc = (o2 == ''1'');


       Alias conditions


                             Alias                     is preferred when

                             CINV                      Rm != ''11111'' && cond != ''111x'' && Rn != ''11111'' && Rn == Rm

                             CSETM                     Rm == ''11111'' && cond != ''111x'' && Rn == ''11111''



       Assembler symbols

       <Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>             Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

       <Wm>             Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>             Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

       <Xm>             Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <cond>           Is one of the standard conditions, encoded in the "cond" field in the standard way.
Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];

 if ConditionHolds(condition) then
    result = operand1;
 else
    result = operand2;
    if else_inv then result = NOT(result);
    if else_inc then result = result + 1;

 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CSNEG','      Conditional select negation, returning the first input or negated second input: Rd = if cond then Rn else -Rm       (C6.6.55)

      This instruction is used by the alias CNEG. See the Alias conditions table for details of when each alias is preferred.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15        12 11 10 9              5 4            0
          sf 1 0 1 1 0 1 0 1 0 0                  Rm            cond      0 1         Rn              Rd
             op                                                             o2


      32-bit variant

      Applies when sf = 0.

      CSNEG <Wd>, <Wn>, <Wm>, <cond>


      64-bit variant

      Applies when sf = 1.

      CSNEG <Xd>, <Xn>, <Xm>, <cond>


      Decode for all variants of this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        integer datasize = if sf == ''1'' then 64 else 32;
        bits(4) condition = cond;
        boolean else_inv = (op == ''1'');
        boolean else_inc = (o2 == ''1'');


      Alias conditions


                           Alias                     is preferred when

                           CNEG                      cond != ''111x'' && Rn == Rm



      Assembler symbols

      <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

      <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

      <cond>          Is one of the standard conditions, encoded in the "cond" field in the standard way.


      Operation

        bits(datasize) result;
        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = X[m];

if ConditionHolds(condition) then
   result = operand1;
else
   result = operand2;
   if else_inv then result = NOT(result);
   if else_inc then result = result + 1;

X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','DC','Data cache operation       (C6.6.56)

This instruction is an alias of the SYS instruction. This means that:

.       The encodings in this description are named to match the encodings of SYS.

.       The description of SYS gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20 19 18      16 15        12 11       8 7      5 4             0
    1 1 0 1 0 1 0 1 0 0 0 0 1                  op1     0 1 1 1        CRm        op2           Rt
                                    L                     CRn


System variant

DC <dc_op>, <Xt>

is equivalent to

SYS #<op1>, C7, <Cm>, #<op2>, <Xt>

and is the preferred disassembly when SysOp(op1,''0111'',CRm,op2) == Sys_DC.


Assembler symbols

<dc_op>         Is a DC operation name, as listed for the DC system operation group, encoded in the
                "op1:CRm:op2" field. It can have the following values:

                IVAC         when op1 = 000, CRm = 0110, op2 = 001

                ISW          when op1 = 000, CRm = 0110, op2 = 010

                CSW          when op1 = 000, CRm = 1010, op2 = 010

                CISW         when op1 = 000, CRm = 1110, op2 = 010

                ZVA          when op1 = 011, CRm = 0100, op2 = 001

                CVAC         when op1 = 011, CRm = 1010, op2 = 001

                CVAU         when op1 = 011, CRm = 1011, op2 = 001

                CIVAC        when op1 = 011, CRm = 1110, op2 = 001

<op1>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op1" field.

<Cm>            Is a name ''Cm'', with ''m'' in the range 0 to 15, encoded in the "CRm" field.

<op2>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op2" field.

<Xt>            Is the 64-bit name of the general-purpose source register, encoded in the "Rt" field.


Operation

The description of SYS gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','DCPS1','Debug Change PE State to EL1 allows the debugger to move the PE into EL1 from a lower Exception Level or to       (C6.6.57)
a specific mode at the current Exception Level.

If the PE is at EL1 or lower, then the PE enters EL1h.

If the PE is at an Exception Level higher than EL1, then the PE does not change Exception Level but selects use of
the stack pointer for the current Exception Level by updating PSTATE.SP.

This instruction is always UNDEFINED in Non-debug state.

For more information on the operation of this instructions, see DCPS on page H2-4963.




  31 30 29 28 27 26 25 24 23 22 21 20                                                 5 4 3 2 1 0
   1 1 0 1 0 1 0 0 1 0 1                                   imm16                        0 0 0 0 1
                                                                                                    LL


System variant

DCPS1 {#<imm>}


Decode for this encoding

 bits(2) target_level = LL;
 if LL == ''00'' then UnallocatedEncoding();
 if !Halted() then AArch64.UndefinedFault();


Assembler symbols

<imm>            Is an optional 16-bit unsigned immediate, in the range 0 to 65535, defaulting to 0 and encoded in
                 the "imm16" field.


Operation

 DCPSInstruction(target_level);');
INSERT INTO "instructions" VALUES('ARM','DCPS2','Debug Change PE State to EL2 allows the debugger to move the PE into EL2 from a lower Exception Level or to       (C6.6.58)
a specific mode at the current Exception Level.

If the PE is at EL2 or lower, then the PE enters EL2h.

If the PE is at an Exception Level higher than EL2, then the PE does not change Exception Level but selects use of
the stack pointer for the current Exception Level by updating PSTATE.SP.

This instruction is always UNDEFINED in Non-debug state.

For more information on the operation of this instructions, see DCPS on page H2-4963.




    31 30 29 28 27 26 25 24 23 22 21 20                                               5 4 3 2 1 0
    1 1 0 1 0 1 0 0 1 0 1                                  imm16                        0 0 0 1 0
                                                                                                    LL


System variant

DCPS2 {#<imm>}


Decode for this encoding

  bits(2) target_level = LL;
  if LL == ''00'' then UnallocatedEncoding();
  if !Halted() then AArch64.UndefinedFault();


Assembler symbols

<imm>            Is an optional 16-bit unsigned immediate, in the range 0 to 65535, defaulting to 0 and encoded in
                 the "imm16" field.


Operation

  DCPSInstruction(target_level);');
INSERT INTO "instructions" VALUES('ARM','DCPS3','Debug Change PE State to EL3 allows the debugger to move the PE into EL3 from a lower Exception Level or to       (C6.6.59)
a specific mode at the current Exception Level. The PE enters EL3h.

This instruction is always UNDEFINED in Non-debug state.

For more information on the operation of this instructions, see DCPS on page H2-4963.




  31 30 29 28 27 26 25 24 23 22 21 20                                                5 4 3 2 1 0
   1 1 0 1 0 1 0 0 1 0 1                                   imm16                       0 0 0 1 1
                                                                                                   LL


System variant

DCPS3 {#<imm>}


Decode for this encoding

 bits(2) target_level = LL;
 if LL == ''00'' then UnallocatedEncoding();
 if !Halted() then AArch64.UndefinedFault();


Assembler symbols

<imm>           Is an optional 16-bit unsigned immediate, in the range 0 to 65535, defaulting to 0 and encoded in
                the "imm16" field.


Operation

 DCPSInstruction(target_level);');
INSERT INTO "instructions" VALUES('ARM','DMB','       Data memory barrier       (C6.6.60)




           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11            8 7 6 5 4 3 2 1 0
           1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1                            CRm       1 0 1 1 1 1 1 1
                                                                                            opc


       System variant

       DMB <option>|#<imm>


       Decode for this encoding

         MemBarrierOp op;
         MBReqDomain domain;
         MBReqTypes types;

         case opc of
              when ''00'' op = MemBarrierOp_DSB;
              when ''01'' op = MemBarrierOp_DMB;
              when ''10'' op = MemBarrierOp_ISB;
              otherwise UnallocatedEncoding();

         case CRm<3:2> of
              when ''00'' domain = MBReqDomain_OuterShareable;
              when ''01'' domain = MBReqDomain_Nonshareable;
              when ''10'' domain = MBReqDomain_InnerShareable;
              when ''11'' domain = MBReqDomain_FullSystem;

         case CRm<1:0> of
              when ''01'' types = MBReqTypes_Reads;
              when ''10'' types = MBReqTypes_Writes;
              when ''11'' types = MBReqTypes_All;
              otherwise
                   types = MBReqTypes_All;
                   domain = MBReqDomain_FullSystem;


       Assembler symbols

       <option>         Specifies the limitation on the barrier operation. Values are:

                        SY          Full system is the required shareability domain, reads and writes are the required access
                                    types in both Group A on page B2-85 and Group B on page B2-86. This option is
                                    referred to as the full system DMB. Encoded as CRm = 0b1111.

                        ST          Full system is the required shareability domain, writes are the required access type in
                                    both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b1110.

                        LD          Full system is the required shareability domain, reads are the required access type in
                                    Group A on page B2-85, and reads and writes are the required access types in both
                                    Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b1101.

                        ISH         Inner Shareable is the required shareability domain, reads and writes are the required
                                    access types in Group B on page B2-86. Encoded as CRm = 0b1011.

                        ISHST       Inner Shareable is the required shareability domain, writes are the required access type
                                    in both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b1010.

                        ISHLD       Inner Shareable is the required shareability domain, reads are the required access type
                                    in Group A on page B2-85. Encoded as CRm = 0b1001.

                        NSH         Non-shareable is the required shareability domain, reads and writes are the required
                                    access types in Group B on page B2-86. Encoded as CRm = 0b0111.
              NSHST       Non-shareable is the required shareability domain, writes are the required access type
                          in both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b0110.

              NSHLD       Non-shareable is the required shareability domain, reads are the required access type in
                          Group A on page B2-85. Encoded as CRm = 0b0101.

              OSH         Outer Shareable is the required shareability domain, reads and writes are the required
                          access types in Group B on page B2-86. Encoded as CRm = 0b0011.

              OSHST       Outer Shareable is the required shareability domain, writes are the required access type
                          in both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b0010.

              OSHLD       Outer Shareable is the required shareability domain, reads are the required access type
                          in Group A on page B2-85. Encoded as CRm = 0b0001.

               All other encodings of CRm that are not listed above are reserved, and can be encoded using the
              #<imm> syntax. It is IMPLEMENTATION DEFINED whether options other than SY are implemented. All
              unsupported and reserved options must execute as a full system operation, but software must not
              rely on this behavior.

<imm>         Is a 4-bit unsigned immediate, in the range 0 to 15, encoded in the "CRm" field.


Operation

 case op of
    when MemBarrierOp_DSB
         DataSynchronizationBarrier(domain, types);
    when MemBarrierOp_DMB
         DataMemoryBarrier(domain, types);
    when MemBarrierOp_ISB
         InstructionSynchronizationBarrier();');
INSERT INTO "instructions" VALUES('ARM','DRPS','Debug restore process state       (C6.6.61)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0
    1 1 0 1 0 1 1 0 1 0 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0




System variant

DRPS


Decode for this encoding

  if !Halted() || PSTATE.EL == EL0 then UnallocatedEncoding();


Operation

  DRPSInstruction();');
INSERT INTO "instructions" VALUES('ARM','DSB','Data synchronization barrier       (C6.6.62)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11           8 7 6 5 4 3 2 1 0
  1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1                           CRm       1 0 0 1 1 1 1 1
                                                                                  opc


System variant

DSB <option>|#<imm>


Decode for this encoding

 MemBarrierOp op;
 MBReqDomain domain;
 MBReqTypes types;

 case opc of
     when ''00'' op = MemBarrierOp_DSB;
     when ''01'' op = MemBarrierOp_DMB;
     when ''10'' op = MemBarrierOp_ISB;
     otherwise UnallocatedEncoding();

 case CRm<3:2> of
     when ''00'' domain = MBReqDomain_OuterShareable;
     when ''01'' domain = MBReqDomain_Nonshareable;
     when ''10'' domain = MBReqDomain_InnerShareable;
     when ''11'' domain = MBReqDomain_FullSystem;

 case CRm<1:0> of
     when ''01'' types = MBReqTypes_Reads;
     when ''10'' types = MBReqTypes_Writes;
     when ''11'' types = MBReqTypes_All;
     otherwise
        types = MBReqTypes_All;
        domain = MBReqDomain_FullSystem;


Assembler symbols

<option>      Specifies the limitation on the barrier operation. Values are:

              SY          Full system is the required shareability domain, reads and writes are the required access
                          types in both Group A on page B2-85 and Group B on page B2-86. This option is
                          referred to as the full system DMB. Encoded as CRm = 0b1111.

              ST          Full system is the required shareability domain, writes are the required access type in
                          both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b1110.

              LD          Full system is the required shareability domain, reads are the required access type in
                          Group A on page B2-85, and reads and writes are the required access types in both
                          Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b1101.

              ISH         Inner Shareable is the required shareability domain, reads and writes are the required
                          access types in Group B on page B2-86. Encoded as CRm = 0b1011.

              ISHST       Inner Shareable is the required shareability domain, writes are the required access type
                          in both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b1010.

              ISHLD       Inner Shareable is the required shareability domain, reads are the required access type
                          in Group A on page B2-85. Encoded as CRm = 0b1001.

              NSH         Non-shareable is the required shareability domain, reads and writes are the required
                          access types in Group B on page B2-86. Encoded as CRm = 0b0111.
                        NSHST       Non-shareable is the required shareability domain, writes are the required access type
                                    in both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b0110.

                        NSHLD       Non-shareable is the required shareability domain, reads are the required access type in
                                    Group A on page B2-85. Encoded as CRm = 0b0101.

                        OSH         Outer Shareable is the required shareability domain, reads and writes are the required
                                    access types in Group B on page B2-86. Encoded as CRm = 0b0011.

                        OSHST       Outer Shareable is the required shareability domain, writes are the required access type
                                    in both Group A on page B2-85 and Group B on page B2-86. Encoded as CRm = 0b0010.

                        OSHLD       Outer Shareable is the required shareability domain, reads are the required access type
                                    in Group A on page B2-85. Encoded as CRm = 0b0001.

                         All other encodings of CRm that are not listed above are reserved, and can be encoded using the
                        #<imm> syntax. It is IMPLEMENTATION DEFINED whether options other than SY are implemented. All
                        unsupported and reserved options must execute as a full system operation, but software must not
                        rely on this behavior.

       <imm>            Is a 4-bit unsigned immediate, in the range 0 to 15, encoded in the "CRm" field.


       Operation

         case op of
              when MemBarrierOp_DSB
                   DataSynchronizationBarrier(domain, types);
              when MemBarrierOp_DMB
                   DataMemoryBarrier(domain, types);
              when MemBarrierOp_ISB
                   InstructionSynchronizationBarrier();');
INSERT INTO "instructions" VALUES('ARM','EON','Bitwise exclusive OR NOT (shifted register): Rd = Rn EOR NOT shift(Rm, amount)       (C6.6.63)




  31 30 29 28 27 26 25 24 23 22 21 20              16 15               10 9             5 4             0
  sf 1 0 0 1 0 1 0 shift 1                  Rm               imm6                Rn            Rd
     opc                           N


32-bit variant

Applies when sf = 0.

EON <Wd>, <Wn>, <Wm>{, <shift> #<amount>}


64-bit variant

Applies when sf = 1.

EON <Xd>, <Xn>, <Xm>{, <shift> #<amount>}


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean setflags;
 LogicalOp op;
 case opc of
     when ''00'' op = LogicalOp_AND; setflags = FALSE;
     when ''01'' op = LogicalOp_ORR; setflags = FALSE;
     when ''10'' op = LogicalOp_EOR; setflags = FALSE;
     when ''11'' op = LogicalOp_AND; setflags = TRUE;

 if sf == ''0'' && imm6<5> == ''1'' then ReservedValue();

 ShiftType shift_type = DecodeShift(shift);
 integer shift_amount = UInt(imm6);
 boolean invert = (N == ''1'');


Assembler symbols

<Wd>           Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>           Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>           Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>           Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>           Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>           Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

<shift>        Is the optional shift to be applied to the final source, defaulting to LSL and encoded in the "shift"
               field. It can have the following values:

               LSL          when shift = 00

               LSR          when shift = 01

               ASR          when shift = 10

               ROR          when shift = 11
       <amount>        For the 32-bit variant: is the shift amount, in the range 0 to 31, defaulting to 0 and encoded in the
                       "imm6" field.

                       For the 64-bit variant: is the shift amount, in the range 0 to 63, defaulting to 0 and encoded in the
                       "imm6" field.


       Operation

         bits(datasize) operand1 = X[n];
         bits(datasize) operand2 = ShiftReg(m, shift_type, shift_amount);

         if invert then operand2 = NOT(operand2);

         case op of
              when LogicalOp_AND result = operand1 AND operand2;
              when LogicalOp_ORR result = operand1 OR       operand2;
              when LogicalOp_EOR result = operand1 EOR operand2;

         if setflags then
              PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

         X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','EOR','Bitwise exclusive OR (immediate): Rd = Rn EOR imm       (C6.6.64)




  31 30 29 28 27 26 25 24 23 22 21                16 15             10 9             5 4              0
  sf 1 0 1 0 0 1 0 0 N                  immr               imms               Rn               Rd
     opc


32-bit variant

Applies when sf = 0 && N = 0.

EOR <Wd|WSP>, <Wn>, #<imm>


64-bit variant

Applies when sf = 1.

EOR <Xd|SP>, <Xn>, #<imm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean setflags;
 LogicalOp op;
 case opc of
     when ''00'' op = LogicalOp_AND; setflags = FALSE;
     when ''01'' op = LogicalOp_ORR; setflags = FALSE;
     when ''10'' op = LogicalOp_EOR; setflags = FALSE;
     when ''11'' op = LogicalOp_AND; setflags = TRUE;

 bits(datasize) imm;
 if sf == ''0'' && N != ''0'' then ReservedValue();
 (imm, -) = DecodeBitMasks(N, imms, immr, TRUE);


Assembler symbols

<Wd|WSP>       Is the 32-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
               field.

<Wn>           Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd|SP>        Is the 64-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
               field.

<Xn>           Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<imm>          Is the bitmask immediate, encoded in "N:imms:immr".


Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = imm;

 case op of
     when LogicalOp_AND result = operand1 AND operand2;
     when LogicalOp_ORR result = operand1 OR      operand2;
     when LogicalOp_EOR result = operand1 EOR operand2;

         if setflags then
              PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

         if d == 31 && !setflags then
              SP[] = result;
         else
              X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ERET','Exception return using current ELR and SPSR       (C6.6.66)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9 8 7 6 5 4 3 2 1 0
  1 1 0 1 0 1 1 0 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0




System variant

ERET


Decode for this encoding

 if PSTATE.EL == EL0 then UnallocatedEncoding();


Operation

 AArch64.ExceptionReturn(ELR[], SPSR[]);');
INSERT INTO "instructions" VALUES('ARM','EXTR','       Extract register from pair of registers       (C6.6.67)

       This instruction is used by the alias ROR (immediate). See the Alias conditions table for details of when each alias
       is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20              16 15                10 9            5 4               0
           sf 0 0 1 0 0 1 1 1 N 0                   Rm                imms                Rn              Rd




       32-bit variant

       Applies when sf = 0 && N = 0 && imms = 0xxxxx.

       EXTR <Wd>, <Wn>, <Wm>, #<lsb>


       64-bit variant

       Applies when sf = 1 && N = 1.

       EXTR <Xd>, <Xn>, <Xm>, #<lsb>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer datasize = if sf == ''1'' then 64 else 32;
         integer lsb;

         if N != sf then UnallocatedEncoding();
         if sf == ''0'' && imms<5> == ''1'' then ReservedValue();
         lsb = UInt(imms);


       Alias conditions


                            Alias                      is preferred when

                            ROR (immediate)            Rn == Rm



       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

       <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

       <Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <lsb>           For the 32-bit variant: is the least significant bit position from which to extract, in the range 0 to 31,
                       encoded in the "imms" field.

                       For the 64-bit variant: is the least significant bit position from which to extract, in the range 0 to 63,
                       encoded in the "imms" field.
Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];
 bits(2*datasize) concat = operand1:operand2;

 result = concat<lsb+datasize-1:lsb>;

 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','HINT','    Hint instruction       (C6.6.68)

    This instruction is used by the aliases NOP, SEVL, SEV, WFE, WFI, and YIELD. See the Alias conditions table
    for details of when each alias is preferred.




        31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11          8 7      5 4 3 2 1 0
        1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0                            CRm        op2  1 1 1 1 1




    System variant

    HINT #<imm>


    Decode for this encoding

      SystemHintOp op;

      case CRm:op2 of
           when ''0000 000'' op = SystemHintOp_NOP;
           when ''0000 001'' op = SystemHintOp_YIELD;
           when ''0000 010'' op = SystemHintOp_WFE;
           when ''0000 011'' op = SystemHintOp_WFI;
           when ''0000 100'' op = SystemHintOp_SEV;
           when ''0000 101'' op = SystemHintOp_SEVL;
           otherwise   op = SystemHintOp_NOP;


    Alias conditions


                          Alias                  is preferred when

                          NOP                    CRm == ''0000'' && op2 == ''000''

                          SEVL                   CRm == ''0000'' && op2 == ''101''

                          SEV                    CRm == ''0000'' && op2 == ''100''

                          WFE                    CRm == ''0000'' && op2 == ''010''

                          WFI                    CRm == ''0000'' && op2 == ''011''

                          YIELD                  CRm == ''0000'' && op2 == ''001''



    Assembler symbols

    <imm>            Is a 7-bit unsigned immediate, in the range 0 to 127, encoded in "CRm:op2".


    Operation

      case op of
           when SystemHintOp_YIELD
                Hint_Yield();

           when SystemHintOp_WFE
                if EventRegistered() then
                    ClearEventRegister();
                else
                   if PSTATE.EL == EL0 then
            AArch64.CheckForWFxTrap(EL1, TRUE);
       if HaveEL(EL2) && !IsSecure() && PSTATE.EL IN {EL0,EL1} then
            AArch64.CheckForWFxTrap(EL2, TRUE);
       if HaveEL(EL3) && PSTATE.EL != EL3 then
            AArch64.CheckForWFxTrap(EL3, TRUE);
        WaitForEvent();

when SystemHintOp_WFI
   if !InterruptPending() then
       if PSTATE.EL == EL0 then
            AArch64.CheckForWFxTrap(EL1, FALSE);
       if HaveEL(EL2) && !IsSecure() && PSTATE.EL IN {EL0,EL1} then
            AArch64.CheckForWFxTrap(EL2, FALSE);
       if HaveEL(EL3) && PSTATE.EL != EL3 then
            AArch64.CheckForWFxTrap(EL3, FALSE);
        WaitForInterrupt();

when SystemHintOp_SEV
    SendEvent();

when SystemHintOp_SEVL
    EventRegisterSet();

otherwise // do nothing');
INSERT INTO "instructions" VALUES('ARM','HLT','External debug breakpoint       (C6.6.69)




    31 30 29 28 27 26 25 24 23 22 21 20                                              5 4 3 2 1 0
    1 1 0 1 0 1 0 0 0 1 0                                 imm16                         0 0 0 0 0




System variant

HLT #<imm>


Decode for this encoding

  if EDSCR.HDE == ''0'' || !HaltingAllowed() then UndefinedFault();


Assembler symbols

<imm>           Is a 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.


Operation

  Halt(DebugHalt_HaltInstruction);');
INSERT INTO "instructions" VALUES('ARM','HVC','Generate exception targeting exception level 2       (C6.6.70)




  31 30 29 28 27 26 25 24 23 22 21 20                                              5 4 3 2 1 0
  1 1 0 1 0 1 0 0 0 0 0                                 imm16                         0 0 0 1 0




System variant

HVC #<imm>


Decode for this encoding

 bits(16) imm = imm16;


Assembler symbols

<imm>         Is a 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.


Operation

 if !HaveEL(EL2) || PSTATE.EL == EL0 || (PSTATE.EL == EL1 && IsSecure()) then
     UnallocatedEncoding();

 hvc_enable = if HaveEL(EL3) then SCR_EL3.HCE else NOT(HCR_EL2.HCD);
 if hvc_enable == ''0'' then
     AArch64.UndefinedFault();
 else
     AArch64.CallHypervisor(imm);');
INSERT INTO "instructions" VALUES('ARM','IC','Instruction cache operation       (C6.6.71)

This instruction is an alias of the SYS instruction. This means that:

.       The encodings in this description are named to match the encodings of SYS.

.       The description of SYS gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20 19 18      16 15         12 11       8 7       5 4             0
    1 1 0 1 0 1 0 1 0 0 0 0 1                  op1      0 1 1 1        CRm        op2           Rt
                                    L                      CRn


System variant

IC <ic_op>{, <Xt>}

is equivalent to

SYS #<op1>, C7, <Cm>, #<op2>{, <Xt>}

and is the preferred disassembly when SysOp(op1,''0111'',CRm,op2) == Sys_IC.


Assembler symbols

<ic_op>         Is an IC operation name, as listed for the IC system operation pages, encoded in the "op1:CRm:op2"
                field. It can have the following values:

                IALLUIS      when op1 = 000, CRm = 0001, op2 = 000

                IALLU        when op1 = 000, CRm = 0101, op2 = 000

                IVAU         when op1 = 011, CRm = 0101, op2 = 001

<op1>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op1" field.

<Cm>            Is a name ''Cm'', with ''m'' in the range 0 to 15, encoded in the "CRm" field.

<op2>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op2" field.

<Xt>            Is the 64-bit name of the optional general-purpose source register, defaulting to ''11111'', encoded in
                the "Rt" field.


Operation

The description of SYS gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','ISB','Instruction synchronization barrier       (C6.6.72)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11           8 7 6 5 4 3 2 1 0
  1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 1                            CRm       1 1 0 1 1 1 1 1
                                                                                   opc


System variant

ISB {<option>|#<imm>}


Decode for this encoding

 MemBarrierOp op;
 MBReqDomain domain;
 MBReqTypes types;

 case opc of
     when ''00'' op = MemBarrierOp_DSB;
     when ''01'' op = MemBarrierOp_DMB;
     when ''10'' op = MemBarrierOp_ISB;
     otherwise UnallocatedEncoding();

 case CRm<3:2> of
     when ''00'' domain = MBReqDomain_OuterShareable;
     when ''01'' domain = MBReqDomain_Nonshareable;
     when ''10'' domain = MBReqDomain_InnerShareable;
     when ''11'' domain = MBReqDomain_FullSystem;

 case CRm<1:0> of
     when ''01'' types = MBReqTypes_Reads;
     when ''10'' types = MBReqTypes_Writes;
     when ''11'' types = MBReqTypes_All;
     otherwise
          types = MBReqTypes_All;
          domain = MBReqDomain_FullSystem;


Assembler symbols

<option>       Specifies an optional limitation on the barrier operation. Values are:

               SY          Full system barrier operation, encoded as CRm = 0b1111. Can be omitted.

                All other encodings of CRm are reserved. The corresponding instructions execute as full system
               barrier operations, but must not be relied upon by software.

<imm>          Is an optional 4-bit unsigned immediate, in the range 0 to 15, defaulting to 15 and encoded in the
               "CRm" field.


Operation

 case op of
     when MemBarrierOp_DSB
          DataSynchronizationBarrier(domain, types);
     when MemBarrierOp_DMB
          DataMemoryBarrier(domain, types);
     when MemBarrierOp_ISB
          InstructionSynchronizationBarrier();');
INSERT INTO "instructions" VALUES('ARM','LDAR','      Load-Acquire Register loads a 32-bit word or 64-bit doubleword from memory, and writes it to a register. The       (C6.6.73)
      instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For
      information about memory accesses see Load/Store addressing modes on page C1-122.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4            0
          1 x 0 0 1 0 0 0 1 1 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)             Rn              Rt
          size                     o2 L o1        Rs        o0       Rt2


      32-bit variant

      Applies when size = 10.

      LDAR <Wt>, [<Xn|SP>{,#0}]


      64-bit variant

      Applies when size = 11.

      LDAR <Xt>, [<Xn|SP>{,#0}]


      Decode for all variants of this encoding

        integer n = UInt(Rn);
        integer t = UInt(Rt);
        integer t2 = UInt(Rt2); // ignored by load/store single register
        integer s = UInt(Rs);     // ignored by all loads and store-release

        if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
        if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

        AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
        boolean excl = (o2 == ''0'');
        boolean pair = (o1 == ''1'');
        MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
        integer elsize = 8 << UInt(size);
        integer regsize = if elsize == 64 then 64 else 32;
        integer datasize = if pair then elsize * 2 else elsize;


      Assembler symbols

      <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


      Operation

        bits(64) address;
        bits(datasize) data;
        constant integer dbytes = datasize DIV 8;
        boolean rt_unknown = FALSE;
        boolean rn_unknown = FALSE;

        if memop == MemOp_LOAD && pair && t == t2 then
             Constraint c = ConstrainUnpredictable();
             assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
             case c of
                  when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
        when Constraint_UNDEF      UnallocatedEncoding();
        when Constraint_NOP        EndOfInstruction();

if memop == MemOp_STORE && excl then
   if s == t || (pair && s == t2) then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
           when Constraint_NONE       rt_unknown = FALSE;       // store original value
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();
   if s == n && n != 31 then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
           when Constraint_NONE       rn_unknown = FALSE;       // address is original base
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();

if n == 31 then
    CheckSPAlignment();
   address = SP[];
elsif rn_unknown then
   address = bits(64) UNKNOWN;
else
   address = X[n];

case memop of
   when MemOp_STORE
       if rt_unknown then
           data = bits(datasize) UNKNOWN;
       elsif pair then
           assert excl;
           bits(datasize DIV 2) el1 = X[t];
           bits(datasize DIV 2) el2 = X[t2];
           data = if BigEndian() then el1 : el2 else el2 : el1;
       else
           data = X[t];

        if excl then
           // store {release} exclusive register|pair (atomic)
           bit status = ''1'';
           // Check whether the Exclusive Monitors are set to include the
           // physical memory locations corresponding to virtual address
           // range [address, address+dbytes-1].
           if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                // This atomic write will be rejected if it does not refer
                // to the same physical locations after address translation.
                Mem[address, dbytes, acctype] = data;
                status = ExclusiveMonitorsStatus();
            X[s] = ZeroExtend(status, 32);
        else
           // store release register (atomic)
            Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
        if excl then
           // Tell the Exclusive Monitors to record a sequence of one or more atomic
           // memory reads from virtual address range [address, address+dbytes-1].
           // The Exclusive Monitor will only be set if all the reads are from the
           // same dbytes-aligned physical address, to allow for the possibility of
           // an atomicity break if the translation is changed between reads.
            AArch64.SetExclusiveMonitors(address, dbytes);

        if pair then
           // load exclusive pair
                     assert excl;
                     if rt_unknown then
                         // ConstrainedUNPREDICTABLE case
                         X[t]   = bits(datasize) UNKNOWN;
                     elsif elsize == 32 then
                         // 32-bit load exclusive pair (atomic)
                         data = Mem[address, dbytes, acctype];
                         if BigEndian() then
                              X[t]  = data<datasize-1:elsize>;
                              X[t2] = data<elsize-1:0>;
                         else
                              X[t]  = data<elsize-1:0>;
                              X[t2] = data<datasize-1:elsize>;
                     else // elsize == 64
                         // 64-bit load exclusive pair (not atomic),
                         // but must be 128-bit aligned
                         if address != Align(address, dbytes) then
                             iswrite = FALSE;
                             secondstage = FALSE;
                             AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                         X[t]   = Mem[address + 0, 8, acctype];
                         X[t2] = Mem[address + 8, 8, acctype];
                  else
                     // load {acquire} {exclusive} single register
                     data = Mem[address, dbytes, acctype];
                      X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDARB','Load-Acquire Register Byte loads a byte from memory, zero-extends it and writes it to a register. The instruction       (C6.6.74)
also has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For information
about memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14            10 9             5 4             0
   0 0 0 0 1 0 0 0 1 1 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)           Rn              Rt
   size                   o2 L o1        Rs        o0       Rt2


No offset variant

LDARB <Wt>, [<Xn|SP>{,#0}]


Decode for this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);   // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Assembler symbols

<Wt>          Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>       Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
     assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
     case c of
         when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
         when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP         EndOfInstruction();

 if memop == MemOp_STORE && excl then
     if s == t || (pair && s == t2) then
         Constraint c = ConstrainUnpredictable();
         assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
         case c of
            when Constraint_UNKNOWN       rt_unknown = TRUE;      // store UNKNOWN value
            when Constraint_NONE          rt_unknown = FALSE;     // store original value
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
                      when Constraint_NONE       rn_unknown = FALSE;       // address is original base
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
                               X[t2] = data<elsize-1:0>;
          else
               X[t]  = data<elsize-1:0>;
               X[t2] = data<datasize-1:elsize>;
      else // elsize == 64
          // 64-bit load exclusive pair (not atomic),
          // but must be 128-bit aligned
          if address != Align(address, dbytes) then
              iswrite = FALSE;
              secondstage = FALSE;
              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
          X[t]   = Mem[address + 0, 8, acctype];
          X[t2] = Mem[address + 8, 8, acctype];
   else
      // load {acquire} {exclusive} single register
      data = Mem[address, dbytes, acctype];
       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDARH','      Load-Acquire Register Halfword loads a halfword from memory, zero-extends it, and writes it to a register. The       (C6.6.75)
      instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For
      information about memory accesses see Load/Store addressing modes on page C1-122.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4            0
          0 1 0 0 1 0 0 0 1 1 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)             Rn              Rt
          size                     o2 L o1        Rs        o0       Rt2


      No offset variant

      LDARH <Wt>, [<Xn|SP>{,#0}]


      Decode for this encoding

        integer n = UInt(Rn);
        integer t = UInt(Rt);
        integer t2 = UInt(Rt2); // ignored by load/store single register
        integer s = UInt(Rs);     // ignored by all loads and store-release

        if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
        if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

        AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
        boolean excl = (o2 == ''0'');
        boolean pair = (o1 == ''1'');
        MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
        integer elsize = 8 << UInt(size);
        integer regsize = if elsize == 64 then 64 else 32;
        integer datasize = if pair then elsize * 2 else elsize;


      Assembler symbols

      <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


      Operation

        bits(64) address;
        bits(datasize) data;
        constant integer dbytes = datasize DIV 8;
        boolean rt_unknown = FALSE;
        boolean rn_unknown = FALSE;

        if memop == MemOp_LOAD && pair && t == t2 then
             Constraint c = ConstrainUnpredictable();
             assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
             case c of
                  when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
                  when Constraint_UNDEF       UnallocatedEncoding();
                  when Constraint_NOP         EndOfInstruction();

        if memop == MemOp_STORE && excl then
             if s == t || (pair && s == t2) then
                  Constraint c = ConstrainUnpredictable();
                  assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                  case c of
                     when Constraint_UNKNOWN      rt_unknown = TRUE;       // store UNKNOWN value
                     when Constraint_NONE         rt_unknown = FALSE;      // store original value
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();
   if s == n && n != 31 then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
           when Constraint_NONE       rn_unknown = FALSE;       // address is original base
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();

if n == 31 then
    CheckSPAlignment();
   address = SP[];
elsif rn_unknown then
   address = bits(64) UNKNOWN;
else
   address = X[n];

case memop of
   when MemOp_STORE
       if rt_unknown then
           data = bits(datasize) UNKNOWN;
       elsif pair then
           assert excl;
           bits(datasize DIV 2) el1 = X[t];
           bits(datasize DIV 2) el2 = X[t2];
           data = if BigEndian() then el1 : el2 else el2 : el1;
       else
           data = X[t];

       if excl then
           // store {release} exclusive register|pair (atomic)
           bit status = ''1'';
           // Check whether the Exclusive Monitors are set to include the
           // physical memory locations corresponding to virtual address
           // range [address, address+dbytes-1].
           if AArch64.ExclusiveMonitorsPass(address, dbytes) then
               // This atomic write will be rejected if it does not refer
               // to the same physical locations after address translation.
               Mem[address, dbytes, acctype] = data;
               status = ExclusiveMonitorsStatus();
           X[s] = ZeroExtend(status, 32);
       else
           // store release register (atomic)
           Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
       if excl then
           // Tell the Exclusive Monitors to record a sequence of one or more atomic
           // memory reads from virtual address range [address, address+dbytes-1].
           // The Exclusive Monitor will only be set if all the reads are from the
           // same dbytes-aligned physical address, to allow for the possibility of
           // an atomicity break if the translation is changed between reads.
           AArch64.SetExclusiveMonitors(address, dbytes);

       if pair then
           // load exclusive pair
           assert excl;
           if rt_unknown then
               // ConstrainedUNPREDICTABLE case
               X[t]   = bits(datasize) UNKNOWN;
           elsif elsize == 32 then
               // 32-bit load exclusive pair (atomic)
               data = Mem[address, dbytes, acctype];
               if BigEndian() then
                   X[t]   = data<datasize-1:elsize>;
                   X[t2] = data<elsize-1:0>;
                         else
                              X[t]  = data<elsize-1:0>;
                              X[t2] = data<datasize-1:elsize>;
                     else // elsize == 64
                         // 64-bit load exclusive pair (not atomic),
                         // but must be 128-bit aligned
                         if address != Align(address, dbytes) then
                             iswrite = FALSE;
                             secondstage = FALSE;
                             AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                         X[t]   = Mem[address + 0, 8, acctype];
                         X[t2] = Mem[address + 8, 8, acctype];
                  else
                     // load {acquire} {exclusive} single register
                     data = Mem[address, dbytes, acctype];
                      X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDAXP','Load-Acquire Exclusive Pair of Registers loads two 32-bit words or two 64-bit doublewords from memory, and       (C6.6.76)
writes them to two registers. A 32-bit pair requires the address to be doubleword aligned and is single-copy atomic
at doubleword granularity. A 64-bit pair requires the address to be quadword aligned and is single-copy atomic for
each doubleword at doubleword granularity. The PE marks the physical address being accessed as an exclusive
access. This exclusive access mark is checked by Store Exclusive instructions. See Synchronization and semaphores
on page B2-103. The instruction also has memory ordering semantics as described in Load-Acquire, Store-Release
on page B2-88. For information about memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14            10 9             5 4             0
   1 x 0 0 1 0 0 0 0 1 1 (1) (1) (1) (1) (1) 1                 Rt2               Rn             Rt
   size                     o2 L o1          Rs       o0


32-bit variant

Applies when size = 10.

LDAXP <Wt1>, <Wt2>, [<Xn|SP>{,#0}]


64-bit variant

Applies when size = 11.

LDAXP <Xt1>, <Xt2>, [<Xn|SP>{,#0}]


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);     // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Notes for all encodings

For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDAXP on page J1-5407.


Assembler symbols

<Wt1>           Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

<Wt2>           Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                field.

<Xt1>           Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

<Xt2>           Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                field.
       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


       Operation

         bits(64) address;
         bits(datasize) data;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;
         boolean rn_unknown = FALSE;

         if memop == MemOp_LOAD && pair && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN     rt_unknown = TRUE;     // result is UNKNOWN
                   when Constraint_UNDEF       UnallocatedEncoding();
                   when Constraint_NOP         EndOfInstruction();

         if memop == MemOp_STORE && excl then
              if s == t || (pair && s == t2) then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN      rt_unknown = TRUE;      // store UNKNOWN value
                      when Constraint_NONE         rt_unknown = FALSE;     // store original value
                      when Constraint_UNDEF        UnallocatedEncoding();
                      when Constraint_NOP          EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN      rn_unknown = TRUE;      // address is UNKNOWN
                      when Constraint_NONE         rn_unknown = FALSE;     // address is original base
                      when Constraint_UNDEF        UnallocatedEncoding();
                      when Constraint_NOP          EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
          X[s] = ZeroExtend(status, 32);
      else
          // store release register (atomic)
          Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
      if excl then
          // Tell the Exclusive Monitors to record a sequence of one or more atomic
          // memory reads from virtual address range [address, address+dbytes-1].
          // The Exclusive Monitor will only be set if all the reads are from the
          // same dbytes-aligned physical address, to allow for the possibility of
          // an atomicity break if the translation is changed between reads.
          AArch64.SetExclusiveMonitors(address, dbytes);

      if pair then
          // load exclusive pair
          assert excl;
          if rt_unknown then
              // ConstrainedUNPREDICTABLE case
              X[t]  = bits(datasize) UNKNOWN;
          elsif elsize == 32 then
              // 32-bit load exclusive pair (atomic)
              data = Mem[address, dbytes, acctype];
              if BigEndian() then
                  X[t]  = data<datasize-1:elsize>;
                  X[t2] = data<elsize-1:0>;
              else
                  X[t]  = data<elsize-1:0>;
                  X[t2] = data<datasize-1:elsize>;
          else // elsize == 64
              // 64-bit load exclusive pair (not atomic),
              // but must be 128-bit aligned
              if address != Align(address, dbytes) then
                  iswrite = FALSE;
                  secondstage = FALSE;
                  AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
              X[t]  = Mem[address + 0, 8, acctype];
              X[t2] = Mem[address + 8, 8, acctype];
      else
          // load {acquire} {exclusive} single register
          data = Mem[address, dbytes, acctype];
          X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDAXR','      Load-Acquire Exclusive Register loads a 32-bit word or 64-bit doubleword from memory, and writes it to a register.       (C6.6.77)
      The memory access is atomic. The PE marks the physical address being accessed as an exclusive access. This
      exclusive access mark is checked by Store Exclusive instructions. See Synchronization and semaphores on
      page B2-103. The instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on
      page B2-88. For information about memory accesses see Load/Store addressing modes on page C1-122.




          31 30 29 28 27 26 25 24 23 22 21 20           16 15 14            10 9             5 4            0
          1 x 0 0 1 0 0 0 0 1 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)            Rn              Rt
          size                    o2 L o1        Rs        o0       Rt2


      32-bit variant

      Applies when size = 10.

      LDAXR <Wt>, [<Xn|SP>{,#0}]


      64-bit variant

      Applies when size = 11.

      LDAXR <Xt>, [<Xn|SP>{,#0}]


      Decode for all variants of this encoding

        integer n = UInt(Rn);
        integer t = UInt(Rt);
        integer t2 = UInt(Rt2); // ignored by load/store single register
        integer s = UInt(Rs);    // ignored by all loads and store-release

        if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
        if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

        AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
        boolean excl = (o2 == ''0'');
        boolean pair = (o1 == ''1'');
        MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
        integer elsize = 8 << UInt(size);
        integer regsize = if elsize == 64 then 64 else 32;
        integer datasize = if pair then elsize * 2 else elsize;


      Assembler symbols

      <Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xt>            Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


      Operation

        bits(64) address;
        bits(datasize) data;
        constant integer dbytes = datasize DIV 8;
        boolean rt_unknown = FALSE;
        boolean rn_unknown = FALSE;

        if memop == MemOp_LOAD && pair && t == t2 then
             Constraint c = ConstrainUnpredictable();
             assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
   case c of
        when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
        when Constraint_UNDEF      UnallocatedEncoding();
        when Constraint_NOP        EndOfInstruction();

if memop == MemOp_STORE && excl then
   if s == t || (pair && s == t2) then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
           when Constraint_NONE       rt_unknown = FALSE;       // store original value
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();
   if s == n && n != 31 then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
           when Constraint_NONE       rn_unknown = FALSE;       // address is original base
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();

if n == 31 then
    CheckSPAlignment();
   address = SP[];
elsif rn_unknown then
   address = bits(64) UNKNOWN;
else
   address = X[n];

case memop of
   when MemOp_STORE
       if rt_unknown then
           data = bits(datasize) UNKNOWN;
       elsif pair then
           assert excl;
           bits(datasize DIV 2) el1 = X[t];
           bits(datasize DIV 2) el2 = X[t2];
           data = if BigEndian() then el1 : el2 else el2 : el1;
        else
           data = X[t];

        if excl then
           // store {release} exclusive register|pair (atomic)
           bit status = ''1'';
           // Check whether the Exclusive Monitors are set to include the
           // physical memory locations corresponding to virtual address
           // range [address, address+dbytes-1].
           if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                // This atomic write will be rejected if it does not refer
                // to the same physical locations after address translation.
                Mem[address, dbytes, acctype] = data;
                status = ExclusiveMonitorsStatus();
            X[s] = ZeroExtend(status, 32);
        else
           // store release register (atomic)
            Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
        if excl then
           // Tell the Exclusive Monitors to record a sequence of one or more atomic
           // memory reads from virtual address range [address, address+dbytes-1].
           // The Exclusive Monitor will only be set if all the reads are from the
           // same dbytes-aligned physical address, to allow for the possibility of
           // an atomicity break if the translation is changed between reads.
            AArch64.SetExclusiveMonitors(address, dbytes);
                  if pair then
                     // load exclusive pair
                     assert excl;
                     if rt_unknown then
                          // ConstrainedUNPREDICTABLE case
                          X[t]  = bits(datasize) UNKNOWN;
                     elsif elsize == 32 then
                          // 32-bit load exclusive pair (atomic)
                          data = Mem[address, dbytes, acctype];
                          if BigEndian() then
                              X[t]  = data<datasize-1:elsize>;
                              X[t2] = data<elsize-1:0>;
                          else
                              X[t]  = data<elsize-1:0>;
                              X[t2] = data<datasize-1:elsize>;
                     else // elsize == 64
                          // 64-bit load exclusive pair (not atomic),
                          // but must be 128-bit aligned
                          if address != Align(address, dbytes) then
                             iswrite = FALSE;
                             secondstage = FALSE;
                             AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                          X[t]  = Mem[address + 0, 8, acctype];
                          X[t2] = Mem[address + 8, 8, acctype];
                  else
                     // load {acquire} {exclusive} single register
                     data = Mem[address, dbytes, acctype];
                      X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDAXRB','Load-Acquire Exclusive Register Byte loads a byte from memory, zero-extends it and writes it to a register. The       (C6.6.78)
memory access is atomic. The PE marks the physical address being accessed as an exclusive access. This exclusive
access mark is checked by Store Exclusive instructions. See Synchronization and semaphores on page B2-103. The
instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For
information about memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14            10 9             5 4             0
   0 0 0 0 1 0 0 0 0 1 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)             Rn              Rt
   size                     o2 L o1        Rs        o0       Rt2


No offset variant

LDAXRB <Wt>, [<Xn|SP>{,#0}]


Decode for this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);     // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Assembler symbols

<Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
     assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
     case c of
          when Constraint_UNKNOWN      rt_unknown = TRUE;      // result is UNKNOWN
          when Constraint_UNDEF        UnallocatedEncoding();
          when Constraint_NOP          EndOfInstruction();

 if memop == MemOp_STORE && excl then
     if s == t || (pair && s == t2) then
          Constraint c = ConstrainUnpredictable();
          assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
          case c of
                      when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
                      when Constraint_NONE       rt_unknown = FALSE;       // store original value
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
                      when Constraint_NONE       rn_unknown = FALSE;       // address is original base
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
               X[t]  = data<datasize-1:elsize>;
               X[t2] = data<elsize-1:0>;
          else
               X[t]  = data<elsize-1:0>;
               X[t2] = data<datasize-1:elsize>;
      else // elsize == 64
          // 64-bit load exclusive pair (not atomic),
          // but must be 128-bit aligned
          if address != Align(address, dbytes) then
              iswrite = FALSE;
              secondstage = FALSE;
              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
          X[t]   = Mem[address + 0, 8, acctype];
          X[t2] = Mem[address + 8, 8, acctype];
   else
      // load {acquire} {exclusive} single register
      data = Mem[address, dbytes, acctype];
       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDAXRH','      Load-Acquire Exclusive Register Halfword loads a halfword from memory, zero-extends it and writes it to a       (C6.6.79)
      register. The memory access is atomic. The PE marks the physical address being accessed as an exclusive access.
      This exclusive access mark is checked by Store Exclusive instructions. See Synchronization and semaphores on
      page B2-103. The instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on
      page B2-88. For information about memory accesses see Load/Store addressing modes on page C1-122.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4            0
          0 1 0 0 1 0 0 0 0 1 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)             Rn              Rt
          size                     o2 L o1        Rs        o0       Rt2


      No offset variant

      LDAXRH <Wt>, [<Xn|SP>{,#0}]


      Decode for this encoding

        integer n = UInt(Rn);
        integer t = UInt(Rt);
        integer t2 = UInt(Rt2); // ignored by load/store single register
        integer s = UInt(Rs);     // ignored by all loads and store-release

        if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
        if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

        AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
        boolean excl = (o2 == ''0'');
        boolean pair = (o1 == ''1'');
        MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
        integer elsize = 8 << UInt(size);
        integer regsize = if elsize == 64 then 64 else 32;
        integer datasize = if pair then elsize * 2 else elsize;


      Assembler symbols

      <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


      Operation

        bits(64) address;
        bits(datasize) data;
        constant integer dbytes = datasize DIV 8;
        boolean rt_unknown = FALSE;
        boolean rn_unknown = FALSE;

        if memop == MemOp_LOAD && pair && t == t2 then
             Constraint c = ConstrainUnpredictable();
             assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
             case c of
                  when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
                  when Constraint_UNDEF       UnallocatedEncoding();
                  when Constraint_NOP         EndOfInstruction();

        if memop == MemOp_STORE && excl then
             if s == t || (pair && s == t2) then
                  Constraint c = ConstrainUnpredictable();
                  assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                  case c of
           when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
           when Constraint_NONE       rt_unknown = FALSE;       // store original value
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP         EndOfInstruction();
   if s == n && n != 31 then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
           when Constraint_NONE       rn_unknown = FALSE;       // address is original base
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP         EndOfInstruction();

if n == 31 then
    CheckSPAlignment();
   address = SP[];
elsif rn_unknown then
   address = bits(64) UNKNOWN;
else
   address = X[n];

case memop of
   when MemOp_STORE
       if rt_unknown then
           data = bits(datasize) UNKNOWN;
       elsif pair then
           assert excl;
           bits(datasize DIV 2) el1 = X[t];
           bits(datasize DIV 2) el2 = X[t2];
           data = if BigEndian() then el1 : el2 else el2 : el1;
       else
           data = X[t];

       if excl then
           // store {release} exclusive register|pair (atomic)
           bit status = ''1'';
           // Check whether the Exclusive Monitors are set to include the
           // physical memory locations corresponding to virtual address
           // range [address, address+dbytes-1].
           if AArch64.ExclusiveMonitorsPass(address, dbytes) then
               // This atomic write will be rejected if it does not refer
               // to the same physical locations after address translation.
                Mem[address, dbytes, acctype] = data;
               status = ExclusiveMonitorsStatus();
           X[s] = ZeroExtend(status, 32);
       else
           // store release register (atomic)
           Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
       if excl then
           // Tell the Exclusive Monitors to record a sequence of one or more atomic
           // memory reads from virtual address range [address, address+dbytes-1].
           // The Exclusive Monitor will only be set if all the reads are from the
           // same dbytes-aligned physical address, to allow for the possibility of
           // an atomicity break if the translation is changed between reads.
           AArch64.SetExclusiveMonitors(address, dbytes);

        if pair then
           // load exclusive pair
           assert excl;
           if rt_unknown then
                // ConstrainedUNPREDICTABLE case
                X[t]  = bits(datasize) UNKNOWN;
           elsif elsize == 32 then
                // 32-bit load exclusive pair (atomic)
                data = Mem[address, dbytes, acctype];
                if BigEndian() then
                              X[t]  = data<datasize-1:elsize>;
                              X[t2] = data<elsize-1:0>;
                         else
                              X[t]  = data<elsize-1:0>;
                              X[t2] = data<datasize-1:elsize>;
                     else // elsize == 64
                         // 64-bit load exclusive pair (not atomic),
                         // but must be 128-bit aligned
                         if address != Align(address, dbytes) then
                             iswrite = FALSE;
                             secondstage = FALSE;
                             AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                         X[t]   = Mem[address + 0, 8, acctype];
                         X[t2] = Mem[address + 8, 8, acctype];
                  else
                     // load {acquire} {exclusive} single register
                     data = Mem[address, dbytes, acctype];
                      X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDNP','Load pair of registers, with non-temporal hint       (C6.6.80)




  31 30 29 28 27 26 25 24 23 22 21                     15 14         10 9              5 4               0
  x 0 1 0 1 0 0 0 0 1                      imm7                Rt2              Rn              Rt
  opc                          L


32-bit variant

Applies when opc = 00.

LDNP <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}]


64-bit variant

Applies when opc = 10.

LDNP <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}]


Decode for all variants of this encoding

 boolean wback   = FALSE;
 boolean postindex = FALSE;


Assembler symbols

<Wt1>          Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

<Wt2>          Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
               field.

<Xt1>          Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

<Xt2>          Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
               field.

<Xn|SP>        Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<imm>          For the 32-bit variant: is the optional signed immediate byte offset, a multiple of 4 in the range -256
               to 252, defaulting to 0 and encoded in the "imm7" field as <imm>/4.

               For the 64-bit variant: is the optional signed immediate byte offset, a multiple of 8 in the range -512
               to 504, defaulting to 0 and encoded in the "imm7" field as <imm>/8.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2);
 AccType acctype = AccType_STREAM;
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 if opc<0> == ''1'' then UnallocatedEncoding();
 integer scale = 2 + UInt(opc<1>);
 integer datasize = 8 << scale;
 bits(64) offset = LSL(SignExtend(imm7, 64), scale);
       Operation

         bits(64) address;
         bits(datasize) data1;
         bits(datasize) data2;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown && t == n then
                      data1 = bits(datasize) UNKNOWN;
                   else
                      data1 = X[t];
                   if rt_unknown && t2 == n then
                      data2 = bits(datasize) UNKNOWN;
                   else
                      data2 = X[t2];
                   Mem[address + 0     , dbytes, acctype] = data1;
                   Mem[address + dbytes, dbytes, acctype] = data2;

              when MemOp_LOAD
                   data1 = Mem[address + 0     , dbytes, acctype];
                   data2 = Mem[address + dbytes, dbytes, acctype];
                   if rt_unknown then
                      data1 = bits(datasize) UNKNOWN;
                      data2 = bits(datasize) UNKNOWN;
                   X[t]  = data1;
                   X[t2] = data2;

         if wback then
              if postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDP','Load Pair of Registers calculates an address from a base register value and an immediate offset, loads two 32-bit       (C6.6.81)
words or two 64-bit doublewords from memory, and writes them to two registers. For information about memory
accesses see Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21                  15 14            10 9            5 4              0
  x 0 1 0 1 0 0 0 1 1                    imm7                Rt2              Rn             Rt
  opc                          L


32-bit variant

Applies when opc = 00.

LDP <Wt1>, <Wt2>, [<Xn|SP>], #<imm>


64-bit variant

Applies when opc = 10.

LDP <Xt1>, <Xt2>, [<Xn|SP>], #<imm>


Decode for all variants of this encoding

 boolean wback  = TRUE;
 boolean postindex = TRUE;


Pre-index


  31 30 29 28 27 26 25 24 23 22 21                  15 14            10 9            5 4              0
  x 0 1 0 1 0 0 1 1 1                    imm7                Rt2              Rn             Rt
  opc                          L


32-bit variant

Applies when opc = 00.

LDP <Wt1>, <Wt2>, [<Xn|SP>, #<imm>]!


64-bit variant

Applies when opc = 10.

LDP <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]!


Decode for all variants of this encoding

 boolean wback  = TRUE;
 boolean postindex = FALSE;


Signed offset


  31 30 29 28 27 26 25 24 23 22 21                  15 14            10 9            5 4              0
  x 0 1 0 1 0 0 1 0 1                    imm7                Rt2              Rn             Rt
  opc                          L
       32-bit variant

       Applies when opc = 00.

       LDP <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}]


       64-bit variant

       Applies when opc = 10.

       LDP <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}]


       Decode for all variants of this encoding

         boolean wback  = FALSE;
         boolean postindex = FALSE;


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDP on page J1-5406.


       Assembler symbols

       <Wt1>           Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Wt2>           Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                       field.

       <Xt1>           Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt2>           Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                       field.

       <Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <imm>           For the 32-bit post-index and 32-bit pre-index variant: is the signed immediate byte offset, a
                       multiple of 4 in the range -256 to 252, encoded in the "imm7" field as <imm>/4.

                       For the 32-bit signed offset variant: is the optional signed immediate byte offset, a multiple of 4 in
                       the range -256 to 252, defaulting to 0 and encoded in the "imm7" field as <imm>/4.

                       For the 64-bit post-index and 64-bit pre-index variant: is the signed immediate byte offset, a
                       multiple of 8 in the range -512 to 504, encoded in the "imm7" field as <imm>/8.

                       For the 64-bit signed offset variant: is the optional signed immediate byte offset, a multiple of 8 in
                       the range -512 to 504, defaulting to 0 and encoded in the "imm7" field as <imm>/8.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2);
         AccType acctype = AccType_NORMAL;
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         if L:opc<0> == ''01'' || opc == ''11'' then UnallocatedEncoding();
         boolean signed = (opc<0> != ''0'');
         integer scale = 2 + UInt(opc<1>);
         integer datasize = 8 << scale;
         bits(64) offset = LSL(SignExtend(imm7, 64), scale);
Operation for all encodings

 bits(64) address;
 bits(datasize) data1;
 bits(datasize) data2;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean wb_unknown = FALSE;

 if memop == MemOp_LOAD && wback && (t == n || t2 == n) && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;          // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;      // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && (t == n || t2 == n) && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;     // value stored is pre-writeback
         when Constraint_UNKNOWN    rt_unknown = TRUE;      // value stored is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_LOAD && t == t2 then
     Constraint c = ConstrainUnpredictable();
    assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
     CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
         if rt_unknown && t == n then
            data1 = bits(datasize) UNKNOWN;
         else
            data1 = X[t];
         if rt_unknown && t2 == n then
            data2 = bits(datasize) UNKNOWN;
         else
            data2 = X[t2];
         Mem[address + 0     , dbytes, acctype] = data1;
         Mem[address + dbytes, dbytes, acctype] = data2;

    when MemOp_LOAD
         data1 = Mem[address + 0     , dbytes, acctype];
         data2 = Mem[address + dbytes, dbytes, acctype];
         if rt_unknown then
            data1 = bits(datasize) UNKNOWN;
            data2 = bits(datasize) UNKNOWN;
         if signed then
             X[t]  = SignExtend(data1, 64);
             X[t2] = SignExtend(data2, 64);
         else
             X[t]  = data1;
                       X[t2] = data2;

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDPSW','Load Pair of Registers Signed Word calculates an address from a base register value and an immediate offset, loads       (C6.6.82)
two 32-bit words from memory, sign-extends them, and writes them to two registers. For information about memory
accesses see Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21                 15 14           10 9              5 4             0
  0 1 1 0 1 0 0 0 1 1                   imm7                Rt2               Rn             Rt
  opc                         L


Post-index variant

LDPSW <Xt1>, <Xt2>, [<Xn|SP>], #<imm>


Decode for this encoding

 boolean wback   = TRUE;
 boolean postindex = TRUE;


Pre-index


  31 30 29 28 27 26 25 24 23 22 21                 15 14           10 9              5 4             0
  0 1 1 0 1 0 0 1 1 1                   imm7                Rt2               Rn             Rt
  opc                         L


Pre-index variant

LDPSW <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]!


Decode for this encoding

 boolean wback   = TRUE;
 boolean postindex = FALSE;


Signed offset


  31 30 29 28 27 26 25 24 23 22 21                 15 14           10 9              5 4             0
  0 1 1 0 1 0 0 1 0 1                   imm7                Rt2               Rn             Rt
  opc                         L


Signed offset variant

LDPSW <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}]


Decode for this encoding

 boolean wback   = FALSE;
 boolean postindex = FALSE;


Notes for all encodings

For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDPSW on page J1-5406.
       Assembler symbols

       <Xt1>            Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt2>            Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                        field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <imm>            For the post-index and pre-index variant: is the signed immediate byte offset, a multiple of 4 in the
                        range -256 to 252, encoded in the "imm7" field as <imm>/4.

                        For the signed offset variant: is the optional signed immediate byte offset, a multiple of 4 in the
                        range -256 to 252, defaulting to 0 and encoded in the "imm7" field as <imm>/4.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2);
         AccType acctype = AccType_NORMAL;
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         if L:opc<0> == ''01'' || opc == ''11'' then UnallocatedEncoding();
         boolean signed = (opc<0> != ''0'');
         integer scale = 2 + UInt(opc<1>);
         integer datasize = 8 << scale;
         bits(64) offset = LSL(SignExtend(imm7, 64), scale);


       Operation for all encodings

         bits(64) address;
         bits(datasize) data1;
         bits(datasize) data2;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;
         boolean wb_unknown = FALSE;

         if memop == MemOp_LOAD && wback && (t == n || t2 == n) && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;             // writeback is suppressed
                   when Constraint_UNKNOWN     wb_unknown = TRUE;        // writeback is UNKNOWN
                   when Constraint_UNDEF       UnallocatedEncoding();
                   when Constraint_NOP         EndOfInstruction();

         if memop == MemOp_STORE && wback && (t == n || t2 == n) && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE        rt_unknown = FALSE;       // value stored is pre-writeback
                   when Constraint_UNKNOWN     rt_unknown = TRUE;        // value stored is UNKNOWN
                   when Constraint_UNDEF       UnallocatedEncoding();
                   when Constraint_NOP         EndOfInstruction();

         if memop == MemOp_LOAD && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN     rt_unknown = TRUE;        // result is UNKNOWN
                   when Constraint_UNDEF       UnallocatedEncoding();
                   when Constraint_NOP         EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown && t == n then
            data1 = bits(datasize) UNKNOWN;
        else
            data1 = X[t];
        if rt_unknown && t2 == n then
            data2 = bits(datasize) UNKNOWN;
        else
            data2 = X[t2];
         Mem[address + 0     , dbytes, acctype] = data1;
         Mem[address + dbytes, dbytes, acctype] = data2;

    when MemOp_LOAD
        data1 = Mem[address + 0      , dbytes, acctype];
        data2 = Mem[address + dbytes, dbytes, acctype];
        if rt_unknown then
            data1 = bits(datasize) UNKNOWN;
            data2 = bits(datasize) UNKNOWN;
        if signed then
             X[t]  = SignExtend(data1, 64);
             X[t2] = SignExtend(data2, 64);
        else
             X[t]  = data1;
             X[t2] = data2;

 if wback then
    if wb_unknown then
        address = bits(64) UNKNOWN;
    elsif postindex then
        address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDR','       Load Register (immediate) calculates an address from a base register value and an immediate offset, loads a 32-bit       (C6.6.83)
       word or 64-bit doubleword from memory, and writes it to a register. For information about memory accesses see
       Load/Store addressing modes on page C1-122. The Unsigned offset variant scales the immediate offset value by the
       size of the value accessed before adding it to the base register value.


       Post-index


           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9         5 4              0
           1 x 1 1 1 0 0 0 0 1 0                        imm9               0 1      Rn             Rt
           size                    opc


       32-bit variant

       Applies when size = 10.

       LDR <Wt>, [<Xn|SP>], #<simm>


       64-bit variant

       Applies when size = 11.

       LDR <Xt>, [<Xn|SP>], #<simm>


       Decode for all variants of this encoding

         boolean wback = TRUE;
         boolean postindex = TRUE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Pre-index


           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9         5 4              0
           1 x 1 1 1 0 0 0 0 1 0                        imm9               1 1      Rn             Rt
           size                    opc


       32-bit variant

       Applies when size = 10.

       LDR <Wt>, [<Xn|SP>, #<simm>]!


       64-bit variant

       Applies when size = 11.

       LDR <Xt>, [<Xn|SP>, #<simm>]!


       Decode for all variants of this encoding

         boolean wback = TRUE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);
Unsigned offset


  31 30 29 28 27 26 25 24 23 22 21                                   10 9              5 4             0
  1 x 1 1 1 0 0 1 0 1                             imm12                       Rn                Rt
  size                      opc


32-bit variant

Applies when size = 10.

LDR <Wt>, [<Xn|SP>{, #<pimm>}]


64-bit variant

Applies when size = 11.

LDR <Xt>, [<Xn|SP>{, #<pimm>}]


Decode for all variants of this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);


Notes for all encodings

For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDR (immediate) on page J1-5404.


Assembler symbols

<Wt>           Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xt>           Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>        Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<simm>         Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

<pimm>         For the 32-bit variant: is the optional positive immediate byte offset, a multiple of 4 in the range 0
               to 16380, defaulting to 0 and encoded in the "imm12" field as <pimm>/4.

               For the 64-bit variant: is the optional positive immediate byte offset, a multiple of 8 in the range 0
               to 32760, defaulting to 0 and encoded in the "imm12" field as <pimm>/8.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_NORMAL;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
     // store or zero-extending load
     memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
     regsize = if size == ''11'' then 64 else 32;
     signed = FALSE;
 else
     if size == ''11'' then
         UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation for all encodings

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
                   when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              if memop != MemOp_PREFETCH then CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   else
                      data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
       SP[] = address;
   else
       X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDRB','Load Register Byte (immediate) calculates an address from a base register value and an immediate offset, loads a       (C6.6.86)
byte from memory, zero-extends it, and writes it to a register. For information about memory accesses see
Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                           12 11 10 9            5 4             0
  0 0 1 1 1 0 0 0 0 1 0                        imm9                 0 1        Rn            Rt
  size                    opc


Post-index variant

LDRB <Wt>, [<Xn|SP>], #<simm>


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                           12 11 10 9            5 4             0
  0 0 1 1 1 0 0 0 0 1 0                        imm9                 1 1        Rn            Rt
  size                    opc


Pre-index variant

LDRB <Wt>, [<Xn|SP>, #<simm>]!


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Unsigned offset


  31 30 29 28 27 26 25 24 23 22 21                                    10 9            5 4             0
  0 0 1 1 1 0 0 1 0 1                            imm12                         Rn            Rt
  size                    opc


Unsigned offset variant

LDRB <Wt>, [<Xn|SP>{, #<pimm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);
       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDRB (immediate) on page J1-5404.


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           Is the optional positive immediate byte offset, in the range 0 to 4095, defaulting to 0 and encoded
                        in the "imm12" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation for all encodings

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;           // writeback is suppressed
                   when Constraint_UNKNOWN      wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
                   when Constraint_NOP          EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE         rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN      rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
             X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
        address = bits(64) UNKNOWN;
    elsif postindex then
        address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDRH','Load Register Halfword (immediate) calculates an address from a base register value and an immediate offset, loads       (C6.6.88)
a halfword from memory, zero-extends it, and writes it to a register. For information about memory accesses see
Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
  0 1 1 1 1 0 0 0 0 1 0                       imm9                0 1          Rn            Rt
   size                   opc


Post-index variant

LDRH <Wt>, [<Xn|SP>], #<simm>


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
  0 1 1 1 1 0 0 0 0 1 0                       imm9                1 1          Rn            Rt
   size                   opc


Pre-index variant

LDRH <Wt>, [<Xn|SP>, #<simm>]!


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Unsigned offset


  31 30 29 28 27 26 25 24 23 22 21                                    10 9            5 4             0
  0 1 1 1 1 0 0 1 0 1                          imm12                           Rn            Rt
   size                   opc


Unsigned offset variant

LDRH <Wt>, [<Xn|SP>{, #<pimm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);
       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDRH (immediate) on page J1-5405.


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           Is the optional positive immediate byte offset, a multiple of 2 in the range 0 to 8190, defaulting to 0
                        and encoded in the "imm12" field as <pimm>/2.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation for all encodings

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;           // writeback is suppressed
                   when Constraint_UNKNOWN      wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
                   when Constraint_NOP          EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE         rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN      rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
             X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
        address = bits(64) UNKNOWN;
    elsif postindex then
        address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDRSB','Load Register Signed Byte (immediate) calculates an address from a base register value and an immediate byte       (C6.6.90)
offset, loads a byte from memory, sign-extends it to either 32 or 64 bits, and writes it to a register. For information
about memory accesses see Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9               5 4               0
  0 0 1 1 1 0 0 0 1 x 0                        imm9                0 1         Rn                 Rt
   size                      opc


32-bit variant

Applies when opc = 11.

LDRSB <Wt>, [<Xn|SP>], #<simm>


64-bit variant

Applies when opc = 10.

LDRSB <Xt>, [<Xn|SP>], #<simm>


Decode for all variants of this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9               5 4               0
  0 0 1 1 1 0 0 0 1 x 0                        imm9                1 1         Rn                 Rt
   size                      opc


32-bit variant

Applies when opc = 11.

LDRSB <Wt>, [<Xn|SP>, #<simm>]!


64-bit variant

Applies when opc = 10.

LDRSB <Xt>, [<Xn|SP>, #<simm>]!


Decode for all variants of this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);
       Unsigned offset


           31 30 29 28 27 26 25 24 23 22 21                                   10 9             5 4              0
           0 0 1 1 1 0 0 1 1 x                           imm12                          Rn              Rt
           size                      opc


       32-bit variant

       Applies when opc = 11.

       LDRSB <Wt>, [<Xn|SP>{, #<pimm>}]


       64-bit variant

       Applies when opc = 10.

       LDRSB <Xt>, [<Xn|SP>{, #<pimm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDRSB (immediate) on page J1-5405.


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           Is the optional positive immediate byte offset, in the range 0 to 4095, defaulting to 0 and encoded
                        in the "imm12" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation for all encodings

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
         else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDRSH','Load Register Signed Halfword (immediate) calculates an address from a base register value and an immediate       (C6.6.92)
offset, loads a halfword from memory, sign-extends it, and writes it to a register. For information about memory
accesses see Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9               5 4             0
  0 1 1 1 1 0 0 0 1 x 0                       imm9                 0 1         Rn               Rt
   size                      opc


32-bit variant

Applies when opc = 11.

LDRSH <Wt>, [<Xn|SP>], #<simm>


64-bit variant

Applies when opc = 10.

LDRSH <Xt>, [<Xn|SP>], #<simm>


Decode for all variants of this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9               5 4             0
  0 1 1 1 1 0 0 0 1 x 0                       imm9                 1 1         Rn               Rt
   size                      opc


32-bit variant

Applies when opc = 11.

LDRSH <Wt>, [<Xn|SP>, #<simm>]!


64-bit variant

Applies when opc = 10.

LDRSH <Xt>, [<Xn|SP>, #<simm>]!


Decode for all variants of this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);
       Unsigned offset


           31 30 29 28 27 26 25 24 23 22 21                                   10 9               5 4            0
           0 1 1 1 1 0 0 1 1 x                           imm12                           Rn               Rt
           size                      opc


       32-bit variant

       Applies when opc = 11.

       LDRSH <Wt>, [<Xn|SP>{, #<pimm>}]


       64-bit variant

       Applies when opc = 10.

       LDRSH <Xt>, [<Xn|SP>{, #<pimm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDRSH (immediate) on page J1-5405.


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           Is the optional positive immediate byte offset, a multiple of 2 in the range 0 to 8190, defaulting to 0
                        and encoded in the "imm12" field as <pimm>/2.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation for all encodings

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
         else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDRSW','Load Register Signed Word (immediate) calculates an address from a base register value and an immediate offset,       (C6.6.94)
loads a word from memory, sign-extends it, and writes it to a register. For information about memory accesses see
Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9             5 4              0
  1 0 1 1 1 0 0 0 1 0 0                       imm9                0 1          Rn             Rt
  size                    opc


Post-index variant

LDRSW <Xt>, [<Xn|SP>], #<simm>


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9             5 4              0
  1 0 1 1 1 0 0 0 1 0 0                       imm9                1 1          Rn             Rt
  size                    opc


Pre-index variant

LDRSW <Xt>, [<Xn|SP>, #<simm>]!


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Unsigned offset


  31 30 29 28 27 26 25 24 23 22 21                                   10 9             5 4              0
  1 0 1 1 1 0 0 1 1 0                          imm12                           Rn             Rt
  size                    opc


Unsigned offset variant

LDRSW <Xt>, [<Xn|SP>{, #<pimm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);
       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDRSW (immediate) on page J1-5406.


       Assembler symbols

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           Is the optional positive immediate byte offset, a multiple of 4 in the range 0 to 16380, defaulting to
                        0 and encoded in the "imm12" field as <pimm>/4.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation for all encodings

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;           // writeback is suppressed
                   when Constraint_UNKNOWN      wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
                   when Constraint_NOP          EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE         rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN      rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
             X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
        address = bits(64) UNKNOWN;
    elsif postindex then
        address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDTR','       Load Register (unprivileged) calculates an address from a base register and an immediate byte offset, loads a word       (C6.6.97)
       or doubleword from memory, zero-extends it, and writes it to a register. For information about memory accesses see
       Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           1 x 1 1 1 0 0 0 0 1 0                        imm9               1 0         Rn               Rt
           size                      opc


       32-bit variant

       Applies when size = 10.

       LDTR <Wt>, [<Xn|SP>{, #<simm>}]


       64-bit variant

       Applies when size = 11.

       LDTR <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_UNPRIV;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
            X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDTRB','       Load Register Byte (unprivileged) calculates an address from a base register and an immediate byte offset, loads a       (C6.6.98)
       byte from memory, zero-extends it, and writes it to a register. For information about memory accesses see
       Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 0 1 1 1 0 0 0 0 1 0                        imm9               1 0         Rn               Rt
           size                      opc


       Unscaled offset variant

       LDTRB <Wt>, [<Xn|SP>{, #<simm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_UNPRIV;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;
Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDTRH','       Load Register Halfword (unprivileged) calculates an address from a base register value and an immediate offset,       (C6.6.99)
       loads a halfword from memory, zero-extends it, and writes it to a register. For information about memory accesses
       see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 1 1 1 1 0 0 0 0 1 0                        imm9               1 0         Rn               Rt
           size                      opc


       Unscaled offset variant

       LDTRH <Wt>, [<Xn|SP>{, #<simm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_UNPRIV;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;
Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDTRSB','       Load Register Signed Byte (unprivileged) calculates an address from a base register and an immediate byte offset,       (C6.6.100)
       loads a signed byte from memory, sign-extends it, and writes it to a register. For information about memory accesses
       see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 0 1 1 1 0 0 0 1 x 0                        imm9                1 0         Rn              Rt
           size                      opc


       32-bit variant

       Applies when opc = 11.

       LDTRSB <Wt>, [<Xn|SP>{, #<simm>}]


       64-bit variant

       Applies when opc = 10.

       LDTRSB <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_UNPRIV;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
            X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDTRSH','       Load Register Signed Halfword (unprivileged) calculates an address from a base register and an immediate offset,       (C6.6.101)
       loads a signed byte from memory, sign-extends it, and writes it to a register. For information about memory accesses
       see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 1 1 1 1 0 0 0 1 x 0                        imm9                1 0         Rn              Rt
           size                      opc


       32-bit variant

       Applies when opc = 11.

       LDTRSH <Wt>, [<Xn|SP>{, #<simm>}]


       64-bit variant

       Applies when opc = 10.

       LDTRSH <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_UNPRIV;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
            X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDTRSW','       Load Register Signed Word (unprivileged) calculates an address from a base register and an immediate offset, loads       (C6.6.102)
       a signed byte from memory, sign-extends it, and writes it to a register. For information about memory accesses see
       Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           1 0 1 1 1 0 0 0 1 0 0                        imm9               1 0         Rn               Rt
           size                      opc


       Unscaled offset variant

       LDTRSW <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_UNPRIV;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;
Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDUR','       Load Register (unscaled) calculates an address from a base register and an immediate offset, loads a 32-bit word or       (C6.6.103)
       64-bit doubleword from memory, zero-extends it, and writes it to a register. For information about memory accesses
       see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           1 x 1 1 1 0 0 0 0 1 0                        imm9               0 0         Rn               Rt
           size                      opc


       32-bit variant

       Applies when size = 10.

       LDUR <Wt>, [<Xn|SP>{, #<simm>}]


       64-bit variant

       Applies when size = 11.

       LDUR <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   memop = MemOp_PREFETCH;
                   if opc<0> == ''1'' then UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
         else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDURB','       Load Register Byte (unscaled) calculates an address from a base register and an immediate offset, loads a byte from       (C6.6.104)
       memory, zero-extends it, and writes it to a register. For information about memory accesses see Load/Store
       addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 0 1 1 1 0 0 0 0 1 0                        imm9               0 0         Rn               Rt
           size                      opc


       Unscaled offset variant

       LDURB <Wt>, [<Xn|SP>{, #<simm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   memop = MemOp_PREFETCH;
                   if opc<0> == ''1'' then UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;
Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDURH','       Load Register Halfword (unscaled) calculates an address from a base register and an immediate offset, loads a       (C6.6.105)
       halfword from memory, zero-extends it, and writes it to a register. For information about memory accesses see
       Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 1 1 1 1 0 0 0 0 1 0                        imm9               0 0         Rn               Rt
           size                      opc


       Unscaled offset variant

       LDURH <Wt>, [<Xn|SP>{, #<simm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   memop = MemOp_PREFETCH;
                   if opc<0> == ''1'' then UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;
Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDURSB','       Load Register Signed Byte (unscaled) calculates an address from a base register and an immediate offset, loads a       (C6.6.106)
       signed byte from memory, sign-extends it, and writes it to a register. For information about memory accesses see
       Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 0 1 1 1 0 0 0 1 x 0                        imm9               0 0         Rn               Rt
           size                      opc


       32-bit variant

       Applies when opc = 11.

       LDURSB <Wt>, [<Xn|SP>{, #<simm>}]


       64-bit variant

       Applies when opc = 10.

       LDURSB <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   memop = MemOp_PREFETCH;
                   if opc<0> == ''1'' then UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
         else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDURSH','       Load Register Signed Halfword (unscaled) calculates an address from a base register and an immediate offset, loads       (C6.6.107)
       a signed halfword from memory, sign-extends it, and writes it to a register. For information about memory accesses
       see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           0 1 1 1 1 0 0 0 1 x 0                        imm9               0 0         Rn               Rt
           size                      opc


       32-bit variant

       Applies when opc = 11.

       LDURSH <Wt>, [<Xn|SP>{, #<simm>}]


       64-bit variant

       Applies when opc = 10.

       LDURSH <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   memop = MemOp_PREFETCH;
                   if opc<0> == ''1'' then UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
         else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDURSW','       Load Register Signed Word (unscaled) calculates an address from a base register and an immediate offset, loads a       (C6.6.108)
       signed word from memory, sign-extends it, and writes it to a register. For information about memory accesses see
       Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
           1 0 1 1 1 0 0 0 1 0 0                        imm9               0 0         Rn               Rt
           size                      opc


       Unscaled offset variant

       LDURSW <Xt>, [<Xn|SP>{, #<simm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                        in the "imm9" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   memop = MemOp_PREFETCH;
                   if opc<0> == ''1'' then UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;
Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','LDXP','       Load Exclusive Pair of Registers loads two 32-bit words or two 64-bit doublewords from memory, and writes them       (C6.6.109)
       to two registers. A 32-bit pair requires the address to be doubleword aligned and is single-copy atomic at
       doubleword granularity. A 64-bit pair requires the address to be quadword aligned and is single-copy atomic for
       each doubleword at doubleword granularity. The PE marks the physical address being accessed as an exclusive
       access. This exclusive access mark is checked by Store Exclusive instructions. See Synchronization and semaphores
       on page B2-103. For information about memory accesses see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20            16 15 14           10 9              5 4             0
           1 x 0 0 1 0 0 0 0 1 1 (1) (1) (1) (1) (1) 0                Rt2               Rn             Rt
           size                    o2 L o1          Rs        o0


       32-bit variant

       Applies when size = 10.

       LDXP <Wt1>, <Wt2>, [<Xn|SP>{,#0}]


       64-bit variant

       Applies when size = 11.

       LDXP <Xt1>, <Xt2>, [<Xn|SP>{,#0}]


       Decode for all variants of this encoding

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2); // ignored by load/store single register
         integer s = UInt(Rs);     // ignored by all loads and store-release

         if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
         if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

         AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
         boolean excl = (o2 == ''0'');
         boolean pair = (o1 == ''1'');
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer elsize = 8 << UInt(size);
         integer regsize = if elsize == 64 then 64 else 32;
         integer datasize = if pair then elsize * 2 else elsize;


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly LDXP on page J1-5407.


       Assembler symbols

       <Wt1>           Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Wt2>           Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                       field.

       <Xt1>           Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt2>           Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                       field.
<Xn|SP>       Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
    assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_UNKNOWN     rt_unknown = TRUE;     // result is UNKNOWN
         when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP         EndOfInstruction();

 if memop == MemOp_STORE && excl then
    if s == t || (pair && s == t2) then
         Constraint c = ConstrainUnpredictable();
         assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
        case c of
            when Constraint_UNKNOWN      rt_unknown = TRUE;      // store UNKNOWN value
            when Constraint_NONE         rt_unknown = FALSE;     // store original value
            when Constraint_UNDEF        UnallocatedEncoding();
            when Constraint_NOP          EndOfInstruction();
    if s == n && n != 31 then
         Constraint c = ConstrainUnpredictable();
         assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
        case c of
            when Constraint_UNKNOWN      rn_unknown = TRUE;      // address is UNKNOWN
            when Constraint_NONE         rn_unknown = FALSE;     // address is original base
            when Constraint_UNDEF        UnallocatedEncoding();
            when Constraint_NOP          EndOfInstruction();

 if n == 31 then
     CheckSPAlignment();
    address = SP[];
 elsif rn_unknown then
    address = bits(64) UNKNOWN;
 else
    address = X[n];

 case memop of
    when MemOp_STORE
         if rt_unknown then
            data = bits(datasize) UNKNOWN;
         elsif pair then
            assert excl;
            bits(datasize DIV 2) el1 = X[t];
            bits(datasize DIV 2) el2 = X[t2];
            data = if BigEndian() then el1 : el2 else el2 : el1;
         else
            data = X[t];

         if excl then
            // store {release} exclusive register|pair (atomic)
            bit status = ''1'';
            // Check whether the Exclusive Monitors are set to include the
            // physical memory locations corresponding to virtual address
            // range [address, address+dbytes-1].
            if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                 // This atomic write will be rejected if it does not refer
                 // to the same physical locations after address translation.
                 Mem[address, dbytes, acctype] = data;
                 status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
                               X[t2] = data<elsize-1:0>;
                           else
                               X[t]  = data<elsize-1:0>;
                               X[t2] = data<datasize-1:elsize>;
                      else // elsize == 64
                           // 64-bit load exclusive pair (not atomic),
                           // but must be 128-bit aligned
                           if address != Align(address, dbytes) then
                              iswrite = FALSE;
                              secondstage = FALSE;
                              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                           X[t]  = Mem[address + 0, 8, acctype];
                           X[t2] = Mem[address + 8, 8, acctype];
                   else
                      // load {acquire} {exclusive} single register
                      data = Mem[address, dbytes, acctype];
                       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDXR','Load Exclusive Register loads a 32-bit word or a 64-bit doubleword from memory, and writes it to a register. The       (C6.6.110)
memory access is atomic. The PE marks the physical address being accessed as an exclusive access. This exclusive
access mark is checked by Store Exclusive instructions. See Synchronization and semaphores on page B2-103. For
information about memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4             0
   1 x 0 0 1 0 0 0 0 1 0 (1) (1) (1) (1) (1) 0 (1) (1) (1) (1) (1)            Rn              Rt
   size                    o2 L o1        Rs        o0       Rt2


32-bit variant

Applies when size = 10.

LDXR <Wt>, [<Xn|SP>{,#0}]


64-bit variant

Applies when size = 11.

LDXR <Xt>, [<Xn|SP>{,#0}]


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);    // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Assembler symbols

<Wt>           Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xt>           Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>        Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
     assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
     case c of
                   when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && excl then
              if s == t || (pair && s == t2) then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
                      when Constraint_NONE       rt_unknown = FALSE;       // store original value
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP        EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
                      when Constraint_NONE       rn_unknown = FALSE;       // address is original base
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
      // load exclusive pair
      assert excl;
      if rt_unknown then
          // ConstrainedUNPREDICTABLE case
          X[t]   = bits(datasize) UNKNOWN;
      elsif elsize == 32 then
          // 32-bit load exclusive pair (atomic)
          data = Mem[address, dbytes, acctype];
          if BigEndian() then
               X[t]  = data<datasize-1:elsize>;
               X[t2] = data<elsize-1:0>;
          else
               X[t]  = data<elsize-1:0>;
               X[t2] = data<datasize-1:elsize>;
      else // elsize == 64
          // 64-bit load exclusive pair (not atomic),
          // but must be 128-bit aligned
          if address != Align(address, dbytes) then
              iswrite = FALSE;
              secondstage = FALSE;
              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
          X[t]   = Mem[address + 0, 8, acctype];
          X[t2] = Mem[address + 8, 8, acctype];
   else
      // load {acquire} {exclusive} single register
      data = Mem[address, dbytes, acctype];
       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDXRB','      Load Exclusive Register Byte loads a byte from memory, zero-extends it and writes it to a register. The memory       (C6.6.111)
      access is atomic. The PE marks the physical address being accessed as an exclusive access. This exclusive access
      mark is checked by Store Exclusive instructions. See Synchronization and semaphores on page B2-103. For
      information about memory accesses see Load/Store addressing modes on page C1-122.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4            0
          0 0 0 0 1 0 0 0 0 1 0 (1) (1) (1) (1) (1) 0 (1) (1) (1) (1) (1)             Rn              Rt
          size                     o2 L o1        Rs        o0       Rt2


      No offset variant

      LDXRB <Wt>, [<Xn|SP>{,#0}]


      Decode for this encoding

        integer n = UInt(Rn);
        integer t = UInt(Rt);
        integer t2 = UInt(Rt2); // ignored by load/store single register
        integer s = UInt(Rs);     // ignored by all loads and store-release

        if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
        if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

        AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
        boolean excl = (o2 == ''0'');
        boolean pair = (o1 == ''1'');
        MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
        integer elsize = 8 << UInt(size);
        integer regsize = if elsize == 64 then 64 else 32;
        integer datasize = if pair then elsize * 2 else elsize;


      Assembler symbols

      <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


      Operation

        bits(64) address;
        bits(datasize) data;
        constant integer dbytes = datasize DIV 8;
        boolean rt_unknown = FALSE;
        boolean rn_unknown = FALSE;

        if memop == MemOp_LOAD && pair && t == t2 then
             Constraint c = ConstrainUnpredictable();
             assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
             case c of
                  when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
                  when Constraint_UNDEF       UnallocatedEncoding();
                  when Constraint_NOP         EndOfInstruction();

        if memop == MemOp_STORE && excl then
             if s == t || (pair && s == t2) then
                  Constraint c = ConstrainUnpredictable();
                  assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                  case c of
                     when Constraint_UNKNOWN      rt_unknown = TRUE;       // store UNKNOWN value
           when Constraint_NONE       rt_unknown = FALSE;       // store original value
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();
   if s == n && n != 31 then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
           when Constraint_NONE       rn_unknown = FALSE;       // address is original base
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();

if n == 31 then
    CheckSPAlignment();
   address = SP[];
elsif rn_unknown then
   address = bits(64) UNKNOWN;
else
   address = X[n];

case memop of
   when MemOp_STORE
       if rt_unknown then
           data = bits(datasize) UNKNOWN;
       elsif pair then
           assert excl;
           bits(datasize DIV 2) el1 = X[t];
           bits(datasize DIV 2) el2 = X[t2];
           data = if BigEndian() then el1 : el2 else el2 : el1;
       else
           data = X[t];

       if excl then
           // store {release} exclusive register|pair (atomic)
           bit status = ''1'';
           // Check whether the Exclusive Monitors are set to include the
           // physical memory locations corresponding to virtual address
           // range [address, address+dbytes-1].
           if AArch64.ExclusiveMonitorsPass(address, dbytes) then
               // This atomic write will be rejected if it does not refer
               // to the same physical locations after address translation.
               Mem[address, dbytes, acctype] = data;
               status = ExclusiveMonitorsStatus();
           X[s] = ZeroExtend(status, 32);
       else
           // store release register (atomic)
           Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
       if excl then
           // Tell the Exclusive Monitors to record a sequence of one or more atomic
           // memory reads from virtual address range [address, address+dbytes-1].
           // The Exclusive Monitor will only be set if all the reads are from the
           // same dbytes-aligned physical address, to allow for the possibility of
           // an atomicity break if the translation is changed between reads.
           AArch64.SetExclusiveMonitors(address, dbytes);

       if pair then
           // load exclusive pair
           assert excl;
           if rt_unknown then
               // ConstrainedUNPREDICTABLE case
               X[t]   = bits(datasize) UNKNOWN;
           elsif elsize == 32 then
               // 32-bit load exclusive pair (atomic)
               data = Mem[address, dbytes, acctype];
               if BigEndian() then
                   X[t]   = data<datasize-1:elsize>;
                              X[t2] = data<elsize-1:0>;
                         else
                              X[t]  = data<elsize-1:0>;
                              X[t2] = data<datasize-1:elsize>;
                     else // elsize == 64
                         // 64-bit load exclusive pair (not atomic),
                         // but must be 128-bit aligned
                         if address != Align(address, dbytes) then
                             iswrite = FALSE;
                             secondstage = FALSE;
                             AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                         X[t]   = Mem[address + 0, 8, acctype];
                         X[t2] = Mem[address + 8, 8, acctype];
                  else
                     // load {acquire} {exclusive} single register
                     data = Mem[address, dbytes, acctype];
                      X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LDXRH','Load Exclusive Register Halfword loads a halfword from memory, zero-extends it and writes it to a register. The       (C6.6.112)
memory access is atomic. The PE marks the physical address being accessed as an exclusive access. This exclusive
access mark is checked by Store Exclusive instructions. See Synchronization and semaphores on page B2-103. For
information about memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4             0
   0 1 0 0 1 0 0 0 0 1 0 (1) (1) (1) (1) (1) 0 (1) (1) (1) (1) (1)            Rn              Rt
   size                    o2 L o1        Rs        o0       Rt2


No offset variant

LDXRH <Wt>, [<Xn|SP>{,#0}]


Decode for this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);    // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Assembler symbols

<Wt>           Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>        Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
     assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
     case c of
         when Constraint_UNKNOWN      rt_unknown = TRUE;      // result is UNKNOWN
         when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP          EndOfInstruction();

 if memop == MemOp_STORE && excl then
     if s == t || (pair && s == t2) then
         Constraint c = ConstrainUnpredictable();
         assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
         case c of
             when Constraint_UNKNOWN      rt_unknown = TRUE;       // store UNKNOWN value
                      when Constraint_NONE       rt_unknown = FALSE;       // store original value
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
                      when Constraint_NONE       rn_unknown = FALSE;       // address is original base
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
               X[t2] = data<elsize-1:0>;
          else
               X[t]  = data<elsize-1:0>;
               X[t2] = data<datasize-1:elsize>;
      else // elsize == 64
          // 64-bit load exclusive pair (not atomic),
          // but must be 128-bit aligned
          if address != Align(address, dbytes) then
              iswrite = FALSE;
              secondstage = FALSE;
              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
          X[t]   = Mem[address + 0, 8, acctype];
          X[t2] = Mem[address + 8, 8, acctype];
   else
      // load {acquire} {exclusive} single register
      data = Mem[address, dbytes, acctype];
       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','LSL','Logical shift left (register): Rd = LSL(Rn, Rm)       (C6.6.113)

This instruction is an alias of the LSLV instruction. This means that:

.       The encodings in this description are named to match the encodings of LSLV.

.       The description of LSLV gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9             5 4              0
    sf 0 0 1 1 0 1 0 1 1 0                  Rm          0 0 1 0 0 0             Rn              Rd
                                                                   op2


32-bit variant

Applies when sf = 0.

LSL <Wd>, <Wn>, <Wm>

is equivalent to

LSLV <Wd>, <Wn>, <Wm>

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

LSL <Xd>, <Xn>, <Xm>

is equivalent to

LSLV <Xd>, <Xn>, <Xm>

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding a shift amount from 0 to
                31 in its bottom 5 bits, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding a shift amount from 0 to
                63 in its bottom 6 bits, encoded in the "Rm" field.


Operation

The description of LSLV gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','LSLV','Logical shift left variable: Rd = LSL(Rn, Rm)       (C6.6.115)

This instruction is used by the alias LSL (register). The alias is always the preferred disassembly.




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4            0
    sf 0 0 1 1 0 1 0 1 1 0                  Rm         0 0 1 0 0 0              Rn              Rd
                                                                     op2


32-bit variant

Applies when sf = 0.

LSLV <Wd>, <Wn>, <Wm>


64-bit variant

Applies when sf = 1.

LSLV <Xd>, <Xn>, <Xm>


Decode for all variants of this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  integer datasize = if sf == ''1'' then 64 else 32;
  ShiftType shift_type = DecodeShift(op2);


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding a shift amount from 0 to
                31 in its bottom 5 bits, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding a shift amount from 0 to
                63 in its bottom 6 bits, encoded in the "Rm" field.


Operation

  bits(datasize) result;
  bits(datasize) operand2 = X[m];

  result = ShiftReg(n, shift_type, UInt(operand2) MOD datasize);
  X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','LSR','Logical shift right (register): Rd = LSR(Rn, Rm)       (C6.6.116)

This instruction is an alias of the LSRV instruction. This means that:

.      The encodings in this description are named to match the encodings of LSRV.

.      The description of LSRV gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9              5 4              0
   sf 0 0 1 1 0 1 0 1 1 0                   Rm         0 0 1 0 0 1              Rn              Rd
                                                                   op2


32-bit variant

Applies when sf = 0.

LSR <Wd>, <Wn>, <Wm>

is equivalent to

LSRV <Wd>, <Wn>, <Wm>

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

LSR <Xd>, <Xn>, <Xm>

is equivalent to

LSRV <Xd>, <Xn>, <Xm>

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding a shift amount from 0 to
                31 in its bottom 5 bits, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding a shift amount from 0 to
                63 in its bottom 6 bits, encoded in the "Rm" field.


Operation

The description of LSRV gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','LSRV','Logical shift right variable: Rd = LSR(Rn, Rm)       (C6.6.118)

This instruction is used by the alias LSR (register). The alias is always the preferred disassembly.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9               5 4             0
  sf 0 0 1 1 0 1 0 1 1 0                    Rm         0 0 1 0 0 1              Rn              Rd
                                                                     op2


32-bit variant

Applies when sf = 0.

LSRV <Wd>, <Wn>, <Wm>


64-bit variant

Applies when sf = 1.

LSRV <Xd>, <Xn>, <Xm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 ShiftType shift_type = DecodeShift(op2);


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding a shift amount from 0 to
                31 in its bottom 5 bits, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding a shift amount from 0 to
                63 in its bottom 6 bits, encoded in the "Rm" field.


Operation

 bits(datasize) result;
 bits(datasize) operand2 = X[m];

 result = ShiftReg(n, shift_type, UInt(operand2) MOD datasize);
 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','MADD','       Multiply-add: Rd = Ra + Rn * Rm       (C6.6.119)

       This instruction is used by the alias MUL. See the Alias conditions table for details of when each alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20            16 15 14          10 9              5 4             0
           sf 0 0 1 1 0 1 1 0 0 0                  Rm         0       Ra               Rn             Rd
                                                              o0


       32-bit variant

       Applies when sf = 0.

       MADD <Wd>, <Wn>, <Wm>, <Wa>


       64-bit variant

       Applies when sf = 1.

       MADD <Xd>, <Xn>, <Xm>, <Xa>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer a = UInt(Ra);
         integer destsize = if sf == ''1'' then 64 else 32;
         integer datasize = destsize;
         boolean sub_op = (o0 == ''1'');


       Alias conditions


                            Alias                     is preferred when

                            MUL                       Ra == ''11111''



       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                       the "Rn" field.

       <Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                       the "Rm" field.

       <Wa>            Is the 32-bit name of the third general-purpose source register holding the addend, encoded in the
                       "Ra" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>            Is the 64-bit name of the first general-purpose source register holding the multiplicand, encoded in
                       the "Rn" field.

       <Xm>            Is the 64-bit name of the second general-purpose source register holding the multiplier, encoded in
                       the "Rm" field.
<Xa>          Is the 64-bit name of the third general-purpose source register holding the addend, encoded in the
              "Ra" field.


Operation

 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];
 bits(destsize) operand3 = X[a];

 integer result;

 if sub_op then
    result = UInt(operand3) - (UInt(operand1) * UInt(operand2));
 else
    result = UInt(operand3) + (UInt(operand1) * UInt(operand2));

 X[d] = result<destsize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','MNEG','Multiply-negate: Rd = -(Rn * Rm)       (C6.6.120)

This instruction is an alias of the MSUB instruction. This means that:

.       The encodings in this description are named to match the encodings of MSUB.

.       The description of MSUB gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14          10 9             5 4              0
    sf 0 0 1 1 0 1 1 0 0 0                  Rm         1 1 1 1 1 1              Rn             Rd
                                                       o0      Ra


32-bit variant

Applies when sf = 0.

MNEG <Wd>, <Wn>, <Wm>

is equivalent to

MSUB <Wd>, <Wn>, <Wm>, WZR

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

MNEG <Xd>, <Xn>, <Xm>

is equivalent to

MSUB <Xd>, <Xn>, <Xm>, XZR

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

The description of MSUB gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','MOV','Move between register and stack pointer: Rd = Rn       (C6.6.121)

This instruction is an alias of the ADD (immediate) instruction. This means that:

.      The encodings in this description are named to match the encodings of ADD (immediate).

.      The description of ADD (immediate) gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                                   10 9              5 4              0
   sf 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0                                 Rn              Rd
     op S                     shift               imm12


32-bit variant

Applies when sf = 0.

MOV <Wd|WSP>, <Wn|WSP>

is equivalent to

ADD <Wd|WSP>, <Wn|WSP>, #0

and is the preferred disassembly when (Rd == ''11111'' || Rn == ''11111'').

64-bit variant

Applies when sf = 1.

MOV <Xd|SP>, <Xn|SP>

is equivalent to

ADD <Xd|SP>, <Xn|SP>, #0

and is the preferred disassembly when (Rd == ''11111'' || Rn == ''11111'').


Assembler symbols

<Wd|WSP>        Is the 32-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
                field.

<Wn|WSP>        Is the 32-bit name of the source general-purpose register or stack pointer, encoded in the "Rn" field.

<Xd|SP>         Is the 64-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
                field.

<Xn|SP>         Is the 64-bit name of the source general-purpose register or stack pointer, encoded in the "Rn" field.


Operation

The description of ADD (immediate) gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','MOVK','      Move 16-bit immediate into register, keeping other bits unchanged: Rd<shift+15:shift> = imm16       (C6.6.126)




          31 30 29 28 27 26 25 24 23 22 21 20                                               5 4               0
          sf 1 1 1 0 0 1 0 1           hw                        imm16                                Rd
              opc


      32-bit variant

      Applies when sf = 0.

      MOVK <Wd>, #<imm>{, LSL #<shift>}


      64-bit variant

      Applies when sf = 1.

      MOVK <Xd>, #<imm>{, LSL #<shift>}


      Decode for all variants of this encoding

        integer d = UInt(Rd);
        integer datasize = if sf == ''1'' then 64 else 32;
        bits(16) imm = imm16;
        integer pos;
        MoveWideOp opcode;

        case opc of
             when ''00'' opcode = MoveWideOp_N;
             when ''10'' opcode = MoveWideOp_Z;
             when ''11'' opcode = MoveWideOp_K;
             otherwise UnallocatedEncoding();

        if sf == ''0'' && hw<1> == ''1'' then UnallocatedEncoding();
        pos = UInt(hw:''0000'');


      Assembler symbols

      <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <imm>           Is the 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.

      <shift>         For the 32-bit variant: is the amount by which to shift the immediate left, either 0 (the default) or
                      16, encoded in the "hw" field as <shift>/16.

                      For the 64-bit variant: is the amount by which to shift the immediate left, either 0 (the default), 16,
                      32 or 48, encoded in the "hw" field as <shift>/16.


      Operation

        bits(datasize) result;

        if opcode == MoveWideOp_K then
             result = X[d];
        else
             result = Zeros();

        result<pos+15:pos> = imm;
if opcode == MoveWideOp_N then
   result = NOT(result);
X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','MOVN','       Move inverse of shifted 16-bit immediate to register: Rd = NOT (LSL (imm16, shift))       (C6.6.127)

       This instruction is used by the alias MOV (inverted wide immediate). See the Alias conditions table for details of
       when each alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20                                              5 4              0
           sf 0 0 1 0 0 1 0 1           hw                        imm16                               Rd
               opc


       32-bit variant

       Applies when sf = 0.

       MOVN <Wd>, #<imm>{, LSL #<shift>}


       64-bit variant

       Applies when sf = 1.

       MOVN <Xd>, #<imm>{, LSL #<shift>}


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer datasize = if sf == ''1'' then 64 else 32;
         bits(16) imm = imm16;
         integer pos;
         MoveWideOp opcode;

         case opc of
              when ''00'' opcode = MoveWideOp_N;
              when ''10'' opcode = MoveWideOp_Z;
              when ''11'' opcode = MoveWideOp_K;
              otherwise UnallocatedEncoding();

         if sf == ''0'' && hw<1> == ''1'' then UnallocatedEncoding();
         pos = UInt(hw:''0000'');


       Alias conditions


          Alias                  of variant         is preferred when

          MOV (inverted wide     64-bit             ! (IsZero(imm16) && hw != ''00'')
          immediate)

          MOV (inverted wide     32-bit             ! (IsZero(imm16) && hw != ''00'') && ! IsOnes(imm16)
          immediate)


       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <imm>           Is the 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.
<shift>       For the 32-bit variant: is the amount by which to shift the immediate left, either 0 (the default) or
              16, encoded in the "hw" field as <shift>/16.

              For the 64-bit variant: is the amount by which to shift the immediate left, either 0 (the default), 16,
              32 or 48, encoded in the "hw" field as <shift>/16.


Operation

 bits(datasize) result;

 if opcode == MoveWideOp_K then
    result = X[d];
 else
    result = Zeros();

 result<pos+15:pos> = imm;
 if opcode == MoveWideOp_N then
    result = NOT(result);
 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','MOVZ','       Move shifted 16-bit immediate to register: Rd = LSL (imm16, shift)       (C6.6.128)

       This instruction is used by the alias MOV (wide immediate). See the Alias conditions table for details of when each
       alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20                                                5 4               0
           sf 1 0 1 0 0 1 0 1            hw                        imm16                                Rd
               opc


       32-bit variant

       Applies when sf = 0.

       MOVZ <Wd>, #<imm>{, LSL #<shift>}


       64-bit variant

       Applies when sf = 1.

       MOVZ <Xd>, #<imm>{, LSL #<shift>}


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer datasize = if sf == ''1'' then 64 else 32;
         bits(16) imm = imm16;
         integer pos;
         MoveWideOp opcode;

         case opc of
              when ''00'' opcode = MoveWideOp_N;
              when ''10'' opcode = MoveWideOp_Z;
              when ''11'' opcode = MoveWideOp_K;
              otherwise UnallocatedEncoding();

         if sf == ''0'' && hw<1> == ''1'' then UnallocatedEncoding();
         pos = UInt(hw:''0000'');


       Alias conditions


                             Alias                     is preferred when

                             MOV (wide                 ! (IsZero(imm16) && hw != ''00'')
                             immediate)


       Assembler symbols

       <Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <imm>            Is the 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.

       <shift>          For the 32-bit variant: is the amount by which to shift the immediate left, either 0 (the default) or
                        16, encoded in the "hw" field as <shift>/16.

                        For the 64-bit variant: is the amount by which to shift the immediate left, either 0 (the default), 16,
                        32 or 48, encoded in the "hw" field as <shift>/16.
Operation

 bits(datasize) result;

 if opcode == MoveWideOp_K then
    result = X[d];
 else
    result = Zeros();

 result<pos+15:pos> = imm;
 if opcode == MoveWideOp_N then
    result = NOT(result);
 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','MRS','Move from system register       (C6.6.129)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18     16 15       12 11         8 7      5 4              0
    1 1 0 1 0 1 0 1 0 0 1 1 o0                op1        CRn         CRm          op2          Rt
                                   L


System variant

MRS <Xt>, <systemreg>


Decode for this encoding

  CheckSystemAccess(''1'':o0, op1, CRn, CRm, op2, Rt, L);

  integer t = UInt(Rt);

  integer sys_op0 = 2 + UInt(o0);
  integer sys_op1 = UInt(op1);
  integer sys_op2 = UInt(op2);
  integer sys_crn = UInt(CRn);
  integer sys_crm = UInt(CRm);
  boolean read = (L == ''1'');


Assembler symbols

<Xt>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rt" field.

<systemreg>     Is a system register name, encoded in the "o0:op1:CRn:CRm:op2".


Operation

  if read then
       X[t] = System_Get(sys_op0, sys_op1, sys_crn, sys_crm, sys_op2);
  else
       System_Put(sys_op0, sys_op1, sys_crn, sys_crm, sys_op2, X[t]);');
INSERT INTO "instructions" VALUES('ARM','MSR','Move immediate to process state field       (C6.6.130)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18     16 15 14 13 12 11        8 7       5 4 3 2 1 0
  1 1 0 1 0 1 0 1 0 0 0 0 0                op1      0 1 0 0         CRm        op2    1 1 1 1 1




System variant

MSR <pstatefield>, #<imm>


Decode for this encoding

 CheckSystemAccess(''00'', op1, ''0100'', CRm, op2, ''11111'', ''0'');

 bits(4) operand = CRm;
 PSTATEField field;
 case op1:op2 of
     when ''000 101'' field = PSTATEField_SP;
     when ''011 110'' field = PSTATEField_DAIFSet;
     when ''011 111'' field = PSTATEField_DAIFClr;
     otherwise       UnallocatedEncoding();

 // Check that an AArch64 MSR/MRS access to the DAIF flags is permitted
 if op1 == ''011'' && PSTATE.EL == EL0 && SCTLR_EL1.UMA == ''0'' then
     AArch64.SystemRegisterTrap(EL1, ''00'', op2, op1, ''0100'', ''11111'', CRm, ''0'');


Assembler symbols

<pstatefield> Is a PSTATE field name, encoded in the "op1:op2" field. It can have the following values:

              SPSel       when op1 = 000, op2 = 101

              DAIFSet     when op1 = 011, op2 = 110

              DAIFClr     when op1 = 011, op2 = 111

              It is RESERVED when:

              .      op1 = 000, op2 = 0xx.

              .      op1 = 000, op2 = 100.

              .      op1 = 000, op2 = 11x.

              .      op1 = 001, op2 = xxx.

              .      op1 = 010, op2 = xxx.

              .      op1 = 011, op2 = 0xx.

              .      op1 = 011, op2 = 10x.

              .      op1 = 1xx, op2 = xxx.

<imm>         Is a 4-bit unsigned immediate, in the range 0 to 15, encoded in the "CRm" field.


Operation

 case field of
     when PSTATEField_SP
        PSTATE.SP = operand<0>;
     when PSTATEField_DAIFSet
        PSTATE.D = PSTATE.D OR operand<3>;
        PSTATE.A = PSTATE.A OR operand<2>;
                   PSTATE.I = PSTATE.I OR operand<1>;
                   PSTATE.F = PSTATE.F OR operand<0>;
              when PSTATEField_DAIFClr
                   PSTATE.D = PSTATE.D AND NOT(operand<3>);
                   PSTATE.A = PSTATE.A AND NOT(operand<2>);
                   PSTATE.I = PSTATE.I AND NOT(operand<1>);
                   PSTATE.F = PSTATE.F AND NOT(operand<0>);');
INSERT INTO "instructions" VALUES('ARM','MSUB','       Multiply-subtract: Rd = Ra - Rn * Rm       (C6.6.132)

       This instruction is used by the alias MNEG. See the Alias conditions table for details of when each alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20            16 15 14          10 9              5 4             0
           sf 0 0 1 1 0 1 1 0 0 0                  Rm         1       Ra               Rn              Rd
                                                              o0


       32-bit variant

       Applies when sf = 0.

       MSUB <Wd>, <Wn>, <Wm>, <Wa>


       64-bit variant

       Applies when sf = 1.

       MSUB <Xd>, <Xn>, <Xm>, <Xa>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer a = UInt(Ra);
         integer destsize = if sf == ''1'' then 64 else 32;
         integer datasize = destsize;
         boolean sub_op = (o0 == ''1'');


       Alias conditions


                             Alias                    is preferred when

                             MNEG                     Ra == ''11111''



       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                       the "Rn" field.

       <Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                       the "Rm" field.

       <Wa>            Is the 32-bit name of the third general-purpose source register holding the minuend, encoded in the
                       "Ra" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>            Is the 64-bit name of the first general-purpose source register holding the multiplicand, encoded in
                       the "Rn" field.

       <Xm>            Is the 64-bit name of the second general-purpose source register holding the multiplier, encoded in
                       the "Rm" field.
<Xa>          Is the 64-bit name of the third general-purpose source register holding the minuend, encoded in the
              "Ra" field.


Operation

 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];
 bits(destsize) operand3 = X[a];

 integer result;

 if sub_op then
    result = UInt(operand3) - (UInt(operand1) * UInt(operand2));
 else
    result = UInt(operand3) + (UInt(operand1) * UInt(operand2));

 X[d] = result<destsize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','MUL','Multiply: Rd = Rn * Rm       (C6.6.133)

This instruction is an alias of the MADD instruction. This means that:

.       The encodings in this description are named to match the encodings of MADD.

.       The description of MADD gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14          10 9             5 4              0
    sf 0 0 1 1 0 1 1 0 0 0                  Rm         0 1 1 1 1 1              Rn             Rd
                                                       o0      Ra


32-bit variant

Applies when sf = 0.

MUL <Wd>, <Wn>, <Wm>

is equivalent to

MADD <Wd>, <Wn>, <Wm>, WZR

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

MUL <Xd>, <Xn>, <Xm>

is equivalent to

MADD <Xd>, <Xn>, <Xm>, XZR

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

The description of MADD gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','MVN','Bitwise NOT (shifted register): Rd = NOT shift(Rm, amount)       (C6.6.134)

This instruction is an alias of the ORN (shifted register) instruction. This means that:

.      The encodings in this description are named to match the encodings of ORN (shifted register).

.      The description of ORN (shifted register) gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20                16 15              10 9             5 4             0
   sf 0 1 0 1 0 1 0 shift 1                  Rm               imm6          1 1 1 1 1             Rd
      opc                           N                                             Rn


32-bit variant

Applies when sf = 0.

MVN <Wd>, <Wm>{, <shift> #<amount>}

is equivalent to

ORN <Wd>, WZR, <Wm>{, <shift> #<amount>}

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

MVN <Xd>, <Xm>{, <shift> #<amount>}

is equivalent to

ORN <Xd>, XZR, <Xm>{, <shift> #<amount>}

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wm>            Is the 32-bit name of the general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xm>            Is the 64-bit name of the general-purpose source register, encoded in the "Rm" field.

<shift>         Is the optional shift to be applied to the final source, defaulting to LSL and encoded in the "shift"
                field. It can have the following values:

                LSL          when shift = 00

                LSR          when shift = 01

                ASR          when shift = 10

                ROR          when shift = 11

<amount>        For the 32-bit variant: is the shift amount, in the range 0 to 31, defaulting to 0 and encoded in the
                "imm6" field.

                For the 64-bit variant: is the shift amount, in the range 0 to 63, defaulting to 0 and encoded in the
                "imm6" field.
       Operation

       The description of ORN (shifted register) gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','NEG','Negate: Rd = 0 - shift(Rm, amount)       (C6.6.135)

This instruction is an alias of the SUB (shifted register) instruction. This means that:

.      The encodings in this description are named to match the encodings of SUB (shifted register).

.      The description of SUB (shifted register) gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20                16 15              10 9            5 4              0
   sf 1 0 0 1 0 1 1 shift 0                   Rm               imm6        1 1 1 1 1              Rd
     op S                                                                        Rn


32-bit variant

Applies when sf = 0.

NEG <Wd>, <Wm>{, <shift> #<amount>}

is equivalent to

SUB  <Wd>, WZR, <Wm> {, <shift> #<amount>}

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

NEG <Xd>, <Xm>{, <shift> #<amount>}

is equivalent to

SUB  <Xd>, XZR, <Xm> {, <shift> #<amount>}

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wm>            Is the 32-bit name of the general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xm>            Is the 64-bit name of the general-purpose source register, encoded in the "Rm" field.

<shift>         Is the optional shift type to be applied to the second source operand, defaulting to LSL and encoded
                in the "shift" field. It can have the following values:

                LSL          when shift = 00

                LSR          when shift = 01

                ASR          when shift = 10

                It is RESERVED when shift = 11.

<amount>        For the 32-bit variant: is the shift amount, in the range 0 to 31, defaulting to 0 and encoded in the
                "imm6" field.

                For the 64-bit variant: is the shift amount, in the range 0 to 63, defaulting to 0 and encoded in the
                "imm6" field.
       Operation

       The description of SUB (shifted register) gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','NEGS','Negate, setting the condition flags: Rd = 0 - shift(Rm, amount)       (C6.6.136)

This instruction is an alias of the SUBS (shifted register) instruction. This means that:

.      The encodings in this description are named to match the encodings of SUBS (shifted register).

.      The description of SUBS (shifted register) gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20                16 15              10 9            5 4              0
   sf 1 1 0 1 0 1 1 shift 0                   Rm               imm6        1 1 1 1 1              Rd
     op S                                                                        Rn


32-bit variant

Applies when sf = 0.

NEGS <Wd>, <Wm>{, <shift> #<amount>}

is equivalent to

SUBS <Wd>, WZR, <Wm> {, <shift> #<amount>}

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

NEGS <Xd>, <Xm>{, <shift> #<amount>}

is equivalent to

SUBS <Xd>, XZR, <Xm> {, <shift> #<amount>}

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wm>            Is the 32-bit name of the general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xm>            Is the 64-bit name of the general-purpose source register, encoded in the "Rm" field.

<shift>         Is the optional shift type to be applied to the second source operand, defaulting to LSL and encoded
                in the "shift" field. It can have the following values:

                LSL          when shift = 00

                LSR          when shift = 01

                ASR          when shift = 10

                It is RESERVED when shift = 11.

<amount>        For the 32-bit variant: is the shift amount, in the range 0 to 31, defaulting to 0 and encoded in the
                "imm6" field.

                For the 64-bit variant: is the shift amount, in the range 0 to 63, defaulting to 0 and encoded in the
                "imm6" field.
       Operation

       The description of SUBS (shifted register) gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','NGC','Negate with carry: Rd = 0 - Rm - 1 + C       (C6.6.137)

This instruction is an alias of the SBC instruction. This means that:

.      The encodings in this description are named to match the encodings of SBC.

.      The description of SBC gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9             5 4              0
   sf 1 0 1 1 0 1 0 0 0 0                   Rm         0 0 0 0 0 0 1 1 1 1 1                   Rd
     op S                                                                      Rn


32-bit variant

Applies when sf = 0.

NGC <Wd>, <Wm>

is equivalent to

SBC <Wd>, WZR, <Wm>

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

NGC <Xd>, <Xm>

is equivalent to

SBC <Xd>, XZR, <Xm>

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wm>            Is the 32-bit name of the general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xm>            Is the 64-bit name of the general-purpose source register, encoded in the "Rm" field.


Operation

The description of SBC gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','NGCS','Negate with carry, setting the condition flags: Rd = 0 - Rm - 1 + C       (C6.6.138)

This instruction is an alias of the SBCS instruction. This means that:

.       The encodings in this description are named to match the encodings of SBCS.

.       The description of SBCS gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9            5 4              0
    sf 1 1 1 1 0 1 0 0 0 0                  Rm         0 0 0 0 0 0 1 1 1 1 1                   Rd
       op S                                                                    Rn


32-bit variant

Applies when sf = 0.

NGCS <Wd>, <Wm>

is equivalent to

SBCS <Wd>, WZR, <Wm>

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

NGCS <Xd>, <Xm>

is equivalent to

SBCS <Xd>, XZR, <Xm>

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wm>            Is the 32-bit name of the general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xm>            Is the 64-bit name of the general-purpose source register, encoded in the "Rm" field.


Operation

The description of SBCS gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','NOP','No operation       (C6.6.139)

This instruction is an alias of the HINT instruction. This means that:

.      The encodings in this description are named to match the encodings of HINT.

.      The description of HINT gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11          8 7       5 4 3 2 1 0
   1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1
                                                                      CRm      op2


System variant

NOP

is equivalent to

HINT #0

and is always the preferred disassembly.


Operation

The description of HINT gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','ORN','       Bitwise inclusive OR NOT (shifted register): Rd = Rn OR NOT shift(Rm, amount)       (C6.6.140)

       This instruction is used by the alias MVN. See the Alias conditions table for details of when each alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20            16 15             10 9              5 4             0
           sf 0 1 0 1 0 1 0 shift 1                Rm              imm6                Rn              Rd
               opc                         N


       32-bit variant

       Applies when sf = 0.

       ORN <Wd>, <Wn>, <Wm>{, <shift> #<amount>}


       64-bit variant

       Applies when sf = 1.

       ORN <Xd>, <Xn>, <Xm>{, <shift> #<amount>}


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer datasize = if sf == ''1'' then 64 else 32;
         boolean setflags;
         LogicalOp op;
         case opc of
              when ''00'' op = LogicalOp_AND; setflags = FALSE;
              when ''01'' op = LogicalOp_ORR; setflags = FALSE;
              when ''10'' op = LogicalOp_EOR; setflags = FALSE;
              when ''11'' op = LogicalOp_AND; setflags = TRUE;

         if sf == ''0'' && imm6<5> == ''1'' then ReservedValue();

         ShiftType shift_type = DecodeShift(shift);
         integer shift_amount = UInt(imm6);
         boolean invert = (N == ''1'');


       Alias conditions


                            Alias                     is preferred when

                            MVN                       Rn == ''11111''



       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

       <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.
<Xm>          Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.

<shift>       Is the optional shift to be applied to the final source, defaulting to LSL and encoded in the "shift"
              field. It can have the following values:

              LSL          when shift = 00

              LSR          when shift = 01

              ASR          when shift = 10

              ROR          when shift = 11

<amount>      For the 32-bit variant: is the shift amount, in the range 0 to 31, defaulting to 0 and encoded in the
              "imm6" field.

              For the 64-bit variant: is the shift amount, in the range 0 to 63, defaulting to 0 and encoded in the
              "imm6" field.


Operation

 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = ShiftReg(m, shift_type, shift_amount);

 if invert then operand2 = NOT(operand2);

 case op of
    when LogicalOp_AND result = operand1 AND operand2;
    when LogicalOp_ORR result = operand1 OR        operand2;
    when LogicalOp_EOR result = operand1 EOR operand2;

 if setflags then
    PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ORR','       Bitwise inclusive OR (immediate): Rd = Rn OR imm       (C6.6.141)

       This instruction is used by the alias MOV (bitmask immediate). See the Alias conditions table for details of when
       each alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21               16 15             10 9             5 4             0
           sf 0 1 1 0 0 1 0 0 N                 immr               imms               Rn               Rd
               opc


       32-bit variant

       Applies when sf = 0 && N = 0.

       ORR <Wd|WSP>, <Wn>, #<imm>


       64-bit variant

       Applies when sf = 1.

       ORR <Xd|SP>, <Xn>, #<imm>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer datasize = if sf == ''1'' then 64 else 32;
         boolean setflags;
         LogicalOp op;
         case opc of
              when ''00'' op = LogicalOp_AND; setflags = FALSE;
              when ''01'' op = LogicalOp_ORR; setflags = FALSE;
              when ''10'' op = LogicalOp_EOR; setflags = FALSE;
              when ''11'' op = LogicalOp_AND; setflags = TRUE;

         bits(datasize) imm;
         if sf == ''0'' && N != ''0'' then ReservedValue();
         (imm, -) = DecodeBitMasks(N, imms, immr, TRUE);


       Alias conditions


                            Alias                    is preferred when

                            MOV (bitmask             Rn == ''11111'' && ! MoveWidePreferred(sf, N, imms, immr)
                            immediate)


       Assembler symbols

       <Wd|WSP>        Is the 32-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
                       field.

       <Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

       <Xd|SP>         Is the 64-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
                       field.

       <Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.
<imm>         Is the bitmask immediate, encoded in "N:imms:immr".


Operation

 bits(datasize) result;
 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = imm;

 case op of
    when LogicalOp_AND result = operand1 AND operand2;
    when LogicalOp_ORR result = operand1 OR   operand2;
    when LogicalOp_EOR result = operand1 EOR operand2;

 if setflags then
    PSTATE.<N,Z,C,V> = result<datasize-1>:IsZeroBit(result):''00'';

 if d == 31 && !setflags then
     SP[] = result;
 else
     X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','PRFM','       Prefetch memory (immediate offset)       (C6.6.143)




           31 30 29 28 27 26 25 24 23 22 21                                   10 9             5 4             0
           1 1 1 1 1 0 0 1 1 0                          imm12                           Rn               Rt
           size                     opc


       Unsigned offset variant

       PRFM <prfop>, [<Xn|SP>{, #<pimm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);


       Assembler symbols

       <prfop>         Is the prefetch operation, encoded in the "Rt" field. It can have the following values:

                       PLDL1KEEP   when Rt = 00000

                       PLDL1STRM   when Rt = 00001

                       PLDL2KEEP   when Rt = 00010

                       PLDL2STRM   when Rt = 00011

                       PLDL3KEEP   when Rt = 00100

                       PLDL3STRM   when Rt = 00101

                       #uimm5      when Rt = 0011x

                       PLIL1KEEP   when Rt = 01000

                       PLIL1STRM   when Rt = 01001

                       PLIL2KEEP   when Rt = 01010

                       PLIL2STRM   when Rt = 01011

                       PLIL3KEEP   when Rt = 01100

                       PLIL3STRM   when Rt = 01101

                       #uimm5      when Rt = 0111x

                       PSTL1KEEP   when Rt = 10000

                       PSTL1STRM   when Rt = 10001

                       PSTL2KEEP   when Rt = 10010

                       PSTL2STRM   when Rt = 10011

                       PSTL3KEEP   when Rt = 10100

                       PSTL3STRM   when Rt = 10101

                       #uimm5      when Rt = 1011x

                       #uimm5      when Rt = 11xxx

       <Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <pimm>          Is the optional positive immediate byte offset, a multiple of 8 in the range 0 to 32760, defaulting to
                       0 and encoded in the "imm12" field as <pimm>/8.
Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_NORMAL;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
    // store or zero-extending load
    memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
    regsize = if size == ''11'' then 64 else 32;
    signed = FALSE;
 else
    if size == ''11'' then
         memop = MemOp_PREFETCH;
         if opc<0> == ''1'' then UnallocatedEncoding();
    else
         // sign-extending load
         memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','PRFUM','       Prefetch memory (unscaled offset)       (C6.6.146)




           31 30 29 28 27 26 25 24 23 22 21 20                        12 11 10 9              5 4             0
           1 1 1 1 1 0 0 0 1 0 0                       imm9               0 0          Rn              Rt
           size                     opc


       Unscaled offset variant

       PRFUM <prfop>, [<Xn|SP>{, #<simm>}]


       Decode for this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = SignExtend(imm9, 64);


       Assembler symbols

       <prfop>         Is the prefetch operation, encoded in the "Rt" field. It can have the following values:

                       PLDL1KEEP   when Rt = 00000

                       PLDL1STRM   when Rt = 00001

                       PLDL2KEEP   when Rt = 00010

                       PLDL2STRM   when Rt = 00011

                       PLDL3KEEP   when Rt = 00100

                       PLDL3STRM   when Rt = 00101

                       #uimm5      when Rt = 0011x

                       PLIL1KEEP   when Rt = 01000

                       PLIL1STRM   when Rt = 01001

                       PLIL2KEEP   when Rt = 01010

                       PLIL2STRM   when Rt = 01011

                       PLIL3KEEP   when Rt = 01100

                       PLIL3STRM   when Rt = 01101

                       #uimm5      when Rt = 0111x

                       PSTL1KEEP   when Rt = 10000

                       PSTL1STRM   when Rt = 10001

                       PSTL2KEEP   when Rt = 10010

                       PSTL2STRM   when Rt = 10011

                       PSTL3KEEP   when Rt = 10100

                       PSTL3STRM   when Rt = 10101

                       #uimm5      when Rt = 1011x

                       #uimm5      when Rt = 11xxx

       <Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>          Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                       in the "imm9" field.
Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_NORMAL;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
    // store or zero-extending load
    memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
    regsize = if size == ''11'' then 64 else 32;
    signed = FALSE;
 else
    if size == ''11'' then
         memop = MemOp_PREFETCH;
         if opc<0> == ''1'' then UnallocatedEncoding();
    else
         // sign-extending load
         memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','RBIT','Reverse bit order       (C6.6.147)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                5 4              0
  sf 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0                                Rn              Rd
                                                                  opc


32-bit variant

Applies when sf = 0.

RBIT <Wd>, <Wn>


64-bit variant

Applies when sf = 1.

RBIT <Xd>, <Xn>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer datasize = if sf == ''1'' then 64 else 32;

 RevOp op;
 case opc of
     when ''00''
         op = RevOp_RBIT;
     when ''01''
        op = RevOp_REV16;
     when ''10''
        op = RevOp_REV32;
     when ''11''
        if sf == ''0'' then UnallocatedEncoding();
        op = RevOp_REV64;


Assembler symbols

<Wd>           Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>           Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>           Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>           Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

 bits(datasize) result;
 bits(6) V;
 integer vbit;

 case op of
     when RevOp_REV16 V = ''001000'';
     when RevOp_REV32 V = ''011000'';
     when RevOp_REV64 V = ''111000'';
     when RevOp_RBIT   V = if datasize == 64 then ''111111'' else ''011111'';
         result = X[n];
         for vbit = 0 to 5
              // Swap pairs of 2^vbit bits in result
              if V<vbit> == ''1'' then
                   bits(datasize) tmp = result;
                   integer vsize = 1 << vbit;
                   integer base = 0;
                   while base < datasize do
                      result<base+vsize-1:base> = tmp<base+(2*vsize)-1:base+vsize>;
                      result<base+(2*vsize)-1:base+vsize> = tmp<base+vsize-1:base>;
                      base = base + (2 * vsize);
         X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','RET','Return from subroutine branches unconditionally to an address in a register, with a hint that this is a subroutine       (C6.6.148)
return.




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                5 4 3 2 1 0
   1 1 0 1 0 1 1 0 0 1 0 1 1 1 1 1 0 0 0 0 0 0                               Rn          0 0 0 0 0
                              op


Integer variant

RET {<Xn>}


Decode for this encoding

 integer n = UInt(Rn);
 BranchType branch_type;

 case op of
     when ''00'' branch_type = BranchType_JMP;
     when ''01'' branch_type = BranchType_CALL;
     when ''10'' branch_type = BranchType_RET;
     otherwise UnallocatedEncoding();


Assembler symbols

<Xn>          Is the 64-bit name of the general-purpose register holding the address to be branched to, encoded in
              the "Rn" field. Defaults to X30 if absent.


Operation

 bits(64) target = X[n];

 if branch_type == BranchType_CALL then X[30] = PC[] + 4;
 BranchTo(target, branch_type);');
INSERT INTO "instructions" VALUES('ARM','REV','      Reverse bytes       (C6.6.149)




          31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9               5 4              0
          sf 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 1 x                                Rn              Rd
                                                                          opc


      32-bit variant

      Applies when sf = 0 && opc = 10.

      REV <Wd>, <Wn>


      64-bit variant

      Applies when sf = 1 && opc = 11.

      REV <Xd>, <Xn>


      Decode for all variants of this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);

        integer datasize = if sf == ''1'' then 64 else 32;

        RevOp op;
        case opc of
             when ''00''
                  op = RevOp_RBIT;
             when ''01''
                  op = RevOp_REV16;
             when ''10''
                  op = RevOp_REV32;
             when ''11''
                  if sf == ''0'' then UnallocatedEncoding();
                  op = RevOp_REV64;


      Assembler symbols

      <Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>             Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

      <Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Xn>             Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.


      Operation

        bits(datasize) result;
        bits(6) V;
        integer vbit;

        case op of
             when RevOp_REV16 V = ''001000'';
             when RevOp_REV32 V = ''011000'';
             when RevOp_REV64 V = ''111000'';
             when RevOp_RBIT   V = if datasize == 64 then ''111111'' else ''011111'';
result = X[n];
for vbit = 0 to 5
    // Swap pairs of 2^vbit bits in result
    if V<vbit> == ''1'' then
       bits(datasize) tmp = result;
       integer vsize = 1 << vbit;
       integer base = 0;
       while base < datasize do
            result<base+vsize-1:base> = tmp<base+(2*vsize)-1:base+vsize>;
            result<base+(2*vsize)-1:base+vsize> = tmp<base+vsize-1:base>;
            base = base + (2 * vsize);
X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','REV16','      Reverse bytes in 16-bit halfwords       (C6.6.150)




          31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9               5 4              0
          sf 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1                                Rn              Rd
                                                                          opc


      32-bit variant

      Applies when sf = 0.

      REV16 <Wd>, <Wn>


      64-bit variant

      Applies when sf = 1.

      REV16 <Xd>, <Xn>


      Decode for all variants of this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);

        integer datasize = if sf == ''1'' then 64 else 32;

        RevOp op;
        case opc of
             when ''00''
                  op = RevOp_RBIT;
             when ''01''
                  op = RevOp_REV16;
             when ''10''
                  op = RevOp_REV32;
             when ''11''
                  if sf == ''0'' then UnallocatedEncoding();
                  op = RevOp_REV64;


      Assembler symbols

      <Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>             Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

      <Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Xn>             Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.


      Operation

        bits(datasize) result;
        bits(6) V;
        integer vbit;

        case op of
             when RevOp_REV16 V = ''001000'';
             when RevOp_REV32 V = ''011000'';
             when RevOp_REV64 V = ''111000'';
             when RevOp_RBIT   V = if datasize == 64 then ''111111'' else ''011111'';
result = X[n];
for vbit = 0 to 5
    // Swap pairs of 2^vbit bits in result
    if V<vbit> == ''1'' then
       bits(datasize) tmp = result;
       integer vsize = 1 << vbit;
       integer base = 0;
       while base < datasize do
            result<base+vsize-1:base> = tmp<base+(2*vsize)-1:base+vsize>;
            result<base+(2*vsize)-1:base+vsize> = tmp<base+vsize-1:base>;
            base = base + (2 * vsize);
X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','REV32','Reverse bytes in 32-bit words       (C6.6.151)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9               5 4              0
    1 1 0 1 1 0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 1 0                                 Rn              Rd
    sf                                                              opc


64-bit variant

REV32 <Xd>, <Xn>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  integer datasize = if sf == ''1'' then 64 else 32;

  RevOp op;
  case opc of
       when ''00''
            op = RevOp_RBIT;
       when ''01''
            op = RevOp_REV16;
       when ''10''
            op = RevOp_REV32;
       when ''11''
            if sf == ''0'' then UnallocatedEncoding();
            op = RevOp_REV64;


Assembler symbols

<Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>             Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

  bits(datasize) result;
  bits(6) V;
  integer vbit;

  case op of
       when RevOp_REV16 V = ''001000'';
       when RevOp_REV32 V = ''011000'';
       when RevOp_REV64 V = ''111000'';
       when RevOp_RBIT   V = if datasize == 64 then ''111111'' else ''011111'';

  result = X[n];
  for vbit = 0 to 5
       // Swap pairs of 2^vbit bits in result
       if V<vbit> == ''1'' then
            bits(datasize) tmp = result;
            integer vsize = 1 << vbit;
            integer base = 0;
            while base < datasize do
               result<base+vsize-1:base> = tmp<base+(2*vsize)-1:base+vsize>;
               result<base+(2*vsize)-1:base+vsize> = tmp<base+vsize-1:base>;
               base = base + (2 * vsize);
  X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ROR','Rotate right (immediate): Rd = ROR(Rs, shift)       (C6.6.152)

This instruction is an alias of the EXTR instruction. This means that:

.      The encodings in this description are named to match the encodings of EXTR.

.      The description of EXTR gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15              10 9              5 4              0
   sf 0 0 1 0 0 1 1 1 N 0                    Rm             imms                 Rn              Rd




32-bit variant

Applies when sf = 0 && N = 0 && imms = 0xxxxx.

ROR <Wd>, <Ws>, #<shift>

is equivalent to

EXTR <Wd>, <Ws>, <Ws>, #<shift>

and is the preferred disassembly when Rn == Rm.

64-bit variant

Applies when sf = 1 && N = 1.

ROR <Xd>, <Xs>, #<shift>

is equivalent to

EXTR <Xd>, <Xs>, <Xs>, #<shift>

and is the preferred disassembly when Rn == Rm.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Ws>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xs>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" and "Rm" fields.

<shift>         For the 32-bit variant: is the amount by which to rotate, in the range 0 to 31, encoded in the "imms"
                field.

                For the 64-bit variant: is the amount by which to rotate, in the range 0 to 63, encoded in the "imms"
                field.


Operation

The description of EXTR gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','RORV','Rotate right variable: Rd = ROR(Rn, Rm)       (C6.6.154)

This instruction is used by the alias ROR (register). The alias is always the preferred disassembly.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9              5 4              0
  sf 0 0 1 1 0 1 0 1 1 0                    Rm         0 0 1 0 1 1              Rn              Rd
                                                                     op2


32-bit variant

Applies when sf = 0.

RORV <Wd>, <Wn>, <Wm>


64-bit variant

Applies when sf = 1.

RORV <Xd>, <Xn>, <Xm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 ShiftType shift_type = DecodeShift(op2);


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding a shift amount from 0 to
                31 in its bottom 5 bits, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding a shift amount from 0 to
                63 in its bottom 6 bits, encoded in the "Rm" field.


Operation

 bits(datasize) result;
 bits(datasize) operand2 = X[m];

 result = ShiftReg(n, shift_type, UInt(operand2) MOD datasize);
 X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SBC','      Subtract with carry: Rd = Rn - Rm - 1 + C       (C6.6.155)

      This instruction is used by the alias NGC. See the Alias conditions table for details of when each alias is preferred.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9              5 4             0
          sf 1 0 1 1 0 1 0 0 0 0                  Rm         0 0 0 0 0 0              Rn              Rd
             op S


      32-bit variant

      Applies when sf = 0.

      SBC <Wd>, <Wn>, <Wm>


      64-bit variant

      Applies when sf = 1.

      SBC <Xd>, <Xn>, <Xm>


      Decode for all variants of this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        integer datasize = if sf == ''1'' then 64 else 32;
        boolean sub_op = (op == ''1'');
        boolean setflags = (S == ''1'');


      Alias conditions


                           Alias                     is preferred when

                           NGC                       Rn == ''11111''



      Assembler symbols

      <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

      <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.


      Operation

        bits(datasize) result;
        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = X[m];
        bits(4) nzcv;

        if sub_op then
   operand2 = NOT(operand2);

(result, nzcv) = AddWithCarry(operand1, operand2, PSTATE.C);

if setflags then
   PSTATE.<N,Z,C,V> = nzcv;

X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SBCS','      Subtract with carry, setting the condition flags: Rd = Rn - Rm - 1 + C       (C6.6.156)

      This instruction is used by the alias NGCS. See the Alias conditions table for details of when each alias is preferred.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4            0
          sf 1 1 1 1 0 1 0 0 0 0                  Rm         0 0 0 0 0 0              Rn              Rd
             op S


      32-bit variant

      Applies when sf = 0.

      SBCS <Wd>, <Wn>, <Wm>


      64-bit variant

      Applies when sf = 1.

      SBCS <Xd>, <Xn>, <Xm>


      Decode for all variants of this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        integer datasize = if sf == ''1'' then 64 else 32;
        boolean sub_op = (op == ''1'');
        boolean setflags = (S == ''1'');


      Alias conditions


                           Alias                     is preferred when

                           NGCS                      Rn == ''11111''



      Assembler symbols

      <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

      <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.


      Operation

        bits(datasize) result;
        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = X[m];
        bits(4) nzcv;

        if sub_op then
   operand2 = NOT(operand2);

(result, nzcv) = AddWithCarry(operand1, operand2, PSTATE.C);

if setflags then
   PSTATE.<N,Z,C,V> = nzcv;

X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SBFIZ','Signed bitfield insert in zero, with sign replication to left and zeros to right       (C6.6.157)

This instruction is an alias of the SBFM instruction. This means that:

.       The encodings in this description are named to match the encodings of SBFM.

.       The description of SBFM gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21                16 15                10 9            5 4               0
    sf 0 0 1 0 0 1 1 0 N                  immr                 imms               Rn               Rd
        opc


32-bit variant

Applies when sf = 0 && N = 0.

SBFIZ <Wd>, <Wn>, #<lsb>, #<width>

is equivalent to

SBFM <Wd>, <Wn>, #(-<lsb> MOD 32), #(<width>-1)

and is the preferred disassembly when UInt(imms) < UInt(immr).

64-bit variant

Applies when sf = 1 && N = 1.

SBFIZ <Xd>, <Xn>, #<lsb>, #<width>

is equivalent to

SBFM <Xd>, <Xn>, #(-<lsb> MOD 64), #(<width>-1)

and is the preferred disassembly when UInt(imms) < UInt(immr).


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<lsb>           For the 32-bit variant: is the bit number of the lsb of the destination bitfield, in the range 0 to 31.

                For the 64-bit variant: is the bit number of the lsb of the destination bitfield, in the range 0 to 63.

<width>         For the 32-bit variant: is the width of the bitfield, in the range 1 to 32-<lsb>.

                For the 64-bit variant: is the width of the bitfield, in the range 1 to 64-<lsb>.


Operation

The description of SBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SBFM','Signed bitfield move, with sign replication to left and zeros to right       (C6.6.158)

This instruction is used by the aliases ASR (immediate), SBFIZ, SBFX, SXTB, SXTH, and SXTW. See the Alias
conditions on page C6-678 table for details of when each alias is preferred.




  31 30 29 28 27 26 25 24 23 22 21                 16 15              10 9         5 4              0
  sf 0 0 1 0 0 1 1 0 N                   immr               imms             Rn            Rd
      opc


32-bit variant

Applies when sf = 0 && N = 0.

SBFM <Wd>, <Wn>, #<immr>, #<imms>


64-bit variant

Applies when sf = 1 && N = 1.

SBFM <Xd>, <Xn>, #<immr>, #<imms>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;

 boolean inzero;
 boolean extend;
 integer R;
 integer S;
 bits(datasize) wmask;
 bits(datasize) tmask;

 case opc of
     when ''00'' inzero = TRUE;      extend = TRUE;      // SBFM
     when ''01'' inzero = FALSE; extend = FALSE;         // BFM
     when ''10'' inzero = TRUE;      extend = FALSE;     // UBFM
     when ''11'' UnallocatedEncoding();

 if sf == ''1'' && N != ''1'' then ReservedValue();
 if sf == ''0'' && (N != ''0'' || immr<5> != ''0'' || imms<5> != ''0'') then ReservedValue();

 R = UInt(immr);
 S = UInt(imms);
 (wmask, tmask) = DecodeBitMasks(N, imms, immr, FALSE);
       Alias conditions


          Alias                  of variant            is preferred when

          ASR (immediate)        32-bit                imms == ''011111''

          ASR (immediate)        64-bit                imms == ''111111''

          SBFIZ                  -                     UInt(imms) < UInt(immr)

          SBFX                   -                     BFXPreferred(sf, opc<1>, imms, immr)

          SXTB                   -                     immr == ''000000'' && imms == ''000111''

          SXTH                   -                     immr == ''000000'' && imms == ''001111''

          SXTW                   -                     immr == ''000000'' && imms == ''011111''



       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

       <immr>          For the 32-bit variant: is the right rotate amount, in the range 0 to 31, encoded in the "immr" field.

                       For the 64-bit variant: is the right rotate amount, in the range 0 to 63, encoded in the "immr" field.

       <imms>          For the 32-bit variant: is the leftmost bit number to be moved from the source, in the range 0 to 31,
                       encoded in the "imms" field.

                       For the 64-bit variant: is the leftmost bit number to be moved from the source, in the range 0 to 63,
                       encoded in the "imms" field.


       Operation

         bits(datasize) dst = if inzero then Zeros() else X[d];
         bits(datasize) src = X[n];

         // perform bitfield move on low bits
         bits(datasize) bot = (dst AND NOT(wmask)) OR (ROR(src, R) AND wmask);

         // determine extension bits (sign, zero or dest register)
         bits(datasize) top = if extend then Replicate(src<S>) else dst;

         // combine extension bits and result bits
         X[d] = (top AND NOT(tmask)) OR (bot AND tmask);');
INSERT INTO "instructions" VALUES('ARM','SBFX','Signed bitfield extract       (C6.6.159)

This instruction is an alias of the SBFM instruction. This means that:

.      The encodings in this description are named to match the encodings of SBFM.

.      The description of SBFM gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                  16 15                10 9            5 4              0
   sf 0 0 1 0 0 1 1 0 N                   immr                imms                Rn              Rd
      opc


32-bit variant

Applies when sf = 0 && N = 0.

SBFX <Wd>, <Wn>, #<lsb>, #<width>

is equivalent to

SBFM <Wd>, <Wn>, #<lsb>, #(<lsb>+<width>-1)

and is the preferred disassembly when BFXPreferred(sf, opc<1>, imms, immr).

64-bit variant

Applies when sf = 1 && N = 1.

SBFX <Xd>, <Xn>, #<lsb>, #<width>

is equivalent to

SBFM <Xd>, <Xn>, #<lsb>, #(<lsb>+<width>-1)

and is the preferred disassembly when BFXPreferred(sf, opc<1>, imms, immr).


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<lsb>           For the 32-bit variant: is the bit number of the lsb of the source bitfield, in the range 0 to 31.

                For the 64-bit variant: is the bit number of the lsb of the source bitfield, in the range 0 to 63.

<width>         For the 32-bit variant: is the width of the bitfield, in the range 1 to 32-<lsb>.

                For the 64-bit variant: is the width of the bitfield, in the range 1 to 64-<lsb>.


Operation

The description of SBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SDIV','      Signed Divide divides a signed integer register value by a signed integer register value, and writes the result to the       (C6.6.160)
      destination register of the same size as source registers, 32-bit or 64-bit. The condition flags are not affected. That
      is, it performs a signed divide: Rd = Rn / Rm.




          31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9              5 4              0
          sf 0 0 1 1 0 1 0 1 1 0                   Rm         0 0 0 0 1 1              Rn              Rd
                                                                             o1


      32-bit variant

      Applies when sf = 0.

      SDIV <Wd>, <Wn>, <Wm>


      64-bit variant

      Applies when sf = 1.

      SDIV <Xd>, <Xn>, <Xm>


      Decode for all variants of this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        integer datasize = if sf == ''1'' then 64 else 32;
        boolean unsigned = (o1 == ''0'');


      Assembler symbols

      <Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>             Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Wm>             Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

      <Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Xn>             Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

      <Xm>             Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.


      Overflow

      When using the 32-bit form of the instruction, if the signed integer division 0x8000 0000 / 0xFFFF FFFF is performed,
      the pseudocode produces the intermediate integer result +231, that overflows the 32-bit signed integer range. No
      indication of this overflow case is produced, and the 32-bit result written to <Rd> must be the bottom 32 bits of the
      binary representation of +231. So the result of the division is 0x8000 0000.

      Similarly, when using the 64-bit form of the instruction, if the signed integer division 0x8000 0000 0000 0000 /
      0xFFFF FFFF FFFF FFFF is performed, the result of the division is 0x8000 0000 0000 0000.


      Operation

        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = X[m];
        integer result;
if IsZero(operand2) then
   result = 0;
else
   result = RoundTowardsZero (Int(operand1, unsigned) / Int(operand2, unsigned));

X[d] = result<datasize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','SEV','Send event       (C6.6.161)

This instruction is an alias of the HINT instruction. This means that:

.       The encodings in this description are named to match the encodings of HINT.

.       The description of HINT gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11         8 7       5 4 3 2 1 0
    1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 0 1 1 1 1 1
                                                                      CRm       op2


System variant

SEV

is equivalent to

HINT #4

and is always the preferred disassembly.


Operation

The description of HINT gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SEVL','Send event locally       (C6.6.162)

This instruction is an alias of the HINT instruction. This means that:

.      The encodings in this description are named to match the encodings of HINT.

.      The description of HINT gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11          8 7       5 4 3 2 1 0
   1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 1 0 1 1 1 1 1 1
                                                                      CRm      op2


System variant

SEVL

is equivalent to

HINT #5

and is always the preferred disassembly.


Operation

The description of HINT gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SMADDL','      Signed multiply-add long: Xd = Xa + Wn * Wm       (C6.6.163)

      This instruction is used by the alias SMULL. See the Alias conditions table for details of when each alias is
      preferred.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14          10 9             5 4              0
          1 0 0 1 1 0 1 1 0 0 1                   Rm         0       Ra               Rn             Rd
                                   U                         o0


      64-bit variant

      SMADDL <Xd>, <Wn>, <Wm>, <Xa>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        integer a = UInt(Ra);
        integer destsize = 64;
        integer datasize = 32;
        boolean sub_op = (o0 == ''1'');
        boolean unsigned = (U == ''1'');


      Alias conditions


                           Alias                     is preferred when

                           SMULL                     Ra == ''11111''



      Assembler symbols

      <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                      the "Rn" field.

      <Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                      the "Rm" field.

      <Xa>            Is the 64-bit name of the third general-purpose source register holding the addend, encoded in the
                      "Ra" field.


      Operation

        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = X[m];
        bits(destsize) operand3 = X[a];

        integer result;

        if sub_op then
             result = Int(operand3, unsigned) - (Int(operand1, unsigned) * Int(operand2, unsigned));
        else
   result = Int(operand3, unsigned) + (Int(operand1, unsigned) * Int(operand2, unsigned));

X[d] = result<63:0>;');
INSERT INTO "instructions" VALUES('ARM','SMC','Generate exception targeting exception level 3       (C6.6.164)




    31 30 29 28 27 26 25 24 23 22 21 20                                              5 4 3 2 1 0
    1 1 0 1 0 1 0 0 0 0 0                                 imm16                         0 0 0 1 1




System variant

SMC #<imm>


Decode for this encoding

  bits(16) imm = imm16;


Assembler symbols

<imm>           Is a 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.


Operation

  if !HaveEL(EL3) || PSTATE.EL == EL0 then
       UnallocatedEncoding();

  AArch64.CheckForSMCTrap(imm);

  if SCR_EL3.SMD == ''1'' then
       // SMC disabled
       AArch64.UndefinedFault();
  else
       AArch64.CallSecureMonitor(imm);');
INSERT INTO "instructions" VALUES('ARM','SMNEGL','Signed multiply-negate long: Xd = -(Wn * Wm)       (C6.6.165)

This instruction is an alias of the SMSUBL instruction. This means that:

.      The encodings in this description are named to match the encodings of SMSUBL.

.      The description of SMSUBL gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14          10 9             5 4              0
   1 0 0 1 1 0 1 1 0 0 1                    Rm         1 1 1 1 1 1              Rn             Rd
                             U                         o0      Ra


64-bit variant

SMNEGL <Xd>, <Wn>, <Wm>

is equivalent to

SMSUBL <Xd>, <Wn>, <Wm>, XZR

and is always the preferred disassembly.


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

The description of SMSUBL gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SMSUBL','      Signed multiply-subtract long: Xd = Xa - Wn * Wm       (C6.6.166)

      This instruction is used by the alias SMNEGL. See the Alias conditions table for details of when each alias is
      preferred.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14          10 9             5 4              0
          1 0 0 1 1 0 1 1 0 0 1                   Rm         1       Ra               Rn             Rd
                                   U                         o0


      64-bit variant

      SMSUBL <Xd>, <Wn>, <Wm>, <Xa>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        integer a = UInt(Ra);
        integer destsize = 64;
        integer datasize = 32;
        boolean sub_op = (o0 == ''1'');
        boolean unsigned = (U == ''1'');


      Alias conditions


                           Alias                     is preferred when

                           SMNEGL                    Ra == ''11111''



      Assembler symbols

      <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                      the "Rn" field.

      <Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                      the "Rm" field.

      <Xa>            Is the 64-bit name of the third general-purpose source register holding the minuend, encoded in the
                      "Ra" field.


      Operation

        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = X[m];
        bits(destsize) operand3 = X[a];

        integer result;

        if sub_op then
             result = Int(operand3, unsigned) - (Int(operand1, unsigned) * Int(operand2, unsigned));
        else
   result = Int(operand3, unsigned) + (Int(operand1, unsigned) * Int(operand2, unsigned));

X[d] = result<63:0>;');
INSERT INTO "instructions" VALUES('ARM','SMULH','Signed multiply high: Xd = bits<127:64> of Xn * Xm       (C6.6.167)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14              10 9         5 4              0
    1 0 0 1 1 0 1 1 0 1 0                   Rm         0 (1) (1) (1) (1) (1)    Rn             Rd
                             U                                  Ra


64-bit variant

SMULH <Xd>, <Xn>, <Xm>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  integer a = UInt(Ra);             // ignored by UMULH/SMULH
  integer destsize = 64;
  integer datasize = destsize;
  boolean unsigned = (U == ''1'');


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

  bits(datasize) operand1 = X[n];
  bits(datasize) operand2 = X[m];

  integer result;

  result = Int(operand1, unsigned) * Int(operand2, unsigned);

  X[d] = result<127:64>;');
INSERT INTO "instructions" VALUES('ARM','SMULL','Signed multiply long: Xd = Wn * Wm       (C6.6.168)

This instruction is an alias of the SMADDL instruction. This means that:

.      The encodings in this description are named to match the encodings of SMADDL.

.      The description of SMADDL gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14          10 9             5 4              0
   1 0 0 1 1 0 1 1 0 0 1                    Rm         0 1 1 1 1 1              Rn             Rd
                             U                         o0      Ra


64-bit variant

SMULL <Xd>, <Wn>, <Wm>

is equivalent to

SMADDL <Xd>, <Wn>, <Wm>, XZR

and is always the preferred disassembly.


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

The description of SMADDL gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','STLR','      Store-Release Register stores a 32-bit word or a 64-bit doubleword to a memory location, from a register. The       (C6.6.169)
      instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For
      information about memory accesses see Load/Store addressing modes on page C1-122.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4            0
          1 x 0 0 1 0 0 0 1 0 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)             Rn              Rt
          size                     o2 L o1        Rs        o0       Rt2


      32-bit variant

      Applies when size = 10.

      STLR <Wt>, [<Xn|SP>{,#0}]


      64-bit variant

      Applies when size = 11.

      STLR <Xt>, [<Xn|SP>{,#0}]


      Decode for all variants of this encoding

        integer n = UInt(Rn);
        integer t = UInt(Rt);
        integer t2 = UInt(Rt2); // ignored by load/store single register
        integer s = UInt(Rs);     // ignored by all loads and store-release

        if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
        if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

        AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
        boolean excl = (o2 == ''0'');
        boolean pair = (o1 == ''1'');
        MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
        integer elsize = 8 << UInt(size);
        integer regsize = if elsize == 64 then 64 else 32;
        integer datasize = if pair then elsize * 2 else elsize;


      Assembler symbols

      <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


      Operation

        bits(64) address;
        bits(datasize) data;
        constant integer dbytes = datasize DIV 8;
        boolean rt_unknown = FALSE;
        boolean rn_unknown = FALSE;

        if memop == MemOp_LOAD && pair && t == t2 then
             Constraint c = ConstrainUnpredictable();
             assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
             case c of
                  when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
        when Constraint_UNDEF      UnallocatedEncoding();
        when Constraint_NOP        EndOfInstruction();

if memop == MemOp_STORE && excl then
   if s == t || (pair && s == t2) then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
           when Constraint_NONE       rt_unknown = FALSE;       // store original value
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();
   if s == n && n != 31 then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
           when Constraint_NONE       rn_unknown = FALSE;       // address is original base
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();

if n == 31 then
    CheckSPAlignment();
   address = SP[];
elsif rn_unknown then
   address = bits(64) UNKNOWN;
else
   address = X[n];

case memop of
   when MemOp_STORE
       if rt_unknown then
           data = bits(datasize) UNKNOWN;
       elsif pair then
           assert excl;
           bits(datasize DIV 2) el1 = X[t];
           bits(datasize DIV 2) el2 = X[t2];
           data = if BigEndian() then el1 : el2 else el2 : el1;
       else
           data = X[t];

        if excl then
           // store {release} exclusive register|pair (atomic)
           bit status = ''1'';
           // Check whether the Exclusive Monitors are set to include the
           // physical memory locations corresponding to virtual address
           // range [address, address+dbytes-1].
           if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                // This atomic write will be rejected if it does not refer
                // to the same physical locations after address translation.
                Mem[address, dbytes, acctype] = data;
                status = ExclusiveMonitorsStatus();
            X[s] = ZeroExtend(status, 32);
        else
           // store release register (atomic)
            Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
        if excl then
           // Tell the Exclusive Monitors to record a sequence of one or more atomic
           // memory reads from virtual address range [address, address+dbytes-1].
           // The Exclusive Monitor will only be set if all the reads are from the
           // same dbytes-aligned physical address, to allow for the possibility of
           // an atomicity break if the translation is changed between reads.
            AArch64.SetExclusiveMonitors(address, dbytes);

        if pair then
           // load exclusive pair
                     assert excl;
                     if rt_unknown then
                         // ConstrainedUNPREDICTABLE case
                         X[t]   = bits(datasize) UNKNOWN;
                     elsif elsize == 32 then
                         // 32-bit load exclusive pair (atomic)
                         data = Mem[address, dbytes, acctype];
                         if BigEndian() then
                              X[t]  = data<datasize-1:elsize>;
                              X[t2] = data<elsize-1:0>;
                         else
                              X[t]  = data<elsize-1:0>;
                              X[t2] = data<datasize-1:elsize>;
                     else // elsize == 64
                         // 64-bit load exclusive pair (not atomic),
                         // but must be 128-bit aligned
                         if address != Align(address, dbytes) then
                             iswrite = FALSE;
                             secondstage = FALSE;
                             AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                         X[t]   = Mem[address + 0, 8, acctype];
                         X[t2] = Mem[address + 8, 8, acctype];
                  else
                     // load {acquire} {exclusive} single register
                     data = Mem[address, dbytes, acctype];
                      X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STLRB','Store-Release Register Byte stores a byte from a 32-bit register to a memory location. The instruction also has       (C6.6.170)
memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For information about
memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14             10 9           5 4             0
  0 0 0 0 1 0 0 0 1 0 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)            Rn              Rt
  size                    o2 L o1          Rs       o0        Rt2


No offset variant

STLRB <Wt>, [<Xn|SP>{,#0}]


Decode for this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);   // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Assembler symbols

<Wt>          Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>       Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
     assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
     case c of
         when Constraint_UNKNOWN      rt_unknown = TRUE;       // result is UNKNOWN
         when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP          EndOfInstruction();

 if memop == MemOp_STORE && excl then
     if s == t || (pair && s == t2) then
         Constraint c = ConstrainUnpredictable();
         assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
         case c of
             when Constraint_UNKNOWN       rt_unknown = TRUE;       // store UNKNOWN value
             when Constraint_NONE          rt_unknown = FALSE;      // store original value
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
                      when Constraint_NONE       rn_unknown = FALSE;       // address is original base
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP         EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
                               X[t2] = data<elsize-1:0>;
          else
               X[t]  = data<elsize-1:0>;
               X[t2] = data<datasize-1:elsize>;
      else // elsize == 64
          // 64-bit load exclusive pair (not atomic),
          // but must be 128-bit aligned
          if address != Align(address, dbytes) then
              iswrite = FALSE;
              secondstage = FALSE;
              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
          X[t]   = Mem[address + 0, 8, acctype];
          X[t2] = Mem[address + 8, 8, acctype];
   else
      // load {acquire} {exclusive} single register
      data = Mem[address, dbytes, acctype];
       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STLRH','      Store-Release Register Halfword stores a halfword from a 32-bit register to a memory location. The instruction also       (C6.6.171)
      has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For information about
      memory accesses see Load/Store addressing modes on page C1-122.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14            10 9             5 4            0
          0 1 0 0 1 0 0 0 1 0 0 (1) (1) (1) (1) (1) 1 (1) (1) (1) (1) (1)             Rn              Rt
          size                     o2 L o1        Rs        o0       Rt2


      No offset variant

      STLRH <Wt>, [<Xn|SP>{,#0}]


      Decode for this encoding

        integer n = UInt(Rn);
        integer t = UInt(Rt);
        integer t2 = UInt(Rt2); // ignored by load/store single register
        integer s = UInt(Rs);     // ignored by all loads and store-release

        if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
        if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

        AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
        boolean excl = (o2 == ''0'');
        boolean pair = (o1 == ''1'');
        MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
        integer elsize = 8 << UInt(size);
        integer regsize = if elsize == 64 then 64 else 32;
        integer datasize = if pair then elsize * 2 else elsize;


      Assembler symbols

      <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

      <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.


      Operation

        bits(64) address;
        bits(datasize) data;
        constant integer dbytes = datasize DIV 8;
        boolean rt_unknown = FALSE;
        boolean rn_unknown = FALSE;

        if memop == MemOp_LOAD && pair && t == t2 then
             Constraint c = ConstrainUnpredictable();
             assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
             case c of
                  when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
                  when Constraint_UNDEF       UnallocatedEncoding();
                  when Constraint_NOP         EndOfInstruction();

        if memop == MemOp_STORE && excl then
             if s == t || (pair && s == t2) then
                  Constraint c = ConstrainUnpredictable();
                  assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                  case c of
                     when Constraint_UNKNOWN      rt_unknown = TRUE;       // store UNKNOWN value
                     when Constraint_NONE         rt_unknown = FALSE;      // store original value
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();
   if s == n && n != 31 then
        Constraint c = ConstrainUnpredictable();
        assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
       case c of
           when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
           when Constraint_NONE       rn_unknown = FALSE;       // address is original base
           when Constraint_UNDEF      UnallocatedEncoding();
           when Constraint_NOP        EndOfInstruction();

if n == 31 then
    CheckSPAlignment();
   address = SP[];
elsif rn_unknown then
   address = bits(64) UNKNOWN;
else
   address = X[n];

case memop of
   when MemOp_STORE
       if rt_unknown then
           data = bits(datasize) UNKNOWN;
       elsif pair then
           assert excl;
           bits(datasize DIV 2) el1 = X[t];
           bits(datasize DIV 2) el2 = X[t2];
           data = if BigEndian() then el1 : el2 else el2 : el1;
       else
           data = X[t];

       if excl then
           // store {release} exclusive register|pair (atomic)
           bit status = ''1'';
           // Check whether the Exclusive Monitors are set to include the
           // physical memory locations corresponding to virtual address
           // range [address, address+dbytes-1].
           if AArch64.ExclusiveMonitorsPass(address, dbytes) then
               // This atomic write will be rejected if it does not refer
               // to the same physical locations after address translation.
               Mem[address, dbytes, acctype] = data;
               status = ExclusiveMonitorsStatus();
           X[s] = ZeroExtend(status, 32);
       else
           // store release register (atomic)
           Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
       if excl then
           // Tell the Exclusive Monitors to record a sequence of one or more atomic
           // memory reads from virtual address range [address, address+dbytes-1].
           // The Exclusive Monitor will only be set if all the reads are from the
           // same dbytes-aligned physical address, to allow for the possibility of
           // an atomicity break if the translation is changed between reads.
           AArch64.SetExclusiveMonitors(address, dbytes);

       if pair then
           // load exclusive pair
           assert excl;
           if rt_unknown then
               // ConstrainedUNPREDICTABLE case
               X[t]   = bits(datasize) UNKNOWN;
           elsif elsize == 32 then
               // 32-bit load exclusive pair (atomic)
               data = Mem[address, dbytes, acctype];
               if BigEndian() then
                   X[t]   = data<datasize-1:elsize>;
                   X[t2] = data<elsize-1:0>;
                         else
                              X[t]  = data<elsize-1:0>;
                              X[t2] = data<datasize-1:elsize>;
                     else // elsize == 64
                         // 64-bit load exclusive pair (not atomic),
                         // but must be 128-bit aligned
                         if address != Align(address, dbytes) then
                             iswrite = FALSE;
                             secondstage = FALSE;
                             AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                         X[t]   = Mem[address + 0, 8, acctype];
                         X[t2] = Mem[address + 8, 8, acctype];
                  else
                     // load {acquire} {exclusive} single register
                     data = Mem[address, dbytes, acctype];
                      X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STLXP','Store-Release Exclusive Pair Of Registers stores two 32-bit words or two 64-bit doublewords to a memory location       (C6.6.172)
if the PE has exclusive access to the memory address, from two registers, and returns a status value of 0 if the store
was successful, or of 1 if no store was performed. See Synchronization and semaphores on page B2-103. A 32-bit
pair requires the address to be doubleword aligned and is single-copy atomic at doubleword granularity. A 64-bit
pair requires the address to be quadword aligned and is single-copy atomic for each doubleword at doubleword
granularity. The instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on
page B2-88. For information about memory accesses see Load/Store addressing modes on page C1-122.




   31 30 29 28 27 26 25 24 23 22 21 20               16 15 14         10 9              5 4              0
    1 x 0 0 1 0 0 0 0 0 1                    Rs         1       Rt2              Rn             Rt
    size                    o2 L o1                     o0


32-bit variant

Applies when size = 10.

STLXP <Ws>, <Wt1>, <Wt2>, [<Xn|SP>{,#0}]


64-bit variant

Applies when size = 11.

STLXP <Ws>, <Xt1>, <Xt2>, [<Xn|SP>{,#0}]


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);      // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Notes for all encodings

For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
Architectural Constraints on UNPREDICTABLE behaviors, and particularly STLXP on page J1-5411.


Assembler symbols

<Ws>            Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                is written, encoded in the "Rs" field. The value returned is:

                0            If the operation updates memory.

                1            If the operation fails to update memory.



<Xt1>           Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.
       <Xt2>            Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                        field.

       <Wt1>            Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Wt2>            Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                        field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       Aborts and alignment

       If a synchronous Data Abort exception is generated by the execution of this instruction:

       .       Memory is not updated.

       .       <Ws> is not updated.

       Accessing an address that is not aligned to the size of the data being accessed causes an Alignment fault Data Abort
       exception to be generated, subject to the following rules:

       .       If AArch64.ExclusiveMonitorsPass() returns TRUE, the exception is generated.

       .       Otherwise, it is IMPLEMENTATION DEFINED whether the exception is generated.

       If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
       synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


       Operation

         bits(64) address;
         bits(datasize) data;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;
         boolean rn_unknown = FALSE;

         if memop == MemOp_LOAD && pair && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN     rt_unknown = TRUE;        // result is UNKNOWN
                   when Constraint_UNDEF       UnallocatedEncoding();
                   when Constraint_NOP         EndOfInstruction();

         if memop == MemOp_STORE && excl then
              if s == t || (pair && s == t2) then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                       when Constraint_UNKNOWN      rt_unknown = TRUE;       // store UNKNOWN value
                       when Constraint_NONE         rt_unknown = FALSE;      // store original value
                       when Constraint_UNDEF        UnallocatedEncoding();
                       when Constraint_NOP          EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                       when Constraint_UNKNOWN      rn_unknown = TRUE;       // address is UNKNOWN
                       when Constraint_NONE         rn_unknown = FALSE;      // address is original base
                       when Constraint_UNDEF        UnallocatedEncoding();
                       when Constraint_NOP          EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
 else
    address = X[n];

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        elsif pair then
            assert excl;
            bits(datasize DIV 2) el1 = X[t];
            bits(datasize DIV 2) el2 = X[t2];
            data = if BigEndian() then el1 : el2 else el2 : el1;
        else
            data = X[t];

        if excl then
            // store {release} exclusive register|pair (atomic)
            bit status = ''1'';
            // Check whether the Exclusive Monitors are set to include the
            // physical memory locations corresponding to virtual address
            // range [address, address+dbytes-1].
            if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                // This atomic write will be rejected if it does not refer
                // to the same physical locations after address translation.
                Mem[address, dbytes, acctype] = data;
                status = ExclusiveMonitorsStatus();
            X[s] = ZeroExtend(status, 32);
        else
            // store release register (atomic)
            Mem[address, dbytes, acctype] = data;

    when MemOp_LOAD
        if excl then
            // Tell the Exclusive Monitors to record a sequence of one or more atomic
            // memory reads from virtual address range [address, address+dbytes-1].
            // The Exclusive Monitor will only be set if all the reads are from the
            // same dbytes-aligned physical address, to allow for the possibility of
            // an atomicity break if the translation is changed between reads.
            AArch64.SetExclusiveMonitors(address, dbytes);

        if pair then
            // load exclusive pair
            assert excl;
            if rt_unknown then
                // ConstrainedUNPREDICTABLE case
                X[t]  = bits(datasize) UNKNOWN;
            elsif elsize == 32 then
                // 32-bit load exclusive pair (atomic)
                data = Mem[address, dbytes, acctype];
                if BigEndian() then
                    X[t]  = data<datasize-1:elsize>;
                    X[t2] = data<elsize-1:0>;
                else
                    X[t]  = data<elsize-1:0>;
                    X[t2] = data<datasize-1:elsize>;
            else // elsize == 64
                // 64-bit load exclusive pair (not atomic),
                // but must be 128-bit aligned
                if address != Align(address, dbytes) then
                   iswrite = FALSE;
                   secondstage = FALSE;
                   AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                X[t]  = Mem[address + 0, 8, acctype];
                X[t2] = Mem[address + 8, 8, acctype];
        else
            // load {acquire} {exclusive} single register
            data = Mem[address, dbytes, acctype];
            X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STLXR','       Store-Release Exclusive Register stores a 32-bit word or a 64-bit doubleword to memory if the PE has exclusive       (C6.6.173)
       access to the memory address, from two registers, and returns a status value of 0 if the store was successful, or of 1
       if no store was performed. See Synchronization and semaphores on page B2-103. The memory access is atomic.
       The instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88.
       For information about memory accesses see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14             10 9         5 4               0
           1 x 0 0 1 0 0 0 0 0 0                    Rs         1 (1) (1) (1) (1) (1)  Rn               Rt
           size                    o2 L o1                     o0       Rt2


       32-bit variant

       Applies when size = 10.

       STLXR <Ws>, <Wt>, [<Xn|SP>{,#0}]


       64-bit variant

       Applies when size = 11.

       STLXR <Ws>, <Xt>, [<Xn|SP>{,#0}]


       Decode for all variants of this encoding

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2); // ignored by load/store single register
         integer s = UInt(Rs);     // ignored by all loads and store-release

         if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
         if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

         AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
         boolean excl = (o2 == ''0'');
         boolean pair = (o1 == ''1'');
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer elsize = 8 << UInt(size);
         integer regsize = if elsize == 64 then 64 else 32;
         integer datasize = if pair then elsize * 2 else elsize;


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly STLXR on page J1-5409.


       Assembler symbols

       <Ws>            Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                       is written, encoded in the "Rs" field. The value returned is:

                       0            If the operation updates memory.

                       1            If the operation fails to update memory.



       <Xt>            Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.
<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

Aborts and alignment

If a synchronous Data Abort exception is generated by the execution of this instruction:

.      Memory is not updated.

.      <Ws> is not updated.

Accessing an address that is not aligned to the size of the data being accessed causes an Alignment fault Data Abort
exception to be generated, subject to the following rules:

.      If AArch64.ExclusiveMonitorsPass() returns TRUE, the exception is generated.

.      Otherwise, it is IMPLEMENTATION DEFINED whether the exception is generated.

If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
      Constraint c = ConstrainUnpredictable();
      assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
      case c of
          when Constraint_UNKNOWN      rt_unknown = TRUE;         // result is UNKNOWN
          when Constraint_UNDEF        UnallocatedEncoding();
          when Constraint_NOP          EndOfInstruction();

 if memop == MemOp_STORE && excl then
      if s == t || (pair && s == t2) then
          Constraint c = ConstrainUnpredictable();
          assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
          case c of
               when Constraint_UNKNOWN       rt_unknown = TRUE;       // store UNKNOWN value
               when Constraint_NONE          rt_unknown = FALSE;      // store original value
               when Constraint_UNDEF         UnallocatedEncoding();
               when Constraint_NOP           EndOfInstruction();
      if s == n && n != 31 then
          Constraint c = ConstrainUnpredictable();
          assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
          case c of
               when Constraint_UNKNOWN       rn_unknown = TRUE;       // address is UNKNOWN
               when Constraint_NONE          rn_unknown = FALSE;      // address is original base
               when Constraint_UNDEF         UnallocatedEncoding();
               when Constraint_NOP           EndOfInstruction();

 if n == 31 then
      CheckSPAlignment();
      address = SP[];
 elsif rn_unknown then
      address = bits(64) UNKNOWN;
 else
      address = X[n];

 case memop of
      when MemOp_STORE
          if rt_unknown then
               data = bits(datasize) UNKNOWN;
          elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
                               X[t2] = data<elsize-1:0>;
                           else
                               X[t]  = data<elsize-1:0>;
                               X[t2] = data<datasize-1:elsize>;
                      else // elsize == 64
                           // 64-bit load exclusive pair (not atomic),
                           // but must be 128-bit aligned
                           if address != Align(address, dbytes) then
                              iswrite = FALSE;
                              secondstage = FALSE;
                              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                           X[t]  = Mem[address + 0, 8, acctype];
                           X[t2] = Mem[address + 8, 8, acctype];
                   else
                      // load {acquire} {exclusive} single register
                      data = Mem[address, dbytes, acctype];
                       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STLXRB','Store-Release Exclusive Register Byte stores a byte from a 32-bit register to memory if the PE has exclusive access       (C6.6.174)
to the memory address, and returns a status value of 0 if the store was successful, or of 1 if no store was performed.
See Synchronization and semaphores on page B2-103. The memory access is atomic. The instruction also has
memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For information about
memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                16 15 14             10 9          5 4              0
   0 0 0 0 1 0 0 0 0 0 0                     Rs         1 (1) (1) (1) (1) (1)   Rn                Rt
   size                     o2 L o1                     o0       Rt2


No offset variant

STLXRB <Ws>, <Wt>, [<Xn|SP>{,#0}]


Decode for this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);      // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Notes for all encodings

For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
Architectural Constraints on UNPREDICTABLE behaviors, and particularly STLXRB on page J1-5409.


Assembler symbols

<Ws>            Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                is written, encoded in the "Rs" field. The value returned is:

                0            If the operation updates memory.

                1            If the operation fails to update memory.



<Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

Aborts

If a synchronous Data Abort exception is generated by the execution of this instruction:

.      Memory is not updated.

.      <Ws> is not updated.
       If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
       synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


       Operation

         bits(64) address;
         bits(datasize) data;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;
         boolean rn_unknown = FALSE;

         if memop == MemOp_LOAD && pair && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && excl then
              if s == t || (pair && s == t2) then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
                      when Constraint_NONE       rt_unknown = FALSE;       // store original value
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP        EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
                      when Constraint_NONE       rn_unknown = FALSE;       // address is original base
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
              status = ExclusiveMonitorsStatus();
          X[s] = ZeroExtend(status, 32);
      else
          // store release register (atomic)
          Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
      if excl then
          // Tell the Exclusive Monitors to record a sequence of one or more atomic
          // memory reads from virtual address range [address, address+dbytes-1].
          // The Exclusive Monitor will only be set if all the reads are from the
          // same dbytes-aligned physical address, to allow for the possibility of
          // an atomicity break if the translation is changed between reads.
          AArch64.SetExclusiveMonitors(address, dbytes);

      if pair then
          // load exclusive pair
          assert excl;
          if rt_unknown then
              // ConstrainedUNPREDICTABLE case
              X[t]  = bits(datasize) UNKNOWN;
          elsif elsize == 32 then
              // 32-bit load exclusive pair (atomic)
              data = Mem[address, dbytes, acctype];
              if BigEndian() then
                  X[t]  = data<datasize-1:elsize>;
                  X[t2] = data<elsize-1:0>;
              else
                  X[t]  = data<elsize-1:0>;
                  X[t2] = data<datasize-1:elsize>;
          else // elsize == 64
              // 64-bit load exclusive pair (not atomic),
              // but must be 128-bit aligned
              if address != Align(address, dbytes) then
                  iswrite = FALSE;
                  secondstage = FALSE;
                  AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
              X[t]  = Mem[address + 0, 8, acctype];
              X[t2] = Mem[address + 8, 8, acctype];
      else
          // load {acquire} {exclusive} single register
          data = Mem[address, dbytes, acctype];
          X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STLXRH','       Store-Release Exclusive Register Halfword stores a halfword from a 32-bit register to memory if the PE has       (C6.6.175)
       exclusive access to the memory address, and returns a status value of 0 if the store was successful, or of 1 if no store
       was performed. See Synchronization and semaphores on page B2-103. The memory access is atomic. The
       instruction also has memory ordering semantics as described in Load-Acquire, Store-Release on page B2-88. For
       information about memory accesses see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20               16 15 14             10 9         5 4               0
           0 1 0 0 1 0 0 0 0 0 0                     Rs         1 (1) (1) (1) (1) (1)   Rn              Rt
           size                     o2 L o1                     o0       Rt2


       No offset variant

       STLXRH <Ws>, <Wt>, [<Xn|SP>{,#0}]


       Decode for this encoding

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2); // ignored by load/store single register
         integer s = UInt(Rs);      // ignored by all loads and store-release

         if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
         if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

         AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
         boolean excl = (o2 == ''0'');
         boolean pair = (o1 == ''1'');
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer elsize = 8 << UInt(size);
         integer regsize = if elsize == 64 then 64 else 32;
         integer datasize = if pair then elsize * 2 else elsize;


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly STLXRH on page J1-5409.


       Assembler symbols

       <Ws>             Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                        is written, encoded in the "Rs" field. The value returned is:

                        0            If the operation updates memory.

                        1            If the operation fails to update memory.



       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       Aborts and alignment

       If a synchronous Data Abort exception is generated by the execution of this instruction:

       .       Memory is not updated.

       .       <Ws> is not updated.
A non halfword-aligned memory address causes an Alignment fault Data Abort exception to be generated, subject
to the following rules:

.      If AArch64.ExclusiveMonitorsPass() returns TRUE, the exception is generated.

.      Otherwise, it is IMPLEMENTATION DEFINED whether the exception is generated.

If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
     assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
     case c of
          when Constraint_UNKNOWN     rt_unknown = TRUE;      // result is UNKNOWN
          when Constraint_UNDEF       UnallocatedEncoding();
          when Constraint_NOP         EndOfInstruction();

 if memop == MemOp_STORE && excl then
     if s == t || (pair && s == t2) then
           Constraint c = ConstrainUnpredictable();
          assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
          case c of
              when Constraint_UNKNOWN     rt_unknown = TRUE;       // store UNKNOWN value
              when Constraint_NONE        rt_unknown = FALSE;      // store original value
              when Constraint_UNDEF       UnallocatedEncoding();
              when Constraint_NOP         EndOfInstruction();
     if s == n && n != 31 then
           Constraint c = ConstrainUnpredictable();
          assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
          case c of
              when Constraint_UNKNOWN     rn_unknown = TRUE;       // address is UNKNOWN
              when Constraint_NONE        rn_unknown = FALSE;      // address is original base
              when Constraint_UNDEF       UnallocatedEncoding();
              when Constraint_NOP         EndOfInstruction();

 if n == 31 then
     CheckSPAlignment();
     address = SP[];
 elsif rn_unknown then
     address = bits(64) UNKNOWN;
 else
     address = X[n];

 case memop of
     when MemOp_STORE
          if rt_unknown then
              data = bits(datasize) UNKNOWN;
          elsif pair then
              assert excl;
              bits(datasize DIV 2) el1 = X[t];
              bits(datasize DIV 2) el2 = X[t2];
              data = if BigEndian() then el1 : el2 else el2 : el1;
          else
              data = X[t];

          if excl then
              // store {release} exclusive register|pair (atomic)
              bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
                               X[t2] = data<elsize-1:0>;
                           else
                               X[t]  = data<elsize-1:0>;
                               X[t2] = data<datasize-1:elsize>;
                      else // elsize == 64
                           // 64-bit load exclusive pair (not atomic),
                           // but must be 128-bit aligned
                           if address != Align(address, dbytes) then
                              iswrite = FALSE;
                              secondstage = FALSE;
                              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                           X[t]  = Mem[address + 0, 8, acctype];
                           X[t2] = Mem[address + 8, 8, acctype];
                   else
                      // load {acquire} {exclusive} single register
                      data = Mem[address, dbytes, acctype];
                       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STNP','Store pair of registers, with non-temporal hint       (C6.6.176)




  31 30 29 28 27 26 25 24 23 22 21                      15 14         10 9              5 4               0
  x 0 1 0 1 0 0 0 0 0                       imm7                Rt2              Rn              Rt
  opc                           L


32-bit variant

Applies when opc = 00.

STNP <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}]


64-bit variant

Applies when opc = 10.

STNP <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}]


Decode for all variants of this encoding

 boolean wback    = FALSE;
 boolean postindex = FALSE;


Assembler symbols

<Wt1>           Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

<Wt2>           Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                field.

<Xt1>           Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

<Xt2>           Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<imm>           For the 32-bit variant: is the optional signed immediate byte offset, a multiple of 4 in the range -256
                to 252, defaulting to 0 and encoded in the "imm7" field as <imm>/4.

                For the 64-bit variant: is the optional signed immediate byte offset, a multiple of 8 in the range -512
                to 504, defaulting to 0 and encoded in the "imm7" field as <imm>/8.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2);
 AccType acctype = AccType_STREAM;
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 if opc<0> == ''1'' then UnallocatedEncoding();
 integer scale = 2 + UInt(opc<1>);
 integer datasize = 8 << scale;
 bits(64) offset = LSL(SignExtend(imm7, 64), scale);
       Operation

         bits(64) address;
         bits(datasize) data1;
         bits(datasize) data2;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown && t == n then
                      data1 = bits(datasize) UNKNOWN;
                   else
                      data1 = X[t];
                   if rt_unknown && t2 == n then
                      data2 = bits(datasize) UNKNOWN;
                   else
                      data2 = X[t2];
                   Mem[address + 0     , dbytes, acctype] = data1;
                   Mem[address + dbytes, dbytes, acctype] = data2;

              when MemOp_LOAD
                   data1 = Mem[address + 0     , dbytes, acctype];
                   data2 = Mem[address + dbytes, dbytes, acctype];
                   if rt_unknown then
                      data1 = bits(datasize) UNKNOWN;
                      data2 = bits(datasize) UNKNOWN;
                   X[t]  = data1;
                   X[t2] = data2;

         if wback then
              if postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STP','Store Pair of Registers calculates an address from a base register value and an immediate offset, and stores two       (C6.6.177)
32-bit words or two 64-bit doublewords to the calculated address, from two registers. For information about
memory accesses see Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21                   15 14            10 9            5 4              0
  x 0 1 0 1 0 0 0 1 0                     imm7                Rt2             Rn              Rt
  opc                           L


32-bit variant

Applies when opc = 00.

STP <Wt1>, <Wt2>, [<Xn|SP>], #<imm>


64-bit variant

Applies when opc = 10.

STP <Xt1>, <Xt2>, [<Xn|SP>], #<imm>


Decode for all variants of this encoding

 boolean wback   = TRUE;
 boolean postindex = TRUE;


Pre-index


  31 30 29 28 27 26 25 24 23 22 21                   15 14            10 9            5 4              0
  x 0 1 0 1 0 0 1 1 0                     imm7                Rt2             Rn              Rt
  opc                           L


32-bit variant

Applies when opc = 00.

STP <Wt1>, <Wt2>, [<Xn|SP>, #<imm>]!


64-bit variant

Applies when opc = 10.

STP <Xt1>, <Xt2>, [<Xn|SP>, #<imm>]!


Decode for all variants of this encoding

 boolean wback   = TRUE;
 boolean postindex = FALSE;


Signed offset


  31 30 29 28 27 26 25 24 23 22 21                   15 14            10 9            5 4              0
  x 0 1 0 1 0 0 1 0 0                     imm7                Rt2             Rn              Rt
  opc                           L
       32-bit variant

       Applies when opc = 00.

       STP <Wt1>, <Wt2>, [<Xn|SP>{, #<imm>}]


       64-bit variant

       Applies when opc = 10.

       STP <Xt1>, <Xt2>, [<Xn|SP>{, #<imm>}]


       Decode for all variants of this encoding

         boolean wback  = FALSE;
         boolean postindex = FALSE;


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly STP on page J1-5409.


       Assembler symbols

       <Wt1>           Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Wt2>           Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                       field.

       <Xt1>           Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt2>           Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                       field.

       <Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <imm>           For the 32-bit post-index and 32-bit pre-index variant: is the signed immediate byte offset, a
                       multiple of 4 in the range -256 to 252, encoded in the "imm7" field as <imm>/4.

                       For the 32-bit signed offset variant: is the optional signed immediate byte offset, a multiple of 4 in
                       the range -256 to 252, defaulting to 0 and encoded in the "imm7" field as <imm>/4.

                       For the 64-bit post-index and 64-bit pre-index variant: is the signed immediate byte offset, a
                       multiple of 8 in the range -512 to 504, encoded in the "imm7" field as <imm>/8.

                       For the 64-bit signed offset variant: is the optional signed immediate byte offset, a multiple of 8 in
                       the range -512 to 504, defaulting to 0 and encoded in the "imm7" field as <imm>/8.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2);
         AccType acctype = AccType_NORMAL;
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         if L:opc<0> == ''01'' || opc == ''11'' then UnallocatedEncoding();
         boolean signed = (opc<0> != ''0'');
         integer scale = 2 + UInt(opc<1>);
         integer datasize = 8 << scale;
         bits(64) offset = LSL(SignExtend(imm7, 64), scale);
Operation for all encodings

 bits(64) address;
 bits(datasize) data1;
 bits(datasize) data2;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean wb_unknown = FALSE;

 if memop == MemOp_LOAD && wback && (t == n || t2 == n) && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;          // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;      // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && (t == n || t2 == n) && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;     // value stored is pre-writeback
         when Constraint_UNKNOWN    rt_unknown = TRUE;      // value stored is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_LOAD && t == t2 then
     Constraint c = ConstrainUnpredictable();
    assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
     CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
         if rt_unknown && t == n then
            data1 = bits(datasize) UNKNOWN;
         else
            data1 = X[t];
         if rt_unknown && t2 == n then
            data2 = bits(datasize) UNKNOWN;
         else
            data2 = X[t2];
         Mem[address + 0     , dbytes, acctype] = data1;
         Mem[address + dbytes, dbytes, acctype] = data2;

    when MemOp_LOAD
         data1 = Mem[address + 0     , dbytes, acctype];
         data2 = Mem[address + dbytes, dbytes, acctype];
         if rt_unknown then
            data1 = bits(datasize) UNKNOWN;
            data2 = bits(datasize) UNKNOWN;
         if signed then
             X[t]  = SignExtend(data1, 64);
             X[t2] = SignExtend(data2, 64);
         else
             X[t]  = data1;
                       X[t2] = data2;

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STR','Store Register (immediate) calculates an address from a base register value and an immediate offset, and stores a       (C6.6.178)
32-bit word or a 64-bit doubleword to the calculated address, from a register. For information about memory
accesses see Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
  1 x 1 1 1 0 0 0 0 0 0                        imm9              0 1           Rn             Rt
  size                      opc


32-bit variant

Applies when size = 10.

STR <Wt>, [<Xn|SP>], #<simm>


64-bit variant

Applies when size = 11.

STR <Xt>, [<Xn|SP>], #<simm>


Decode for all variants of this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                         12 11 10 9              5 4             0
  1 x 1 1 1 0 0 0 0 0 0                        imm9              1 1           Rn             Rt
  size                      opc


32-bit variant

Applies when size = 10.

STR <Wt>, [<Xn|SP>, #<simm>]!


64-bit variant

Applies when size = 11.

STR <Xt>, [<Xn|SP>, #<simm>]!


Decode for all variants of this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);
       Unsigned offset


           31 30 29 28 27 26 25 24 23 22 21                                   10 9              5 4             0
           1 x 1 1 1 0 0 1 0 0                             imm12                       Rn                Rt
           size                      opc


       32-bit variant

       Applies when size = 10.

       STR <Wt>, [<Xn|SP>{, #<pimm>}]


       64-bit variant

       Applies when size = 11.

       STR <Xt>, [<Xn|SP>{, #<pimm>}]


       Decode for all variants of this encoding

         boolean wback = FALSE;
         boolean postindex = FALSE;
         integer scale = UInt(size);
         bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xt>             Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           For the 32-bit variant: is the optional positive immediate byte offset, a multiple of 4 in the range 0
                        to 16380, defaulting to 0 and encoded in the "imm12" field as <pimm>/4.

                        For the 64-bit variant: is the optional positive immediate byte offset, a multiple of 8 in the range 0
                        to 32760, defaulting to 0 and encoded in the "imm12" field as <pimm>/8.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;


Operation for all encodings

 bits(64) address;
 bits(datasize) data;
 boolean wb_unknown = FALSE;
 boolean rt_unknown = FALSE;

 if memop == MemOp_LOAD && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
         when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
         when Constraint_UNDEF      UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if memop == MemOp_STORE && wback && n == t && n != 31 then
    c = ConstrainUnpredictable();
    assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
    case c of
         when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
         when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
        when Constraint_UNDEF       UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
            X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
         address = bits(64) UNKNOWN;
    elsif postindex then
         address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STRB','Store Register Byte (immediate) calculates an address from a base register value and an immediate offset, and stores       (C6.6.180)
a byte from a 32-bit register to the calculated address. For information about memory accesses see Load/Store
addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                           12 11 10 9            5 4             0
  0 0 1 1 1 0 0 0 0 0 0                           imm9             0 1         Rn            Rt
   size                      opc


Post-index variant

STRB <Wt>, [<Xn|SP>], #<simm>


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                           12 11 10 9            5 4             0
  0 0 1 1 1 0 0 0 0 0 0                           imm9             1 1         Rn            Rt
   size                      opc


Pre-index variant

STRB <Wt>, [<Xn|SP>, #<simm>]!


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Unsigned offset


  31 30 29 28 27 26 25 24 23 22 21                                    10 9            5 4             0
  0 0 1 1 1 0 0 1 0 0                              imm12                       Rn            Rt
   size                      opc


Unsigned offset variant

STRB <Wt>, [<Xn|SP>{, #<pimm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);
       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly STRB (immediate) on page J1-5408.


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           Is the optional positive immediate byte offset, in the range 0 to 4095, defaulting to 0 and encoded
                        in the "imm12" field.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation for all encodings

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;           // writeback is suppressed
                   when Constraint_UNKNOWN      wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
                   when Constraint_NOP          EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE         rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN      rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
             X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
        address = bits(64) UNKNOWN;
    elsif postindex then
        address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STRH','Store Register Halfword (immediate) calculates an address from a base register value and an immediate offset, and       (C6.6.182)
stores a halfword from a 32-bit register to the calculated address. For information about memory accesses see
Load/Store addressing modes on page C1-122.


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9             5 4              0
  0 1 1 1 1 0 0 0 0 0 0                          imm9               0 1        Rn             Rt
   size                     opc


Post-index variant

STRH <Wt>, [<Xn|SP>], #<simm>


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = TRUE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Pre-index


  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9             5 4              0
  0 1 1 1 1 0 0 0 0 0 0                          imm9               1 1        Rn             Rt
   size                     opc


Pre-index variant

STRH <Wt>, [<Xn|SP>, #<simm>]!


Decode for this encoding

 boolean wback = TRUE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Unsigned offset


  31 30 29 28 27 26 25 24 23 22 21                                    10 9            5 4              0
  0 1 1 1 1 0 0 1 0 0                              imm12                       Rn             Rt
   size                     opc


Unsigned offset variant

STRH <Wt>, [<Xn|SP>{, #<pimm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = LSL(ZeroExtend(imm12, 64), scale);
       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly STRH (immediate) on page J1-5408.


       Assembler symbols

       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <simm>           Is the signed immediate byte offset, in the range -256 to 255, encoded in the "imm9" field.

       <pimm>           Is the optional positive immediate byte offset, a multiple of 2 in the range 0 to 8190, defaulting to 0
                        and encoded in the "imm12" field as <pimm>/2.


       Shared decode for all encodings

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         AccType acctype = AccType_NORMAL;
         MemOp memop;
         boolean signed;
         integer regsize;

         if opc<1> == ''0'' then
              // store or zero-extending load
              memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
              regsize = if size == ''11'' then 64 else 32;
              signed = FALSE;
         else
              if size == ''11'' then
                   UnallocatedEncoding();
              else
                   // sign-extending load
                   memop = MemOp_LOAD;
                   if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation for all encodings

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;           // writeback is suppressed
                   when Constraint_UNKNOWN      wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
                   when Constraint_NOP          EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE         rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN      rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP        EndOfInstruction();

 if n == 31 then
    if memop != MemOp_PREFETCH then CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 if ! postindex then
    address = address + offset;

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        else
            data = X[t];
         Mem[address, datasize DIV 8, acctype] = data;

    when MemOp_LOAD
        data = Mem[address, datasize DIV 8, acctype];
        if signed then
             X[t] = SignExtend(data, regsize);
        else
             X[t] = ZeroExtend(data, regsize);

    when MemOp_PREFETCH
         Prefetch(address, t<4:0>);

 if wback then
    if wb_unknown then
        address = bits(64) UNKNOWN;
    elsif postindex then
        address = address + offset;
    if n == 31 then
         SP[] = address;
    else
         X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STTR','Store Register (unprivileged) calculates an address from a base register value and an immediate offset, and stores a       (C6.6.184)
32-bit word or a 64-bit doubleword to the calculated address, from a register. For information about memory
accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9              5 4             0
  1 x 1 1 1 0 0 0 0 0 0                         imm9               1 0         Rn               Rt
  size                       opc


32-bit variant

Applies when size = 10.

STTR <Wt>, [<Xn|SP>{, #<simm>}]


64-bit variant

Applies when size = 11.

STTR <Xt>, [<Xn|SP>{, #<simm>}]


Decode for all variants of this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Assembler symbols

<Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xt>            Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<simm>          Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                in the "imm9" field.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_UNPRIV;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
     // store or zero-extending load
     memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
     regsize = if size == ''11'' then 64 else 32;
     signed = FALSE;
 else
     if size == ''11'' then
         UnallocatedEncoding();
     else
         // sign-extending load
         memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
                   regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
                   when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              if memop != MemOp_PREFETCH then CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   else
                      data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STTRB','Store Register Byte (unprivileged) calculates an address from a base register value and an immediate offset, and       (C6.6.185)
stores a byte from a 32-bit register to the calculated address. For information about memory accesses see Load/Store
addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                             12 11 10 9            5 4              0
  0 0 1 1 1 0 0 0 0 0 0                             imm9              1 0        Rn              Rt
   size                       opc


Unscaled offset variant

STTRB <Wt>, [<Xn|SP>{, #<simm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Assembler symbols

<Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<simm>           Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                 in the "imm9" field.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_UNPRIV;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
     // store or zero-extending load
     memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
     regsize = if size == ''11'' then 64 else 32;
     signed = FALSE;
 else
     if size == ''11'' then
          UnallocatedEncoding();
     else
          // sign-extending load
          memop = MemOp_LOAD;
          if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
          regsize = if opc<0> == ''1'' then 32 else 64;
          signed = TRUE;

 integer datasize = 8 << scale;
       Operation

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
                   when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              if memop != MemOp_PREFETCH then CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   else
                      data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STTRH','Store Register Halfword (unprivileged) calculates an address from a base register value and an immediate offset,       (C6.6.186)
and stores a halfword from a 32-bit register to the calculated address. For information about memory accesses see
Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9              5 4             0
  0 1 1 1 1 0 0 0 0 0 0                          imm9              1 0         Rn               Rt
  size                       opc


Unscaled offset variant

STTRH <Wt>, [<Xn|SP>{, #<simm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Assembler symbols

<Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<simm>          Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                in the "imm9" field.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_UNPRIV;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
     // store or zero-extending load
     memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
     regsize = if size == ''11'' then 64 else 32;
     signed = FALSE;
 else
     if size == ''11'' then
         UnallocatedEncoding();
     else
         // sign-extending load
         memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
         signed = TRUE;

 integer datasize = 8 << scale;
       Operation

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
                   when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              if memop != MemOp_PREFETCH then CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   else
                      data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STUR','Store register (unscaled offset)       (C6.6.187)




  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9              5 4             0
  1 x 1 1 1 0 0 0 0 0 0                         imm9               0 0         Rn               Rt
  size                       opc


32-bit variant

Applies when size = 10.

STUR <Wt>, [<Xn|SP>{, #<simm>}]


64-bit variant

Applies when size = 11.

STUR <Xt>, [<Xn|SP>{, #<simm>}]


Decode for all variants of this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Assembler symbols

<Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xt>            Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<simm>          Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                in the "imm9" field.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_NORMAL;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
     // store or zero-extending load
     memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
     regsize = if size == ''11'' then 64 else 32;
     signed = FALSE;
 else
     if size == ''11'' then
         memop = MemOp_PREFETCH;
         if opc<0> == ''1'' then UnallocatedEncoding();
     else
         // sign-extending load
         memop = MemOp_LOAD;
         if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
         regsize = if opc<0> == ''1'' then 32 else 64;
                   signed = TRUE;

         integer datasize = 8 << scale;


       Operation

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
                   when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              if memop != MemOp_PREFETCH then CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   else
                      data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STURB','Store Register Byte (unscaled) calculates an address from a base register value and an immediate offset, and stores       (C6.6.188)
a byte to the calculated address, from a 32-bit register. For information about memory accesses see Load/Store
addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                            12 11 10 9            5 4             0
  0 0 1 1 1 0 0 0 0 0 0                          imm9               0 0         Rn              Rt
   size                      opc


Unscaled offset variant

STURB <Wt>, [<Xn|SP>{, #<simm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Assembler symbols

<Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<simm>          Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
                in the "imm9" field.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_NORMAL;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
     // store or zero-extending load
     memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
     regsize = if size == ''11'' then 64 else 32;
     signed = FALSE;
 else
     if size == ''11'' then
          memop = MemOp_PREFETCH;
          if opc<0> == ''1'' then UnallocatedEncoding();
     else
          // sign-extending load
          memop = MemOp_LOAD;
          if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
          regsize = if opc<0> == ''1'' then 32 else 64;
          signed = TRUE;

 integer datasize = 8 << scale;
       Operation

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
                   when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              if memop != MemOp_PREFETCH then CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   else
                      data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STURH','Store Register Halfword (unscaled) calculates an address from a base register value and an immediate offset, and       (C6.6.189)
stores a halfword to the calculated address, from a 32-bit register. For information about memory accesses see
Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                          12 11 10 9             5 4              0
  0 1 1 1 1 0 0 0 0 0 0                         imm9                0 0        Rn              Rt
   size                      opc


Unscaled offset variant

STURH <Wt>, [<Xn|SP>{, #<simm>}]


Decode for this encoding

 boolean wback = FALSE;
 boolean postindex = FALSE;
 integer scale = UInt(size);
 bits(64) offset = SignExtend(imm9, 64);


Assembler symbols

<Wt>           Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>        Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<simm>         Is the optional signed immediate byte offset, in the range -256 to 255, defaulting to 0 and encoded
               in the "imm9" field.


Shared decode for all encodings

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 AccType acctype = AccType_NORMAL;
 MemOp memop;
 boolean signed;
 integer regsize;

 if opc<1> == ''0'' then
     // store or zero-extending load
     memop = if opc<0> == ''1'' then MemOp_LOAD else MemOp_STORE;
     regsize = if size == ''11'' then 64 else 32;
     signed = FALSE;
 else
     if size == ''11'' then
          memop = MemOp_PREFETCH;
          if opc<0> == ''1'' then UnallocatedEncoding();
     else
          // sign-extending load
          memop = MemOp_LOAD;
          if size == ''10'' && opc<0> == ''1'' then UnallocatedEncoding();
          regsize = if opc<0> == ''1'' then 32 else 64;
          signed = TRUE;

 integer datasize = 8 << scale;
       Operation

         bits(64) address;
         bits(datasize) data;
         boolean wb_unknown = FALSE;
         boolean rt_unknown = FALSE;

         if memop == MemOp_LOAD && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_WBSUPPRESS, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_WBSUPPRESS wback = FALSE;         // writeback is suppressed
                   when Constraint_UNKNOWN    wb_unknown = TRUE;     // writeback is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && wback && n == t && n != 31 then
              c = ConstrainUnpredictable();
              assert c IN {Constraint_NONE, Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_NONE       rt_unknown = FALSE;    // value stored is original value
                   when Constraint_UNKNOWN    rt_unknown = TRUE;     // value stored is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              if memop != MemOp_PREFETCH then CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         if ! postindex then
              address = address + offset;

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   else
                      data = X[t];
                   Mem[address, datasize DIV 8, acctype] = data;

              when MemOp_LOAD
                   data = Mem[address, datasize DIV 8, acctype];
                   if signed then
                       X[t] = SignExtend(data, regsize);
                   else
                       X[t] = ZeroExtend(data, regsize);

              when MemOp_PREFETCH
                   Prefetch(address, t<4:0>);

         if wback then
              if wb_unknown then
                   address = bits(64) UNKNOWN;
              elsif postindex then
                   address = address + offset;
              if n == 31 then
                   SP[] = address;
              else
                   X[n] = address;');
INSERT INTO "instructions" VALUES('ARM','STXP','Store Exclusive Pair Of Registers stores two 32-bit words or two 64-bit doublewords from two registers to a       (C6.6.190)
memory location if the PE has exclusive access to the memory address, and returns a status value of 0 if the store
was successful, or of 1 if no store was performed. See Synchronization and semaphores on page B2-103. A 32-bit
pair requires the address to be doubleword aligned and is single-copy atomic at doubleword granularity. A 64-bit
pair requires the address to be quadword aligned and is single-copy atomic for each doubleword at doubleword
granularity. For information about memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                16 15 14         10 9              5 4              0
  1 x 0 0 1 0 0 0 0 0 1                      Rs         0       Rt2              Rn             Rt
  size                      o2 L o1                     o0


32-bit variant

Applies when size = 10.

STXP <Ws>, <Wt1>, <Wt2>, [<Xn|SP>{,#0}]


64-bit variant

Applies when size = 11.

STXP <Ws>, <Xt1>, <Xt2>, [<Xn|SP>{,#0}]


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);      // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Notes for all encodings

For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
Architectural Constraints on UNPREDICTABLE behaviors, and particularly STXP on page J1-5411.


Assembler symbols

<Ws>            Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                is written, encoded in the "Rs" field. The value returned is:

                0            If the operation updates memory.

                1            If the operation fails to update memory.



<Xt1>           Is the 64-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.
       <Xt2>            Is the 64-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                        field.

       <Wt1>            Is the 32-bit name of the first general-purpose register to be transferred, encoded in the "Rt" field.

       <Wt2>            Is the 32-bit name of the second general-purpose register to be transferred, encoded in the "Rt2"
                        field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       Aborts and alignment

       If a synchronous Data Abort exception is generated by the execution of this instruction:

       .       Memory is not updated.

       .       <Ws> is not updated.

       Accessing an address that is not aligned to the size of the data being accessed causes an Alignment fault Data Abort
       exception to be generated, subject to the following rules:

       .       If AArch64.ExclusiveMonitorsPass() returns TRUE, the exception is generated.

       .       Otherwise, it is IMPLEMENTATION DEFINED whether the exception is generated.

       If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
       synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


       Operation

         bits(64) address;
         bits(datasize) data;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;
         boolean rn_unknown = FALSE;

         if memop == MemOp_LOAD && pair && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN     rt_unknown = TRUE;        // result is UNKNOWN
                   when Constraint_UNDEF       UnallocatedEncoding();
                   when Constraint_NOP         EndOfInstruction();

         if memop == MemOp_STORE && excl then
              if s == t || (pair && s == t2) then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                       when Constraint_UNKNOWN      rt_unknown = TRUE;       // store UNKNOWN value
                       when Constraint_NONE         rt_unknown = FALSE;      // store original value
                       when Constraint_UNDEF        UnallocatedEncoding();
                       when Constraint_NOP          EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                       when Constraint_UNKNOWN      rn_unknown = TRUE;       // address is UNKNOWN
                       when Constraint_NONE         rn_unknown = FALSE;      // address is original base
                       when Constraint_UNDEF        UnallocatedEncoding();
                       when Constraint_NOP          EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
 else
    address = X[n];

 case memop of
    when MemOp_STORE
        if rt_unknown then
            data = bits(datasize) UNKNOWN;
        elsif pair then
            assert excl;
            bits(datasize DIV 2) el1 = X[t];
            bits(datasize DIV 2) el2 = X[t2];
            data = if BigEndian() then el1 : el2 else el2 : el1;
        else
            data = X[t];

        if excl then
            // store {release} exclusive register|pair (atomic)
            bit status = ''1'';
            // Check whether the Exclusive Monitors are set to include the
            // physical memory locations corresponding to virtual address
            // range [address, address+dbytes-1].
            if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                // This atomic write will be rejected if it does not refer
                // to the same physical locations after address translation.
                Mem[address, dbytes, acctype] = data;
                status = ExclusiveMonitorsStatus();
            X[s] = ZeroExtend(status, 32);
        else
            // store release register (atomic)
            Mem[address, dbytes, acctype] = data;

    when MemOp_LOAD
        if excl then
            // Tell the Exclusive Monitors to record a sequence of one or more atomic
            // memory reads from virtual address range [address, address+dbytes-1].
            // The Exclusive Monitor will only be set if all the reads are from the
            // same dbytes-aligned physical address, to allow for the possibility of
            // an atomicity break if the translation is changed between reads.
            AArch64.SetExclusiveMonitors(address, dbytes);

        if pair then
            // load exclusive pair
            assert excl;
            if rt_unknown then
                // ConstrainedUNPREDICTABLE case
                X[t]  = bits(datasize) UNKNOWN;
            elsif elsize == 32 then
                // 32-bit load exclusive pair (atomic)
                data = Mem[address, dbytes, acctype];
                if BigEndian() then
                    X[t]  = data<datasize-1:elsize>;
                    X[t2] = data<elsize-1:0>;
                else
                    X[t]  = data<elsize-1:0>;
                    X[t2] = data<datasize-1:elsize>;
            else // elsize == 64
                // 64-bit load exclusive pair (not atomic),
                // but must be 128-bit aligned
                if address != Align(address, dbytes) then
                   iswrite = FALSE;
                   secondstage = FALSE;
                   AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                X[t]  = Mem[address + 0, 8, acctype];
                X[t2] = Mem[address + 8, 8, acctype];
        else
            // load {acquire} {exclusive} single register
            data = Mem[address, dbytes, acctype];
            X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STXR','       Store Exclusive Register stores a 32-bit word or a 64-bit doubleword from a register to memory if the PE has       (C6.6.191)
       exclusive access to the memory address, and returns a status value of 0 if the store was successful, or of 1 if no store
       was performed. See Synchronization and semaphores on page B2-103. For information about memory accesses see
       Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14             10 9         5 4               0
           1 x 0 0 1 0 0 0 0 0 0                    Rs         0 (1) (1) (1) (1) (1)    Rn             Rt
           size                    o2 L o1                     o0       Rt2


       32-bit variant

       Applies when size = 10.

       STXR <Ws>, <Wt>, [<Xn|SP>{,#0}]


       64-bit variant

       Applies when size = 11.

       STXR <Ws>, <Xt>, [<Xn|SP>{,#0}]


       Decode for all variants of this encoding

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2); // ignored by load/store single register
         integer s = UInt(Rs);     // ignored by all loads and store-release

         if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
         if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

         AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
         boolean excl = (o2 == ''0'');
         boolean pair = (o1 == ''1'');
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer elsize = 8 << UInt(size);
         integer regsize = if elsize == 64 then 64 else 32;
         integer datasize = if pair then elsize * 2 else elsize;


       Notes for all encodings

       For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
       Architectural Constraints on UNPREDICTABLE behaviors, and particularly STXR on page J1-5410.


       Assembler symbols

       <Ws>            Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                       is written, encoded in the "Rs" field. The value returned is:

                       0            If the operation updates memory.

                       1            If the operation fails to update memory.



       <Xt>            Is the 64-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.
Aborts and alignment

If a synchronous Data Abort exception is generated by the execution of this instruction:

.      Memory is not updated.

.      <Ws> is not updated.

Accessing an address that is not aligned to the size of the data being accessed causes an Alignment fault Data Abort
exception to be generated, subject to the following rules:

.      If AArch64.ExclusiveMonitorsPass() returns TRUE, the exception is generated.

.      Otherwise, it is IMPLEMENTATION DEFINED whether the exception is generated.

If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
      Constraint c = ConstrainUnpredictable();
      assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
      case c of
          when Constraint_UNKNOWN      rt_unknown = TRUE;         // result is UNKNOWN
          when Constraint_UNDEF        UnallocatedEncoding();
          when Constraint_NOP          EndOfInstruction();

 if memop == MemOp_STORE && excl then
      if s == t || (pair && s == t2) then
          Constraint c = ConstrainUnpredictable();
          assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
          case c of
               when Constraint_UNKNOWN       rt_unknown = TRUE;       // store UNKNOWN value
               when Constraint_NONE          rt_unknown = FALSE;      // store original value
               when Constraint_UNDEF         UnallocatedEncoding();
               when Constraint_NOP           EndOfInstruction();
      if s == n && n != 31 then
          Constraint c = ConstrainUnpredictable();
          assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
          case c of
               when Constraint_UNKNOWN       rn_unknown = TRUE;       // address is UNKNOWN
               when Constraint_NONE          rn_unknown = FALSE;      // address is original base
               when Constraint_UNDEF         UnallocatedEncoding();
               when Constraint_NOP           EndOfInstruction();

 if n == 31 then
      CheckSPAlignment();
      address = SP[];
 elsif rn_unknown then
      address = bits(64) UNKNOWN;
 else
      address = X[n];

 case memop of
      when MemOp_STORE
          if rt_unknown then
               data = bits(datasize) UNKNOWN;
          elsif pair then
               assert excl;
               bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
                               X[t2] = data<elsize-1:0>;
                           else
                               X[t]  = data<elsize-1:0>;
                               X[t2] = data<datasize-1:elsize>;
                      else // elsize == 64
                           // 64-bit load exclusive pair (not atomic),
                           // but must be 128-bit aligned
                           if address != Align(address, dbytes) then
                              iswrite = FALSE;
                              secondstage = FALSE;
                              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                           X[t]  = Mem[address + 0, 8, acctype];
                           X[t2] = Mem[address + 8, 8, acctype];
                   else
                      // load {acquire} {exclusive} single register
                      data = Mem[address, dbytes, acctype];
                       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STXRB','Store Exclusive Register Byte stores a byte from a register to memory if the PE has exclusive access to the memory       (C6.6.192)
address, and returns a status value of 0 if the store was successful, or of 1 if no store was performed. See
Synchronization and semaphores on page B2-103. The memory access is atomic.

For information about memory accesses see Load/Store addressing modes on page C1-122.




  31 30 29 28 27 26 25 24 23 22 21 20                16 15 14             10 9            5 4             0
   0 0 0 0 1 0 0 0 0 0 0                     Rs         0 (1) (1) (1) (1) (1)     Rn              Rt
   size                     o2 L o1                     o0       Rt2


No offset variant

STXRB <Ws>, <Wt>, [<Xn|SP>{,#0}]


Decode for this encoding

 integer n = UInt(Rn);
 integer t = UInt(Rt);
 integer t2 = UInt(Rt2); // ignored by load/store single register
 integer s = UInt(Rs);      // ignored by all loads and store-release

 if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
 if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

 AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
 boolean excl = (o2 == ''0'');
 boolean pair = (o1 == ''1'');
 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer elsize = 8 << UInt(size);
 integer regsize = if elsize == 64 then 64 else 32;
 integer datasize = if pair then elsize * 2 else elsize;


Notes for all encodings

For information about the CONSTRAINED UNPREDICTABLE behavior of this instruction, see Appendix J1
Architectural Constraints on UNPREDICTABLE behaviors, and particularly STXRB on page J1-5410.


Assembler symbols

<Ws>            Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                is written, encoded in the "Rs" field. The value returned is:

                0            If the operation updates memory.

                1            If the operation fails to update memory.



<Wt>            Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

<Xn|SP>         Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

Aborts

If a synchronous Data Abort exception is generated by the execution of this instruction:

.      Memory is not updated.

.      <Ws> is not updated.
       If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
       synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


       Operation

         bits(64) address;
         bits(datasize) data;
         constant integer dbytes = datasize DIV 8;
         boolean rt_unknown = FALSE;
         boolean rn_unknown = FALSE;

         if memop == MemOp_LOAD && pair && t == t2 then
              Constraint c = ConstrainUnpredictable();
              assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
              case c of
                   when Constraint_UNKNOWN    rt_unknown = TRUE;      // result is UNKNOWN
                   when Constraint_UNDEF      UnallocatedEncoding();
                   when Constraint_NOP        EndOfInstruction();

         if memop == MemOp_STORE && excl then
              if s == t || (pair && s == t2) then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rt_unknown = TRUE;        // store UNKNOWN value
                      when Constraint_NONE       rt_unknown = FALSE;       // store original value
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP        EndOfInstruction();
              if s == n && n != 31 then
                   Constraint c = ConstrainUnpredictable();
                   assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
                   case c of
                      when Constraint_UNKNOWN    rn_unknown = TRUE;        // address is UNKNOWN
                      when Constraint_NONE       rn_unknown = FALSE;       // address is original base
                      when Constraint_UNDEF      UnallocatedEncoding();
                      when Constraint_NOP        EndOfInstruction();

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         elsif rn_unknown then
              address = bits(64) UNKNOWN;
         else
              address = X[n];

         case memop of
              when MemOp_STORE
                   if rt_unknown then
                      data = bits(datasize) UNKNOWN;
                   elsif pair then
                      assert excl;
                      bits(datasize DIV 2) el1 = X[t];
                      bits(datasize DIV 2) el2 = X[t2];
                      data = if BigEndian() then el1 : el2 else el2 : el1;
                   else
                      data = X[t];

                   if excl then
                      // store {release} exclusive register|pair (atomic)
                      bit status = ''1'';
                      // Check whether the Exclusive Monitors are set to include the
                      // physical memory locations corresponding to virtual address
                      // range [address, address+dbytes-1].
                      if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                           // This atomic write will be rejected if it does not refer
                           // to the same physical locations after address translation.
                           Mem[address, dbytes, acctype] = data;
              status = ExclusiveMonitorsStatus();
          X[s] = ZeroExtend(status, 32);
      else
          // store release register (atomic)
          Mem[address, dbytes, acctype] = data;

   when MemOp_LOAD
      if excl then
          // Tell the Exclusive Monitors to record a sequence of one or more atomic
          // memory reads from virtual address range [address, address+dbytes-1].
          // The Exclusive Monitor will only be set if all the reads are from the
          // same dbytes-aligned physical address, to allow for the possibility of
          // an atomicity break if the translation is changed between reads.
          AArch64.SetExclusiveMonitors(address, dbytes);

      if pair then
          // load exclusive pair
          assert excl;
          if rt_unknown then
              // ConstrainedUNPREDICTABLE case
              X[t]  = bits(datasize) UNKNOWN;
          elsif elsize == 32 then
              // 32-bit load exclusive pair (atomic)
              data = Mem[address, dbytes, acctype];
              if BigEndian() then
                  X[t]  = data<datasize-1:elsize>;
                  X[t2] = data<elsize-1:0>;
              else
                  X[t]  = data<elsize-1:0>;
                  X[t2] = data<datasize-1:elsize>;
          else // elsize == 64
              // 64-bit load exclusive pair (not atomic),
              // but must be 128-bit aligned
              if address != Align(address, dbytes) then
                  iswrite = FALSE;
                  secondstage = FALSE;
                  AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
              X[t]  = Mem[address + 0, 8, acctype];
              X[t2] = Mem[address + 8, 8, acctype];
      else
          // load {acquire} {exclusive} single register
          data = Mem[address, dbytes, acctype];
          X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','STXRH','       Store Exclusive Register Halfword stores a halfword from a register to memory if the PE has exclusive access to       (C6.6.193)
       the memory address, and returns a status value of 0 if the store was successful, or of 1 if no store was performed.
       See Synchronization and semaphores on page B2-103. The memory access is atomic.

       For information about memory accesses see Load/Store addressing modes on page C1-122.




           31 30 29 28 27 26 25 24 23 22 21 20               16 15 14             10 9         5 4               0
           0 1 0 0 1 0 0 0 0 0 0                     Rs         0 (1) (1) (1) (1) (1)  Rn               Rt
           size                     o2 L o1                     o0       Rt2


       No offset variant

       STXRH <Ws>, <Wt>, [<Xn|SP>{,#0}]


       Decode for this encoding

         integer n = UInt(Rn);
         integer t = UInt(Rt);
         integer t2 = UInt(Rt2); // ignored by load/store single register
         integer s = UInt(Rs);      // ignored by all loads and store-release

         if o2:o1:o0 == ''100'' || o2:o1:o0 == ''11x'' then UnallocatedEncoding();
         if o1 == ''1'' && size<1> == ''0'' then UnallocatedEncoding();

         AccType acctype = if o0 == ''1'' then AccType_ORDERED else AccType_ATOMIC;
         boolean excl = (o2 == ''0'');
         boolean pair = (o1 == ''1'');
         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer elsize = 8 << UInt(size);
         integer regsize = if elsize == 64 then 64 else 32;
         integer datasize = if pair then elsize * 2 else elsize;


       Assembler symbols

       <Ws>             Is the 32-bit name of the general-purpose register into which the status result of the store exclusive
                        is written, encoded in the "Rs" field. The value returned is:

                        0            If the operation updates memory.

                        1            If the operation fails to update memory.



       <Wt>             Is the 32-bit name of the general-purpose register to be transferred, encoded in the "Rt" field.

       <Xn|SP>          Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       Aborts and alignment

       If a synchronous Data Abort exception is generated by the execution of this instruction:

       .       Memory is not updated.

       .       <Ws> is not updated.

       A non halfword-aligned memory address causes an Alignment fault Data Abort exception to be generated, subject
       to the following rules:

       .       If AArch64.ExclusiveMonitorsPass() returns TRUE, the exception is generated.

       .       Otherwise, it is IMPLEMENTATION DEFINED whether the exception is generated.
If AArch64.ExclusiveMonitorsPass() returns FALSE and the memory address, if accessed, would generate a
synchronous Data Abort exception, it is IMPLEMENTATION DEFINED whether the exception is generated.


Operation

 bits(64) address;
 bits(datasize) data;
 constant integer dbytes = datasize DIV 8;
 boolean rt_unknown = FALSE;
 boolean rn_unknown = FALSE;

 if memop == MemOp_LOAD && pair && t == t2 then
     Constraint c = ConstrainUnpredictable();
     assert c IN {Constraint_UNKNOWN, Constraint_UNDEF, Constraint_NOP};
     case c of
         when Constraint_UNKNOWN      rt_unknown = TRUE;     // result is UNKNOWN
         when Constraint_UNDEF        UnallocatedEncoding();
         when Constraint_NOP          EndOfInstruction();

 if memop == MemOp_STORE && excl then
     if s == t || (pair && s == t2) then
         Constraint c = ConstrainUnpredictable();
         assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
         case c of
             when Constraint_UNKNOWN      rt_unknown = TRUE;      // store UNKNOWN value
             when Constraint_NONE         rt_unknown = FALSE;     // store original value
             when Constraint_UNDEF        UnallocatedEncoding();
             when Constraint_NOP          EndOfInstruction();
     if s == n && n != 31 then
         Constraint c = ConstrainUnpredictable();
         assert c IN {Constraint_UNKNOWN, Constraint_NONE, Constraint_UNDEF, Constraint_NOP};
         case c of
             when Constraint_UNKNOWN      rn_unknown = TRUE;      // address is UNKNOWN
             when Constraint_NONE         rn_unknown = FALSE;     // address is original base
             when Constraint_UNDEF        UnallocatedEncoding();
             when Constraint_NOP          EndOfInstruction();

 if n == 31 then
     CheckSPAlignment();
     address = SP[];
 elsif rn_unknown then
     address = bits(64) UNKNOWN;
 else
     address = X[n];

 case memop of
     when MemOp_STORE
         if rt_unknown then
             data = bits(datasize) UNKNOWN;
         elsif pair then
             assert excl;
             bits(datasize DIV 2) el1 = X[t];
             bits(datasize DIV 2) el2 = X[t2];
             data = if BigEndian() then el1 : el2 else el2 : el1;
         else
             data = X[t];

         if excl then
             // store {release} exclusive register|pair (atomic)
             bit status = ''1'';
             // Check whether the Exclusive Monitors are set to include the
             // physical memory locations corresponding to virtual address
             // range [address, address+dbytes-1].
             if AArch64.ExclusiveMonitorsPass(address, dbytes) then
                 // This atomic write will be rejected if it does not refer
                 // to the same physical locations after address translation.
                 Mem[address, dbytes, acctype] = data;
                           status = ExclusiveMonitorsStatus();
                       X[s] = ZeroExtend(status, 32);
                   else
                      // store release register (atomic)
                       Mem[address, dbytes, acctype] = data;

              when MemOp_LOAD
                   if excl then
                      // Tell the Exclusive Monitors to record a sequence of one or more atomic
                      // memory reads from virtual address range [address, address+dbytes-1].
                      // The Exclusive Monitor will only be set if all the reads are from the
                      // same dbytes-aligned physical address, to allow for the possibility of
                      // an atomicity break if the translation is changed between reads.
                       AArch64.SetExclusiveMonitors(address, dbytes);

                   if pair then
                      // load exclusive pair
                      assert excl;
                      if rt_unknown then
                           // ConstrainedUNPREDICTABLE case
                           X[t]  = bits(datasize) UNKNOWN;
                      elsif elsize == 32 then
                           // 32-bit load exclusive pair (atomic)
                           data = Mem[address, dbytes, acctype];
                           if BigEndian() then
                               X[t]  = data<datasize-1:elsize>;
                               X[t2] = data<elsize-1:0>;
                           else
                               X[t]  = data<elsize-1:0>;
                               X[t2] = data<datasize-1:elsize>;
                      else // elsize == 64
                           // 64-bit load exclusive pair (not atomic),
                           // but must be 128-bit aligned
                           if address != Align(address, dbytes) then
                              iswrite = FALSE;
                              secondstage = FALSE;
                              AArch64.Abort(address, AArch64.AlignmentFault(acctype, iswrite, secondstage));
                           X[t]  = Mem[address + 0, 8, acctype];
                           X[t2] = Mem[address + 8, 8, acctype];
                   else
                      // load {acquire} {exclusive} single register
                      data = Mem[address, dbytes, acctype];
                       X[t] = ZeroExtend(data, regsize);');
INSERT INTO "instructions" VALUES('ARM','SUB','Subtract (extended register): Rd = Rn - LSL(extend(Rm), amount)       (C6.6.194)




  31 30 29 28 27 26 25 24 23 22 21 20             16 15     13 12      10 9            5 4             0
  sf 1 0 0 1 0 1 1 0 0 1                   Rm          option    imm3           Rn              Rd
     op S


32-bit variant

Applies when sf = 0.

SUB <Wd|WSP>, <Wn|WSP>, <Wm>{, <extend> {#<amount>}}


64-bit variant

Applies when sf = 1.

SUB <Xd|SP>, <Xn|SP>, <R><m>{, <extend> {#<amount>}}


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean sub_op = (op == ''1'');
 boolean setflags = (S == ''1'');
 ExtendType extend_type = DecodeRegExtend(option);
 integer shift = UInt(imm3);
 if shift > 4 then ReservedValue();


Assembler symbols

<Wd|WSP>       Is the 32-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
               field.

<Wn|WSP>       Is the 32-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
               field.

<Wm>           Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd|SP>        Is the 64-bit name of the destination general-purpose register or stack pointer, encoded in the "Rd"
               field.

<Xn|SP>        Is the 64-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
               field.

<R>            Is a width specifier, encoded in the "option" field. It can have the following values:

               W           when option = 00x

               W           when option = 010

               X           when option = x11

               W           when option = 10x

               W           when option = 110

<m>            Is the number [0-30] of the second general-purpose source register or the name ZR (31), encoded in
               the "Rm" field.
       <extend>        For the 32-bit variant: is the extension to be applied to the second source operand, encoded in the
                       "option" field. It can have the following values:

                       UXTB         when option = 000

                       UXTH         when option = 001

                       LSL|UXTW     when option = 010

                       UXTX         when option = 011

                       SXTB         when option = 100

                       SXTH         when option = 101

                       SXTW         when option = 110

                       SXTX         when option = 111

                       If "Rd" or "Rn" is ''11111'' (WSP) and "option" is ''010'' then LSL is preferred, but may be omitted
                       when "imm3" is ''000''. In all other cases <extend> is required and must be UXTW when "option" is
                       ''010''.

                       For the 64-bit variant: is the extension to be applied to the second source operand, encoded in the
                       "option" field. It can have the following values:

                       UXTB         when option = 000

                       UXTH         when option = 001

                       UXTW         when option = 010

                       LSL|UXTX     when option = 011

                       SXTB         when option = 100

                       SXTH         when option = 101

                       SXTW         when option = 110

                       SXTX         when option = 111

                       If "Rd" or "Rn" is ''11111'' (SP) and "option" is ''011'' then LSL is preferred, but may be omitted when
                       "imm3" is ''000''. In all other cases <extend> is required and must be UXTX when "option" is ''011''.

       <amount>        Is the left shift amount to be applied after extension in the range 0 to 4, defaulting to 0, encoded in
                       the "imm3" field. It must be absent when <extend> is absent, is required when <extend> is LSL,
                       and is optional when <extend> is present but not LSL.


       Operation

         bits(datasize) result;
         bits(datasize) operand1 = if n == 31 then SP[] else X[n];
         bits(datasize) operand2 = ExtendReg(m, extend_type, shift);
         bits(4) nzcv;
         bit carry_in;

         if sub_op then
              operand2 = NOT(operand2);
              carry_in = ''1'';
         else
              carry_in = ''0'';

         (result, nzcv) = AddWithCarry(operand1, operand2, carry_in);

         if setflags then
              PSTATE.<N,Z,C,V> = nzcv;

         if d == 31 && !setflags then
              SP[] = result;
         else
              X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SUBS','Subtract (extended register), setting the condition flags: Rd = Rn - LSL(extend(Rm), amount)       (C6.6.197)

This instruction is used by the alias CMP (extended register). See the Alias conditions table for details of when each
alias is preferred.




  31 30 29 28 27 26 25 24 23 22 21 20               16 15     13 12      10 9            5 4             0
   sf 1 1 0 1 0 1 1 0 0 1                    Rm          option    imm3           Rn              Rd
      op S


32-bit variant

Applies when sf = 0.

SUBS <Wd>, <Wn|WSP>, <Wm>{, <extend> {#<amount>}}


64-bit variant

Applies when sf = 1.

SUBS <Xd>, <Xn|SP>, <R><m>{, <extend> {#<amount>}}


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer datasize = if sf == ''1'' then 64 else 32;
 boolean sub_op = (op == ''1'');
 boolean setflags = (S == ''1'');
 ExtendType extend_type = DecodeRegExtend(option);
 integer shift = UInt(imm3);
 if shift > 4 then ReservedValue();


Alias conditions


                      Alias                     is preferred when

                      CMP (extended             Rd == ''11111''
                      register)


Assembler symbols

<Wd>             Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn|WSP>         Is the 32-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                 field.

<Wm>             Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>             Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn|SP>          Is the 64-bit name of the first source general-purpose register or stack pointer, encoded in the "Rn"
                 field.

<R>              Is a width specifier, encoded in the "option" field. It can have the following values:

                 W           when option = 00x
                       W            when option = 010

                       X            when option = x11

                       W            when option = 10x

                       W            when option = 110

       <m>             Is the number [0-30] of the second general-purpose source register or the name ZR (31), encoded in
                       the "Rm" field.

       <extend>        For the 32-bit variant: is the extension to be applied to the second source operand, encoded in the
                       "option" field. It can have the following values:

                       UXTB         when option = 000

                       UXTH         when option = 001

                       LSL|UXTW     when option = 010

                       UXTX         when option = 011

                       SXTB         when option = 100

                       SXTH         when option = 101

                       SXTW         when option = 110

                       SXTX         when option = 111

                       If "Rn" is ''11111'' (WSP) and "option" is ''010'' then LSL is preferred, but may be omitted when
                       "imm3" is ''000''. In all other cases <extend> is required and must be UXTW when "option" is ''010''.

                       For the 64-bit variant: is the extension to be applied to the second source operand, encoded in the
                       "option" field. It can have the following values:

                       UXTB         when option = 000

                       UXTH         when option = 001

                       UXTW         when option = 010

                       LSL|UXTX     when option = 011

                       SXTB         when option = 100

                       SXTH         when option = 101

                       SXTW         when option = 110

                       SXTX         when option = 111

                       If "Rn" is ''11111'' (SP) and "option" is ''011'' then LSL is preferred, but may be omitted when "imm3"
                       is ''000''. In all other cases <extend> is required and must be UXTX when "option" is ''011''.

       <amount>        Is the left shift amount to be applied after extension in the range 0 to 4, defaulting to 0, encoded in
                       the "imm3" field. It must be absent when <extend> is absent, is required when <extend> is LSL,
                       and is optional when <extend> is present but not LSL.


       Operation

         bits(datasize) result;
         bits(datasize) operand1 = if n == 31 then SP[] else X[n];
         bits(datasize) operand2 = ExtendReg(m, extend_type, shift);
         bits(4) nzcv;
         bit carry_in;

         if sub_op then
              operand2 = NOT(operand2);
              carry_in = ''1'';
         else
              carry_in = ''0'';

         (result, nzcv) = AddWithCarry(operand1, operand2, carry_in);

         if setflags then
    PSTATE.<N,Z,C,V> = nzcv;

 if d == 31 && !setflags then
     SP[] = result;
 else
     X[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SVC','Generate exception targeting exception level 1       (C6.6.200)




    31 30 29 28 27 26 25 24 23 22 21 20                                              5 4 3 2 1 0
    1 1 0 1 0 1 0 0 0 0 0                                 imm16                         0 0 0 0 1




System variant

SVC #<imm>


Decode for this encoding

  bits(16) imm = imm16;


Assembler symbols

<imm>           Is a 16-bit unsigned immediate, in the range 0 to 65535, encoded in the "imm16" field.


Operation

  AArch64.CallSupervisor(imm);');
INSERT INTO "instructions" VALUES('ARM','SXTB','Signed extend byte: Rd = SignExtend(Wn<7:0>)       (C6.6.201)

This instruction is an alias of the SBFM instruction. This means that:

.      The encodings in this description are named to match the encodings of SBFM.

.      The description of SBFM gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                16 15              10 9             5 4              0
   sf 0 0 1 0 0 1 1 0 N 0 0 0 0 0 0 0 0 0 1 1 1                                Rn              Rd
      opc                                immr              imms


32-bit variant

Applies when sf = 0 && N = 0.

SXTB <Wd>, <Wn>

is equivalent to

SBFM <Wd>, <Wn>, #0, #7

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1 && N = 1.

SXTB <Xd>, <Wn>

is equivalent to

SBFM <Xd>, <Xn>, #0, #7

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

The description of SBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SXTH','Signed extend halfword: Rd = SignExtend(Wn<15:0>)       (C6.6.202)

This instruction is an alias of the SBFM instruction. This means that:

.       The encodings in this description are named to match the encodings of SBFM.

.       The description of SBFM gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21              16 15              10 9            5 4              0
    sf 0 0 1 0 0 1 1 0 N 0 0 0 0 0 0 0 0 1 1 1 1                               Rn              Rd
        opc                              immr              imms


32-bit variant

Applies when sf = 0 && N = 0.

SXTH <Wd>, <Wn>

is equivalent to

SBFM <Wd>, <Wn>, #0, #15

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1 && N = 1.

SXTH <Xd>, <Wn>

is equivalent to

SBFM <Xd>, <Xn>, #0, #15

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

The description of SBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SXTW','Signed extend word: Xd = SignExtend(Wn<31:0>)       (C6.6.203)

This instruction is an alias of the SBFM instruction. This means that:

.      The encodings in this description are named to match the encodings of SBFM.

.      The description of SBFM gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                16 15              10 9             5 4              0
   1 0 0 1 0 0 1 1 0 1 0 0 0 0 0 0 0 1 1 1 1 1                                 Rn              Rd
   sf opc                        N       immr              imms


64-bit variant

SXTW <Xd>, <Wn>

is equivalent to

SBFM <Xd>, <Xn>, #0, #31

and is always the preferred disassembly.


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

The description of SBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','SYS','       System instruction       (C6.6.204)

       This instruction is used by the aliases AT, DC, IC, and TLBI. See the Alias conditions table for details of when each
       alias is preferred.




           31 30 29 28 27 26 25 24 23 22 21 20 19 18       16 15         12 11        8 7      5 4             0
           1 1 0 1 0 1 0 1 0 0 0 0 1                    op1        CRn         CRm        op2           Rt
                                           L


       System variant

       SYS #<op1>, <Cn>, <Cm>, #<op2>{, <Xt>}


       Decode for this encoding

         CheckSystemAccess(''01'', op1, CRn, CRm, op2, Rt, L);

         integer t = UInt(Rt);

         integer sys_op0 = 1;
         integer sys_op1 = UInt(op1);
         integer sys_op2 = UInt(op2);
         integer sys_crn = UInt(CRn);
         integer sys_crm = UInt(CRm);
         boolean has_result = (L == ''1'');


       Alias conditions


                             Alias                     is preferred when

                             AT                        CRn == ''0111'' && CRm == ''1000'' &&
                                                       SysOp(op1,''0111'',''1000'',op2) == Sys_AT

                             DC                        CRn == ''0111'' && SysOp(op1,''0111'',CRm,op2) == Sys_DC

                             IC                        CRn == ''0111'' && SysOp(op1,''0111'',CRm,op2) == Sys_IC

                             TLBI                      CRn == ''1000'' && SysOp(op1,''1000'',CRm,op2) == Sys_TLBI



       Assembler symbols

       <op1>            Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op1" field.

       <Cn>             Is a name ''Cn'', with ''n'' in the range 0 to 15, encoded in the "CRn" field.

       <Cm>             Is a name ''Cm'', with ''m'' in the range 0 to 15, encoded in the "CRm" field.

       <op2>            Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op2" field.

       <Xt>             Is the 64-bit name of the optional general-purpose source register, defaulting to ''11111'', encoded in
                        the "Rt" field.
Operation

 if has_result then
     X[t] = SysOp_R(sys_op0, sys_op1, sys_crn, sys_crm, sys_op2);
 else
     SysOp_W(sys_op0, sys_op1, sys_crn, sys_crm, sys_op2, X[t]);');
INSERT INTO "instructions" VALUES('ARM','SYSL','System instruction with result       (C6.6.205)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18      16 15         12 11        8 7      5 4            0
    1 1 0 1 0 1 0 1 0 0 1 0 1                   op1        CRn         CRm        op2          Rt
                                   L


System variant

SYSL <Xt>, #<op1>, <Cn>, <Cm>, #<op2>


Decode for this encoding

  CheckSystemAccess(''01'', op1, CRn, CRm, op2, Rt, L);

  integer t = UInt(Rt);

  integer sys_op0 = 1;
  integer sys_op1 = UInt(op1);
  integer sys_op2 = UInt(op2);
  integer sys_crn = UInt(CRn);
  integer sys_crm = UInt(CRm);
  boolean has_result = (L == ''1'');


Assembler symbols

<Xt>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rt" field.

<op1>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op1" field.

<Cn>            Is a name ''Cn'', with ''n'' in the range 0 to 15, encoded in the "CRn" field.

<Cm>            Is a name ''Cm'', with ''m'' in the range 0 to 15, encoded in the "CRm" field.

<op2>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op2" field.


Operation

  if has_result then
       X[t] = SysOp_R(sys_op0, sys_op1, sys_crn, sys_crm, sys_op2);
  else
       SysOp_W(sys_op0, sys_op1, sys_crn, sys_crm, sys_op2, X[t]);');
INSERT INTO "instructions" VALUES('ARM','TBNZ','Test bit and Branch if Nonzero compares the value of a bit in a general-purpose register with zero, and conditionally       (C6.6.206)
branches to a label at a PC-relative offset if the comparison is not equal. It provides a hint that this is not a subroutine
call or return. This instruction does not affect condition flags.




  31 30 29 28 27 26 25 24 23              19 18                                            5 4                0
  b5 0 1 1 0 1 1 1                 b40                           imm14                                Rt
                          op


14-bit signed PC-relative branch offset variant

TBNZ <R><t>, #<imm>, <label>


Decode for this encoding

 integer t = UInt(Rt);

 integer datasize = if b5 == ''1'' then 64 else 32;
 integer bit_pos = UInt(b5:b40);
 bit bit_val = op;
 bits(64) offset = SignExtend(imm14:''00'', 64);


Assembler symbols

<R>              Is a width specifier, encoded in the "b5" field. It can have the following values:

                 W            when b5 = 0

                 X            when b5 = 1

                 In assembler source code an ''X'' specifier is always permitted, but a ''W'' specifier is only permitted
                 when the bit number is less than 32.

<t>              Is the number [0-30] of the general-purpose register to be tested or the name ZR (31), encoded in
                 the "Rt" field.

<imm>            Is the bit number to be tested, in the range 0 to 63, encoded in "b5:b40".

<label>          Is the program label to be conditionally branched to. Its offset from the address of this instruction,
                 in the range +/-32KB, is encoded as "imm14" times 4.


Operation

 bits(datasize) operand = X[t];

 if operand<bit_pos> == bit_val then
     BranchTo(PC[] + offset, BranchType_JMP);');
INSERT INTO "instructions" VALUES('ARM','TBZ','Test bit and Branch if Zero compares the value of a test bit with zero, and conditionally branches to a label at a       (C6.6.207)
PC-relative offset if the comparison is equal. It provides a hint that this is not a subroutine call or return. This
instruction does not affect condition flags.




    31 30 29 28 27 26 25 24 23           19 18                                           5 4               0
    b5 0 1 1 0 1 1 0              b40                           imm14                              Rt
                          op


14-bit signed PC-relative branch offset variant

TBZ <R><t>, #<imm>, <label>


Decode for this encoding

  integer t = UInt(Rt);

  integer datasize = if b5 == ''1'' then 64 else 32;
  integer bit_pos = UInt(b5:b40);
  bit bit_val = op;
  bits(64) offset = SignExtend(imm14:''00'', 64);


Assembler symbols

<R>             Is a width specifier, encoded in the "b5" field. It can have the following values:

                W           when b5 = 0

                X           when b5 = 1

                In assembler source code an ''X'' specifier is always permitted, but a ''W'' specifier is only permitted
                when the bit number is less than 32.

<t>             Is the number [0-30] of the general-purpose register to be tested or the name ZR (31), encoded in
                the "Rt" field.

<imm>           Is the bit number to be tested, in the range 0 to 63, encoded in "b5:b40".

<label>         Is the program label to be conditionally branched to. Its offset from the address of this instruction,
                in the range +/-32KB, is encoded as "imm14" times 4.


Operation

  bits(datasize) operand = X[t];

  if operand<bit_pos> == bit_val then
       BranchTo(PC[] + offset, BranchType_JMP);');
INSERT INTO "instructions" VALUES('ARM','TLBI','TLB invalidate operation       (C6.6.208)

This instruction is an alias of the SYS instruction. This means that:

.      The encodings in this description are named to match the encodings of SYS.

.      The description of SYS gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20 19 18        16 15        12 11       8 7      5 4              0
   1 1 0 1 0 1 0 1 0 0 0 0 1                   op1     1 0 0 0        CRm        op2           Rt
                                    L                     CRn


System variant

TLBI <tlbi_op>{, <Xt>}

is equivalent to

SYS #<op1>, C8, <Cm>, #<op2>{, <Xt>}

and is the preferred disassembly when SysOp(op1,''1000'',CRm,op2) == Sys_TLBI.


Assembler symbols

<op1>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op1" field.

<Cm>            Is a name ''Cm'', with ''m'' in the range 0 to 15, encoded in the "CRm" field.

<op2>           Is a 3-bit unsigned immediate, in the range 0 to 7, encoded in the "op2" field.

<tlbi_op>       Is a TLBI operation name, as listed for the TLBI system operation group, encoded in the
                "op1:CRm:op2" field. It can have the following values:

                VMALLE1IS    when op1 = 000, CRm = 0011, op2 = 000

                VAE1IS       when op1 = 000, CRm = 0011, op2 = 001

                ASIDE1IS     when op1 = 000, CRm = 0011, op2 = 010

                VAAE1IS      when op1 = 000, CRm = 0011, op2 = 011

                VALE1IS      when op1 = 000, CRm = 0011, op2 = 101

                VAALE1IS     when op1 = 000, CRm = 0011, op2 = 111

                VMALLE1      when op1 = 000, CRm = 0111, op2 = 000

                VAE1         when op1 = 000, CRm = 0111, op2 = 001

                ASIDE1       when op1 = 000, CRm = 0111, op2 = 010

                VAAE1        when op1 = 000, CRm = 0111, op2 = 011

                VALE1        when op1 = 000, CRm = 0111, op2 = 101

                VAALE1       when op1 = 000, CRm = 0111, op2 = 111

                IPAS2E1IS    when op1 = 100, CRm = 0000, op2 = 001

                IPAS2LE1IS when op1 = 100, CRm = 0000, op2 = 101

                ALLE2IS      when op1 = 100, CRm = 0011, op2 = 000

                VAE2IS       when op1 = 100, CRm = 0011, op2 = 001

                ALLE1IS      when op1 = 100, CRm = 0011, op2 = 100

                VALE2IS      when op1 = 100, CRm = 0011, op2 = 101
                       VMALLS12E1ISwhen op1 = 100, CRm = 0011, op2 = 110

                       IPAS2E1     when op1 = 100, CRm = 0100, op2 = 001

                       IPAS2LE1    when op1 = 100, CRm = 0100, op2 = 101

                       ALLE2       when op1 = 100, CRm = 0111, op2 = 000

                       VAE2        when op1 = 100, CRm = 0111, op2 = 001

                       ALLE1       when op1 = 100, CRm = 0111, op2 = 100

                       VALE2       when op1 = 100, CRm = 0111, op2 = 101

                       VMALLS12E1 when op1 = 100, CRm = 0111, op2 = 110

                       ALLE3IS     when op1 = 110, CRm = 0011, op2 = 000

                       VAE3IS      when op1 = 110, CRm = 0011, op2 = 001

                       VALE3IS     when op1 = 110, CRm = 0011, op2 = 101

                       ALLE3       when op1 = 110, CRm = 0111, op2 = 000

                       VAE3        when op1 = 110, CRm = 0111, op2 = 001

                       VALE3       when op1 = 110, CRm = 0111, op2 = 101

       <Xt>            Is the 64-bit name of the optional general-purpose source register, defaulting to ''11111'', encoded in
                       the "Rt" field.


       Operation

       The description of SYS gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','TST','Test bits (immediate), setting the condition flags and discarding the result: Rn AND imm       (C6.6.209)

This instruction is an alias of the ANDS (immediate) instruction. This means that:

.      The encodings in this description are named to match the encodings of ANDS (immediate).

.      The description of ANDS (immediate) gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                 16 15              10 9             5 4             0
   sf 1 1 1 0 0 1 0 0 N                  immr               imms                Rn       1 1 1 1 1
      opc                                                                                     Rd


32-bit variant

Applies when sf = 0 && N = 0.

TST <Wn>, #<imm>

is equivalent to

ANDS WZR, <Wn>, #<imm>

and is always the preferred disassembly.

64-bit variant

Applies when sf = 1.

TST <Xn>, #<imm>

is equivalent to

ANDS XZR, <Xn>, #<imm>

and is always the preferred disassembly.


Assembler symbols

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<imm>           Is the bitmask immediate, encoded in "N:imms:immr".


Operation

The description of ANDS (immediate) gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','UBFIZ','Unsigned bitfield insert in zero, with zeros to left and right       (C6.6.211)

This instruction is an alias of the UBFM instruction. This means that:

.       The encodings in this description are named to match the encodings of UBFM.

.       The description of UBFM gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21                16 15                10 9            5 4               0
    sf 1 0 1 0 0 1 1 0 N                  immr                imms                Rn               Rd
        opc


32-bit variant

Applies when sf = 0 && N = 0.

UBFIZ <Wd>, <Wn>, #<lsb>, #<width>

is equivalent to

UBFM <Wd>, <Wn>, #(-<lsb> MOD 32), #(<width>-1)

and is the preferred disassembly when UInt(imms) < UInt(immr).

64-bit variant

Applies when sf = 1 && N = 1.

UBFIZ <Xd>, <Xn>, #<lsb>, #<width>

is equivalent to

UBFM <Xd>, <Xn>, #(-<lsb> MOD 64), #(<width>-1)

and is the preferred disassembly when UInt(imms) < UInt(immr).


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<lsb>           For the 32-bit variant: is the bit number of the lsb of the destination bitfield, in the range 0 to 31.

                For the 64-bit variant: is the bit number of the lsb of the destination bitfield, in the range 0 to 63.

<width>         For the 32-bit variant: is the width of the bitfield, in the range 1 to 32-<lsb>.

                For the 64-bit variant: is the width of the bitfield, in the range 1 to 64-<lsb>.


Operation

The description of UBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','UBFM','Unsigned bitfield move, with zeros to left and right       (C6.6.212)

This instruction is used by the aliases LSL (immediate), LSR (immediate), UBFIZ, UBFX, UXTB, and UXTH. See
the Alias conditions on page C6-790 table for details of when each alias is preferred.




  31 30 29 28 27 26 25 24 23 22 21                16 15             10 9              5 4             0
  sf 1 0 1 0 0 1 1 0 N                    immr              imms              Rn             Rd
      opc


32-bit variant

Applies when sf = 0 && N = 0.

UBFM <Wd>, <Wn>, #<immr>, #<imms>


64-bit variant

Applies when sf = 1 && N = 1.

UBFM <Xd>, <Xn>, #<immr>, #<imms>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer datasize = if sf == ''1'' then 64 else 32;

 boolean inzero;
 boolean extend;
 integer R;
 integer S;
 bits(datasize) wmask;
 bits(datasize) tmask;

 case opc of
     when ''00'' inzero = TRUE;      extend = TRUE;      // SBFM
     when ''01'' inzero = FALSE; extend = FALSE;         // BFM
     when ''10'' inzero = TRUE;      extend = FALSE;     // UBFM
     when ''11'' UnallocatedEncoding();

 if sf == ''1'' && N != ''1'' then ReservedValue();
 if sf == ''0'' && (N != ''0'' || immr<5> != ''0'' || imms<5> != ''0'') then ReservedValue();

 R = UInt(immr);
 S = UInt(imms);
 (wmask, tmask) = DecodeBitMasks(N, imms, immr, FALSE);
       Alias conditions


          Alias                  of variant            is preferred when

          LSL (immediate)        32-bit                imms != ''011111'' && imms + 1 == immr

          LSL (immediate)        64-bit                imms != ''111111'' && imms + 1 == immr

          LSR (immediate)        32-bit                imms == ''011111''

          LSR (immediate)        64-bit                imms == ''111111''

          UBFIZ                  -                     UInt(imms) < UInt(immr)

          UBFX                   -                     BFXPreferred(sf, opc<1>, imms, immr)

          UXTB                   -                     immr == ''000000'' && imms == ''000111''

          UXTH                   -                     immr == ''000000'' && imms == ''001111''



       Assembler symbols

       <Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

       <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

       <immr>          For the 32-bit variant: is the right rotate amount, in the range 0 to 31, encoded in the "immr" field.

                       For the 64-bit variant: is the right rotate amount, in the range 0 to 63, encoded in the "immr" field.

       <imms>          For the 32-bit variant: is the leftmost bit number to be moved from the source, in the range 0 to 31,
                       encoded in the "imms" field.

                       For the 64-bit variant: is the leftmost bit number to be moved from the source, in the range 0 to 63,
                       encoded in the "imms" field.


       Operation

         bits(datasize) dst = if inzero then Zeros() else X[d];
         bits(datasize) src = X[n];

         // perform bitfield move on low bits
         bits(datasize) bot = (dst AND NOT(wmask)) OR (ROR(src, R) AND wmask);

         // determine extension bits (sign, zero or dest register)
         bits(datasize) top = if extend then Replicate(src<S>) else dst;

         // combine extension bits and result bits
         X[d] = (top AND NOT(tmask)) OR (bot AND tmask);');
INSERT INTO "instructions" VALUES('ARM','UBFX','Unsigned bitfield extract       (C6.6.213)

This instruction is an alias of the UBFM instruction. This means that:

.      The encodings in this description are named to match the encodings of UBFM.

.      The description of UBFM gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                  16 15                10 9            5 4              0
   sf 1 0 1 0 0 1 1 0 N                   immr                imms                Rn              Rd
      opc


32-bit variant

Applies when sf = 0 && N = 0.

UBFX <Wd>, <Wn>, #<lsb>, #<width>

is equivalent to

UBFM <Wd>, <Wn>, #<lsb>, #(<lsb>+<width>-1)

and is the preferred disassembly when BFXPreferred(sf, opc<1>, imms, immr).

64-bit variant

Applies when sf = 1 && N = 1.

UBFX <Xd>, <Xn>, #<lsb>, #<width>

is equivalent to

UBFM <Xd>, <Xn>, #<lsb>, #(<lsb>+<width>-1)

and is the preferred disassembly when BFXPreferred(sf, opc<1>, imms, immr).


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the general-purpose source register, encoded in the "Rn" field.

<lsb>           For the 32-bit variant: is the bit number of the lsb of the source bitfield, in the range 0 to 31.

                For the 64-bit variant: is the bit number of the lsb of the source bitfield, in the range 0 to 63.

<width>         For the 32-bit variant: is the width of the bitfield, in the range 1 to 32-<lsb>.

                For the 64-bit variant: is the width of the bitfield, in the range 1 to 64-<lsb>.


Operation

The description of UBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','UDIV','Unsigned Divide divides an unsigned integer register value by an unsigned integer register value, and writes the       (C6.6.214)
result to the destination register of the same size as source registers, 32-bit or 64-bit. The condition flags are not
affected. That is, it performs n unsigned divide: Rd = Rn / Rm.




    31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4             0
    sf 0 0 1 1 0 1 0 1 1 0                   Rm         0 0 0 0 1 0                Rn             Rd
                                                                         o1


32-bit variant

Applies when sf = 0.

UDIV <Wd>, <Wn>, <Wm>


64-bit variant

Applies when sf = 1.

UDIV <Xd>, <Xn>, <Xm>


Decode for all variants of this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  integer datasize = if sf == ''1'' then 64 else 32;
  boolean unsigned = (o1 == ''0'');


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register, encoded in the "Rm" field.

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register, encoded in the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register, encoded in the "Rm" field.


Operation

  bits(datasize) operand1 = X[n];
  bits(datasize) operand2 = X[m];
  integer result;

  if IsZero(operand2) then
       result = 0;
  else
       result = RoundTowardsZero (Int(operand1, unsigned) / Int(operand2, unsigned));

  X[d] = result<datasize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','UMADDL','Unsigned multiply-add long: Xd = Xa + Wn * Wm       (C6.6.215)

This instruction is used by the alias UMULL. See the Alias conditions table for details of when each alias is
preferred.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14          10 9             5 4              0
  1 0 0 1 1 0 1 1 1 0 1                     Rm         0       Ra               Rn             Rd
                             U                         o0


64-bit variant

UMADDL <Xd>, <Wn>, <Wm>, <Xa>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer a = UInt(Ra);
 integer destsize = 64;
 integer datasize = 32;
 boolean sub_op = (o0 == ''1'');
 boolean unsigned = (U == ''1'');


Alias conditions


                     Alias                     is preferred when

                     UMULL                     Ra == ''11111''



Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.

<Xa>            Is the 64-bit name of the third general-purpose source register holding the addend, encoded in the
                "Ra" field.


Operation

 bits(datasize) operand1 = X[n];
 bits(datasize) operand2 = X[m];
 bits(destsize) operand3 = X[a];

 integer result;

 if sub_op then
     result = Int(operand3, unsigned) - (Int(operand1, unsigned) * Int(operand2, unsigned));
 else
              result = Int(operand3, unsigned) + (Int(operand1, unsigned) * Int(operand2, unsigned));

         X[d] = result<63:0>;');
INSERT INTO "instructions" VALUES('ARM','UMNEGL','Unsigned multiply-negate long: Xd = -(Wn * Wm)       (C6.6.216)

This instruction is an alias of the UMSUBL instruction. This means that:

.      The encodings in this description are named to match the encodings of UMSUBL.

.      The description of UMSUBL gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14          10 9             5 4              0
   1 0 0 1 1 0 1 1 1 0 1                    Rm         1 1 1 1 1 1              Rn             Rd
                             U                         o0      Ra


64-bit variant

UMNEGL <Xd>, <Wn>, <Wm>

is equivalent to

UMSUBL <Xd>, <Wn>, <Wm>, XZR

and is always the preferred disassembly.


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

The description of UMSUBL gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','UMSUBL','      Unsigned multiply-subtract long: Xd = Xa - Wn * Wm       (C6.6.217)

      This instruction is used by the alias UMNEGL. See the Alias conditions table for details of when each alias is
      preferred.




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14          10 9             5 4              0
          1 0 0 1 1 0 1 1 1 0 1                   Rm         1       Ra               Rn             Rd
                                   U                         o0


      64-bit variant

      UMSUBL <Xd>, <Wn>, <Wm>, <Xa>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        integer a = UInt(Ra);
        integer destsize = 64;
        integer datasize = 32;
        boolean sub_op = (o0 == ''1'');
        boolean unsigned = (U == ''1'');


      Alias conditions


                           Alias                     is preferred when

                           UMNEGL                    Ra == ''11111''



      Assembler symbols

      <Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

      <Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                      the "Rn" field.

      <Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                      the "Rm" field.

      <Xa>            Is the 64-bit name of the third general-purpose source register holding the minuend, encoded in the
                      "Ra" field.


      Operation

        bits(datasize) operand1 = X[n];
        bits(datasize) operand2 = X[m];
        bits(destsize) operand3 = X[a];

        integer result;

        if sub_op then
             result = Int(operand3, unsigned) - (Int(operand1, unsigned) * Int(operand2, unsigned));
        else
   result = Int(operand3, unsigned) + (Int(operand1, unsigned) * Int(operand2, unsigned));

X[d] = result<63:0>;');
INSERT INTO "instructions" VALUES('ARM','UMULH','Unsigned multiply high: Xd = bits<127:64> of Xn * Xm       (C6.6.218)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14              10 9         5 4              0
    1 0 0 1 1 0 1 1 1 1 0                   Rm         0 (1) (1) (1) (1) (1)    Rn             Rd
                             U                                  Ra


64-bit variant

UMULH <Xd>, <Xn>, <Xm>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  integer a = UInt(Ra);             // ignored by UMULH/SMULH
  integer destsize = 64;
  integer datasize = destsize;
  boolean unsigned = (U == ''1'');


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Xn>            Is the 64-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Xm>            Is the 64-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

  bits(datasize) operand1 = X[n];
  bits(datasize) operand2 = X[m];

  integer result;

  result = Int(operand1, unsigned) * Int(operand2, unsigned);

  X[d] = result<127:64>;');
INSERT INTO "instructions" VALUES('ARM','UMULL','Unsigned multiply long: Xd = Wn * Wm       (C6.6.219)

This instruction is an alias of the UMADDL instruction. This means that:

.      The encodings in this description are named to match the encodings of UMADDL.

.      The description of UMADDL gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20              16 15 14          10 9             5 4              0
   1 0 0 1 1 0 1 1 1 0 1                    Rm         0 1 1 1 1 1              Rn             Rd
                             U                         o0      Ra


64-bit variant

UMULL <Xd>, <Wn>, <Wm>

is equivalent to

UMADDL <Xd>, <Wn>, <Wm>, XZR

and is always the preferred disassembly.


Assembler symbols

<Xd>            Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the first general-purpose source register holding the multiplicand, encoded in
                the "Rn" field.

<Wm>            Is the 32-bit name of the second general-purpose source register holding the multiplier, encoded in
                the "Rm" field.


Operation

The description of UMADDL gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','UXTB','Unsigned extend byte: Wd = ZeroExtend(Wn<7:0>)       (C6.6.220)

This instruction is an alias of the UBFM instruction. This means that:

.       The encodings in this description are named to match the encodings of UBFM.

.       The description of UBFM gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21              16 15             10 9             5 4              0
    0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1                                Rn              Rd
    sf opc                       N       immr              imms


32-bit variant

UXTB <Wd>, <Wn>

is equivalent to

UBFM <Wd>, <Wn>, #0, #7

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

The description of UBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','UXTH','Unsigned extend halfword: Wd = ZeroExtend(Wn<15:0>)       (C6.6.221)

This instruction is an alias of the UBFM instruction. This means that:

.      The encodings in this description are named to match the encodings of UBFM.

.      The description of UBFM gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21                16 15             10 9              5 4              0
   0 1 0 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1                                 Rn              Rd
   sf opc                        N       immr              imms


32-bit variant

UXTH <Wd>, <Wn>

is equivalent to

UBFM <Wd>, <Wn>, #0, #15

and is always the preferred disassembly.


Assembler symbols

<Wd>            Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

<Wn>            Is the 32-bit name of the general-purpose source register, encoded in the "Rn" field.


Operation

The description of UBFM gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','WFE','Wait for event       (C6.6.222)

This instruction is an alias of the HINT instruction. This means that:

.       The encodings in this description are named to match the encodings of HINT.

.       The description of HINT gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11         8 7       5 4 3 2 1 0
    1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 0 1 1 1 1 1
                                                                      CRm       op2


System variant

WFE

is equivalent to

HINT #2

and is always the preferred disassembly.


Operation

The description of HINT gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','WFI','Wait for interrupt       (C6.6.223)

This instruction is an alias of the HINT instruction. This means that:

.      The encodings in this description are named to match the encodings of HINT.

.      The description of HINT gives the operational pseudocode for this instruction.




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11          8 7       5 4 3 2 1 0
   1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 1 1 1 1 1 1 1
                                                                      CRm      op2


System variant

WFI

is equivalent to

HINT #3

and is always the preferred disassembly.


Operation

The description of HINT gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','YIELD','Yield hint       (C6.6.224)

This instruction is an alias of the HINT instruction. This means that:

.       The encodings in this description are named to match the encodings of HINT.

.       The description of HINT gives the operational pseudocode for this instruction.




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11         8 7       5 4 3 2 1 0
    1 1 0 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 1 0 0 0 0 0 0 0 1 1 1 1 1 1
                                                                      CRm       op2


System variant

YIELD

is equivalent to

HINT #1

and is always the preferred disassembly.


Operation

The description of HINT gives the operational pseudocode for this instruction.');
INSERT INTO "instructions" VALUES('ARM','ABS','       Absolute value (vector)       (C7.3.1)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
            0 1 0 1 1 1 1 0 size 1 0 0 0 0 0 1 0 1 1 1 0                                  Rn             Rd
                  U


       Scalar variant

       ABS <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if size != ''11'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = esize;
         integer elements = 1;

         boolean neg = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
            0 Q 0 0 1 1 1 0 size 1 0 0 0 0 0 1 0 1 1 1 0                                  Rn             Rd
                  U


       Vector variant

       ABS <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if size:Q == ''110'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         boolean neg = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "size" field. It can have the following values:

                         D           when size = 11

                         It is RESERVED when:

                         .      size = 0x.

                         .      size = 10.

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.
<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              4H          when size = 01, Q = 0

              8H          when size = 01, Q = 1

              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              2D          when size = 11, Q = 1

              It is RESERVED when size = 11, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 integer element;

 for e = 0 to elements-1
     element = SInt(Elem[operand, e, esize]);
     if neg then
         element = -element;
     else
         element = Abs(element);
     Elem[result, e, esize] = element<esize-1:0>;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','ADDHN','       Add returning high narrow       (C7.3.3)




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 0 size 1                   Rm          0 1 0 0 0 0               Rn               Rd
                  U                                                    o1


       Three registers, not all the same type variant

       ADDHN{2} <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         if size == ''11'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean sub_op = (o1 == ''1'');
         boolean round = (U == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when size = 11, Q = x.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         8H          when size = 00

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when size = 11.
<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(2*datasize) operand1 = V[n];
 bits(2*datasize) operand2 = V[m];
 bits(datasize)   result;
 integer round_const = if round then 1 << (esize - 1) else 0;
 bits(2*esize) element1;
 bits(2*esize) element2;
 bits(2*esize) sum;

 for e = 0 to elements-1
     element1 = Elem[operand1, e, 2*esize];
     element2 = Elem[operand2, e, 2*esize];
     if sub_op then
         sum = element1 - element2;
     else
         sum = element1 + element2;
     sum = sum + round_const;
     Elem[result, e, esize] = sum<2*esize-1:esize>;

 Vpart[d, part] = result;');
INSERT INTO "instructions" VALUES('ARM','ADDHN2','-R:ADDHN');
INSERT INTO "instructions" VALUES('ARM','ADDP','Add pair of elements (scalar)       (C7.3.4)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4            0
     0 1 0 1 1 1 1 0 size 1 1 0 0 0 1 1 0 1 1 1 0                                  Rn               Rd




Advanced SIMD variant

ADDP <V><d>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  if size != ''11'' then ReservedValue();

  integer esize = 8 << UInt(size);
  integer datasize = esize * 2;
  integer elements = 2;

  ReduceOp op = ReduceOp_ADD;


Assembler symbols

<V>               Is the destination width specifier, encoded in the "size" field. It can have the following values:

                  D           when size = 11

                  It is RESERVED when:

                  .      size = 0x.

                  .      size = 10.

<d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>               Is the source arrangement specifier, encoded in the "size" field. It can have the following values:

                  2D          when size = 11

                  It is RESERVED when:

                  .      size = 0x.

                  .      size = 10.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','ADDV','Add across vector       (C7.3.6)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4            0
     0 Q 0 0 1 1 1 0 size 1 1 0 0 0 1 1 0 1 1 1 0                                  Rn               Rd




Advanced SIMD variant

ADDV <V><d>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  if size:Q == ''100'' then ReservedValue();
  if size == ''11'' then ReservedValue();

  integer esize = 8 << UInt(size);
  integer datasize = if Q == ''1'' then 128 else 64;
  integer elements = datasize DIV esize;

  ReduceOp op = ReduceOp_ADD;


Assembler symbols

<V>               Is the destination width specifier, encoded in the "size" field. It can have the following values:

                  B           when size = 00

                  H           when size = 01

                  S           when size = 10

                  It is RESERVED when size = 11.

<d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                  8B          when size = 00, Q = 0

                  16B         when size = 00, Q = 1

                  4H          when size = 01, Q = 0

                  8H          when size = 01, Q = 1

                  4S          when size = 10, Q = 1

                  It is RESERVED when:

                  .      size = 10, Q = 0.

                  .      size = 11, Q = x.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','AESD','AES single round decryption       (C7.3.7)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                5 4          0
  0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 1 1 0                                Rn             Rd
                                                           D


Advanced SIMD variant

AESD <Vd>.16B, <Vn>.16B


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 if ! HaveCryptoExt() then UnallocatedEncoding();
 boolean decrypt = (D == ''1'');


Assembler symbols

<Vd>          Is the name of the SIMD&FP source and destination register, encoded in the "Rd" field.

<Vn>          Is the name of the second SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckCryptoEnabled64();

 bits(128) operand1 = V[d];
 bits(128) operand2 = V[n];
 bits(128) result;
 result = operand1 EOR operand2;
 if decrypt then
     result = AESInvSubBytes(AESInvShiftRows(result));
 else
     result = AESSubBytes(AESShiftRows(result));

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','AESE','AES single round encryption       (C7.3.8)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9             5 4             0
     0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 0 0 1 0                              Rn             Rd
                                                               D


Advanced SIMD variant

AESE <Vd>.16B, <Vn>.16B


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  if ! HaveCryptoExt() then UnallocatedEncoding();
  boolean decrypt = (D == ''1'');


Assembler symbols

<Vd>              Is the name of the SIMD&FP source and destination register, encoded in the "Rd" field.

<Vn>              Is the name of the second SIMD&FP source register, encoded in the "Rn" field.


Operation

  CheckCryptoEnabled64();

  bits(128) operand1 = V[d];
  bits(128) operand2 = V[n];
  bits(128) result;
  result = operand1 EOR operand2;
  if decrypt then
       result = AESInvSubBytes(AESInvShiftRows(result));
  else
       result = AESSubBytes(AESShiftRows(result));

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','AESIMC','AES inverse mix columns       (C7.3.9)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                5 4          0
  0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 1 1 0                                Rn             Rd
                                                           D


Advanced SIMD variant

AESIMC <Vd>.16B, <Vn>.16B


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 if ! HaveCryptoExt() then UnallocatedEncoding();
 boolean decrypt = (D == ''1'');


Assembler symbols

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckCryptoEnabled64();

 bits(128) operand = V[n];
 bits(128) result;
 if decrypt then
     result = AESInvMixColumns(operand);
 else
     result = AESMixColumns(operand);
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','AESMC','AES mix columns       (C7.3.10)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9             5 4         0
     0 1 0 0 1 1 1 0 0 0 1 0 1 0 0 0 0 1 1 0 1 0                              Rn             Rd
                                                               D


Advanced SIMD variant

AESMC <Vd>.16B, <Vn>.16B


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  if ! HaveCryptoExt() then UnallocatedEncoding();
  boolean decrypt = (D == ''1'');


Assembler symbols

<Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

  CheckCryptoEnabled64();

  bits(128) operand = V[n];
  bits(128) result;
  if decrypt then
       result = AESInvMixColumns(operand);
  else
       result = AESMixColumns(operand);
  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','BIF','Bitwise insert if false       (C7.3.14)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                 5 4          0
  0 Q 1 0 1 1 1 0 1 1 1                    Rm         0 0 0 1 1 1               Rn             Rd
                             opc2


Three registers of the same type variant

BIF <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 8;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 VBitOp op;

 case opc2 of
     when ''00'' op = VBitOp_VEOR;
     when ''01'' op = VBitOp_VBSL;
     when ''10'' op = VBitOp_VBIT;
     when ''11'' op = VBitOp_VBIF;


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "Q" field. It can have the following values:

                8B          when Q = 0

                16B         when Q = 1

<Vn>            Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>            Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1;
 bits(datasize) operand2;
 bits(datasize) operand3;
 bits(datasize) operand4 = V[n];

 case op of
     when VBitOp_VEOR
         operand1 = V[m];
         operand2 = Zeros();
         operand3 = Ones();
     when VBitOp_VBSL
         operand1 = V[m];
         operand2 = operand1;
         operand3 = V[d];
     when VBitOp_VBIT
         operand1 = V[d];
                   operand2 = operand1;
                   operand3 = V[m];
              when VBitOp_VBIF
                   operand1 = V[d];
                   operand2 = operand1;
                   operand3 = NOT(V[m]);

         V[d] = operand1 EOR ((operand2 EOR operand4) AND operand3);');
INSERT INTO "instructions" VALUES('ARM','BIT','Bitwise insert if true       (C7.3.15)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                 5 4          0
  0 Q 1 0 1 1 1 0 1 0 1                    Rm         0 0 0 1 1 1               Rn             Rd
                             opc2


Three registers of the same type variant

BIT <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 8;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 VBitOp op;

 case opc2 of
     when ''00'' op = VBitOp_VEOR;
     when ''01'' op = VBitOp_VBSL;
     when ''10'' op = VBitOp_VBIT;
     when ''11'' op = VBitOp_VBIF;


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "Q" field. It can have the following values:

                8B          when Q = 0

                16B         when Q = 1

<Vn>            Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>            Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1;
 bits(datasize) operand2;
 bits(datasize) operand3;
 bits(datasize) operand4 = V[n];

 case op of
     when VBitOp_VEOR
         operand1 = V[m];
         operand2 = Zeros();
         operand3 = Ones();
     when VBitOp_VBSL
         operand1 = V[m];
         operand2 = operand1;
         operand3 = V[d];
     when VBitOp_VBIT
         operand1 = V[d];
                   operand2 = operand1;
                   operand3 = V[m];
              when VBitOp_VBIF
                   operand1 = V[d];
                   operand2 = operand1;
                   operand3 = NOT(V[m]);

         V[d] = operand1 EOR ((operand2 EOR operand4) AND operand3);');
INSERT INTO "instructions" VALUES('ARM','BSL','Bitwise select       (C7.3.16)




  31 30 29 28 27 26 25 24 23 22 21 20          16 15 14 13 12 11 10 9                 5 4          0
  0 Q 1 0 1 1 1 0 0 1 1                  Rm         0 0 0 1 1 1               Rn             Rd
                          opc2


Three registers of the same type variant

BSL <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 8;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 VBitOp op;

 case opc2 of
     when ''00'' op = VBitOp_VEOR;
     when ''01'' op = VBitOp_VBSL;
     when ''10'' op = VBitOp_VBIT;
     when ''11'' op = VBitOp_VBIF;


Assembler symbols

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "Q" field. It can have the following values:

              8B          when Q = 0

              16B         when Q = 1

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1;
 bits(datasize) operand2;
 bits(datasize) operand3;
 bits(datasize) operand4 = V[n];

 case op of
     when VBitOp_VEOR
         operand1 = V[m];
         operand2 = Zeros();
         operand3 = Ones();
     when VBitOp_VBSL
         operand1 = V[m];
         operand2 = operand1;
         operand3 = V[d];
     when VBitOp_VBIT
         operand1 = V[d];
                   operand2 = operand1;
                   operand3 = V[m];
              when VBitOp_VBIF
                   operand1 = V[d];
                   operand2 = operand1;
                   operand3 = NOT(V[m]);

         V[d] = operand1 EOR ((operand2 EOR operand4) AND operand3);');
INSERT INTO "instructions" VALUES('ARM','CMEQ','Compare bitwise equal (vector), setting destination vector element to all ones if the condition holds, else zero       (C7.3.19)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                 5 4           0
  0 1 1 1 1 1 1 0 size 1                  Rm         1 0 0 0 1 1                Rn             Rd
        U


Scalar variant

CMEQ <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;
 boolean and_test = (U == ''0'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                 5 4           0
  0 Q 1 0 1 1 1 0 size 1                  Rm         1 0 0 0 1 1                Rn             Rd
        U


Vector variant

CMEQ <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean and_test = (U == ''0'');


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              D           when size = 11

              It is RESERVED when:

              .      size = 0x.

              .      size = 10.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<m>           Is the number of the second SIMD&FP source register, encoded in the "Rm" field.
       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              if and_test then
                   test_passed = !IsZero(element1 AND element2);
              else
                   test_passed = (element1 == element2);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CMGE','Compare signed greater than or equal (vector)       (C7.3.21)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4          0
  0 1 0 1 1 1 1 0 size 1                  Rm         0 0 1 1 1 1               Rn             Rd
        U                                                          eq


Scalar variant

CMGE <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 1 0 size 1                  Rm         0 0 1 1 1 1               Rn             Rd
        U                                                          eq


Vector variant

CMGE <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              D           when size = 11

              It is RESERVED when:

              .      size = 0x.

              .      size = 10.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.
       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         integer element1;
         integer element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Int(Elem[operand1, e, esize], unsigned);
              element2 = Int(Elem[operand2, e, esize], unsigned);
              test_passed = if cmp_eq then element1 >= element2 else element1 > element2;
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CMGT','Compare signed greater than (vector), setting destination vector element to all ones if the condition holds, else zero       (C7.3.23)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4             0
  0 1 0 1 1 1 1 0 size 1                   Rm        0 0 1 1 0 1               Rn              Rd
        U                                                          eq


Scalar variant

CMGT <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4             0
  0 Q 0 0 1 1 1 0 size 1                   Rm        0 0 1 1 0 1               Rn              Rd
        U                                                          eq


Vector variant

CMGT <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              D           when size = 11

              It is RESERVED when:

              .      size = 0x.

              .      size = 10.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.
       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         integer element1;
         integer element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Int(Elem[operand1, e, esize], unsigned);
              element2 = Int(Elem[operand2, e, esize], unsigned);
              test_passed = if cmp_eq then element1 >= element2 else element1 > element2;
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CMHI','Compare unsigned higher (vector), setting destination vector element to all ones if the condition holds, else zero       (C7.3.25)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4            0
  0 1 1 1 1 1 1 0 size 1                  Rm         0 0 1 1 0 1               Rn             Rd
        U                                                          eq


Scalar variant

CMHI <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4            0
  0 Q 1 0 1 1 1 0 size 1                  Rm         0 0 1 1 0 1               Rn             Rd
        U                                                          eq


Vector variant

CMHI <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              D           when size = 11

              It is RESERVED when:

              .      size = 0x.

              .      size = 10.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.
       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         integer element1;
         integer element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Int(Elem[operand1, e, esize], unsigned);
              element2 = Int(Elem[operand2, e, esize], unsigned);
              test_passed = if cmp_eq then element1 >= element2 else element1 > element2;
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CMHS','Compare unsigned higher or same (vector), setting destination vector element to all ones if the condition holds, else       (C7.3.26)
zero


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4              0
  0 1 1 1 1 1 1 0 size 1                 Rm          0 0 1 1 1 1               Rn               Rd
        U                                                          eq


Scalar variant

CMHS <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4              0
  0 Q 1 0 1 1 1 0 size 1                 Rm          0 0 1 1 1 1               Rn               Rd
        U                                                          eq


Vector variant

CMHS <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean unsigned = (U == ''1'');
 boolean cmp_eq = (eq == ''1'');


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              D           when size = 11

              It is RESERVED when:

              .      size = 0x.

              .      size = 10.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.
       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         integer element1;
         integer element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Int(Elem[operand1, e, esize], unsigned);
              element2 = Int(Elem[operand2, e, esize], unsigned);
              test_passed = if cmp_eq then element1 >= element2 else element1 > element2;
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CMLE','Compare signed less than or equal to zero (vector), setting destination vector element to all ones if the condition       (C7.3.27)
holds, else zero


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4             0
  0 1 1 1 1 1 1 0 size 1 0 0 0 0 0 1 0 0 1 1 0                                 Rn              Rd
         U                                                    op


Scalar variant

CMLE <V><d>, <V><n>, #0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;

 CompareOp comparison;
 case op:U of
     when ''00'' comparison = CompareOp_GT;
     when ''01'' comparison = CompareOp_GE;
     when ''10'' comparison = CompareOp_EQ;
     when ''11'' comparison = CompareOp_LE;


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4             0
  0 Q 1 0 1 1 1 0 size 1 0 0 0 0 0 1 0 0 1 1 0                                 Rn              Rd
         U                                                    op


Vector variant

CMLE <Vd>.<T>, <Vn>.<T>, #0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 CompareOp comparison;
 case op:U of
     when ''00'' comparison = CompareOp_GT;
     when ''01'' comparison = CompareOp_GE;
     when ''10'' comparison = CompareOp_EQ;
     when ''11'' comparison = CompareOp_LE;
       Assembler symbols

       <V>               Is a width specifier, encoded in the "size" field. It can have the following values:

                         D           when size = 11

                         It is RESERVED when:

                         .      size = 0x.

                         .      size = 10.

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = V[n];
         bits(datasize) result;
         integer element;
         boolean test_passed;

         for e = 0 to elements-1
              element = SInt(Elem[operand, e, esize]);
              case comparison of
                   when CompareOp_GT test_passed = element > 0;
                   when CompareOp_GE test_passed = element >= 0;
                   when CompareOp_EQ test_passed = element == 0;
                   when CompareOp_LE test_passed = element <= 0;
                   when CompareOp_LT test_passed = element < 0;
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CMLT','Compare signed less than zero (vector), setting destination vector element to all ones if the condition holds, else zero       (C7.3.28)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4              0
  0 1 0 1 1 1 1 0 size 1 0 0 0 0 0 1 0 1 0 1 0                                  Rn               Rd




Scalar variant

CMLT <V><d>, <V><n>, #0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;

 CompareOp comparison = CompareOp_LT;


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4              0
  0 Q 0 0 1 1 1 0 size 1 0 0 0 0 0 1 0 1 0 1 0                                  Rn               Rd




Vector variant

CMLT <Vd>.<T>, <Vn>.<T>, #0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 CompareOp comparison = CompareOp_LT;


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              D           when size = 11

              It is RESERVED when:

              .      size = 0x.

              .      size = 10.

<d>           Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>           Is the number of the SIMD&FP source register, encoded in the "Rn" field.
       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = V[n];
         bits(datasize) result;
         integer element;
         boolean test_passed;

         for e = 0 to elements-1
              element = SInt(Elem[operand, e, esize]);
              case comparison of
                   when CompareOp_GT test_passed = element > 0;
                   when CompareOp_GE test_passed = element >= 0;
                   when CompareOp_EQ test_passed = element == 0;
                   when CompareOp_LE test_passed = element <= 0;
                   when CompareOp_LT test_passed = element < 0;
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CMTST','Compare bitwise test bits nonzero (vector), setting destination vector element to all ones if the condition holds, else       (C7.3.29)
zero


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4              0
  0 1 0 1 1 1 1 0 size 1                   Rm         1 0 0 0 1 1               Rn                Rd
        U


Scalar variant

CMTST <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size != ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;
 boolean and_test = (U == ''0'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4              0
  0 Q 0 0 1 1 1 0 size 1                   Rm         1 0 0 0 1 1               Rn                Rd
        U


Vector variant

CMTST <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size:Q == ''110'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean and_test = (U == ''0'');


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              D            when size = 11

              It is RESERVED when:

              .      size = 0x.

              .      size = 10.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.
       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         2D          when size = 11, Q = 1

                         It is RESERVED when size = 11, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              if and_test then
                   test_passed = !IsZero(element1 AND element2);
              else
                   test_passed = (element1 == element2);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','CNT','Population count per byte       (C7.3.30)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                 5 4           0
  0 Q 0 0 1 1 1 0 size 1 0 0 0 0 0 0 1 0 1 1 0                                Rn              Rd




Vector variant

CNT <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if size != ''00'' then ReservedValue();
 integer esize = 8;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV 8;


Assembler symbols

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              It is RESERVED when:

              .      size = 01, Q = x.

              .      size = 1x, Q = x.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;

 integer count;
 for e = 0 to elements-1
     count = BitCount(Elem[operand, e, esize]);
     Elem[result, e, esize] = count<esize-1:0>;
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','DUP','       Duplicate vector element to vector or scalar       (C7.3.31)

       This instruction is used by the alias MOV (scalar). The alias is always the preferred disassembly.


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9              5 4          0
            0 1 0 1 1 1 1 0 0 0 0                imm5         0 0 0 0 0 1             Rn             Rd




       Scalar variant

       DUP <V><d>, <Vn>.<T>[<index>]


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer size = LowestSetBit(imm5);
         if size > 3 then UnallocatedEncoding();

         integer index = UInt(imm5<4:size+1>);
         integer idxdsize = if imm5<4> == ''1'' then 128 else 64;

         integer esize = 8 << size;
         integer datasize = esize;
         integer elements = 1;


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9              5 4          0
            0 Q 0 0 1 1 1 0 0 0 0                imm5         0 0 0 0 0 1             Rn             Rd




       Vector variant

       DUP <Vd>.<T>, <Vn>.<Ts>[<index>]


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer size = LowestSetBit(imm5);
         if size > 3 then UnallocatedEncoding();

         integer index = UInt(imm5<4:size+1>);
         integer idxdsize = if imm5<4> == ''1'' then 128 else 64;

         if size == 3 && Q == ''0'' then ReservedValue();
         integer esize = 8 << size;
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;
Assembler symbols

<T>       For the scalar variant: is the element width specifier, encoded in the "imm5" field. It can have the
          following values:

          B           when imm5 = xxxx1

          H           when imm5 = xxx10

          S           when imm5 = xx100

          D           when imm5 = x1000

          It is RESERVED when imm5 = x0000.

          For the vector variant: is an arrangement specifier, encoded in the "imm5:Q" field. It can have the
          following values:

          8B          when imm5 = xxxx1, Q = 0

          16B         when imm5 = xxxx1, Q = 1

          4H          when imm5 = xxx10, Q = 0

          8H          when imm5 = xxx10, Q = 1

          2S          when imm5 = xx100, Q = 0

          4S          when imm5 = xx100, Q = 1

          2D          when imm5 = x1000, Q = 1

          It is RESERVED when:

          .      imm5 = x0000, Q = x.

          .      imm5 = x1000, Q = 0.

<Ts>      Is an element size specifier, encoded in the "imm5" field. It can have the following values:

          B           when imm5 = xxxx1

          H           when imm5 = xxx10

          S           when imm5 = xx100

          D           when imm5 = x1000

          It is RESERVED when imm5 = x0000.

<V>       Is the destination width specifier, encoded in the "imm5" field. It can have the following values:

          B           when imm5 = xxxx1

          H           when imm5 = xxx10

          S           when imm5 = xx100

          D           when imm5 = x1000

          It is RESERVED when imm5 = x0000.

<Vn>      Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<index>   Is the element index encoded in the "imm5" field. It can have the following values:

          imm5<4:1>   when imm5 = xxxx1

          imm5<4:2>   when imm5 = xxx10

          imm5<4:3>   when imm5 = xx100

          imm5<4>     when imm5 = x1000

          It is RESERVED when imm5 = x0000.

<d>       Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vd>      Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(idxdsize) operand = V[n];
         bits(datasize) result;
         bits(esize) element;

         element = Elem[operand, index, esize];
         for e = 0 to elements-1
              Elem[result, e, esize] = element;
         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','EXT','Extract vector from pair of vectors       (C7.3.34)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14         11 10 9               5 4          0
  0 Q 1 0 1 1 1 0 0 0 0                    Rm         0    imm4        0        Rn             Rd




Advanced SIMD variant

EXT <Vd>.<T>, <Vn>.<T>, <Vm>.<T>, #<index>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);

 if Q == ''0'' && imm4<3> == ''1'' then UnallocatedEncoding();

 integer datasize = if Q == ''1'' then 128 else 64;
 integer position = UInt(imm4) << 3;


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "Q" field. It can have the following values:

                8B          when Q = 0

                16B         when Q = 1

<Vn>            Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>            Is the name of the second SIMD&FP source register, encoded in the "Rm" field.

<index>         Is the lowest numbered byte element to be extracted, encoded in the "Q:imm4" field. It can have the
                following values:

                imm4<2:0>   when Q = 0, imm4<3> = 0

                imm4        when Q = 1, imm4<3> = x

                It is RESERVED when Q = 0, imm4<3> = 1.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) hi = V[m];
 bits(datasize) lo = V[n];
 bits(datasize*2) concat = hi : lo;

 V[d] = concat<position+datasize-1:position>;');
INSERT INTO "instructions" VALUES('ARM','FABD','       Floating-point absolute difference (vector)       (C7.3.35)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4         0
            0 1 1 1 1 1 1 0 1 sz 1                   Rm         1 1 0 1 0 1               Rn             Rd




       Scalar variant

       FABD <V><d>, <V><n>, <V><m>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;
         boolean abs = TRUE;


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4         0
            0 Q 1 0 1 1 1 0 1 sz 1                   Rm         1 1 0 1 0 1               Rn             Rd
                  U


       Vector variant

       FABD <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;
         boolean abs = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

              2S          when sz = 0, Q = 0

              4S          when sz = 0, Q = 1

              2D          when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];
 bits(datasize) result;
 bits(esize) element1;
 bits(esize) element2;
 bits(esize) diff;

 for e = 0 to elements-1
     element1 = Elem[operand1, e, esize];
     element2 = Elem[operand2, e, esize];
     diff = FPSub(element1, element2, FPCR);
     Elem[result, e, esize] = if abs then FPAbs(diff) else diff;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FABS','Floating-point absolute value (vector)       (C7.3.36)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4            0
     0 Q 0 0 1 1 1 0 1 sz 1 0 0 0 0 0 1 1 1 1 1 0                                Rn              Rd
           U


Vector variant

FABS <Vd>.<T>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  if sz:Q == ''10'' then ReservedValue();
  integer esize = 32 << UInt(sz);
  integer datasize = if Q == ''1'' then 128 else 64;
  integer elements = datasize DIV esize;

  boolean neg = (U == ''1'');


Assembler symbols

<Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                  2S          when sz = 0, Q = 0

                  4S          when sz = 0, Q = 1

                  2D          when sz = 1, Q = 1

                  It is RESERVED when sz = 1, Q = 0.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  bits(datasize) result;
  bits(esize) element;

  for e = 0 to elements-1
       element = Elem[operand, e, esize];
       if neg then
            element = FPNeg(element);
       else
            element = FPAbs(element);
       Elem[result, e, esize] = element;

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FACGE','Floating-point absolute compare greater than or equal (vector)       (C7.3.38)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4          0
  0 1 1 1 1 1 1 0 0 sz 1                  Rm        1 1 1 0 1 1               Rn             Rd
        U                  E                                    ac


Scalar variant

FACGE <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();


Vector


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4          0
  0 Q 1 0 1 1 1 0 0 sz 1                  Rm        1 1 1 0 1 1               Rn             Rd
        U                  E                                    ac


Vector variant

FACGE <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();
       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              if abs then
                   element1 = FPAbs(element1);
                   element2 = FPAbs(element2);
              case cmp of
                   when CompareOp_EQ test_passed = FPCompareEQ(element1, element2, FPCR);
                   when CompareOp_GE test_passed = FPCompareGE(element1, element2, FPCR);
                   when CompareOp_GT test_passed = FPCompareGT(element1, element2, FPCR);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FACGT','Floating-point absolute compare greater than (vector)       (C7.3.39)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4          0
  0 1 1 1 1 1 1 0 1 sz 1                  Rm        1 1 1 0 1 1               Rn             Rd
        U                  E                                    ac


Scalar variant

FACGT <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();


Vector


  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                5 4          0
  0 Q 1 0 1 1 1 0 1 sz 1                  Rm        1 1 1 0 1 1               Rn             Rd
        U                  E                                    ac


Vector variant

FACGT <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();
       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              if abs then
                   element1 = FPAbs(element1);
                   element2 = FPAbs(element2);
              case cmp of
                   when CompareOp_EQ test_passed = FPCompareEQ(element1, element2, FPCR);
                   when CompareOp_GE test_passed = FPCompareGE(element1, element2, FPCR);
                   when CompareOp_GT test_passed = FPCompareGT(element1, element2, FPCR);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FADD','Floating-point add (vector)       (C7.3.40)




  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                 5 4           0
  0 Q 0 0 1 1 1 0 0 sz 1                  Rm         1 1 0 1 0 1               Rn             Rd
        U


Three registers of the same type variant

FADD <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean pair = (U == ''1'');


Assembler symbols

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>            Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

               2S          when sz = 0, Q = 0

               4S          when sz = 0, Q = 1

               2D          when sz = 1, Q = 1

               It is RESERVED when sz = 1, Q = 0.

<Vn>           Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>           Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];
 bits(datasize) result;
 bits(2*datasize) concat = operand2:operand1;
 bits(esize) element1;
 bits(esize) element2;

 for e = 0 to elements-1
     if pair then
         element1 = Elem[concat, 2*e, esize];
         element2 = Elem[concat, (2*e)+1, esize];
     else
         element1 = Elem[operand1, e, esize];
         element2 = Elem[operand2, e, esize];
     Elem[result, e, esize] = FPAdd(element1, element2, FPCR);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FADDP','Floating-point add pair of elements (scalar)       (C7.3.42)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4             0
  0 1 1 1 1 1 1 0 0 sz 1 1 0 0 0 0 1 1 0 1 1 0                                   Rn              Rd




Advanced SIMD variant

FADDP <V><d>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 32 << UInt(sz);
 integer datasize = esize * 2;
 integer elements = 2;

 ReduceOp op = ReduceOp_FADD;


Assembler symbols

<V>            Is the destination width specifier, encoded in the "sz" field. It can have the following values:

               S            when sz = 0

               D            when sz = 1

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>           Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>            Is the source arrangement specifier, encoded in the "sz" field. It can have the following values:

               2S           when sz = 0

               2D           when sz = 1


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FCCMP','Floating-point conditional quiet compare (scalar), setting condition flags to result of comparison or an immediate       (C7.3.44)
value: flags = if cond then compareQuiet(Vn,Vm) else #nzcv




  31 30 29 28 27 26 25 24 23 22 21 20             16 15         12 11 10 9               5 4 3          0
  0 0 0 1 1 1 1 0 0 x 1                      Rm           cond      0 1          Rn         0    nzcv
                            type                                                           op


Single-precision variant

Applies when type = 00.

FCCMP <Sn>, <Sm>, #<nzcv>, <cond>


Double-precision variant

Applies when type = 01.

FCCMP <Dn>, <Dm>, #<nzcv>, <cond>


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer m = UInt(Rm);

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 boolean signal_all_nans = (op == ''1'');
 bits(4) condition = cond;
 bits(4) flags = nzcv;


Assembler symbols

<Dn>           Is the 64-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<Sn>           Is the 32-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Sm>           Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<nzcv>         Is the flag bit specifier, an immediate in the range 0 to 15, giving the alternative state for the 4-bit
               NZCV condition flags, encoded in the "nzcv" field.

<cond>         Is one of the standard conditions, encoded in the "cond" field in the standard way.


Operation

 CheckFPAdvSIMDEnabled64();

 bits(datasize) operand1 = V[n];
 bits(datasize) operand2;

 operand2 = V[m];
         if ConditionHolds(condition) then
              flags = FPCompare(operand1, operand2, signal_all_nans, FPCR);
         PSTATE.<N,Z,C,V> = flags;');
INSERT INTO "instructions" VALUES('ARM','FCCMPE','Floating-point conditional signaling compare (scalar), setting condition flags to result of comparison or an       (C7.3.45)
immediate value: flags = if cond then compareSignaling(Vn,Vm) else #nzcv




  31 30 29 28 27 26 25 24 23 22 21 20             16 15         12 11 10 9               5 4 3          0
  0 0 0 1 1 1 1 0 0 x 1                      Rm           cond      0 1          Rn         1    nzcv
                            type                                                           op


Single-precision variant

Applies when type = 00.

FCCMPE <Sn>, <Sm>, #<nzcv>, <cond>


Double-precision variant

Applies when type = 01.

FCCMPE <Dn>, <Dm>, #<nzcv>, <cond>


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer m = UInt(Rm);

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 boolean signal_all_nans = (op == ''1'');
 bits(4) condition = cond;
 bits(4) flags = nzcv;


Assembler symbols

<Dn>           Is the 64-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<Sn>           Is the 32-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Sm>           Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<nzcv>         Is the flag bit specifier, an immediate in the range 0 to 15, giving the alternative state for the 4-bit
               NZCV condition flags, encoded in the "nzcv" field.

<cond>         Is one of the standard conditions, encoded in the "cond" field in the standard way.


Operation

 CheckFPAdvSIMDEnabled64();

 bits(datasize) operand1 = V[n];
 bits(datasize) operand2;

 operand2 = V[m];
         if ConditionHolds(condition) then
              flags = FPCompare(operand1, operand2, signal_all_nans, FPCR);
         PSTATE.<N,Z,C,V> = flags;');
INSERT INTO "instructions" VALUES('ARM','FCMEQ','Floating-point compare equal (vector), setting destination vector element to all ones if the condition holds, else zero       (C7.3.46)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4             0
  0 1 0 1 1 1 1 0 0 sz 1                   Rm         1 1 1 0 0 1               Rn              Rd
        U                  E                                      ac


Scalar variant

FCMEQ <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();


Vector


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4             0
  0 Q 0 0 1 1 1 0 0 sz 1                   Rm         1 1 1 0 0 1               Rn              Rd
        U                  E                                      ac


Vector variant

FCMEQ <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();
       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              if abs then
                   element1 = FPAbs(element1);
                   element2 = FPAbs(element2);
              case cmp of
                   when CompareOp_EQ test_passed = FPCompareEQ(element1, element2, FPCR);
                   when CompareOp_GE test_passed = FPCompareGE(element1, element2, FPCR);
                   when CompareOp_GT test_passed = FPCompareGT(element1, element2, FPCR);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCMGE','Floating-point compare greater than or equal (vector), setting destination vector element to all ones if the condition       (C7.3.48)
holds, else zero


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4              0
  0 1 1 1 1 1 1 0 0 sz 1                  Rm         1 1 1 0 0 1               Rn               Rd
         U                 E                                       ac


Scalar variant

FCMGE <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();


Vector


  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4              0
  0 Q 1 0 1 1 1 0 0 sz 1                  Rm         1 1 1 0 0 1               Rn               Rd
         U                 E                                       ac


Vector variant

FCMGE <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
              when ''110'' cmp = CompareOp_GT; abs = FALSE;
              when ''111'' cmp = CompareOp_GT; abs = TRUE;
              otherwise    UnallocatedEncoding();


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              if abs then
                   element1 = FPAbs(element1);
                   element2 = FPAbs(element2);
              case cmp of
                   when CompareOp_EQ test_passed = FPCompareEQ(element1, element2, FPCR);
                   when CompareOp_GE test_passed = FPCompareGE(element1, element2, FPCR);
                   when CompareOp_GT test_passed = FPCompareGT(element1, element2, FPCR);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCMGT','Floating-point compare greater than (vector), setting destination vector element to all ones if the condition holds,       (C7.3.50)
else zero


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9               5 4             0
   0 1 1 1 1 1 1 0 1 sz 1                Rm           1 1 1 0 0 1              Rn               Rd
         U                 E                                      ac


Scalar variant

FCMGT <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
     when ''110'' cmp = CompareOp_GT; abs = FALSE;
     when ''111'' cmp = CompareOp_GT; abs = TRUE;
     otherwise   UnallocatedEncoding();


Vector


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9               5 4             0
   0 Q 1 0 1 1 1 0 1 sz 1                Rm           1 1 1 0 0 1              Rn               Rd
         U                 E                                      ac


Vector variant

FCMGT <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 CompareOp cmp;
 boolean abs;

 case E:U:ac of
     when ''000'' cmp = CompareOp_EQ; abs = FALSE;
     when ''010'' cmp = CompareOp_GE; abs = FALSE;
     when ''011'' cmp = CompareOp_GE; abs = TRUE;
              when ''110'' cmp = CompareOp_GT; abs = FALSE;
              when ''111'' cmp = CompareOp_GT; abs = TRUE;
              otherwise    UnallocatedEncoding();


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;
         boolean test_passed;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              if abs then
                   element1 = FPAbs(element1);
                   element2 = FPAbs(element2);
              case cmp of
                   when CompareOp_EQ test_passed = FPCompareEQ(element1, element2, FPCR);
                   when CompareOp_GE test_passed = FPCompareGE(element1, element2, FPCR);
                   when CompareOp_GT test_passed = FPCompareGT(element1, element2, FPCR);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCMLE','Floating-point compare less than or equal to zero (vector), setting destination vector element to all ones if the       (C7.3.52)
condition holds, else zero


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4            0
  0 1 1 1 1 1 1 0 1 sz 1 0 0 0 0 0 1 1 0 1 1 0                                  Rn             Rd
        U                                                      op


Scalar variant

FCMLE <V><d>, <V><n>, #0.0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;

 CompareOp comparison;
 case op:U of
     when ''00'' comparison = CompareOp_GT;
     when ''01'' comparison = CompareOp_GE;
     when ''10'' comparison = CompareOp_EQ;
     when ''11'' comparison = CompareOp_LE;


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4            0
  0 Q 1 0 1 1 1 0 1 sz 1 0 0 0 0 0 1 1 0 1 1 0                                  Rn             Rd
        U                                                      op


Vector variant

FCMLE <Vd>.<T>, <Vn>.<T>, #0.0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 CompareOp comparison;
 case op:U of
     when ''00'' comparison = CompareOp_GT;
     when ''01'' comparison = CompareOp_GE;
     when ''10'' comparison = CompareOp_EQ;
     when ''11'' comparison = CompareOp_LE;
       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = V[n];
         bits(datasize) result;
         bits(esize) zero = FPZero(''0'');
         bits(esize) element;
         boolean test_passed;

         for e = 0 to elements-1
              element = Elem[operand, e, esize];
              case comparison of
                   when CompareOp_GT test_passed = FPCompareGT(element, zero, FPCR);
                   when CompareOp_GE test_passed = FPCompareGE(element, zero, FPCR);
                   when CompareOp_EQ test_passed = FPCompareEQ(element, zero, FPCR);
                   when CompareOp_LE test_passed = FPCompareGE(zero, element, FPCR);
                   when CompareOp_LT test_passed = FPCompareGT(zero, element, FPCR);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCMLT','Floating-point compare less than zero (vector), setting destination vector element to all ones if the condition holds,       (C7.3.53)
else zero


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4              0
   0 1 0 1 1 1 1 0 1 sz 1 0 0 0 0 0 1 1 1 0 1 0                                 Rn              Rd




Scalar variant

FCMLT <V><d>, <V><n>, #0.0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;

 CompareOp comparison = CompareOp_LT;


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4              0
   0 Q 0 0 1 1 1 0 1 sz 1 0 0 0 0 0 1 1 1 0 1 0                                 Rn              Rd




Vector variant

FCMLT <Vd>.<T>, <Vn>.<T>, #0.0


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 CompareOp comparison = CompareOp_LT;


Assembler symbols

<V>            Is a width specifier, encoded in the "sz" field. It can have the following values:

               S           when sz = 0

               D           when sz = 1

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>            Is the number of the SIMD&FP source register, encoded in the "Rn" field.

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = V[n];
         bits(datasize) result;
         bits(esize) zero = FPZero(''0'');
         bits(esize) element;
         boolean test_passed;

         for e = 0 to elements-1
              element = Elem[operand, e, esize];
              case comparison of
                   when CompareOp_GT test_passed = FPCompareGT(element, zero, FPCR);
                   when CompareOp_GE test_passed = FPCompareGE(element, zero, FPCR);
                   when CompareOp_EQ test_passed = FPCompareEQ(element, zero, FPCR);
                   when CompareOp_LE test_passed = FPCompareGE(zero, element, FPCR);
                   when CompareOp_LT test_passed = FPCompareGT(zero, element, FPCR);
              Elem[result, e, esize] = if test_passed then Ones() else Zeros();

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCMP','Floating-point quiet compare (scalar): flags = compareQuiet(Vn, Vm) // with register       (C7.3.54)




  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9               5 4 3 2 1 0
  0 0 0 1 1 1 1 0 0 x 1                   Rm          0 0 1 0 0 0               Rn        0 x 0 0 0
                            type                                                          opc


Single-precision variant

Applies when type = 00 && opc = 00.

FCMP <Sn>, <Sm>


Single-precision, zero variant

Applies when type = 00 && Rm = (00000) && opc = 01.

FCMP <Sn>, #0.0


Double-precision variant

Applies when type = 01 && opc = 00.

FCMP <Dn>, <Dm>


Double-precision, zero variant

Applies when type = 01 && Rm = (00000) && opc = 01.

FCMP <Dn>, #0.0


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer m = UInt(Rm);    // ignored when opc<0> == ''1''

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 boolean signal_all_nans = (opc<1> == ''1'');
 boolean cmp_with_zero = (opc<0> == ''1'');


Assembler symbols

<Dn>           For the double-precision variant: is the 64-bit name of the first SIMD&FP source register, encoded
               in the "Rn" field.

               For the double-precision, zero variant: is the 64-bit name of the SIMD&FP source register, encoded
               in the "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<Sn>           For the single-precision variant: is the 32-bit name of the first SIMD&FP source register, encoded
               in the "Rn" field.

               For the single-precision, zero variant: is the 32-bit name of the SIMD&FP source register, encoded
               in the "Rn" field.
       <Sm>              Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation

         CheckFPAdvSIMDEnabled64();

         bits(datasize) operand1 = V[n];
         bits(datasize) operand2;

         operand2 = if cmp_with_zero then FPZero(''0'') else V[m];

         PSTATE.<N,Z,C,V> = FPCompare(operand1, operand2, signal_all_nans, FPCR);');
INSERT INTO "instructions" VALUES('ARM','FCMPE','Floating-point signaling compare (scalar): flags = compareSignaling(Vn, Vm) // with register       (C7.3.55)




  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9               5 4 3 2 1 0
  0 0 0 1 1 1 1 0 0 x 1                   Rm          0 0 1 0 0 0               Rn        1 x 0 0 0
                            type                                                          opc


Single-precision variant

Applies when type = 00 && opc = 10.

FCMPE <Sn>, <Sm>


Single-precision, zero variant

Applies when type = 00 && Rm = (00000) && opc = 11.

FCMPE <Sn>, #0.0


Double-precision variant

Applies when type = 01 && opc = 10.

FCMPE <Dn>, <Dm>


Double-precision, zero variant

Applies when type = 01 && Rm = (00000) && opc = 11.

FCMPE <Dn>, #0.0


Decode for all variants of this encoding

 integer n = UInt(Rn);
 integer m = UInt(Rm);    // ignored when opc<0> == ''1''

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 boolean signal_all_nans = (opc<1> == ''1'');
 boolean cmp_with_zero = (opc<0> == ''1'');


Assembler symbols

<Dn>           For the double-precision variant: is the 64-bit name of the first SIMD&FP source register, encoded
               in the "Rn" field.

               For the double-precision, zero variant: is the 64-bit name of the SIMD&FP source register, encoded
               in the "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<Sn>           For the single-precision variant: is the 32-bit name of the first SIMD&FP source register, encoded
               in the "Rn" field.

               For the single-precision, zero variant: is the 32-bit name of the SIMD&FP source register, encoded
               in the "Rn" field.
       <Sm>              Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation

         CheckFPAdvSIMDEnabled64();

         bits(datasize) operand1 = V[n];
         bits(datasize) operand2;

         operand2 = if cmp_with_zero then FPZero(''0'') else V[m];

         PSTATE.<N,Z,C,V> = FPCompare(operand1, operand2, signal_all_nans, FPCR);');
INSERT INTO "instructions" VALUES('ARM','FCSEL','Floating-point conditional select (scalar): Vd = if cond then Vn else Vm       (C7.3.56)




  31 30 29 28 27 26 25 24 23 22 21 20             16 15       12 11 10 9                 5 4          0
  0 0 0 1 1 1 1 0 0 x 1                     Rm           cond       1 1          Rn             Rd
                            type


Single-precision variant

Applies when type = 00.

FCSEL <Sd>, <Sn>, <Sm>, <cond>


Double-precision variant

Applies when type = 01.

FCSEL <Dd>, <Dn>, <Dm>, <cond>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 bits(4) condition = cond;


Assembler symbols

<Dd>           Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Dn>           Is the 64-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<Sd>           Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Sn>           Is the 32-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Sm>           Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<cond>         Is one of the standard conditions, encoded in the "cond" field in the standard way.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) result;

 result = if ConditionHolds(condition) then V[n] else V[m];

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVT','       Floating-point convert precision (scalar): Vd = convertFormat(Vn)       (C7.3.57)




           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9         5 4    0
            0 0 0 1 1 1 1 0 type 1 0 0 0 1 opc 1 0 0 0 0                            Rn     Rd




       Half-precision to single-precision variant

       Applies when type = 11 && opc = 00.

       FCVT <Sd>, <Hn>


       Half-precision to double-precision variant

       Applies when type = 11 && opc = 01.

       FCVT <Dd>, <Hn>


       Single-precision to half-precision variant

       Applies when type = 00 && opc = 11.

       FCVT <Hd>, <Sn>


       Single-precision to double-precision variant

       Applies when type = 00 && opc = 01.

       FCVT <Dd>, <Sn>


       Double-precision to half-precision variant

       Applies when type = 01 && opc = 11.

       FCVT <Hd>, <Dn>


       Double-precision to single-precision variant

       Applies when type = 01 && opc = 00.

       FCVT <Sd>, <Dn>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if type == opc then UnallocatedEncoding();

         integer srcsize;
         case type of
              when ''00'' srcsize = 32;
              when ''01'' srcsize = 64;
              when ''10'' UnallocatedEncoding();
              when ''11'' srcsize = 16;
         integer dstsize;
         case opc of
              when ''00'' dstsize = 32;
              when ''01'' dstsize = 64;
              when ''10'' UnallocatedEncoding();
              when ''11'' dstsize = 16;
Assembler symbols

<Dd>          Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Hd>          Is the 16-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Sn>          Is the 32-bit name of the SIMD&FP source register, encoded in the "Rn" field.

<Sd>          Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Hn>          Is the 16-bit name of the SIMD&FP source register, encoded in the "Rn" field.

<Dn>          Is the 64-bit name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();

 bits(dstsize) result;
 bits(srcsize) operand = V[n];

 result = FPConvert(operand, FPCR);
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTAS','       Floating-point convert to signed integer, rounding to nearest with ties to away (vector)       (C7.3.58)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 1 0 1 1 1 1 0 0 sz 1 0 0 0 0 1 1 1 0 0 1 0                                  Rn             Rd
                  U


       Scalar variant

       FCVTAS <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;

         FPRounding rounding = FPRounding_TIEAWAY;
         boolean unsigned = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 Q 0 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 1 0 0 1 0                                  Rn             Rd
                  U


       Vector variant

       FCVTAS <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         FPRounding rounding = FPRounding_TIEAWAY;
         boolean unsigned = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

              2S          when sz = 0, Q = 0

              4S          when sz = 0, Q = 1

              2D          when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTAU','       Floating-point convert to unsigned integer, rounding to nearest with ties to away (vector)       (C7.3.60)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 1 1 1 1 1 1 0 0 sz 1 0 0 0 0 1 1 1 0 0 1 0                                  Rn             Rd
                  U


       Scalar variant

       FCVTAU <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;

         FPRounding rounding = FPRounding_TIEAWAY;
         boolean unsigned = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 Q 1 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 1 0 0 1 0                                  Rn             Rd
                  U


       Vector variant

       FCVTAU <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         FPRounding rounding = FPRounding_TIEAWAY;
         boolean unsigned = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

              2S          when sz = 0, Q = 0

              4S          when sz = 0, Q = 1

              2D          when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTL','Floating-point convert to higher precision long (vector)       (C7.3.62)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4             0
     0 Q 0 0 1 1 1 0 0 sz 1 0 0 0 0 1 0 1 1 1 1 0                                   Rn               Rd




Vector variant

FCVTL{2} <Vd>.<Ta>, <Vn>.<Tb>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  integer esize = 16 << UInt(sz);
  integer datasize = 64;
  integer part = UInt(Q);
  integer elements = datasize DIV esize;


Assembler symbols

2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                  64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                  the following values:

                  [absent]    when Q = 0

                  [present]   when Q = 1

<Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Ta>              Is an arrangement specifier, encoded in the "sz" field. It can have the following values:

                  4S          when sz = 0

                  2D          when sz = 1

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<Tb>              Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                  4H          when sz = 0, Q = 0

                  8H          when sz = 0, Q = 1

                  2S          when sz = 1, Q = 0

                  4S          when sz = 1, Q = 1


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = Vpart[n, part];
  bits(2*datasize) result;

  for e = 0 to elements-1
       Elem[result, e, 2*esize] = FPConvert(Elem[operand, e, esize], FPCR);

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTL2','-R:FCVTL');
INSERT INTO "instructions" VALUES('ARM','FCVTMS','Floating-point convert to signed integer, rounding toward minus infinity (vector)       (C7.3.63)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
  0 1 0 1 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 1 1 0                                  Rn             Rd
        U                   o2                                  o1


Scalar variant

FCVTMS <V><d>, <V><n>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;

 FPRounding rounding = FPDecodeRounding(o1:o2);
 boolean unsigned = (U == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
  0 Q 0 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 1 1 0                                  Rn             Rd
        U                   o2                                  o1


Vector variant

FCVTMS <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 FPRounding rounding = FPDecodeRounding(o1:o2);
 boolean unsigned = (U == ''1'');


Assembler symbols

<V>            Is a width specifier, encoded in the "sz" field. It can have the following values:

               S            when sz = 0

               D            when sz = 1

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>            Is the number of the SIMD&FP source register, encoded in the "Rn" field.

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = V[n];
         bits(datasize) result;
         bits(esize) element;

         for e = 0 to elements-1
              element = Elem[operand, e, esize];
              Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTMU','Floating-point convert to unsigned integer, rounding toward minus infinity (vector)       (C7.3.65)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
  0 1 1 1 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 1 1 0                                  Rn             Rd
        U                  o2                                   o1


Scalar variant

FCVTMU <V><d>, <V><n>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;

 FPRounding rounding = FPDecodeRounding(o1:o2);
 boolean unsigned = (U == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
  0 Q 1 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 1 1 0                                  Rn             Rd
        U                  o2                                   o1


Vector variant

FCVTMU <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 FPRounding rounding = FPDecodeRounding(o1:o2);
 boolean unsigned = (U == ''1'');


Assembler symbols

<V>            Is a width specifier, encoded in the "sz" field. It can have the following values:

               S           when sz = 0

               D           when sz = 1

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>            Is the number of the SIMD&FP source register, encoded in the "Rn" field.

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1

                         2D          when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = V[n];
         bits(datasize) result;
         bits(esize) element;

         for e = 0 to elements-1
              element = Elem[operand, e, esize];
              Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTN','Floating-point convert to lower precision narrow (vector)       (C7.3.67)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4             0
  0 Q 0 0 1 1 1 0 0 sz 1 0 0 0 0 1 0 1 1 0 1 0                                   Rn               Rd




Vector variant

FCVTN{2} <Vd>.<Tb>, <Vn>.<Ta>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 16 << UInt(sz);
 integer datasize = 64;
 integer part = UInt(Q);
 integer elements = datasize DIV esize;


Assembler symbols

2              Is the second and upper half specifier. If present it causes the operation to be performed on the upper
               64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
               the following values:

               [absent]     when Q = 0

               [present]    when Q = 1

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Tb>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

               4H           when sz = 0, Q = 0

               8H           when sz = 0, Q = 1

               2S           when sz = 1, Q = 0

               4S           when sz = 1, Q = 1

<Vn>           Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<Ta>           Is an arrangement specifier, encoded in the "sz" field. It can have the following values:

               4S           when sz = 0

               2D           when sz = 1


Operation

 CheckFPAdvSIMDEnabled64();
 bits(2*datasize) operand = V[n];
 bits(datasize) result;

 for e = 0 to elements-1
     Elem[result, e, esize] = FPConvert(Elem[operand, e, 2*esize], FPCR);

 Vpart[d, part] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTN2','-R:FCVTN');
INSERT INTO "instructions" VALUES('ARM','FCVTNS','       Floating-point convert to signed integer, rounding to nearest with ties to even (vector)       (C7.3.68)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 1 0 1 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Scalar variant

       FCVTNS <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 Q 0 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Vector variant

       FCVTNS <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

              2S          when sz = 0, Q = 0

              4S          when sz = 0, Q = 1

              2D          when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTNU','       Floating-point convert to unsigned integer, rounding to nearest with ties to even (vector)       (C7.3.70)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 1 1 1 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Scalar variant

       FCVTNU <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 Q 1 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Vector variant

       FCVTNU <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

              2S          when sz = 0, Q = 0

              4S          when sz = 0, Q = 1

              2D          when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTPS','       Floating-point convert to signed integer, rounding toward positive infinity (vector)       (C7.3.72)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 1 0 1 1 1 1 0 1 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Scalar variant

       FCVTPS <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 Q 0 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Vector variant

       FCVTPS <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

              2S          when sz = 0, Q = 0

              4S          when sz = 0, Q = 1

              2D          when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTPU','       Floating-point convert to unsigned integer, rounding toward positive infinity (vector)       (C7.3.74)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 1 1 1 1 1 1 0 1 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Scalar variant

       FCVTPU <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
            0 Q 1 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 0 1 0 1 0                                  Rn             Rd
                  U                  o2                                   o1


       Vector variant

       FCVTPU <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         FPRounding rounding = FPDecodeRounding(o1:o2);
         boolean unsigned = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

              2S          when sz = 0, Q = 0

              4S          when sz = 0, Q = 1

              2D          when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, 0, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTXN','       Floating-point convert to lower precision narrow, rounding to odd (vector)       (C7.3.76)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4             0
            0 1 1 1 1 1 1 0 0 sz 1 0 0 0 0 1 0 1 1 0 1 0                                   Rn               Rd




       Scalar variant

       FCVTXN <Vb><d>, <Va><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz == ''0'' then ReservedValue();
         integer esize = 32;
         integer datasize = esize;
         integer elements = 1;
         integer part = 0;


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4             0
            0 Q 1 0 1 1 1 0 0 sz 1 0 0 0 0 1 0 1 1 0 1 0                                   Rn               Rd




       Vector variant

       FCVTXN{2} <Vd>.<Tb>, <Vn>.<Ta>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz == ''0'' then ReservedValue();
         integer esize = 32;
         integer datasize = 64;
         integer elements = 2;
         integer part = UInt(Q);


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Tb>              Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 1, Q = 0
              4S          when sz = 1, Q = 1

              It is RESERVED when sz = 0, Q = x.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<Ta>          Is an arrangement specifier, encoded in the "sz" field. It can have the following values:

              2D          when sz = 1

              It is RESERVED when sz = 0.

<Vb>          Is the destination width specifier, encoded in the "sz" field. It can have the following values:

              S           when sz = 1

              It is RESERVED when sz = 0.

<d>           Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Va>          Is the source width specifier, encoded in the "sz" field. It can have the following values:

              D           when sz = 1

              It is RESERVED when sz = 0.

<n>           Is the number of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(2*datasize) operand = V[n];
 bits(datasize) result;

 for e = 0 to elements-1
     Elem[result, e, esize] = FPConvert(Elem[operand, e, 2*esize], FPCR, FPRounding_ODD);

 Vpart[d, part] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTXN2','-R:FCVTXN');
INSERT INTO "instructions" VALUES('ARM','FCVTZS','       Floating-point convert to signed fixed-point, rounding toward zero (vector)       (C7.3.77)


       Scalar


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 1 0 1 1 1 1 1 0              !=0000     immb      1 1 1 1 1 1             Rn             Rd
                  U                         immh


       Scalar variant

       FCVTZS <V><d>, <V><n>, #<fbits>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''00xx'' then ReservedValue();
         integer esize = 32 << UInt(immh<3>);
         integer datasize = esize;
         integer elements = 1;

         integer fracbits = (esize * 2) - UInt(immh:immb);
         boolean unsigned = (U == ''1'');
         FPRounding rounding = FPRounding_ZERO;


       Vector


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 Q 0 0 1 1 1 1 0              !=0000     immb      1 1 1 1 1 1             Rn             Rd
                  U                         immh


       Vector variant

       FCVTZS <Vd>.<T>, <Vn>.<T>, #<fbits>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''0000'' then SEE "Advanced SIMD modified immediate";
         if immh == ''00xx'' then ReservedValue();
         if immh<3>:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(immh<3>);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         integer fracbits = (esize * 2) - UInt(immh:immb);
         boolean unsigned = (U == ''1'');
         FPRounding rounding = FPRounding_ZERO;


       Assembler symbols

       <V>               Is a width specifier, encoded in the "immh" field. It can have the following values:

                         S           when immh = 01xx

                         D           when immh = 1xxx
              It is RESERVED when immh = 00xx.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "immh:Q" field. It can have the following values:

              2S          when immh = 01xx, Q = 0

              4S          when immh = 01xx, Q = 1

              2D          when immh = 1xxx, Q = 1

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000, Q = x.

              It is RESERVED when:

              .      immh = 0001, Q = x.

              .      immh = 001x, Q = x.

              .      immh = 1xxx, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<fbits>       For the scalar variant: is the number of fractional bits, in the range 1 to the operand width, encoded
              in the "immh:immb" field. It can have the following values:

              (64-UInt(immh:immb))when immh = 01xx

              (128-UInt(immh:immb))when immh = 1xxx

              It is RESERVED when immh = 00xx.

              For the vector variant: is the number of fractional bits, in the range 1 to the element width, encoded
              in the "immh:immb" field. It can have the following values:

              (64-UInt(immh:immb))when immh = 01xx

              (128-UInt(immh:immb))when immh = 1xxx

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000.

              It is RESERVED when:

              .      immh = 0001.

              .      immh = 001x.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand  = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, fracbits, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FCVTZU','       Floating-point convert to unsigned fixed-point, rounding toward zero (vector)       (C7.3.81)


       Scalar


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 1 1 1 1 1 1 1 0              !=0000     immb      1 1 1 1 1 1             Rn             Rd
                  U                         immh


       Scalar variant

       FCVTZU <V><d>, <V><n>, #<fbits>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''00xx'' then ReservedValue();
         integer esize = 32 << UInt(immh<3>);
         integer datasize = esize;
         integer elements = 1;

         integer fracbits = (esize * 2) - UInt(immh:immb);
         boolean unsigned = (U == ''1'');
         FPRounding rounding = FPRounding_ZERO;


       Vector


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 Q 1 0 1 1 1 1 0              !=0000     immb      1 1 1 1 1 1             Rn             Rd
                  U                         immh


       Vector variant

       FCVTZU <Vd>.<T>, <Vn>.<T>, #<fbits>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''0000'' then SEE "Advanced SIMD modified immediate";
         if immh == ''00xx'' then ReservedValue();
         if immh<3>:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(immh<3>);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         integer fracbits = (esize * 2) - UInt(immh:immb);
         boolean unsigned = (U == ''1'');
         FPRounding rounding = FPRounding_ZERO;


       Assembler symbols

       <V>               Is a width specifier, encoded in the "immh" field. It can have the following values:

                         S           when immh = 01xx

                         D           when immh = 1xxx
              It is RESERVED when immh = 00xx.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "immh:Q" field. It can have the following values:

              2S          when immh = 01xx, Q = 0

              4S          when immh = 01xx, Q = 1

              2D          when immh = 1xxx, Q = 1

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000, Q = x.

              It is RESERVED when:

              .      immh = 0001, Q = x.

              .      immh = 001x, Q = x.

              .      immh = 1xxx, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<fbits>       For the scalar variant: is the number of fractional bits, in the range 1 to the operand width, encoded
              in the "immh:immb" field. It can have the following values:

              (64-UInt(immh:immb))when immh = 01xx

              (128-UInt(immh:immb))when immh = 1xxx

              It is RESERVED when immh = 00xx.

              For the vector variant: is the number of fractional bits, in the range 1 to the element width, encoded
              in the "immh:immb" field. It can have the following values:

              (64-UInt(immh:immb))when immh = 01xx

              (128-UInt(immh:immb))when immh = 1xxx

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000.

              It is RESERVED when:

              .      immh = 0001.

              .      immh = 001x.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand  = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPToFixed(element, fracbits, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FDIV','Floating-point divide (vector)       (C7.3.85)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4            0
     0 Q 1 0 1 1 1 0 0 sz 1                  Rm         1 1 1 1 1 1              Rn              Rd




Three registers of the same type variant

FDIV <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  if sz:Q == ''10'' then ReservedValue();
  integer esize = 32 << UInt(sz);
  integer datasize = if Q == ''1'' then 128 else 64;
  integer elements = datasize DIV esize;


Assembler symbols

<Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                  2S          when sz = 0, Q = 0

                  4S          when sz = 0, Q = 1

                  2D          when sz = 1, Q = 1

                  It is RESERVED when sz = 1, Q = 0.

<Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand1 = V[n];
  bits(datasize) operand2 = V[m];
  bits(datasize) result;
  bits(esize) element1;
  bits(esize) element2;

  for e = 0 to elements-1
       element1 = Elem[operand1, e, esize];
       element2 = Elem[operand2, e, esize];
       Elem[result, e, esize] = FPDiv(element1, element2, FPCR);

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMADD','       Floating-point fused multiply-add (scalar): Vd = Va + Vn*Vm       (C7.3.87)




           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14          10 9            5 4            0
            0 0 0 1 1 1 1 1 0 x 0                    Rm       0       Ra              Rn              Rd
                                      type o1                 o0


       Single-precision variant

       Applies when type = 00.

       FMADD <Sd>, <Sn>, <Sm>, <Sa>


       Double-precision variant

       Applies when type = 01.

       FMADD <Dd>, <Dn>, <Dm>, <Da>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer a = UInt(Ra);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         integer datasize;
         case type of
              when ''00'' datasize = 32;
              when ''01'' datasize = 64;
              when ''1x'' UnallocatedEncoding();

         boolean opa_neg = (o1 == ''1'');
         boolean op1_neg = (o0 != o1);


       Assembler symbols

       <Dd>              Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Dn>              Is the 64-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
                         "Rn" field.

       <Dm>              Is the 64-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
                         "Rm" field.

       <Da>              Is the 64-bit name of the third SIMD&FP source register holding the addend, encoded in the "Ra"
                         field.

       <Sd>              Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Sn>              Is the 32-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
                         "Rn" field.

       <Sm>              Is the 32-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
                         "Rm" field.

       <Sa>              Is the 32-bit name of the third SIMD&FP source register holding the addend, encoded in the "Ra"
                         field.
Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) result;
 bits(datasize) operanda = V[a];
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];

 if opa_neg then operanda = FPNeg(operanda);
 if op1_neg then operand1 = FPNeg(operand1);
 result = FPMulAdd(operanda, operand1, operand2, FPCR);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMAX','      Floating-point maximum (vector)       (C7.3.88)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4            0
           0 Q 0 0 1 1 1 0 0 sz 1                  Rm         1 1 1 1 0 1              Rn              Rd
                 U                 o1


      Three registers of the same type variant

      FMAX <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if sz:Q == ''10'' then ReservedValue();
        integer esize = 32 << UInt(sz);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean pair = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                        2S          when sz = 0, Q = 0

                        4S          when sz = 0, Q = 1

                        2D          when sz = 1, Q = 1

                        It is RESERVED when sz = 1, Q = 0.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        bits(2*datasize) concat = operand2:operand1;
        bits(esize) element1;
        bits(esize) element2;

        for e = 0 to elements-1
             if pair then
                  element1 = Elem[concat, 2*e, esize];
                  element2 = Elem[concat, (2*e)+1, esize];
             else
                  element1 = Elem[operand1, e, esize];
                  element2 = Elem[operand2, e, esize];

             if minimum then
                  Elem[result, e, esize] = FPMin(element1, element2, FPCR);
   else
        Elem[result, e, esize] = FPMax(element1, element2, FPCR);

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMAXNM','      Floating-point maximum number (vector)       (C7.3.90)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4            0
           0 Q 0 0 1 1 1 0 0 sz 1                  Rm         1 1 0 0 0 1              Rn              Rd
                 U                 o1


      Three registers of the same type variant

      FMAXNM <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if sz:Q == ''10'' then ReservedValue();
        integer esize = 32 << UInt(sz);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean pair = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                        2S          when sz = 0, Q = 0

                        4S          when sz = 0, Q = 1

                        2D          when sz = 1, Q = 1

                        It is RESERVED when sz = 1, Q = 0.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        bits(2*datasize) concat = operand2:operand1;
        bits(esize) element1;
        bits(esize) element2;

        for e = 0 to elements-1
             if pair then
                  element1 = Elem[concat, 2*e, esize];
                  element2 = Elem[concat, (2*e)+1, esize];
             else
                  element1 = Elem[operand1, e, esize];
                  element2 = Elem[operand2, e, esize];

             if minimum then
                  Elem[result, e, esize] = FPMinNum(element1, element2, FPCR);
   else
       Elem[result, e, esize] = FPMaxNum(element1, element2, FPCR);

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMAXNMP','Floating-point maximum number of pair of elements (scalar)       (C7.3.92)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4             0
     0 1 1 1 1 1 1 0 0 sz 1 1 0 0 0 0 1 1 0 0 1 0                                   Rn              Rd
                              o1


Advanced SIMD variant

FMAXNMP <V><d>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  integer esize = 32 << UInt(sz);
  integer datasize = esize * 2;
  integer elements = 2;

  ReduceOp op = if o1 == ''1'' then ReduceOp_FMINNUM else ReduceOp_FMAXNUM;


Assembler symbols

<V>               Is the destination width specifier, encoded in the "sz" field. It can have the following values:

                  S           when sz = 0

                  D           when sz = 1

<d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>               Is the source arrangement specifier, encoded in the "sz" field. It can have the following values:

                  2S          when sz = 0

                  2D          when sz = 1


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMAXNMV','Floating-point maximum number across vector       (C7.3.94)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4             0
  0 Q 1 0 1 1 1 0 0 sz 1 1 0 0 0 0 1 1 0 0 1 0                                   Rn              Rd
                           o1


Advanced SIMD variant

FMAXNMV <V><d>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q != ''01'' then ReservedValue();      // .4S only

 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 ReduceOp op = if o1 == ''1'' then ReduceOp_FMINNUM else ReduceOp_FMAXNUM;


Assembler symbols

<V>            Is the destination width specifier, encoded in the "sz" field. It can have the following values:

               S           when sz = 0

               It is RESERVED when sz = 1.

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>           Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>            Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

               4S          when Q = 1, sz = 0

               It is RESERVED when:

               .      Q = 0, sz = x.

               .      Q = 1, sz = 1.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMAXP','Floating-point maximum of pair of elements (scalar)       (C7.3.95)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4             0
     0 1 1 1 1 1 1 0 0 sz 1 1 0 0 0 0 1 1 1 1 1 0                                   Rn              Rd
                              o1


Advanced SIMD variant

FMAXP <V><d>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  integer esize = 32 << UInt(sz);
  integer datasize = esize * 2;
  integer elements = 2;

  ReduceOp op = if o1 == ''1'' then ReduceOp_FMIN else ReduceOp_FMAX;


Assembler symbols

<V>               Is the destination width specifier, encoded in the "sz" field. It can have the following values:

                  S           when sz = 0

                  D           when sz = 1

<d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>               Is the source arrangement specifier, encoded in the "sz" field. It can have the following values:

                  2S          when sz = 0

                  2D          when sz = 1


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMAXV','Floating-point maximum across vector       (C7.3.97)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4             0
  0 Q 1 0 1 1 1 0 0 sz 1 1 0 0 0 0 1 1 1 1 1 0                                   Rn              Rd
                           o1


Advanced SIMD variant

FMAXV <V><d>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q != ''01'' then ReservedValue();

 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 ReduceOp op = if o1 == ''1'' then ReduceOp_FMIN else ReduceOp_FMAX;


Assembler symbols

<V>            Is the destination width specifier, encoded in the "sz" field. It can have the following values:

               S           when sz = 0

               It is RESERVED when sz = 1.

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>           Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>            Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

               4S          when Q = 1, sz = 0

               It is RESERVED when:

               .      Q = 0, sz = x.

               .      Q = 1, sz = 1.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMIN','      Floating-point minimum (vector)       (C7.3.98)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4            0
           0 Q 0 0 1 1 1 0 1 sz 1                  Rm         1 1 1 1 0 1              Rn              Rd
                 U                 o1


      Three registers of the same type variant

      FMIN <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if sz:Q == ''10'' then ReservedValue();
        integer esize = 32 << UInt(sz);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean pair = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                        2S          when sz = 0, Q = 0

                        4S          when sz = 0, Q = 1

                        2D          when sz = 1, Q = 1

                        It is RESERVED when sz = 1, Q = 0.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        bits(2*datasize) concat = operand2:operand1;
        bits(esize) element1;
        bits(esize) element2;

        for e = 0 to elements-1
             if pair then
                  element1 = Elem[concat, 2*e, esize];
                  element2 = Elem[concat, (2*e)+1, esize];
             else
                  element1 = Elem[operand1, e, esize];
                  element2 = Elem[operand2, e, esize];

             if minimum then
                  Elem[result, e, esize] = FPMin(element1, element2, FPCR);
   else
        Elem[result, e, esize] = FPMax(element1, element2, FPCR);

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMINNM','      Floating-point minimum number (vector)       (C7.3.100)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4            0
           0 Q 0 0 1 1 1 0 1 sz 1                  Rm         1 1 0 0 0 1              Rn              Rd
                 U                 o1


      Three registers of the same type variant

      FMINNM <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if sz:Q == ''10'' then ReservedValue();
        integer esize = 32 << UInt(sz);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean pair = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                        2S          when sz = 0, Q = 0

                        4S          when sz = 0, Q = 1

                        2D          when sz = 1, Q = 1

                        It is RESERVED when sz = 1, Q = 0.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        bits(2*datasize) concat = operand2:operand1;
        bits(esize) element1;
        bits(esize) element2;

        for e = 0 to elements-1
             if pair then
                  element1 = Elem[concat, 2*e, esize];
                  element2 = Elem[concat, (2*e)+1, esize];
             else
                  element1 = Elem[operand1, e, esize];
                  element2 = Elem[operand2, e, esize];

             if minimum then
                  Elem[result, e, esize] = FPMinNum(element1, element2, FPCR);
   else
       Elem[result, e, esize] = FPMaxNum(element1, element2, FPCR);

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMINNMP','Floating-point minimum number of pair of elements (scalar)       (C7.3.102)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4             0
     0 1 1 1 1 1 1 0 1 sz 1 1 0 0 0 0 1 1 0 0 1 0                                   Rn              Rd
                              o1


Advanced SIMD variant

FMINNMP <V><d>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  integer esize = 32 << UInt(sz);
  integer datasize = esize * 2;
  integer elements = 2;

  ReduceOp op = if o1 == ''1'' then ReduceOp_FMINNUM else ReduceOp_FMAXNUM;


Assembler symbols

<V>               Is the destination width specifier, encoded in the "sz" field. It can have the following values:

                  S           when sz = 0

                  D           when sz = 1

<d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>               Is the source arrangement specifier, encoded in the "sz" field. It can have the following values:

                  2S          when sz = 0

                  2D          when sz = 1


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMINNMV','Floating-point minimum number across vector       (C7.3.104)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4             0
  0 Q 1 0 1 1 1 0 1 sz 1 1 0 0 0 0 1 1 0 0 1 0                                   Rn              Rd
                           o1


Advanced SIMD variant

FMINNMV <V><d>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q != ''01'' then ReservedValue();      // .4S only

 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 ReduceOp op = if o1 == ''1'' then ReduceOp_FMINNUM else ReduceOp_FMAXNUM;


Assembler symbols

<V>            Is the destination width specifier, encoded in the "sz" field. It can have the following values:

               S           when sz = 0

               It is RESERVED when sz = 1.

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>           Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>            Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

               4S          when Q = 1, sz = 0

               It is RESERVED when:

               .      Q = 0, sz = x.

               .      Q = 1, sz = 1.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMINP','Floating-point minimum of pair of elements (scalar)       (C7.3.105)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4             0
     0 1 1 1 1 1 1 0 1 sz 1 1 0 0 0 0 1 1 1 1 1 0                                   Rn              Rd
                              o1


Advanced SIMD variant

FMINP <V><d>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  integer esize = 32 << UInt(sz);
  integer datasize = esize * 2;
  integer elements = 2;

  ReduceOp op = if o1 == ''1'' then ReduceOp_FMIN else ReduceOp_FMAX;


Assembler symbols

<V>               Is the destination width specifier, encoded in the "sz" field. It can have the following values:

                  S           when sz = 0

                  D           when sz = 1

<d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>               Is the source arrangement specifier, encoded in the "sz" field. It can have the following values:

                  2S          when sz = 0

                  2D          when sz = 1


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMINV','Floating-point minimum across vector       (C7.3.107)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4             0
  0 Q 1 0 1 1 1 0 1 sz 1 1 0 0 0 0 1 1 1 1 1 0                                   Rn              Rd
                           o1


Advanced SIMD variant

FMINV <V><d>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q != ''01'' then ReservedValue();

 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 ReduceOp op = if o1 == ''1'' then ReduceOp_FMIN else ReduceOp_FMAX;


Assembler symbols

<V>            Is the destination width specifier, encoded in the "sz" field. It can have the following values:

               S           when sz = 0

               It is RESERVED when sz = 1.

<d>            Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vn>           Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<T>            Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

               4S          when Q = 1, sz = 0

               It is RESERVED when:

               .      Q = 0, sz = x.

               .      Q = 1, sz = 1.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 V[d] = Reduce(op, operand, esize);');
INSERT INTO "instructions" VALUES('ARM','FMLA','       Floating-point fused multiply-add to accumulator (by element)       (C7.3.108)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 1 0 1 1 1 1 1 1 sz L M                Rm       0 0 0 1 H 0            Rn     Rd
                                                               o2


       Scalar variant

       FMLA <V><d>, <V><n>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi = M;
         case sz:L of
              when ''0x'' index = UInt(H:L);
              when ''10'' index = UInt(H);
              when ''11'' UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;
         boolean sub_op = (o2 == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 Q 0 0 1 1 1 1 1 sz L M                Rm       0 0 0 1 H 0            Rn     Rd
                                                               o2


       Vector variant

       FMLA <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi = M;
         case sz:L of
              when ''0x'' index = UInt(H:L);
              when ''10'' index = UInt(H);
              when ''11'' UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;
         boolean sub_op = (o2 == ''1'');
Assembler symbols

<V>           Is a width specifier, encoded in the "sz" field. It can have the following values:

              S           when sz = 0

              D           when sz = 1

<d>           Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

              2S          when Q = 0, sz = 0

              4S          when Q = 1, sz = 0

              2D          when Q = 1, sz = 1

              It is RESERVED when Q = 0, sz = 1.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          For the scalar variant: is the name of the SIMD&FP source register, encoded in the "M:Rm" fields.

              For the vector variant: is the name of the second SIMD&FP source register, encoded in the "M:Rm"
              fields.

<Ts>          For the scalar variant: is the element width specifier, encoded in the "sz" field. It can have the
              following values:

              S           when sz = 0

              D           when sz = 1

              For the vector variant: is an element size specifier, encoded in the "sz" field. It can have the
              following values:

              S           when sz = 0

              D           when sz = 1

<index>       For the scalar variant: is the element index, encoded in the "sz:L:H" field. It can have the following
              values:

              H:L         when sz = 0, L = x

              H           when sz = 1, L = 0

              It is RESERVED when sz = 1, L = 1.

              For the vector variant: is the element index encoded in the "sz:L:H" field. It can have the following
              values:

              H:L         when sz = 0, L = x

              H           when sz = 1, L = 0

              It is RESERVED when sz = 1, L = 1.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(idxdsize) operand2 = V[m];
 bits(datasize) operand3 = V[d];
 bits(datasize) result;
 bits(esize) element1;
 bits(esize) element2 = Elem[operand2, index, esize];

 for e = 0 to elements-1
     element1 = Elem[operand1, e, esize];
              if sub_op then element1 = FPNeg(element1);
              Elem[result, e, esize] = FPMulAdd(Elem[operand3, e, esize], element1, element2, FPCR);
         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMLS','       Floating-point fused multiply-subtract from accumulator (by element)       (C7.3.110)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 1 0 1 1 1 1 1 1 sz L M                Rm       0 1 0 1 H 0            Rn     Rd
                                                               o2


       Scalar variant

       FMLS <V><d>, <V><n>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi = M;
         case sz:L of
              when ''0x'' index = UInt(H:L);
              when ''10'' index = UInt(H);
              when ''11'' UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;
         boolean sub_op = (o2 == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 Q 0 0 1 1 1 1 1 sz L M                Rm       0 1 0 1 H 0            Rn     Rd
                                                               o2


       Vector variant

       FMLS <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi = M;
         case sz:L of
              when ''0x'' index = UInt(H:L);
              when ''10'' index = UInt(H);
              when ''11'' UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;
         boolean sub_op = (o2 == ''1'');
Assembler symbols

<V>           Is a width specifier, encoded in the "sz" field. It can have the following values:

              S           when sz = 0

              D           when sz = 1

<d>           Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

              2S          when Q = 0, sz = 0

              4S          when Q = 1, sz = 0

              2D          when Q = 1, sz = 1

              It is RESERVED when Q = 0, sz = 1.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          For the scalar variant: is the name of the SIMD&FP source register, encoded in the "M:Rm" fields.

              For the vector variant: is the name of the second SIMD&FP source register, encoded in the "M:Rm"
              fields.

<Ts>          For the scalar variant: is the element width specifier, encoded in the "sz" field. It can have the
              following values:

              S           when sz = 0

              D           when sz = 1

              For the vector variant: is an element size specifier, encoded in the "sz" field. It can have the
              following values:

              S           when sz = 0

              D           when sz = 1

<index>       For the scalar variant: is the element index, encoded in the "sz:L:H" field. It can have the following
              values:

              H:L         when sz = 0, L = x

              H           when sz = 1, L = 0

              It is RESERVED when sz = 1, L = 1.

              For the vector variant: is the element index encoded in the "sz:L:H" field. It can have the following
              values:

              H:L         when sz = 0, L = x

              H           when sz = 1, L = 0

              It is RESERVED when sz = 1, L = 1.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(idxdsize) operand2 = V[m];
 bits(datasize) operand3 = V[d];
 bits(datasize) result;
 bits(esize) element1;
 bits(esize) element2 = Elem[operand2, index, esize];

 for e = 0 to elements-1
     element1 = Elem[operand1, e, esize];
              if sub_op then element1 = FPNeg(element1);
              Elem[result, e, esize] = FPMulAdd(Elem[operand3, e, esize], element1, element2, FPCR);
         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMOV','       Floating-point move immediate (vector)       (C7.3.112)




           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15             12 11 10 9 8 7 6 5 4                   0
            0 Q op 0 1 1 1 1 0 0 0 0 0 a b c 1 1 1 1 0 1 d e f g h                                       Rd
                                                                  cmode


       Single-precision variant

       Applies when op = 0.

       FMOV <Vd>.<T>, #<imm>


       Double-precision variant

       Applies when Q = 1 && op = 1.

       FMOV <Vd>.2D, #<imm>


       Decode for all variants of this encoding

         integer rd = UInt(Rd);

         integer datasize = if Q == ''1'' then 128 else 64;
         bits(datasize) imm;
         bits(64) imm64;

         ImmediateOp operation;
         case cmode:op of
              when ''0xx00'' operation = ImmediateOp_MOVI;
              when ''0xx01'' operation = ImmediateOp_MVNI;
              when ''0xx10'' operation = ImmediateOp_ORR;
              when ''0xx11'' operation = ImmediateOp_BIC;
              when ''10x00'' operation = ImmediateOp_MOVI;
              when ''10x01'' operation = ImmediateOp_MVNI;
              when ''10x10'' operation = ImmediateOp_ORR;
              when ''10x11'' operation = ImmediateOp_BIC;
              when ''110x0'' operation = ImmediateOp_MOVI;
              when ''110x1'' operation = ImmediateOp_MVNI;
              when ''1110x'' operation = ImmediateOp_MOVI;
              when ''11110'' operation = ImmediateOp_MOVI;
              when ''11111''
                   // FMOV Dn,#imm is in main FP instruction set
                   if Q == ''0'' then UnallocatedEncoding();
                   operation = ImmediateOp_MOVI;

         imm64 = AdvSIMDExpandImm(op, cmode, a:b:c:d:e:f:g:h);
         imm = Replicate(imm64, datasize DIV 64);


       Assembler symbols

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "Q" field. It can have the following values:

                         2S           when Q = 0

                         4S           when Q = 1

       <imm>             Is a floating-point constant with sign, 3-bit exponent and normalized 4 bits of precision, encoded in
                         "a:b:c:d:e:f:g:h".
Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand;
 bits(datasize) result;

 case operation of
    when ImmediateOp_MOVI
         result = imm;
    when ImmediateOp_MVNI
         result = NOT(imm);
    when ImmediateOp_ORR
         operand = V[rd];
         result = operand OR imm;
    when ImmediateOp_BIC
        operand = V[rd];
        result = operand AND NOT(imm);

 V[rd] = result;');
INSERT INTO "instructions" VALUES('ARM','FMSUB','       Floating-point fused multiply-subtract (scalar): Vd = Va + (-Vn)*Vm       (C7.3.116)




           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14          10 9            5 4            0
            0 0 0 1 1 1 1 1 0 x 0                    Rm        1      Ra              Rn              Rd
                                      type o1                 o0


       Single-precision variant

       Applies when type = 00.

       FMSUB <Sd>, <Sn>, <Sm>, <Sa>


       Double-precision variant

       Applies when type = 01.

       FMSUB <Dd>, <Dn>, <Dm>, <Da>


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer a = UInt(Ra);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         integer datasize;
         case type of
              when ''00'' datasize = 32;
              when ''01'' datasize = 64;
              when ''1x'' UnallocatedEncoding();

         boolean opa_neg = (o1 == ''1'');
         boolean op1_neg = (o0 != o1);


       Assembler symbols

       <Dd>              Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Dn>              Is the 64-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
                         "Rn" field.

       <Dm>              Is the 64-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
                         "Rm" field.

       <Da>              Is the 64-bit name of the third SIMD&FP source register holding the minuend, encoded in the "Ra"
                         field.

       <Sd>              Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Sn>              Is the 32-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
                         "Rn" field.

       <Sm>              Is the 32-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
                         "Rm" field.

       <Sa>              Is the 32-bit name of the third SIMD&FP source register holding the minuend, encoded in the "Ra"
                         field.
Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) result;
 bits(datasize) operanda = V[a];
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];

 if opa_neg then operanda = FPNeg(operanda);
 if op1_neg then operand1 = FPNeg(operand1);
 result = FPMulAdd(operanda, operand1, operand2, FPCR);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMUL','       Floating-point multiply (by element)       (C7.3.117)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 1 0 1 1 1 1 1 1 sz L M                Rm       1 0 0 1 H 0            Rn     Rd
                  U


       Scalar variant

       FMUL <V><d>, <V><n>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi = M;
         case sz:L of
              when ''0x'' index = UInt(H:L);
              when ''10'' index = UInt(H);
              when ''11'' UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;
         boolean mulx_op = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 Q 0 0 1 1 1 1 1 sz L M                Rm       1 0 0 1 H 0            Rn     Rd
                  U


       Vector variant

       FMUL <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi = M;
         case sz:L of
              when ''0x'' index = UInt(H:L);
              when ''10'' index = UInt(H);
              when ''11'' UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;
         boolean mulx_op = (U == ''1'');
Assembler symbols

<V>           Is a width specifier, encoded in the "sz" field. It can have the following values:

              S           when sz = 0

              D           when sz = 1

<d>           Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

              2S          when Q = 0, sz = 0

              4S          when Q = 1, sz = 0

              2D          when Q = 1, sz = 1

              It is RESERVED when Q = 0, sz = 1.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          For the scalar variant: is the name of the SIMD&FP source register, encoded in the "M:Rm" fields.

              For the vector variant: is the name of the second SIMD&FP source register, encoded in the "M:Rm"
              fields.

<Ts>          For the scalar variant: is the element width specifier, encoded in the "sz" field. It can have the
              following values:

              S           when sz = 0

              D           when sz = 1

              For the vector variant: is an element size specifier, encoded in the "sz" field. It can have the
              following values:

              S           when sz = 0

              D           when sz = 1

<index>       For the scalar variant: is the element index, encoded in the "sz:L:H" field. It can have the following
              values:

              H:L         when sz = 0, L = x

              H           when sz = 1, L = 0

              It is RESERVED when sz = 1, L = 1.

              For the vector variant: is the element index encoded in the "sz:L:H" field. It can have the following
              values:

              H:L         when sz = 0, L = x

              H           when sz = 1, L = 0

              It is RESERVED when sz = 1, L = 1.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(idxdsize) operand2 = V[m];
 bits(datasize) result;
 bits(esize) element1;
 bits(esize) element2 = Elem[operand2, index, esize];

 for e = 0 to elements-1
     element1 = Elem[operand1, e, esize];
     if mulx_op then
                   Elem[result, e, esize] = FPMulX(element1, element2, FPCR);
              else
                   Elem[result, e, esize] = FPMul(element1, element2, FPCR);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FMULX','Floating-point multiply extended (by element)       (C7.3.120)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9                5 4          0
  0 1 1 1 1 1 1 1 1 sz L M                Rm        1 0 0 1 H 0              Rn             Rd
        U


Scalar variant

FMULX <V><d>, <V><n>, <Vm>.<Ts>[<index>]


Decode for this encoding

 integer idxdsize = if H == ''1'' then 128 else 64;
 integer index;
 bit Rmhi = M;
 case sz:L of
     when ''0x'' index = UInt(H:L);
     when ''10'' index = UInt(H);
     when ''11'' UnallocatedEncoding();

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rmhi:Rm);

 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;
 boolean mulx_op = (U == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9                5 4          0
  0 Q 1 0 1 1 1 1 1 sz L M                Rm        1 0 0 1 H 0              Rn             Rd
        U


Vector variant

FMULX <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]


Decode for this encoding

 integer idxdsize = if H == ''1'' then 128 else 64;
 integer index;
 bit Rmhi = M;
 case sz:L of
     when ''0x'' index = UInt(H:L);
     when ''10'' index = UInt(H);
     when ''11'' UnallocatedEncoding();

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rmhi:Rm);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean mulx_op = (U == ''1'');
       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "Q:sz" field. It can have the following values:

                         2S          when Q = 0, sz = 0

                         4S          when Q = 1, sz = 0

                         2D          when Q = 1, sz = 1

                         It is RESERVED when Q = 0, sz = 1.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              For the scalar variant: is the name of the SIMD&FP source register, encoded in the "M:Rm" fields.

                         For the vector variant: is the name of the second SIMD&FP source register, encoded in the "M:Rm"
                         fields.

       <Ts>              For the scalar variant: is the element width specifier, encoded in the "sz" field. It can have the
                         following values:

                         S           when sz = 0

                         D           when sz = 1

                         For the vector variant: is an element size specifier, encoded in the "sz" field. It can have the
                         following values:

                         S           when sz = 0

                         D           when sz = 1

       <index>           For the scalar variant: is the element index, encoded in the "sz:L:H" field. It can have the following
                         values:

                         H:L         when sz = 0, L = x

                         H           when sz = 1, L = 0

                         It is RESERVED when sz = 1, L = 1.

                         For the vector variant: is the element index encoded in the "sz:L:H" field. It can have the following
                         values:

                         H:L         when sz = 0, L = x

                         H           when sz = 1, L = 0

                         It is RESERVED when sz = 1, L = 1.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(idxdsize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2 = Elem[operand2, index, esize];

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              if mulx_op then
        Elem[result, e, esize] = FPMulX(element1, element2, FPCR);
    else
         Elem[result, e, esize] = FPMul(element1, element2, FPCR);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FNEG','Floating-point negate (vector)       (C7.3.122)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4            0
     0 Q 1 0 1 1 1 0 1 sz 1 0 0 0 0 0 1 1 1 1 1 0                                Rn              Rd
           U


Vector variant

FNEG <Vd>.<T>, <Vn>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  if sz:Q == ''10'' then ReservedValue();
  integer esize = 32 << UInt(sz);
  integer datasize = if Q == ''1'' then 128 else 64;
  integer elements = datasize DIV esize;

  boolean neg = (U == ''1'');


Assembler symbols

<Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                  2S          when sz = 0, Q = 0

                  4S          when sz = 0, Q = 1

                  2D          when sz = 1, Q = 1

                  It is RESERVED when sz = 1, Q = 0.

<Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  bits(datasize) result;
  bits(esize) element;

  for e = 0 to elements-1
       element = Elem[operand, e, esize];
       if neg then
            element = FPNeg(element);
       else
            element = FPAbs(element);
       Elem[result, e, esize] = element;

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FNMADD','Floating-point negated fused multiply-add (scalar): Vd = (-Va) + (-Vn)*Vm       (C7.3.124)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14             10 9              5 4          0
  0 0 0 1 1 1 1 1 0 x 1                    Rm        0       Ra                 Rn             Rd
                            type o1                 o0


Single-precision variant

Applies when type = 00.

FNMADD <Sd>, <Sn>, <Sm>, <Sa>


Double-precision variant

Applies when type = 01.

FNMADD <Dd>, <Dn>, <Dm>, <Da>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer a = UInt(Ra);
 integer n = UInt(Rn);
 integer m = UInt(Rm);

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 boolean opa_neg = (o1 == ''1'');
 boolean op1_neg = (o0 != o1);


Assembler symbols

<Dd>           Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Dn>           Is the 64-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
               "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
               "Rm" field.

<Da>           Is the 64-bit name of the third SIMD&FP source register holding the addend, encoded in the "Ra"
               field.

<Sd>           Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Sn>           Is the 32-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
               "Rn" field.

<Sm>           Is the 32-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
               "Rm" field.

<Sa>           Is the 32-bit name of the third SIMD&FP source register holding the addend, encoded in the "Ra"
               field.
       Operation

         CheckFPAdvSIMDEnabled64();
         bits(datasize) result;
         bits(datasize) operanda = V[a];
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];

         if opa_neg then operanda = FPNeg(operanda);
         if op1_neg then operand1 = FPNeg(operand1);
         result = FPMulAdd(operanda, operand1, operand2, FPCR);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FNMSUB','Floating-point negated fused multiply-subtract (scalar): Vd = (-Va) + Vn*Vm       (C7.3.125)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14             10 9              5 4          0
  0 0 0 1 1 1 1 1 0 x 1                    Rm        1        Ra                Rn             Rd
                            type o1                 o0


Single-precision variant

Applies when type = 00.

FNMSUB <Sd>, <Sn>, <Sm>, <Sa>


Double-precision variant

Applies when type = 01.

FNMSUB <Dd>, <Dn>, <Dm>, <Da>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer a = UInt(Ra);
 integer n = UInt(Rn);
 integer m = UInt(Rm);

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 boolean opa_neg = (o1 == ''1'');
 boolean op1_neg = (o0 != o1);


Assembler symbols

<Dd>           Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Dn>           Is the 64-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
               "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
               "Rm" field.

<Da>           Is the 64-bit name of the third SIMD&FP source register holding the minuend, encoded in the "Ra"
               field.

<Sd>           Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Sn>           Is the 32-bit name of the first SIMD&FP source register holding the multiplicand, encoded in the
               "Rn" field.

<Sm>           Is the 32-bit name of the second SIMD&FP source register holding the multiplier, encoded in the
               "Rm" field.

<Sa>           Is the 32-bit name of the third SIMD&FP source register holding the minuend, encoded in the "Ra"
               field.
       Operation

         CheckFPAdvSIMDEnabled64();
         bits(datasize) result;
         bits(datasize) operanda = V[a];
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];

         if opa_neg then operanda = FPNeg(operanda);
         if op1_neg then operand1 = FPNeg(operand1);
         result = FPMulAdd(operanda, operand1, operand2, FPCR);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FNMUL','Floating-point multiply-negate (scalar): Vd = -(Vn * Vm)       (C7.3.126)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                 5 4          0
  0 0 0 1 1 1 1 0 0 x 1                    Rm        1 0 0 0 1 0                Rn             Rd
                            type                    op


Single-precision variant

Applies when type = 00.

FNMUL <Sd>, <Sn>, <Sm>


Double-precision variant

Applies when type = 01.

FNMUL <Dd>, <Dn>, <Dm>


Decode for all variants of this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);

 integer datasize;
 case type of
     when ''00'' datasize = 32;
     when ''01'' datasize = 64;
     when ''1x'' UnallocatedEncoding();

 boolean negated = (op == ''1'');


Assembler symbols

<Dd>           Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Dn>           Is the 64-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Dm>           Is the 64-bit name of the second SIMD&FP source register, encoded in the "Rm" field.

<Sd>           Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Sn>           Is the 32-bit name of the first SIMD&FP source register, encoded in the "Rn" field.

<Sm>           Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) result;
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];

 result = FPMul(operand1, operand2, FPCR);

 if negated then result = FPNeg(result);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRECPE','       Floating-point reciprocal estimate       (C7.3.127)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
            0 1 0 1 1 1 1 0 1 sz 1 0 0 0 0 1 1 1 0 1 1 0                                  Rn             Rd




       Scalar variant

       FRECPE <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
            0 Q 0 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 1 0 1 1 0                                  Rn             Rd




       Vector variant

       FRECPE <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0

                         4S          when sz = 0, Q = 1
              2D         when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRecipEstimate(element, FPCR);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRECPS','       Floating-point reciprocal step       (C7.3.128)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4           0
            0 1 0 1 1 1 1 0 0 sz 1                   Rm         1 1 1 1 1 1               Rn             Rd




       Scalar variant

       FRECPS <V><d>, <V><n>, <V><m>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer esize = 32 << UInt(sz);
         integer datasize = esize;
         integer elements = 1;


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4           0
            0 Q 0 0 1 1 1 0 0 sz 1                   Rm         1 1 1 1 1 1               Rn             Rd




       Vector variant

       FRECPS <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         if sz:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(sz);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;


       Assembler symbols

       <V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                         S           when sz = 0

                         D           when sz = 1

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                         2S          when sz = 0, Q = 0
              4S         when sz = 0, Q = 1

              2D         when sz = 1, Q = 1

              It is RESERVED when sz = 1, Q = 0.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];
 bits(datasize) result;
 bits(esize) element1;
 bits(esize) element2;

 for e = 0 to elements-1
     element1 = Elem[operand1, e, esize];
     element2 = Elem[operand2, e, esize];
     Elem[result, e, esize] = FPRecipStepFused(element1, element2);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRECPX','Floating-point reciprocal exponent (scalar)       (C7.3.129)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4         0
     0 1 0 1 1 1 1 0 1 sz 1 0 0 0 0 1 1 1 1 1 1 0                                  Rn             Rd




Scalar variant

FRECPX <V><d>, <V><n>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);

  integer esize = 32 << UInt(sz);
  integer datasize = esize;
  integer elements = 1;


Assembler symbols

<V>               Is a width specifier, encoded in the "sz" field. It can have the following values:

                  S           when sz = 0

                  D           when sz = 1

<d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand = V[n];
  bits(datasize) result;
  bits(esize) element;

  for e = 0 to elements-1
       element = Elem[operand, e, esize];
       Elem[result, e, esize] = FPRecpX(element, FPCR);

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRINTA','Floating-point round to integral, to nearest with ties to away (vector)       (C7.3.130)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 Q 1 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 0 0 1 0                                  Rn             Rd
        U                  o2                                   o1


Vector variant

FRINTA <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean exact = FALSE;
 FPRounding rounding;
 case U:o1:o2 of
     when ''0xx'' rounding = FPDecodeRounding(o1:o2);
     when ''100'' rounding = FPRounding_TIEAWAY;
     when ''101'' UnallocatedEncoding();
     when ''110'' rounding = FPRoundingMode(FPCR); exact = TRUE;
     when ''111'' rounding = FPRoundingMode(FPCR);


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1

                2D          when sz = 1, Q = 1

                It is RESERVED when sz = 1, Q = 0.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRoundInt(element, FPCR, rounding, exact);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRINTI','Floating-point round to integral, using current rounding mode (vector)       (C7.3.132)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 Q 1 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 0 0 1 1 0                                  Rn             Rd
        U                  o2                                 o1


Vector variant

FRINTI <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean exact = FALSE;
 FPRounding rounding;
 case U:o1:o2 of
     when ''0xx'' rounding = FPDecodeRounding(o1:o2);
     when ''100'' rounding = FPRounding_TIEAWAY;
     when ''101'' UnallocatedEncoding();
     when ''110'' rounding = FPRoundingMode(FPCR); exact = TRUE;
     when ''111'' rounding = FPRoundingMode(FPCR);


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1

                2D          when sz = 1, Q = 1

                It is RESERVED when sz = 1, Q = 0.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRoundInt(element, FPCR, rounding, exact);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRINTM','Floating-point round to integral, toward minus infinity (vector)       (C7.3.134)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 Q 0 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 0 1 1 0                                  Rn             Rd
        U                  o2                                 o1


Vector variant

FRINTM <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean exact = FALSE;
 FPRounding rounding;
 case U:o1:o2 of
     when ''0xx'' rounding = FPDecodeRounding(o1:o2);
     when ''100'' rounding = FPRounding_TIEAWAY;
     when ''101'' UnallocatedEncoding();
     when ''110'' rounding = FPRoundingMode(FPCR); exact = TRUE;
     when ''111'' rounding = FPRoundingMode(FPCR);


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1

                2D          when sz = 1, Q = 1

                It is RESERVED when sz = 1, Q = 0.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRoundInt(element, FPCR, rounding, exact);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRINTN','Floating-point round to integral, to nearest with ties to even (vector)       (C7.3.136)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 Q 0 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 0 0 1 0                                  Rn             Rd
        U                  o2                                   o1


Vector variant

FRINTN <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean exact = FALSE;
 FPRounding rounding;
 case U:o1:o2 of
     when ''0xx'' rounding = FPDecodeRounding(o1:o2);
     when ''100'' rounding = FPRounding_TIEAWAY;
     when ''101'' UnallocatedEncoding();
     when ''110'' rounding = FPRoundingMode(FPCR); exact = TRUE;
     when ''111'' rounding = FPRoundingMode(FPCR);


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1

                2D          when sz = 1, Q = 1

                It is RESERVED when sz = 1, Q = 0.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRoundInt(element, FPCR, rounding, exact);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRINTP','Floating-point round to integral, toward positive infinity (vector)       (C7.3.138)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 Q 0 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 0 0 0 1 0                                  Rn             Rd
        U                  o2                                   o1


Vector variant

FRINTP <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean exact = FALSE;
 FPRounding rounding;
 case U:o1:o2 of
     when ''0xx'' rounding = FPDecodeRounding(o1:o2);
     when ''100'' rounding = FPRounding_TIEAWAY;
     when ''101'' UnallocatedEncoding();
     when ''110'' rounding = FPRoundingMode(FPCR); exact = TRUE;
     when ''111'' rounding = FPRoundingMode(FPCR);


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1

                2D          when sz = 1, Q = 1

                It is RESERVED when sz = 1, Q = 0.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRoundInt(element, FPCR, rounding, exact);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRINTX','Floating-point round to integral exact, using current rounding mode (vector)       (C7.3.140)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4          0
  0 Q 1 0 1 1 1 0 0 sz 1 0 0 0 0 1 1 0 0 1 1 0                                   Rn             Rd
        U                  o2                                 o1


Vector variant

FRINTX <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean exact = FALSE;
 FPRounding rounding;
 case U:o1:o2 of
     when ''0xx'' rounding = FPDecodeRounding(o1:o2);
     when ''100'' rounding = FPRounding_TIEAWAY;
     when ''101'' UnallocatedEncoding();
     when ''110'' rounding = FPRoundingMode(FPCR); exact = TRUE;
     when ''111'' rounding = FPRoundingMode(FPCR);


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1

                2D          when sz = 1, Q = 1

                It is RESERVED when sz = 1, Q = 0.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRoundInt(element, FPCR, rounding, exact);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRINTZ','Floating-point round to integral, toward zero (vector)       (C7.3.142)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 Q 0 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 0 0 1 1 0                                  Rn             Rd
        U                  o2                                 o1


Vector variant

FRINTZ <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean exact = FALSE;
 FPRounding rounding;
 case U:o1:o2 of
     when ''0xx'' rounding = FPDecodeRounding(o1:o2);
     when ''100'' rounding = FPRounding_TIEAWAY;
     when ''101'' UnallocatedEncoding();
     when ''110'' rounding = FPRoundingMode(FPCR); exact = TRUE;
     when ''111'' rounding = FPRoundingMode(FPCR);


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1

                2D          when sz = 1, Q = 1

                It is RESERVED when sz = 1, Q = 0.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPRoundInt(element, FPCR, rounding, exact);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRSQRTE','Floating-point reciprocal square root estimate       (C7.3.144)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 1 1 1 1 1 1 0 1 sz 1 0 0 0 0 1 1 1 0 1 1 0                                   Rn             Rd




Scalar variant

FRSQRTE <V><d>, <V><n>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4           0
  0 Q 1 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 1 0 1 1 0                                   Rn             Rd




Vector variant

FRSQRTE <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;


Assembler symbols

<V>             Is a width specifier, encoded in the "sz" field. It can have the following values:

                S           when sz = 0

                D           when sz = 1

<d>             Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>             Is the number of the SIMD&FP source register, encoded in the "Rn" field.

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0

                4S          when sz = 0, Q = 1
                         2D         when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = V[n];
         bits(datasize) result;
         bits(esize) element;

         for e = 0 to elements-1
              element = Elem[operand, e, esize];
              Elem[result, e, esize] = FPRSqrtEstimate(element, FPCR);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FRSQRTS','Floating-point reciprocal square root step       (C7.3.145)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4           0
  0 1 0 1 1 1 1 0 1 sz 1                    Rm         1 1 1 1 1 1               Rn             Rd




Scalar variant

FRSQRTS <V><d>, <V><n>, <V><m>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 integer esize = 32 << UInt(sz);
 integer datasize = esize;
 integer elements = 1;


Vector


  31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4           0
  0 Q 0 0 1 1 1 0 1 sz 1                    Rm         1 1 1 1 1 1               Rn             Rd




Vector variant

FRSQRTS <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;


Assembler symbols

<V>             Is a width specifier, encoded in the "sz" field. It can have the following values:

                S           when sz = 0

                D           when sz = 1

<d>             Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>             Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<m>             Is the number of the second SIMD&FP source register, encoded in the "Rm" field.

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                2S          when sz = 0, Q = 0
                         4S         when sz = 0, Q = 1

                         2D         when sz = 1, Q = 1

                         It is RESERVED when sz = 1, Q = 0.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand1 = V[n];
         bits(datasize) operand2 = V[m];
         bits(datasize) result;
         bits(esize) element1;
         bits(esize) element2;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              Elem[result, e, esize] = FPRSqrtStepFused(element1, element2);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FSQRT','Floating-point square root (vector)       (C7.3.146)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                  5 4           0
  0 Q 1 0 1 1 1 0 1 sz 1 0 0 0 0 1 1 1 1 1 1 0                                 Rn             Rd




Vector variant

FSQRT <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if sz:Q == ''10'' then ReservedValue();
 integer esize = 32 << UInt(sz);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;


Assembler symbols

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>            Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

               2S           when sz = 0, Q = 0

               4S           when sz = 0, Q = 1

               2D           when sz = 1, Q = 1

               It is RESERVED when sz = 1, Q = 0.

<Vn>           Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FPSqrt(element, FPCR);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','FSUB','Floating-point subtract (vector)       (C7.3.148)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4            0
     0 Q 0 0 1 1 1 0 1 sz 1                  Rm         1 1 0 1 0 1              Rn              Rd
           U


Three registers of the same type variant

FSUB <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  if sz:Q == ''10'' then ReservedValue();
  integer esize = 32 << UInt(sz);
  integer datasize = if Q == ''1'' then 128 else 64;
  integer elements = datasize DIV esize;
  boolean abs = (U == ''1'');


Assembler symbols

<Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>               Is an arrangement specifier, encoded in the "sz:Q" field. It can have the following values:

                  2S          when sz = 0, Q = 0

                  4S          when sz = 0, Q = 1

                  2D          when sz = 1, Q = 1

                  It is RESERVED when sz = 1, Q = 0.

<Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand1 = V[n];
  bits(datasize) operand2 = V[m];
  bits(datasize) result;
  bits(esize) element1;
  bits(esize) element2;
  bits(esize) diff;

  for e = 0 to elements-1
       element1 = Elem[operand1, e, esize];
       element2 = Elem[operand2, e, esize];
       diff = FPSub(element1, element2, FPCR);
       Elem[result, e, esize] = if abs then FPAbs(diff) else diff;

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','INS','       Insert vector element from another vector element       (C7.3.150)

       This instruction is used by the alias MOV (element). The alias is always the preferred disassembly.




           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14        11 10 9             5 4             0
            0 1 1 0 1 1 1 0 0 0 0                  imm5        0     imm4     1         Rn              Rd




       Advanced SIMD variant

       INS <Vd>.<Ts>[<index1>], <Vn>.<Ts>[<index2>]


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer size = LowestSetBit(imm5);
         if size > 3 then UnallocatedEncoding();

         integer dst_index = UInt(imm5<4:size+1>);
         integer src_index = UInt(imm4<3:size>);
         integer idxdsize = if imm4<3> == ''1'' then 128 else 64;
         // imm4<size-1:0> is IGNORED

         integer esize = 8 << size;


       Assembler symbols

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ts>              Is an element size specifier, encoded in the "imm5" field. It can have the following values:

                         B           when imm5 = xxxx1

                         H           when imm5 = xxx10

                         S           when imm5 = xx100

                         D           when imm5 = x1000

                         It is RESERVED when imm5 = x0000.

       <index1>          Is the destination element index encoded in the "imm5" field. It can have the following values:

                         imm5<4:1>   when imm5 = xxxx1

                         imm5<4:2>   when imm5 = xxx10

                         imm5<4:3>   when imm5 = xx100

                         imm5<4>     when imm5 = x1000

                         It is RESERVED when imm5 = x0000.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

       <index2>          Is the source element index encoded in the "imm5:imm4" field. It can have the following values:

                         imm4<3:0>   when imm5 = xxxx1

                         imm4<3:1>   when imm5 = xxx10

                         imm4<3:2>   when imm5 = xx100

                         imm4<3>     when imm5 = x1000
              It is RESERVED when imm5 = x0000.

              Unspecified bits in "imm4" are ignored but should be set to zero by an assembler.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(idxdsize) operand = V[n];
 bits(128) result;

 result = V[d];
 Elem[result, dst_index, esize] = Elem[operand, src_index, esize];
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','LD1','       Load multiple 1-element structures to one, two, three or four registers       (C7.3.152)


       No offset


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15         12 11 10 9       5 4     0
            0 Q 0 0 1 1 0 0 0 1 0 0 0 0 0 0 x x 1 x size                            Rn     Rt
                                       L                      opcode


       One register variant

       Applies when opcode = 0111.

       LD1 { <Vt>.<T> }, [<Xn|SP>]


       Two registers variant

       Applies when opcode = 1010.

       LD1 { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>]


       Three registers variant

       Applies when opcode = 0110.

       LD1 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>]


       Four registers variant

       Applies when opcode = 0010.

       LD1 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>]


       Decode for all variants of this encoding

         integer t = UInt(Rt);
         integer n = UInt(Rn);
         integer m = integer UNKNOWN;
         boolean wback = FALSE;


       Post-index


           31 30 29 28 27 26 25 24 23 22 21 20          16 15         12 11 10 9       5 4     0
            0 Q 0 0 1 1 0 0 1 1 0                 Rm         x x 1 x size           Rn     Rt
                                       L                      opcode


       One register, immediate offset variant

       Applies when Rm = 11111 && opcode = 0111.

       LD1 { <Vt>.<T> }, [<Xn|SP>], <imm>


       One register, register offset variant

       Applies when Rm != 11111 && opcode = 0111.

       LD1 { <Vt>.<T> }, [<Xn|SP>], <Xm>


       Two registers, immediate offset variant

       Applies when Rm = 11111 && opcode = 1010.
LD1 { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm>


Two registers, register offset variant

Applies when Rm != 11111 && opcode = 1010.

LD1 { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm>


Three registers, immediate offset variant

Applies when Rm = 11111 && opcode = 0110.

LD1 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm>


Three registers, register offset variant

Applies when Rm != 11111 && opcode = 0110.

LD1 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm>


Four registers, immediate offset variant

Applies when Rm = 11111 && opcode = 0010.

LD1 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm>


Four registers, register offset variant

Applies when Rm != 11111 && opcode = 0010.

LD1 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm>


Decode for all variants of this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 boolean wback = TRUE;


Assembler symbols

<Vt>          Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

<T>           Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              4H          when size = 01, Q = 0

              8H          when size = 01, Q = 1

              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              1D          when size = 11, Q = 0

              2D          when size = 11, Q = 1

<Vt2>         Is the name of the second SIMD&FP register to be transferred, encoded as "Rt" plus 1 modulo 32.

<Vt3>         Is the name of the third SIMD&FP register to be transferred, encoded as "Rt" plus 2 modulo 32.

<Vt4>         Is the name of the fourth SIMD&FP register to be transferred, encoded as "Rt" plus 3 modulo 32.

<Xn|SP>       Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.
       <imm>             For the one register, immediate offset variant: is the post-index immediate offset, encoded in the "Q"
                         field. It can have the following values:

                         #8           when Q = 0

                         #16          when Q = 1

                         For the two registers, immediate offset variant: is the post-index immediate offset, encoded in the
                         "Q" field. It can have the following values:

                         #16          when Q = 0

                         #32          when Q = 1

                         For the three registers, immediate offset variant: is the post-index immediate offset, encoded in the
                         "Q" field. It can have the following values:

                         #24          when Q = 0

                         #48          when Q = 1

                         For the four registers, immediate offset variant: is the post-index immediate offset, encoded in the
                         "Q" field. It can have the following values:

                         #32          when Q = 0

                         #64          when Q = 1

       <Xm>              Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
                         field.


       Shared decode for all encodings

         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer datasize = if Q == ''1'' then 128 else 64;
         integer esize = 8 << UInt(size);
         integer elements = datasize DIV esize;

         integer rpt;       // number of iterations
         integer selem;     // structure elements

         case opcode of
              when ''0000'' rpt = 1; selem = 4;          // LD/ST4 (4 registers)
              when ''0010'' rpt = 4; selem = 1;          // LD/ST1 (4 registers)
              when ''0100'' rpt = 1; selem = 3;          // LD/ST3 (3 registers)
              when ''0110'' rpt = 3; selem = 1;          // LD/ST1 (3 registers)
              when ''0111'' rpt = 1; selem = 1;          // LD/ST1 (1 register)
              when ''1000'' rpt = 1; selem = 2;          // LD/ST2 (2 registers)
              when ''1010'' rpt = 2; selem = 1;          // LD/ST1 (2 registers)
              otherwise UnallocatedEncoding();

         // .1D format only permitted with LD1 & ST1
         if size:Q == ''110'' && selem != 1 then ReservedValue();


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();

         bits(64) address;
         bits(64) offs;
         bits(datasize) rval;
         integer e, r, s, tt;
         constant integer ebytes = esize DIV 8;

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         else
              address = X[n];
 offs = Zeros();
 for r = 0 to rpt-1
     for e = 0 to elements-1
         tt = (t + r) MOD 32;
         for s = 0 to selem-1
             rval = V[tt];
             if memop == MemOp_LOAD then
                 Elem[rval, e, esize] = Mem[address + offs, ebytes, AccType_VEC];
                 V[tt] = rval;
             else // memop == MemOp_STORE
                 Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, e, esize];
             offs = offs + ebytes;
             tt = (tt + 1) MOD 32;

 if wback then
     if m != 31 then
         offs = X[m];
     if n == 31 then
         SP[] = address + offs;
     else
         X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','LD1R','Load single 1-element structure and replicate to all lanes (of one register)       (C7.3.154)


No offset


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15        13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 1 0 0 size                                   Rn             Rt
                              L R                      opcode S


No offset variant

LD1R { <Vt>.<T> }, [<Xn|SP>]


Decode for this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = integer UNKNOWN;
 boolean wback = FALSE;


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20             16 15     13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 1 1 0                    Rm         1 1 0 0 size               Rn             Rt
                              L R                      opcode S


Immediate offset variant

Applies when Rm = 11111.

LD1R { <Vt>.<T> }, [<Xn|SP>], <imm>


Register offset variant

Applies when Rm != 11111.

LD1R { <Vt>.<T> }, [<Xn|SP>], <Xm>


Decode for all variants of this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 boolean wback = TRUE;


Assembler symbols

<Vt>           Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

<T>            Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

               8B          when size = 00, Q = 0

               16B         when size = 00, Q = 1

               4H          when size = 01, Q = 0

               8H          when size = 01, Q = 1

               2S          when size = 10, Q = 0

               4S          when size = 10, Q = 1
                         1D           when size = 11, Q = 0

                         2D           when size = 11, Q = 1

       <Xn|SP>           Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <imm>             Is the post-index immediate offset, encoded in the "size" field. It can have the following values:

                         #1           when size = 00

                         #2           when size = 01

                         #4           when size = 10

                         #8           when size = 11

       <Xm>              Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
                         field.


       Shared decode for all encodings

         integer scale = UInt(opcode<2:1>);
         integer selem = UInt(opcode<0>:R) + 1;
         boolean replicate = FALSE;
         integer index;

         case scale of
              when 3
                   // load and replicate
                   if L == ''0'' || S == ''1'' then UnallocatedEncoding();
                   scale = UInt(size);
                   replicate = TRUE;
              when 0
                   index = UInt(Q:S:size);            // B[0-15]
              when 1
                   if size<0> == ''1'' then UnallocatedEncoding();
                   index = UInt(Q:S:size<1>);         // H[0-7]
              when 2
                   if size<1> == ''1'' then UnallocatedEncoding();
                   if size<0> == ''0'' then
                       index = UInt(Q:S);             // S[0-3]
                   else
                       if S == ''1'' then UnallocatedEncoding();
                       index = UInt(Q);               // D[0-1]
                       scale = 3;

         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer datasize = if Q == ''1'' then 128 else 64;
         integer esize = 8 << scale;


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();

         bits(64) address;
         bits(64) offs;
         bits(128) rval;
         bits(esize) element;
         integer s;
         constant integer ebytes = esize DIV 8;

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

         offs = Zeros();
 if replicate then
    // load and replicate to all elements
    for s = 0 to selem-1
        element = Mem[address + offs, ebytes, AccType_VEC];
        // replicate to fill 128- or 64-bit register
         V[t] = Replicate(element, datasize DIV esize);
        offs = offs + ebytes;
        t = (t + 1) MOD 32;
 else
    // load/store one element per register
    for s = 0 to selem-1
        rval = V[t];
        if memop == MemOp_LOAD then
            // insert into one lane of 128-bit register
             Elem[rval, index, esize] = Mem[address + offs, ebytes, AccType_VEC];
             V[t] = rval;
        else // memop == MemOp_STORE
            // extract from one lane of 128-bit register
             Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, index, esize];
        offs = offs + ebytes;
        t = (t + 1) MOD 32;

 if wback then
    if m != 31 then
        offs = X[m];
    if n == 31 then
         SP[] = address + offs;
    else
         X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','LD2','       Load multiple 2-element structures to two registers       (C7.3.155)


       No offset


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15           12 11 10 9             5 4             0
            0 Q 0 0 1 1 0 0 0 1 0 0 0 0 0 0 1 0 0 0 size                                 Rn              Rt
                                        L                       opcode


       No offset variant

       LD2 { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>]


       Decode for this encoding

         integer t = UInt(Rt);
         integer n = UInt(Rn);
         integer m = integer UNKNOWN;
         boolean wback = FALSE;


       Post-index


           31 30 29 28 27 26 25 24 23 22 21 20              16 15       12 11 10 9             5 4             0
            0 Q 0 0 1 1 0 0 1 1 0                    Rm        1 0 0 0 size              Rn              Rt
                                        L                       opcode


       Immediate offset variant

       Applies when Rm = 11111.

       LD2 { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm>


       Register offset variant

       Applies when Rm != 11111.

       LD2 { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm>


       Decode for all variants of this encoding

         integer t = UInt(Rt);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         boolean wback = TRUE;


       Assembler symbols

       <Vt>              Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1
              2D           when size = 11, Q = 1

              It is RESERVED when size = 11, Q = 0.

<Vt2>         Is the name of the second SIMD&FP register to be transferred, encoded as "Rt" plus 1 modulo 32.

<Xn|SP>       Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<imm>         Is the post-index immediate offset, encoded in the "Q" field. It can have the following values:

              #16          when Q = 0

              #32          when Q = 1

<Xm>          Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
              field.


Shared decode for all encodings

 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer esize = 8 << UInt(size);
 integer elements = datasize DIV esize;

 integer rpt;    // number of iterations
 integer selem;  // structure elements

 case opcode of
    when ''0000'' rpt = 1; selem = 4;        // LD/ST4 (4 registers)
    when ''0010'' rpt = 4; selem = 1;        // LD/ST1 (4 registers)
    when ''0100'' rpt = 1; selem = 3;        // LD/ST3 (3 registers)
    when ''0110'' rpt = 3; selem = 1;        // LD/ST1 (3 registers)
    when ''0111'' rpt = 1; selem = 1;        // LD/ST1 (1 register)
    when ''1000'' rpt = 1; selem = 2;        // LD/ST2 (2 registers)
    when ''1010'' rpt = 2; selem = 1;        // LD/ST1 (2 registers)
    otherwise UnallocatedEncoding();

 // .1D format only permitted with LD1 & ST1
 if size:Q == ''110'' && selem != 1 then ReservedValue();


Operation for all encodings

 CheckFPAdvSIMDEnabled64();

 bits(64) address;
 bits(64) offs;
 bits(datasize) rval;
 integer e, r, s, tt;
 constant integer ebytes = esize DIV 8;

 if n == 31 then
     CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 offs = Zeros();
 for r = 0 to rpt-1
     for e = 0 to elements-1
         tt = (t + r) MOD 32;
         for s = 0 to selem-1
             rval = V[tt];
             if memop == MemOp_LOAD then
                 Elem[rval, e, esize] = Mem[address + offs, ebytes, AccType_VEC];
                 V[tt] = rval;
             else // memop == MemOp_STORE
                 Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, e, esize];
             offs = offs + ebytes;
                       tt = (tt + 1) MOD 32;

         if wback then
              if m != 31 then
                   offs = X[m];
              if n == 31 then
                   SP[] = address + offs;
              else
                   X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','LD2R','Load single 2-element structure and replicate to all lanes of two registers       (C7.3.157)


No offset


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15        13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 0 0 size                                   Rn             Rt
                              L R                      opcode S


No offset variant

LD2R { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>]


Decode for this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = integer UNKNOWN;
 boolean wback = FALSE;


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20             16 15     13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 1 1 1                    Rm         1 1 0 0 size               Rn             Rt
                              L R                      opcode S


Immediate offset variant

Applies when Rm = 11111.

LD2R { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <imm>


Register offset variant

Applies when Rm != 11111.

LD2R { <Vt>.<T>, <Vt2>.<T> }, [<Xn|SP>], <Xm>


Decode for all variants of this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 boolean wback = TRUE;


Assembler symbols

<Vt>           Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

<T>            Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

               8B          when size = 00, Q = 0

               16B         when size = 00, Q = 1

               4H          when size = 01, Q = 0

               8H          when size = 01, Q = 1

               2S          when size = 10, Q = 0

               4S          when size = 10, Q = 1
                         1D           when size = 11, Q = 0

                         2D           when size = 11, Q = 1

       <Vt2>             Is the name of the second SIMD&FP register to be transferred, encoded as "Rt" plus 1 modulo 32.

       <Xn|SP>           Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <imm>             Is the post-index immediate offset, encoded in the "size" field. It can have the following values:

                         #2           when size = 00

                         #4           when size = 01

                         #8           when size = 10

                         #16          when size = 11

       <Xm>              Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
                         field.


       Shared decode for all encodings

         integer scale = UInt(opcode<2:1>);
         integer selem = UInt(opcode<0>:R) + 1;
         boolean replicate = FALSE;
         integer index;

         case scale of
              when 3
                   // load and replicate
                   if L == ''0'' || S == ''1'' then UnallocatedEncoding();
                   scale = UInt(size);
                   replicate = TRUE;
              when 0
                   index = UInt(Q:S:size);            // B[0-15]
              when 1
                   if size<0> == ''1'' then UnallocatedEncoding();
                   index = UInt(Q:S:size<1>);         // H[0-7]
              when 2
                   if size<1> == ''1'' then UnallocatedEncoding();
                   if size<0> == ''0'' then
                       index = UInt(Q:S);             // S[0-3]
                   else
                       if S == ''1'' then UnallocatedEncoding();
                       index = UInt(Q);               // D[0-1]
                       scale = 3;

         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer datasize = if Q == ''1'' then 128 else 64;
         integer esize = 8 << scale;


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();

         bits(64) address;
         bits(64) offs;
         bits(128) rval;
         bits(esize) element;
         integer s;
         constant integer ebytes = esize DIV 8;

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
         else
              address = X[n];

 offs = Zeros();
 if replicate then
    // load and replicate to all elements
    for s = 0 to selem-1
        element = Mem[address + offs, ebytes, AccType_VEC];
        // replicate to fill 128- or 64-bit register
         V[t] = Replicate(element, datasize DIV esize);
        offs = offs + ebytes;
        t = (t + 1) MOD 32;
 else
    // load/store one element per register
    for s = 0 to selem-1
        rval = V[t];
        if memop == MemOp_LOAD then
            // insert into one lane of 128-bit register
             Elem[rval, index, esize] = Mem[address + offs, ebytes, AccType_VEC];
             V[t] = rval;
        else // memop == MemOp_STORE
            // extract from one lane of 128-bit register
             Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, index, esize];
        offs = offs + ebytes;
        t = (t + 1) MOD 32;

 if wback then
    if m != 31 then
        offs = X[m];
    if n == 31 then
         SP[] = address + offs;
    else
         X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','LD3','       Load multiple 3-element structures to three registers       (C7.3.158)


       No offset


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15           12 11 10 9             5 4             0
            0 Q 0 0 1 1 0 0 0 1 0 0 0 0 0 0 0 1 0 0 size                                 Rn              Rt
                                        L                       opcode


       No offset variant

       LD3 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>]


       Decode for this encoding

         integer t = UInt(Rt);
         integer n = UInt(Rn);
         integer m = integer UNKNOWN;
         boolean wback = FALSE;


       Post-index


           31 30 29 28 27 26 25 24 23 22 21 20              16 15       12 11 10 9             5 4             0
            0 Q 0 0 1 1 0 0 1 1 0                    Rm        0 1 0 0 size              Rn              Rt
                                        L                       opcode


       Immediate offset variant

       Applies when Rm = 11111.

       LD3 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm>


       Register offset variant

       Applies when Rm != 11111.

       LD3 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm>


       Decode for all variants of this encoding

         integer t = UInt(Rt);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         boolean wback = TRUE;


       Assembler symbols

       <Vt>              Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1
              2D           when size = 11, Q = 1

              It is RESERVED when size = 11, Q = 0.

<Vt2>         Is the name of the second SIMD&FP register to be transferred, encoded as "Rt" plus 1 modulo 32.

<Vt3>         Is the name of the third SIMD&FP register to be transferred, encoded as "Rt" plus 2 modulo 32.

<Xn|SP>       Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<imm>         Is the post-index immediate offset, encoded in the "Q" field. It can have the following values:

              #24          when Q = 0

              #48          when Q = 1

<Xm>          Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
              field.


Shared decode for all encodings

 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer esize = 8 << UInt(size);
 integer elements = datasize DIV esize;

 integer rpt;    // number of iterations
 integer selem;  // structure elements

 case opcode of
    when ''0000'' rpt = 1; selem = 4;        // LD/ST4 (4 registers)
    when ''0010'' rpt = 4; selem = 1;        // LD/ST1 (4 registers)
    when ''0100'' rpt = 1; selem = 3;        // LD/ST3 (3 registers)
    when ''0110'' rpt = 3; selem = 1;        // LD/ST1 (3 registers)
    when ''0111'' rpt = 1; selem = 1;        // LD/ST1 (1 register)
    when ''1000'' rpt = 1; selem = 2;        // LD/ST2 (2 registers)
    when ''1010'' rpt = 2; selem = 1;        // LD/ST1 (2 registers)
    otherwise UnallocatedEncoding();

 // .1D format only permitted with LD1 & ST1
 if size:Q == ''110'' && selem != 1 then ReservedValue();


Operation for all encodings

 CheckFPAdvSIMDEnabled64();

 bits(64) address;
 bits(64) offs;
 bits(datasize) rval;
 integer e, r, s, tt;
 constant integer ebytes = esize DIV 8;

 if n == 31 then
     CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 offs = Zeros();
 for r = 0 to rpt-1
     for e = 0 to elements-1
         tt = (t + r) MOD 32;
         for s = 0 to selem-1
             rval = V[tt];
             if memop == MemOp_LOAD then
                 Elem[rval, e, esize] = Mem[address + offs, ebytes, AccType_VEC];
                 V[tt] = rval;
             else // memop == MemOp_STORE
                           Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, e, esize];
                       offs = offs + ebytes;
                       tt = (tt + 1) MOD 32;

         if wback then
              if m != 31 then
                   offs = X[m];
              if n == 31 then
                   SP[] = address + offs;
              else
                   X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','LD3R','Load single 3-element structure and replicate to all lanes of three registers       (C7.3.160)


No offset


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15        13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 0 1 0 0 0 0 0 0 1 1 1 0 size                                   Rn             Rt
                              L R                      opcode S


No offset variant

LD3R { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>]


Decode for this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = integer UNKNOWN;
 boolean wback = FALSE;


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20             16 15     13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 1 1 0                    Rm         1 1 1 0 size               Rn             Rt
                              L R                      opcode S


Immediate offset variant

Applies when Rm = 11111.

LD3R { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <imm>


Register offset variant

Applies when Rm != 11111.

LD3R { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T> }, [<Xn|SP>], <Xm>


Decode for all variants of this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 boolean wback = TRUE;


Assembler symbols

<Vt>           Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

<T>            Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

               8B          when size = 00, Q = 0

               16B         when size = 00, Q = 1

               4H          when size = 01, Q = 0

               8H          when size = 01, Q = 1

               2S          when size = 10, Q = 0

               4S          when size = 10, Q = 1
                         1D           when size = 11, Q = 0

                         2D           when size = 11, Q = 1

       <Vt2>             Is the name of the second SIMD&FP register to be transferred, encoded as "Rt" plus 1 modulo 32.

       <Vt3>             Is the name of the third SIMD&FP register to be transferred, encoded as "Rt" plus 2 modulo 32.

       <Xn|SP>           Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <imm>             Is the post-index immediate offset, encoded in the "size" field. It can have the following values:

                         #3           when size = 00

                         #6           when size = 01

                         #12          when size = 10

                         #24          when size = 11

       <Xm>              Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
                         field.


       Shared decode for all encodings

         integer scale = UInt(opcode<2:1>);
         integer selem = UInt(opcode<0>:R) + 1;
         boolean replicate = FALSE;
         integer index;

         case scale of
              when 3
                   // load and replicate
                   if L == ''0'' || S == ''1'' then UnallocatedEncoding();
                   scale = UInt(size);
                   replicate = TRUE;
              when 0
                   index = UInt(Q:S:size);            // B[0-15]
              when 1
                   if size<0> == ''1'' then UnallocatedEncoding();
                   index = UInt(Q:S:size<1>);         // H[0-7]
              when 2
                   if size<1> == ''1'' then UnallocatedEncoding();
                   if size<0> == ''0'' then
                       index = UInt(Q:S);             // S[0-3]
                   else
                       if S == ''1'' then UnallocatedEncoding();
                       index = UInt(Q);               // D[0-1]
                       scale = 3;

         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer datasize = if Q == ''1'' then 128 else 64;
         integer esize = 8 << scale;


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();

         bits(64) address;
         bits(64) offs;
         bits(128) rval;
         bits(esize) element;
         integer s;
         constant integer ebytes = esize DIV 8;

         if n == 31 then
              CheckSPAlignment();
              address = SP[];
 else
    address = X[n];

 offs = Zeros();
 if replicate then
    // load and replicate to all elements
    for s = 0 to selem-1
        element = Mem[address + offs, ebytes, AccType_VEC];
        // replicate to fill 128- or 64-bit register
         V[t] = Replicate(element, datasize DIV esize);
        offs = offs + ebytes;
        t = (t + 1) MOD 32;
 else
    // load/store one element per register
    for s = 0 to selem-1
        rval = V[t];
        if memop == MemOp_LOAD then
            // insert into one lane of 128-bit register
             Elem[rval, index, esize] = Mem[address + offs, ebytes, AccType_VEC];
             V[t] = rval;
        else // memop == MemOp_STORE
            // extract from one lane of 128-bit register
             Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, index, esize];
        offs = offs + ebytes;
        t = (t + 1) MOD 32;

 if wback then
    if m != 31 then
        offs = X[m];
    if n == 31 then
         SP[] = address + offs;
    else
         X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','LD4','       Load multiple 4-element structures to four registers       (C7.3.161)


       No offset


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15           12 11 10 9             5 4             0
            0 Q 0 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 size                                 Rn              Rt
                                        L                       opcode


       No offset variant

       LD4 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>]


       Decode for this encoding

         integer t = UInt(Rt);
         integer n = UInt(Rn);
         integer m = integer UNKNOWN;
         boolean wback = FALSE;


       Post-index


           31 30 29 28 27 26 25 24 23 22 21 20              16 15       12 11 10 9             5 4             0
            0 Q 0 0 1 1 0 0 1 1 0                    Rm        0 0 0 0 size              Rn              Rt
                                        L                       opcode


       Immediate offset variant

       Applies when Rm = 11111.

       LD4 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm>


       Register offset variant

       Applies when Rm != 11111.

       LD4 { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm>


       Decode for all variants of this encoding

         integer t = UInt(Rt);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         boolean wback = TRUE;


       Assembler symbols

       <Vt>              Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1
              2D           when size = 11, Q = 1

              It is RESERVED when size = 11, Q = 0.

<Vt2>         Is the name of the second SIMD&FP register to be transferred, encoded as "Rt" plus 1 modulo 32.

<Vt3>         Is the name of the third SIMD&FP register to be transferred, encoded as "Rt" plus 2 modulo 32.

<Vt4>         Is the name of the fourth SIMD&FP register to be transferred, encoded as "Rt" plus 3 modulo 32.

<Xn|SP>       Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

<imm>         Is the post-index immediate offset, encoded in the "Q" field. It can have the following values:

              #32          when Q = 0

              #64          when Q = 1

<Xm>          Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
              field.


Shared decode for all encodings

 MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer esize = 8 << UInt(size);
 integer elements = datasize DIV esize;

 integer rpt;    // number of iterations
 integer selem;  // structure elements

 case opcode of
    when ''0000'' rpt = 1; selem = 4;        // LD/ST4 (4 registers)
    when ''0010'' rpt = 4; selem = 1;        // LD/ST1 (4 registers)
    when ''0100'' rpt = 1; selem = 3;        // LD/ST3 (3 registers)
    when ''0110'' rpt = 3; selem = 1;        // LD/ST1 (3 registers)
    when ''0111'' rpt = 1; selem = 1;        // LD/ST1 (1 register)
    when ''1000'' rpt = 1; selem = 2;        // LD/ST2 (2 registers)
    when ''1010'' rpt = 2; selem = 1;        // LD/ST1 (2 registers)
    otherwise UnallocatedEncoding();

 // .1D format only permitted with LD1 & ST1
 if size:Q == ''110'' && selem != 1 then ReservedValue();


Operation for all encodings

 CheckFPAdvSIMDEnabled64();

 bits(64) address;
 bits(64) offs;
 bits(datasize) rval;
 integer e, r, s, tt;
 constant integer ebytes = esize DIV 8;

 if n == 31 then
     CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 offs = Zeros();
 for r = 0 to rpt-1
     for e = 0 to elements-1
         tt = (t + r) MOD 32;
         for s = 0 to selem-1
             rval = V[tt];
             if memop == MemOp_LOAD then
                 Elem[rval, e, esize] = Mem[address + offs, ebytes, AccType_VEC];
                           V[tt] = rval;
                       else // memop == MemOp_STORE
                           Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, e, esize];
                       offs = offs + ebytes;
                       tt = (tt + 1) MOD 32;

         if wback then
              if m != 31 then
                   offs = X[m];
              if n == 31 then
                   SP[] = address + offs;
              else
                   X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','LD4R','Load single 4-element structure and replicate to all lanes of four registers       (C7.3.163)


No offset


  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15        13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 0 1 1 0 0 0 0 0 1 1 1 0 size                                   Rn             Rt
                              L R                      opcode S


No offset variant

LD4R { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>]


Decode for this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = integer UNKNOWN;
 boolean wback = FALSE;


Post-index


  31 30 29 28 27 26 25 24 23 22 21 20             16 15     13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 0 1 1 1 1                    Rm         1 1 1 0 size               Rn             Rt
                              L R                      opcode S


Immediate offset variant

Applies when Rm = 11111.

LD4R { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <imm>


Register offset variant

Applies when Rm != 11111.

LD4R { <Vt>.<T>, <Vt2>.<T>, <Vt3>.<T>, <Vt4>.<T> }, [<Xn|SP>], <Xm>


Decode for all variants of this encoding

 integer t = UInt(Rt);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 boolean wback = TRUE;


Assembler symbols

<Vt>           Is the name of the first or only SIMD&FP register to be transferred, encoded in the "Rt" field.

<T>            Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

               8B          when size = 00, Q = 0

               16B         when size = 00, Q = 1

               4H          when size = 01, Q = 0

               8H          when size = 01, Q = 1

               2S          when size = 10, Q = 0

               4S          when size = 10, Q = 1
                         1D           when size = 11, Q = 0

                         2D           when size = 11, Q = 1

       <Vt2>             Is the name of the second SIMD&FP register to be transferred, encoded as "Rt" plus 1 modulo 32.

       <Vt3>             Is the name of the third SIMD&FP register to be transferred, encoded as "Rt" plus 2 modulo 32.

       <Vt4>             Is the name of the fourth SIMD&FP register to be transferred, encoded as "Rt" plus 3 modulo 32.

       <Xn|SP>           Is the 64-bit name of the general-purpose base register or stack pointer, encoded in the "Rn" field.

       <imm>             Is the post-index immediate offset, encoded in the "size" field. It can have the following values:

                         #4           when size = 00

                         #8           when size = 01

                         #16          when size = 10

                         #32          when size = 11

       <Xm>              Is the 64-bit name of the general-purpose post-index register, excluding XZR, encoded in the "Rm"
                         field.


       Shared decode for all encodings

         integer scale = UInt(opcode<2:1>);
         integer selem = UInt(opcode<0>:R) + 1;
         boolean replicate = FALSE;
         integer index;

         case scale of
              when 3
                   // load and replicate
                   if L == ''0'' || S == ''1'' then UnallocatedEncoding();
                   scale = UInt(size);
                   replicate = TRUE;
              when 0
                   index = UInt(Q:S:size);            // B[0-15]
              when 1
                   if size<0> == ''1'' then UnallocatedEncoding();
                   index = UInt(Q:S:size<1>);         // H[0-7]
              when 2
                   if size<1> == ''1'' then UnallocatedEncoding();
                   if size<0> == ''0'' then
                       index = UInt(Q:S);             // S[0-3]
                   else
                       if S == ''1'' then UnallocatedEncoding();
                       index = UInt(Q);               // D[0-1]
                       scale = 3;

         MemOp memop = if L == ''1'' then MemOp_LOAD else MemOp_STORE;
         integer datasize = if Q == ''1'' then 128 else 64;
         integer esize = 8 << scale;


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();

         bits(64) address;
         bits(64) offs;
         bits(128) rval;
         bits(esize) element;
         integer s;
         constant integer ebytes = esize DIV 8;

         if n == 31 then
              CheckSPAlignment();
    address = SP[];
 else
    address = X[n];

 offs = Zeros();
 if replicate then
    // load and replicate to all elements
    for s = 0 to selem-1
        element = Mem[address + offs, ebytes, AccType_VEC];
        // replicate to fill 128- or 64-bit register
         V[t] = Replicate(element, datasize DIV esize);
        offs = offs + ebytes;
        t = (t + 1) MOD 32;
 else
    // load/store one element per register
    for s = 0 to selem-1
        rval = V[t];
        if memop == MemOp_LOAD then
            // insert into one lane of 128-bit register
             Elem[rval, index, esize] = Mem[address + offs, ebytes, AccType_VEC];
             V[t] = rval;
        else // memop == MemOp_STORE
            // extract from one lane of 128-bit register
             Mem[address + offs, ebytes, AccType_VEC] = Elem[rval, index, esize];
        offs = offs + ebytes;
        t = (t + 1) MOD 32;

 if wback then
    if m != 31 then
        offs = X[m];
    if n == 31 then
         SP[] = address + offs;
    else
         X[n] = address + offs;');
INSERT INTO "instructions" VALUES('ARM','MLA','       Multiply-add to accumulator (vector, by element)       (C7.3.170)




           31 30 29 28 27 26 25 24 23 22 21 20 19         16 15 14 13 12 11 10 9               5 4             0
            0 Q 1 0 1 1 1 1 size L M                  Rm       0 0 0 0 H 0               Rn              Rd
                                                                 o2


       Vector variant

       MLA <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);       Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         boolean sub_op = (o2 == ''1'');


       Assembler symbols

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when:

                         .      size = 00, Q = x.

                         .      size = 11, Q = x.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "size:M:Rm" field. It can have
                         the following values:

                         0:Rm        when size = 01

                         M:Rm        when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

                         Restricted to V0-V15 when element size <Ts> is H.
<Ts>          Is an element size specifier, encoded in the "size" field. It can have the following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<index>       Is the element index encoded in the "size:L:H:M" field. It can have the following values:

              H:L:M       when size = 01

              H:L         when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(idxdsize) operand2 = V[m];
 bits(datasize) operand3 = V[d];
 bits(datasize) result;
 integer element1;
 integer element2;
 bits(esize) product;

 element2 = UInt(Elem[operand2, index, esize]);
 for e = 0 to elements-1
     element1 = UInt(Elem[operand1, e, esize]);
     product = (element1 * element2)<esize-1:0>;
     if sub_op then
         Elem[result, e, esize] = Elem[operand3, e, esize] - product;
     else
         Elem[result, e, esize] = Elem[operand3, e, esize] + product;
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','MLS','       Multiply-subtract from accumulator (vector, by element)       (C7.3.172)




           31 30 29 28 27 26 25 24 23 22 21 20 19         16 15 14 13 12 11 10 9               5 4             0
            0 Q 1 0 1 1 1 1 size L M                  Rm       0 1 0 0 H 0               Rn              Rd
                                                                 o2


       Vector variant

       MLS <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);       Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         boolean sub_op = (o2 == ''1'');


       Assembler symbols

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when:

                         .      size = 00, Q = x.

                         .      size = 11, Q = x.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "size:M:Rm" field. It can have
                         the following values:

                         0:Rm        when size = 01

                         M:Rm        when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

                         Restricted to V0-V15 when element size <Ts> is H.
<Ts>          Is an element size specifier, encoded in the "size" field. It can have the following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<index>       Is the element index encoded in the "size:L:H:M" field. It can have the following values:

              H:L:M       when size = 01

              H:L         when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(idxdsize) operand2 = V[m];
 bits(datasize) operand3 = V[d];
 bits(datasize) result;
 integer element1;
 integer element2;
 bits(esize) product;

 element2 = UInt(Elem[operand2, index, esize]);
 for e = 0 to elements-1
     element1 = UInt(Elem[operand1, e, esize]);
     product = (element1 * element2)<esize-1:0>;
     if sub_op then
         Elem[result, e, esize] = Elem[operand3, e, esize] - product;
     else
         Elem[result, e, esize] = Elem[operand3, e, esize] + product;
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','MOVI','Move immediate (vector)       (C7.3.179)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15       12 11 10 9 8 7 6 5 4                   0
  0 Q op 0 1 1 1 1 0 0 0 0 0 a b c                  cmode       0 1 d e f g h               Rd




8-bit variant

Applies when op = 0 && cmode = 1110.

MOVI <Vd>.<T>, #<imm8>{, LSL #0}


16-bit shifted immediate variant

Applies when op = 0 && cmode = 10x0.

MOVI <Vd>.<T>, #<imm8>{, LSL #<amount>}


32-bit shifted immediate variant

Applies when op = 0 && cmode = 0xx0.

MOVI <Vd>.<T>, #<imm8>{, LSL #<amount>}


32-bit shifting ones variant

Applies when op = 0 && cmode = 110x.

MOVI <Vd>.<T>, #<imm8>, MSL #<amount>


64-bit scalar variant

Applies when Q = 0 && op = 1 && cmode = 1110.

MOVI <Dd>, #<imm>


64-bit vector variant

Applies when Q = 1 && op = 1 && cmode = 1110.

MOVI <Vd>.2D, #<imm>


Decode for all variants of this encoding

 integer rd = UInt(Rd);

 integer datasize = if Q == ''1'' then 128 else 64;
 bits(datasize) imm;
 bits(64) imm64;

 ImmediateOp operation;
 case cmode:op of
     when ''0xx00'' operation = ImmediateOp_MOVI;
     when ''0xx01'' operation = ImmediateOp_MVNI;
     when ''0xx10'' operation = ImmediateOp_ORR;
     when ''0xx11'' operation = ImmediateOp_BIC;
     when ''10x00'' operation = ImmediateOp_MOVI;
     when ''10x01'' operation = ImmediateOp_MVNI;
     when ''10x10'' operation = ImmediateOp_ORR;
     when ''10x11'' operation = ImmediateOp_BIC;
     when ''110x0'' operation = ImmediateOp_MOVI;
              when ''110x1'' operation = ImmediateOp_MVNI;
              when ''1110x'' operation = ImmediateOp_MOVI;
              when ''11110'' operation = ImmediateOp_MOVI;
              when ''11111''
                   // FMOV Dn,#imm is in main FP instruction set
                   if Q == ''0'' then UnallocatedEncoding();
                   operation = ImmediateOp_MOVI;

         imm64 = AdvSIMDExpandImm(op, cmode, a:b:c:d:e:f:g:h);
         imm = Replicate(imm64, datasize DIV 64);


       Assembler symbols

       <Dd>              Is the 64-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <imm>             Is a 64-bit immediate ''aaaaaaaabbbbbbbbccccccccddddddddeeeeeeeeffffffffgggggggghhhhhhhh'',
                         encoded in "a:b:c:d:e:f:g:h".

       <T>               For the 8-bit variant: is an arrangement specifier, encoded in the "Q" field. It can have the following
                         values:

                         8B           when Q = 0

                         16B          when Q = 1

                         For the 16-bit variant: is an arrangement specifier, encoded in the "Q" field. It can have the
                         following values:

                         4H           when Q = 0

                         8H           when Q = 1

                         For the 32-bit variant: is an arrangement specifier, encoded in the "Q" field. It can have the
                         following values:

                         2S           when Q = 0

                         4S           when Q = 1

       <imm8>            Is an 8-bit immediate encoded in "a:b:c:d:e:f:g:h".

       <amount>          For the 16-bit shifted immediate variant: is the shift amount encoded in the "cmode<1>" field. It can
                         have the following values:

                         0            when cmode<1> = 0

                         8            when cmode<1> = 1

                         defaulting to 0 if LSL is omitted.

                         For the 32-bit shifted immediate variant: is the shift amount encoded in the "cmode<2:1>" field. It
                         can have the following values:

                         0            when cmode<2:1> = 00

                         8            when cmode<2:1> = 01

                         16           when cmode<2:1> = 10

                         24           when cmode<2:1> = 11

                         defaulting to 0 if LSL is omitted.

                         For the 32-bit shifting ones variant: is the shift amount encoded in the "cmode<0>" field. It can have
                         the following values:

                         8            when cmode<0> = 0

                         16           when cmode<0> = 1
Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand;
 bits(datasize) result;

 case operation of
    when ImmediateOp_MOVI
         result = imm;
    when ImmediateOp_MVNI
         result = NOT(imm);
    when ImmediateOp_ORR
         operand = V[rd];
         result = operand OR imm;
    when ImmediateOp_BIC
        operand = V[rd];
        result = operand AND NOT(imm);

 V[rd] = result;');
INSERT INTO "instructions" VALUES('ARM','MVNI','Move inverted immediate (vector)       (C7.3.183)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15       12 11 10 9 8 7 6 5 4                   0
  0 Q 1 0 1 1 1 1 0 0 0 0 0 a b c                    cmode      0 1 d e f g h               Rd
        op


16-bit shifted immediate variant

Applies when cmode = 10x0.

MVNI <Vd>.<T>, #<imm8>{, LSL #<amount>}


32-bit shifted immediate variant

Applies when cmode = 0xx0.

MVNI <Vd>.<T>, #<imm8>{, LSL #<amount>}


32-bit shifting ones variant

Applies when cmode = 110x.

MVNI <Vd>.<T>, #<imm8>, MSL #<amount>


Decode for all variants of this encoding

 integer rd = UInt(Rd);

 integer datasize = if Q == ''1'' then 128 else 64;
 bits(datasize) imm;
 bits(64) imm64;

 ImmediateOp operation;
 case cmode:op of
     when ''0xx00'' operation = ImmediateOp_MOVI;
     when ''0xx01'' operation = ImmediateOp_MVNI;
     when ''0xx10'' operation = ImmediateOp_ORR;
     when ''0xx11'' operation = ImmediateOp_BIC;
     when ''10x00'' operation = ImmediateOp_MOVI;
     when ''10x01'' operation = ImmediateOp_MVNI;
     when ''10x10'' operation = ImmediateOp_ORR;
     when ''10x11'' operation = ImmediateOp_BIC;
     when ''110x0'' operation = ImmediateOp_MOVI;
     when ''110x1'' operation = ImmediateOp_MVNI;
     when ''1110x'' operation = ImmediateOp_MOVI;
     when ''11110'' operation = ImmediateOp_MOVI;
     when ''11111''
         // FMOV Dn,#imm is in main FP instruction set
         if Q == ''0'' then UnallocatedEncoding();
         operation = ImmediateOp_MOVI;

 imm64 = AdvSIMDExpandImm(op, cmode, a:b:c:d:e:f:g:h);
 imm = Replicate(imm64, datasize DIV 64);


Assembler symbols

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
       <T>               For the 16-bit variant: is an arrangement specifier, encoded in the "Q" field. It can have the
                         following values:

                         4H           when Q = 0

                         8H           when Q = 1

                         For the 32-bit variant: is an arrangement specifier, encoded in the "Q" field. It can have the
                         following values:

                         2S           when Q = 0

                         4S           when Q = 1

       <imm8>            Is an 8-bit immediate encoded in "a:b:c:d:e:f:g:h".

       <amount>          For the 16-bit shifted immediate variant: is the shift amount encoded in the "cmode<1>" field. It can
                         have the following values:

                         0            when cmode<1> = 0

                         8            when cmode<1> = 1

                         defaulting to 0 if LSL is omitted.

                         For the 32-bit shifted immediate variant: is the shift amount encoded in the "cmode<2:1>" field. It
                         can have the following values:

                         0            when cmode<2:1> = 00

                         8            when cmode<2:1> = 01

                         16           when cmode<2:1> = 10

                         24           when cmode<2:1> = 11

                         defaulting to 0 if LSL is omitted.

                         For the 32-bit shifting ones variant: is the shift amount encoded in the "cmode<0>" field. It can have
                         the following values:

                         8            when cmode<0> = 0

                         16           when cmode<0> = 1


       Operation

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand;
         bits(datasize) result;

         case operation of
              when ImmediateOp_MOVI
                   result = imm;
              when ImmediateOp_MVNI
                   result = NOT(imm);
              when ImmediateOp_ORR
                   operand = V[rd];
                   result = operand OR imm;
              when ImmediateOp_BIC
                   operand = V[rd];
                   result = operand AND NOT(imm);

         V[rd] = result;');
INSERT INTO "instructions" VALUES('ARM','NOT','Bitwise NOT (vector)       (C7.3.185)

This instruction is used by the alias MVN. The alias is always the preferred disassembly.




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
  0 Q 1 0 1 1 1 0 0 0 1 0 0 0 0 0 0 1 0 1 1 0                                   Rn             Rd




Vector variant

NOT <Vd>.<T>, <Vn>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 integer esize = 8;
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV 8;


Assembler symbols

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>             Is an arrangement specifier, encoded in the "Q" field. It can have the following values:

                8B          when Q = 0

                16B         when Q = 1

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = NOT(element);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','PMUL','Polynomial multiply       (C7.3.189)




  31 30 29 28 27 26 25 24 23 22 21 20          16 15 14 13 12 11 10 9                 5 4           0
  0 Q 1 0 1 1 1 0 size 1                 Rm         1 0 0 1 1 1               Rn              Rd
        U


Three registers of the same type variant

PMUL <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if U == ''1'' && size != ''00'' then ReservedValue();
 if size == ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean poly = (U == ''1'');


Assembler symbols

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              It is RESERVED when:

              .      size = 01, Q = x.

              .      size = 1x, Q = x.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];
 bits(datasize) result;
 bits(esize) element1;
 bits(esize) element2;
 bits(esize) product;

 for e = 0 to elements-1
     element1 = Elem[operand1, e, esize];
     element2 = Elem[operand2, e, esize];
     if poly then
         product = PolynomialMult(element1, element2)<esize-1:0>;
     else
         product = (UInt(element1) * UInt(element2))<esize-1:0>;
              Elem[result, e, esize] = product;

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','PMULL','Polynomial multiply long       (C7.3.190)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4             0
  0 Q 0 0 1 1 1 0 size 1                  Rm          1 1 1 0 0 0               Rn               Rd




Three registers, not all the same type variant

PMULL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);

 if size == ''01'' || size == ''10'' then ReservedValue();
 if size == ''11'' && ! HaveCryptoExt() then UnallocatedEncoding();
 integer esize = 8 << UInt(size);
 integer datasize = 64;
 integer part = UInt(Q);
 integer elements = datasize DIV esize;


Assembler symbols

2             Is the second and upper half specifier. If present it causes the operation to be performed on the upper
              64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
              the following values:

              [absent]    when Q = 0

              [present]   when Q = 1

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Ta>          Is an arrangement specifier, encoded in the "size" field. It can have the following values:

              8H          when size = 00

              1Q          when size = 11

              It is RESERVED when:

              .      size = 01.

              .      size = 10.

              The ''1Q'' arrangement is only allocated in an implementation that includes the Cryptographic
              Extension, and is otherwise RESERVED.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Tb>          Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              1D          when size = 11, Q = 0

              2D          when size = 11, Q = 1

              It is RESERVED when:

              .      size = 01, Q = x.
                         .      size = 10, Q = x.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation

         CheckFPAdvSIMDEnabled64();
         bits(datasize)      operand1 = Vpart[n, part];
         bits(datasize)      operand2 = Vpart[m, part];
         bits(2*datasize) result;
         bits(esize) element1;
         bits(esize) element2;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, esize];
              element2 = Elem[operand2, e, esize];
              Elem[result, e, 2*esize] = PolynomialMult(element1, element2);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','PMULL2','-R:PMULL');
INSERT INTO "instructions" VALUES('ARM','RADDHN','Rounding add returning high narrow       (C7.3.191)




  31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9                5 4             0
  0 Q 1 0 1 1 1 0 size 1                  Rm          0 1 0 0 0 0               Rn               Rd
        U                                                   o1


Three registers, not all the same type variant

RADDHN{2} <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);

 if size == ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = 64;
 integer part = UInt(Q);
 integer elements = datasize DIV esize;

 boolean sub_op = (o1 == ''1'');
 boolean round = (U == ''1'');


Assembler symbols

2             Is the second and upper half specifier. If present it causes the operation to be performed on the upper
              64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
              the following values:

              [absent]    when Q = 0

              [present]   when Q = 1

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Tb>          Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              4H          when size = 01, Q = 0

              8H          when size = 01, Q = 1

              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              It is RESERVED when size = 11, Q = x.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Ta>          Is an arrangement specifier, encoded in the "size" field. It can have the following values:

              8H          when size = 00

              4S          when size = 01

              2D          when size = 10

              It is RESERVED when size = 11.
       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


       Operation

         CheckFPAdvSIMDEnabled64();
         bits(2*datasize) operand1 = V[n];
         bits(2*datasize) operand2 = V[m];
         bits(datasize)      result;
         integer round_const = if round then 1 << (esize - 1) else 0;
         bits(2*esize) element1;
         bits(2*esize) element2;
         bits(2*esize) sum;

         for e = 0 to elements-1
              element1 = Elem[operand1, e, 2*esize];
              element2 = Elem[operand2, e, 2*esize];
              if sub_op then
                   sum = element1 - element2;
              else
                   sum = element1 + element2;
              sum = sum + round_const;
              Elem[result, e, esize] = sum<2*esize-1:esize>;

         Vpart[d, part] = result;');
INSERT INTO "instructions" VALUES('ARM','RADDHN2','-R:RADDHN');
INSERT INTO "instructions" VALUES('ARM','REV64','       Reverse elements in 64-bit doublewords (vector)       (C7.3.195)




           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                 5 4             0
            0 Q 0 0 1 1 1 0 size 1 0 0 0 0 0 0 0 0 0 1 0                                 Rn              Rd
                  U                                                     o0


       Vector variant

       REV64 <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         // size=esize:      B(0),   H(1),  S(1), D(S)
         integer esize = 8 << UInt(size);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         // op=REVx:        64(0), 32(1), 16(2)
         bits(2) op = o0:U;

         // => op+size:
         //        64+B = 0, 64+H = 1, 64+S = 2, 64+D = X
         //        32+B = 1, 32+H = 2, 32+S = X, 32+D = X
         //        16+B = 2, 16+H = X, 16+S = X, 16+D = X
         //         8+B = X,    8+H = X, 8+S = X,   8+D = X
         // => 3-(op+size) (index bits in group)
         //        64/B = 3, 64+H = 2, 64+S = 1, 64+D = X
         //        32+B = 2, 32+H = 1, 32+S = X, 32+D = X
         //        16+B = 1, 16+H = X, 16+S = X, 16+D = X
         //         8+B = X,    8+H = X, 8+S = X,   8+D = X

         // index bits within group: 1, 2, 3
         if UInt(op)+UInt(size) >= 3 then UnallocatedEncoding();
         integer ibits = 3-(UInt(op)+UInt(size));

         // invert mask to invert index bits within group (max index = 15)
         bits(4) revmask = Zeros(4-ibits):Ones(ibits);


       Assembler symbols

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when size = 11, Q = x.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.
Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 integer e_rev;
 for e = 0 to elements-1
     e_rev = UInt(e<3:0> EOR revmask);
     Elem[result, e_rev, esize] = Elem[operand, e, esize];

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','RSHRN','       Rounding shift right narrow (immediate)       (C7.3.196)




           31 30 29 28 27 26 25 24 23 22           19 18    16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 1 0              !=0000      immb      1 0 0 0 1 1               Rn               Rd
                                            immh                               op


       Vector variant

       RSHRN{2} <Vd>.<Tb>, <Vn>.<Ta>, #<shift>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''0000'' then SEE "Advanced SIMD modified immediate";
         if immh<3> == ''1'' then ReservedValue();
         integer esize = 8 << HighestSetBit(immh);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         integer shift = (2 * esize) - UInt(immh:immb);
         boolean round = (op == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Tb>              Is an arrangement specifier, encoded in the "immh:Q" field. It can have the following values:

                         8B          when immh = 0001, Q = 0

                         16B         when immh = 0001, Q = 1

                         4H          when immh = 001x, Q = 0

                         8H          when immh = 001x, Q = 1

                         2S          when immh = 01xx, Q = 0

                         4S          when immh = 01xx, Q = 1

                         See Advanced SIMD modified immediate on page C4-213 when immh = 0000, Q = x.

                         It is RESERVED when immh = 1xxx, Q = x.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

       <Ta>              Is an arrangement specifier, encoded in the "immh" field. It can have the following values:

                         8H          when immh = 0001

                         4S          when immh = 001x

                         2D          when immh = 01xx

                         See Advanced SIMD modified immediate on page C4-213 when immh = 0000.
              It is RESERVED when immh = 1xxx.

<shift>       Is the right shift amount, in the range 1 to the destination element width in bits, encoded in the
              "immh:immb" field. It can have the following values:

              (16-UInt(immh:immb))when immh = 0001

              (32-UInt(immh:immb))when immh = 001x

              (64-UInt(immh:immb))when immh = 01xx

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000.

              It is RESERVED when immh = 1xxx.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize*2) operand = V[n];
 bits(datasize) result;
 integer round_const = if round then (1 << (shift - 1)) else 0;
 integer element;

 for e = 0 to elements-1
     element = (UInt(Elem[operand, e, 2*esize]) + round_const) >> shift;
     Elem[result, e, esize] = element<esize-1:0>;

 Vpart[d, part] = result;');
INSERT INTO "instructions" VALUES('ARM','RSHRN2','-R:RSHRN');
INSERT INTO "instructions" VALUES('ARM','RSUBHN','       Rounding subtract returning high narrow       (C7.3.197)




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9                5 4             0
            0 Q 1 0 1 1 1 0 size 1                   Rm          0 1 1 0 0 0               Rn               Rd
                  U                                                    o1


       Three registers, not all the same type variant

       RSUBHN{2} <Vd>.<Tb>, <Vn>.<Ta>, <Vm>.<Ta>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         if size == ''11'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean sub_op = (o1 == ''1'');
         boolean round = (U == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when size = 11, Q = x.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         8H          when size = 00

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when size = 11.
<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(2*datasize) operand1 = V[n];
 bits(2*datasize) operand2 = V[m];
 bits(datasize)   result;
 integer round_const = if round then 1 << (esize - 1) else 0;
 bits(2*esize) element1;
 bits(2*esize) element2;
 bits(2*esize) sum;

 for e = 0 to elements-1
     element1 = Elem[operand1, e, 2*esize];
     element2 = Elem[operand2, e, 2*esize];
     if sub_op then
         sum = element1 - element2;
     else
         sum = element1 + element2;
     sum = sum + round_const;
     Elem[result, e, esize] = sum<2*esize-1:esize>;

 Vpart[d, part] = result;');
INSERT INTO "instructions" VALUES('ARM','RSUBHN2','-R:RSUBHN');
INSERT INTO "instructions" VALUES('ARM','SABA','      Signed absolute difference and accumulate       (C7.3.198)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4             0
           0 Q 0 0 1 1 1 0 size 1                  Rm         0 1 1 1 1 1               Rn              Rd
                 U                                                        ac


      Three registers of the same type variant

      SABA <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean accumulate = (ac == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        integer element1;
        integer element2;
        bits(esize) absdiff;

        result = if accumulate then V[d] else Zeros();
        for e = 0 to elements-1
             element1 = Int(Elem[operand1, e, esize], unsigned);
             element2 = Int(Elem[operand2, e, esize], unsigned);
   absdiff = Abs(element1 - element2)<esize-1:0>;
   Elem[result, e, esize] = Elem[result, e, esize] + absdiff;
V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SABAL','       Signed absolute difference and accumulate long       (C7.3.199)




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 0 size 1                   Rm          0 1 0 1 0 0               Rn               Rd
                  U                                                    op


       Three registers, not all the same type variant

       SABAL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         if size == ''11'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean accumulate = (op == ''0'');
         boolean unsigned = (U == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         8H          when size = 00

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when size = 11, Q = x.
<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize)   operand1 = Vpart[n, part];
 bits(datasize)   operand2 = Vpart[m, part];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 bits(2*esize) absdiff;

 result = if accumulate then V[d] else Zeros();
 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     element2 = Int(Elem[operand2, e, esize], unsigned);
     absdiff = Abs(element1 - element2)<2*esize-1:0>;
     Elem[result, e, 2*esize] = Elem[result, e, 2*esize] + absdiff;
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SABAL2','-R:SABAL');
INSERT INTO "instructions" VALUES('ARM','SABD','      Signed absolute difference       (C7.3.200)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4             0
           0 Q 0 0 1 1 1 0 size 1                  Rm         0 1 1 1 0 1               Rn              Rd
                 U                                                        ac


      Three registers of the same type variant

      SABD <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean accumulate = (ac == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        integer element1;
        integer element2;
        bits(esize) absdiff;

        result = if accumulate then V[d] else Zeros();
        for e = 0 to elements-1
             element1 = Int(Elem[operand1, e, esize], unsigned);
             element2 = Int(Elem[operand2, e, esize], unsigned);
   absdiff = Abs(element1 - element2)<esize-1:0>;
   Elem[result, e, esize] = Elem[result, e, esize] + absdiff;
V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SABDL','       Signed absolute difference long       (C7.3.201)




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 0 size 1                   Rm          0 1 1 1 0 0               Rn               Rd
                  U                                                    op


       Three registers, not all the same type variant

       SABDL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         if size == ''11'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean accumulate = (op == ''0'');
         boolean unsigned = (U == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         8H          when size = 00

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when size = 11, Q = x.
<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize)   operand1 = Vpart[n, part];
 bits(datasize)   operand2 = Vpart[m, part];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 bits(2*esize) absdiff;

 result = if accumulate then V[d] else Zeros();
 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     element2 = Int(Elem[operand2, e, esize], unsigned);
     absdiff = Abs(element1 - element2)<2*esize-1:0>;
     Elem[result, e, 2*esize] = Elem[result, e, 2*esize] + absdiff;
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SABDL2','-R:SABDL');
INSERT INTO "instructions" VALUES('ARM','SADALP','      Signed add and accumulate long pairwise       (C7.3.202)




          31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                 5 4             0
           0 Q 0 0 1 1 1 0 size 1 0 0 0 0 0 0 1 1 0 1 0                                 Rn              Rd
                 U                                              op


      Vector variant

      SADALP <Vd>.<Ta>, <Vn>.<Tb>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);

        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV (2*esize);
        boolean acc = (op == ''1'');
        boolean unsigned = (U == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <Ta>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        4H          when size = 00, Q = 0

                        8H          when size = 00, Q = 1

                        2S          when size = 01, Q = 0

                        4S          when size = 01, Q = 1

                        1D          when size = 10, Q = 0

                        2D          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

      <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand = V[n];
        bits(datasize) result;

bits(2*esize) sum;
integer op1;
integer op2;

result = if acc then V[d] else Zeros();
for e = 0 to elements-1
    op1 = Int(Elem[operand, 2*e+0, esize], unsigned);
    op2 = Int(Elem[operand, 2*e+1, esize], unsigned);
    sum = (op1 + op2)<2*esize-1:0>;
    Elem[result, e, 2*esize] = Elem[result, e, 2*esize] + sum;

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SADDL','       Signed add long (vector)       (C7.3.203)




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 0 size 1                   Rm          0 0 0 0 0 0               Rn               Rd
                  U                                                    o1


       Three registers, not all the same type variant

       SADDL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Tb>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         if size == ''11'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean sub_op = (o1 == ''1'');
         boolean unsigned = (U == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         8H          when size = 00

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when size = 11, Q = x.
<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize)   operand1 = Vpart[n, part];
 bits(datasize)   operand2 = Vpart[m, part];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 integer sum;

 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     element2 = Int(Elem[operand2, e, esize], unsigned);
     if sub_op then
         sum = element1 - element2;
     else
         sum = element1 + element2;
     Elem[result, e, 2*esize] = sum<2*esize-1:0>;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SADDL2','-R:SADDL');
INSERT INTO "instructions" VALUES('ARM','SADDLP','      Signed add long pairwise       (C7.3.204)




          31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                 5 4             0
           0 Q 0 0 1 1 1 0 size 1 0 0 0 0 0 0 0 1 0 1 0                                 Rn              Rd
                 U                                              op


      Vector variant

      SADDLP <Vd>.<Ta>, <Vn>.<Tb>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);

        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV (2*esize);
        boolean acc = (op == ''1'');
        boolean unsigned = (U == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <Ta>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        4H          when size = 00, Q = 0

                        8H          when size = 00, Q = 1

                        2S          when size = 01, Q = 0

                        4S          when size = 01, Q = 1

                        1D          when size = 10, Q = 0

                        2D          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

      <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand = V[n];
        bits(datasize) result;

bits(2*esize) sum;
integer op1;
integer op2;

result = if acc then V[d] else Zeros();
for e = 0 to elements-1
    op1 = Int(Elem[operand, 2*e+0, esize], unsigned);
    op2 = Int(Elem[operand, 2*e+1, esize], unsigned);
    sum = (op1 + op2)<2*esize-1:0>;
    Elem[result, e, 2*esize] = Elem[result, e, 2*esize] + sum;

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SADDLV','      Signed add long across vector       (C7.3.205)




          31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4            0
           0 Q 0 0 1 1 1 0 size 1 1 0 0 0 0 0 0 1 1 1 0                                  Rn               Rd
                 U


      Advanced SIMD variant

      SADDLV <V><d>, <Vn>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);

        if size:Q == ''100'' then ReservedValue();
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');


      Assembler symbols

      <V>               Is the destination width specifier, encoded in the "size" field. It can have the following values:

                        H           when size = 00

                        S           when size = 01

                        D           when size = 10

                        It is RESERVED when size = 11.

      <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

      <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        4S          when size = 10, Q = 1

                        It is RESERVED when:

                        .      size = 10, Q = 0.

                        .      size = 11, Q = x.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand = V[n];
        integer sum;

        sum = Int(Elem[operand, 0, esize], unsigned);
for e = 1 to elements-1
    sum = sum + Int(Elem[operand, e, esize], unsigned);

V[d] = sum<2*esize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','SADDW','       Signed add wide       (C7.3.206)




           31 30 29 28 27 26 25 24 23 22 21 20              16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 0 size 1                   Rm          0 0 0 1 0 0               Rn               Rd
                  U                                                    o1


       Three registers, not all the same type variant

       SADDW{2} <Vd>.<Ta>, <Vn>.<Ta>, <Vm>.<Tb>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);

         if size == ''11'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean sub_op = (o1 == ''1'');
         boolean unsigned = (U == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         8H          when size = 00

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         8B          when size = 00, Q = 0

                         16B         when size = 00, Q = 1

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1
              It is RESERVED when size = 11, Q = x.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(2*datasize) operand1 = V[n];
 bits(datasize)   operand2 = Vpart[m, part];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 integer sum;

 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, 2*esize], unsigned);
     element2 = Int(Elem[operand2, e, esize], unsigned);
     if sub_op then
         sum = element1 - element2;
     else
         sum = element1 + element2;
     Elem[result, e, 2*esize] = sum<2*esize-1:0>;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SADDW2','-R:SADDW');
INSERT INTO "instructions" VALUES('ARM','SCVTF','       Signed fixed-point convert to floating-point (vector)       (C7.3.207)


       Scalar


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 1 0 1 1 1 1 1 0              !=0000     immb      1 1 1 0 0 1             Rn             Rd
                  U                         immh


       Scalar variant

       SCVTF <V><d>, <V><n>, #<fbits>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''00xx'' then ReservedValue();
         integer esize = 32 << UInt(immh<3>);
         integer datasize = esize;
         integer elements = 1;

         integer fracbits = (esize * 2) - UInt(immh:immb);
         boolean unsigned = (U == ''1'');
         FPRounding rounding = FPRoundingMode(FPCR);


       Vector


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 Q 0 0 1 1 1 1 0              !=0000     immb      1 1 1 0 0 1             Rn             Rd
                  U                         immh


       Vector variant

       SCVTF <Vd>.<T>, <Vn>.<T>, #<fbits>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''0000'' then SEE "Advanced SIMD modified immediate";
         if immh == ''00xx'' then ReservedValue();
         if immh<3>:Q == ''10'' then ReservedValue();
         integer esize = 32 << UInt(immh<3>);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         integer fracbits = (esize * 2) - UInt(immh:immb);
         boolean unsigned = (U == ''1'');
         FPRounding rounding = FPRoundingMode(FPCR);


       Assembler symbols

       <V>               Is a width specifier, encoded in the "immh" field. It can have the following values:

                         S           when immh = 01xx

                         D           when immh = 1xxx
              It is RESERVED when immh = 00xx.

<d>           Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "immh:Q" field. It can have the following values:

              2S          when immh = 01xx, Q = 0

              4S          when immh = 01xx, Q = 1

              2D          when immh = 1xxx, Q = 1

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000, Q = x.

              It is RESERVED when:

              .      immh = 0001, Q = x.

              .      immh = 001x, Q = x.

              .      immh = 1xxx, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<fbits>       For the scalar variant: is the number of fractional bits, in the range 1 to the operand width, encoded
              in the "immh:immb" field. It can have the following values:

              (64-UInt(immh:immb))when immh = 01xx

              (128-UInt(immh:immb))when immh = 1xxx

              It is RESERVED when immh = 00xx.

              For the vector variant: is the number of fractional bits, in the range 1 to the element width, encoded
              in the "immh:immb" field. It can have the following values:

              (64-UInt(immh:immb))when immh = 01xx

              (128-UInt(immh:immb))when immh = 1xxx

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000.

              It is RESERVED when:

              .      immh = 0001.

              .      immh = 001x.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand  = V[n];
 bits(datasize) result;
 bits(esize) element;

 for e = 0 to elements-1
     element = Elem[operand, e, esize];
     Elem[result, e, esize] = FixedToFP(element, fracbits, unsigned, FPCR, rounding);

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHA1C','SHA1 hash update (choose)       (C7.3.211)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9           5 4             0
     0 1 0 1 1 1 1 0 0 0 0                   Rm         0 0 0 0 0 0          Rn              Rd




Advanced SIMD variant

SHA1C <Qd>, <Sn>, <Vm>.4S


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Qd>              Is the 128-bit name of the SIMD&FP source and destination, encoded in the "Rd" field.

<Sn>              Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rn" field.

<Vm>              Is the name of the third SIMD&FP source register, encoded in the "Rm" field.


Operation

  CheckCryptoEnabled64();

  bits(128) X = V[d];
  bits(32)    Y = V[n];      // Note: 32 not 128 bits wide
  bits(128) W = V[m];
  bits(32)    t;

  for e = 0 to 3
       t = SHAchoose(X<63:32>, X<95:64>, X<127:96>);
       Y = Y + ROL(X<31:0>, 5) + t + Elem[W, e, 32];
       X<63:32> = ROL(X<63:32>, 30);
       <Y, X> = ROL(Y : X, 32);
  V[d] = X;');
INSERT INTO "instructions" VALUES('ARM','SHA1H','SHA1 fixed rotate       (C7.3.212)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                5 4          0
  0 1 0 1 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 0 1 0                                Rn             Rd




Advanced SIMD variant

SHA1H <Sd>, <Sn>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Sd>          Is the 32-bit name of the SIMD&FP destination register, encoded in the "Rd" field.

<Sn>          Is the 32-bit name of the SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckCryptoEnabled64();

 bits(32) operand = V[n];        // read element [0] only,    [1-3] zeroed
 V[d] = ROL(operand, 30);');
INSERT INTO "instructions" VALUES('ARM','SHA1M','SHA1 hash update (majority)       (C7.3.213)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9           5 4             0
     0 1 0 1 1 1 1 0 0 0 0                   Rm         0 0 1 0 0 0          Rn              Rd




Advanced SIMD variant

SHA1M <Qd>, <Sn>, <Vm>.4S


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Qd>              Is the 128-bit name of the SIMD&FP source and destination, encoded in the "Rd" field.

<Sn>              Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rn" field.

<Vm>              Is the name of the third SIMD&FP source register, encoded in the "Rm" field.


Operation

  CheckCryptoEnabled64();

  bits(128) X = V[d];
  bits(32)    Y = V[n];      // Note: 32 not 128 bits wide
  bits(128) W = V[m];
  bits(32)    t;

  for e = 0 to 3
       t = SHAmajority(X<63:32>, X<95:64>, X<127:96>);
       Y = Y + ROL(X<31:0>, 5) + t + Elem[W, e, 32];
       X<63:32> = ROL(X<63:32>, 30);
       <Y, X> = ROL(Y : X, 32);
  V[d] = X;');
INSERT INTO "instructions" VALUES('ARM','SHA1P','SHA1 hash update (parity)       (C7.3.214)




  31 30 29 28 27 26 25 24 23 22 21 20          16 15 14 13 12 11 10 9                 5 4          0
  0 1 0 1 1 1 1 0 0 0 0                  Rm         0 0 0 1 0 0               Rn             Rd




Advanced SIMD variant

SHA1P <Qd>, <Sn>, <Vm>.4S


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Qd>          Is the 128-bit name of the SIMD&FP source and destination, encoded in the "Rd" field.

<Sn>          Is the 32-bit name of the second SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the third SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckCryptoEnabled64();

 bits(128) X = V[d];
 bits(32)  Y = V[n];     // Note: 32 not 128 bits wide
 bits(128) W = V[m];
 bits(32)  t;

 for e = 0 to 3
     t = SHAparity(X<63:32>, X<95:64>, X<127:96>);
     Y = Y + ROL(X<31:0>, 5) + t + Elem[W, e, 32];
     X<63:32> = ROL(X<63:32>, 30);
     <Y, X> = ROL(Y : X, 32);
 V[d] = X;');
INSERT INTO "instructions" VALUES('ARM','SHA1SU0','SHA1 schedule update 0       (C7.3.215)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9           5 4             0
     0 1 0 1 1 1 1 0 0 0 0                   Rm         0 0 1 1 0 0           Rn             Rd




Advanced SIMD variant

SHA1SU0 <Vd>.4S, <Vn>.4S, <Vm>.4S


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Vd>              Is the name of the SIMD&FP source and destination register, encoded in the "Rd" field.

<Vn>              Is the name of the second SIMD&FP source register, encoded in the "Rn" field.

<Vm>              Is the name of the third SIMD&FP source register, encoded in the "Rm" field.


Operation

  CheckCryptoEnabled64();

  bits(128) operand1 = V[d];
  bits(128) operand2 = V[n];
  bits(128) operand3 = V[m];
  bits(128) result;

  result = operand2<63:0> : operand1<127:64>;
  result = result EOR operand1 EOR operand3;
  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHA1SU1','SHA1 schedule update 1       (C7.3.216)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                5 4          0
  0 1 0 1 1 1 1 0 0 0 1 0 1 0 0 0 0 0 0 1 1 0                                Rn             Rd




Advanced SIMD variant

SHA1SU1 <Vd>.4S, <Vn>.4S


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Vd>          Is the name of the SIMD&FP source and destination register, encoded in the "Rd" field.

<Vn>          Is the name of the second SIMD&FP source register, encoded in the "Rn" field.


Operation

 CheckCryptoEnabled64();

 bits(128) operand1 = V[d];
 bits(128) operand2 = V[n];
 bits(128) result;
 bits(128) T = operand1 EOR LSR(operand2, 32);
 result<31:0>   = ROL(T<31:0>,    1);
 result<63:32>  = ROL(T<63:32>,   1);
 result<95:64>  = ROL(T<95:64>,   1);
 result<127:96> = ROL(T<127:96>, 1) EOR ROL(T<31:0>, 2);
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHA256H2','SHA256 hash update (part 2)       (C7.3.217)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9           5 4             0
     0 1 0 1 1 1 1 0 0 0 0                   Rm         0 1 0 1 0 0          Rn              Rd
                                                                P


Advanced SIMD variant

SHA256H2 <Qd>, <Qn>, <Vm>.4S


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  if ! HaveCryptoExt() then UnallocatedEncoding();
  boolean part1 = (P == ''0'');


Assembler symbols

<Qd>              Is the 128-bit name of the SIMD&FP source and destination, encoded in the "Rd" field.

<Qn>              Is the 128-bit name of the second SIMD&FP source register, encoded in the "Rn" field.

<Vm>              Is the name of the third SIMD&FP source register, encoded in the "Rm" field.


Operation

  CheckCryptoEnabled64();

  bits(128) result;
  if part1 then
       result = SHA256hash(V[d], V[n], V[m], TRUE);
  else
       result = SHA256hash(V[n], V[d], V[m], FALSE);
  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHA256H','SHA256 hash update (part 1)       (C7.3.218)




  31 30 29 28 27 26 25 24 23 22 21 20          16 15 14 13 12 11 10 9                 5 4          0
  0 1 0 1 1 1 1 0 0 0 0                  Rm         0 1 0 0 0 0               Rn             Rd
                                                            P


Advanced SIMD variant

SHA256H <Qd>, <Qn>, <Vm>.4S


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if ! HaveCryptoExt() then UnallocatedEncoding();
 boolean part1 = (P == ''0'');


Assembler symbols

<Qd>          Is the 128-bit name of the SIMD&FP source and destination, encoded in the "Rd" field.

<Qn>          Is the 128-bit name of the second SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the third SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckCryptoEnabled64();

 bits(128) result;
 if part1 then
     result = SHA256hash(V[d], V[n], V[m], TRUE);
 else
     result = SHA256hash(V[n], V[d], V[m], FALSE);
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHA256SU0','SHA256 schedule update 0       (C7.3.219)




    31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9             5 4             0
     0 1 0 1 1 1 1 0 0 0 1 0 1 0 0 0 0 0 1 0 1 0                              Rn             Rd




Advanced SIMD variant

SHA256SU0 <Vd>.4S, <Vn>.4S


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Vd>              Is the name of the SIMD&FP source and destination register, encoded in the "Rd" field.

<Vn>              Is the name of the second SIMD&FP source register, encoded in the "Rn" field.


Operation

  CheckCryptoEnabled64();

  bits(128) operand1 = V[d];
  bits(128) operand2 = V[n];
  bits(128) result;
  bits(128) T = operand2<31:0> : operand1<127:32>;
  bits(32) elt;

  for e = 0 to 3
       elt = Elem[T, e, 32];
       elt = ROR(elt, 7) EOR ROR(elt, 18) EOR LSR(elt, 3);
       Elem[result, e, 32] = elt + Elem[operand1, e, 32];
  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHA256SU1','SHA256 schedule update 1       (C7.3.220)




  31 30 29 28 27 26 25 24 23 22 21 20          16 15 14 13 12 11 10 9                5 4          0
  0 1 0 1 1 1 1 0 0 0 0                  Rm         0 1 1 0 0 0              Rn             Rd




Advanced SIMD variant

SHA256SU1 <Vd>.4S, <Vn>.4S, <Vm>.4S


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if ! HaveCryptoExt() then UnallocatedEncoding();


Assembler symbols

<Vd>          Is the name of the SIMD&FP source and destination register, encoded in the "Rd" field.

<Vn>          Is the name of the second SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the third SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckCryptoEnabled64();

 bits(128) operand1 = V[d];
 bits(128) operand2 = V[n];
 bits(128) operand3 = V[m];
 bits(128) result;
 bits(128) T0 = operand3<31:0> : operand2<127:32>;
 bits(64) T1;
 bits(32) elt;

 T1 = operand3<127:64>;
 for e = 0 to 1
     elt = Elem[T1, e, 32];
     elt = ROR(elt, 17) EOR ROR(elt, 19) EOR LSR(elt, 10);
     elt = elt + Elem[operand1, e, 32] + Elem[T0, e, 32];
     Elem[result, e, 32] = elt;

 T1 = result<63:0>;
 for e = 2 to 3
     elt = Elem[T1, e - 2, 32];
     elt = ROR(elt, 17) EOR ROR(elt, 19) EOR LSR(elt, 10);
     elt = elt + Elem[operand1, e, 32] + Elem[T0, e, 32];
     Elem[result, e, 32] = elt;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHADD','Signed halving add       (C7.3.221)




    31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4             0
     0 Q 0 0 1 1 1 0 size 1                  Rm         0 0 0 0 0 1               Rn              Rd
           U


Three registers of the same type variant

SHADD <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

  integer d = UInt(Rd);
  integer n = UInt(Rn);
  integer m = UInt(Rm);
  if size == ''11'' then ReservedValue();
  integer esize = 8 << UInt(size);
  integer datasize = if Q == ''1'' then 128 else 64;
  integer elements = datasize DIV esize;
  boolean unsigned = (U == ''1'');


Assembler symbols

<Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                  8B          when size = 00, Q = 0

                  16B         when size = 00, Q = 1

                  4H          when size = 01, Q = 0

                  8H          when size = 01, Q = 1

                  2S          when size = 10, Q = 0

                  4S          when size = 10, Q = 1

                  It is RESERVED when size = 11, Q = x.

<Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

  CheckFPAdvSIMDEnabled64();
  bits(datasize) operand1 = V[n];
  bits(datasize) operand2 = V[m];
  bits(datasize) result;
  integer element1;
  integer element2;
  integer sum;

  for e = 0 to elements-1
       element1 = Int(Elem[operand1, e, esize], unsigned);
       element2 = Int(Elem[operand2, e, esize], unsigned);
       sum = element1 + element2;
       Elem[result, e, esize] = sum<esize:1>;

  V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHL','Shift left (immediate)       (C7.3.222)


Scalar


  31 30 29 28 27 26 25 24 23 22         19 18    16 15 14 13 12 11 10 9                5 4          0
  0 1 0 1 1 1 1 1 0              !=0000     immb      0 1 0 1 0 1              Rn             Rd
                                  immh


Scalar variant

SHL <V><d>, <V><n>, #<shift>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if immh<3> != ''1'' then ReservedValue();
 integer esize = 8 << 3;
 integer datasize = esize;
 integer elements = 1;

 integer shift = UInt(immh:immb) - esize;


Vector


  31 30 29 28 27 26 25 24 23 22         19 18    16 15 14 13 12 11 10 9                5 4          0
  0 Q 0 0 1 1 1 1 0              !=0000     immb      0 1 0 1 0 1              Rn             Rd
                                  immh


Vector variant

SHL <Vd>.<T>, <Vn>.<T>, #<shift>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if immh == ''0000'' then SEE "Advanced SIMD modified immediate";
 if immh<3>:Q == ''10'' then ReservedValue();
 integer esize = 8 << HighestSetBit(immh);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 integer shift = UInt(immh:immb) - esize;


Assembler symbols

<V>            Is a width specifier, encoded in the "immh" field. It can have the following values:

               D           when immh = 1xxx

               It is RESERVED when immh = 0xxx.

<d>            Is the number of the SIMD&FP destination register, in the "Rd" field.

<n>            Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
       <T>               Is an arrangement specifier, encoded in the "immh:Q" field. It can have the following values:

                         8B           when immh = 0001, Q = 0

                         16B          when immh = 0001, Q = 1

                         4H           when immh = 001x, Q = 0

                         8H           when immh = 001x, Q = 1

                         2S           when immh = 01xx, Q = 0

                         4S           when immh = 01xx, Q = 1

                         2D           when immh = 1xxx, Q = 1

                         See Advanced SIMD modified immediate on page C4-213 when immh = 0000, Q = x.

                         It is RESERVED when immh = 1xxx, Q = 0.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

       <shift>           For the scalar variant: is the left shift amount, in the range 0 to 63, encoded in the "immh:immb"
                         field. It can have the following values:

                         (UInt(immh:immb)-64)when immh = 1xxx

                         It is RESERVED when immh = 0xxx.

                         For the vector variant: is the left shift amount, in the range 0 to the element width in bits minus 1,
                         encoded in the "immh:immb" field. It can have the following values:

                         (UInt(immh:immb)-8)when immh = 0001

                         (UInt(immh:immb)-16)when immh = 001x

                         (UInt(immh:immb)-32)when immh = 01xx

                         (UInt(immh:immb)-64)when immh = 1xxx

                         See Advanced SIMD modified immediate on page C4-213 when immh = 0000.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand      = V[n];
         bits(datasize) result;

         for e = 0 to elements-1
              Elem[result, e, esize] = LSL(Elem[operand, e, esize], shift);

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHLL','Shift left long (by element size)       (C7.3.223)




  31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                     5 4             0
  0 Q 1 0 1 1 1 0 size 1 0 0 0 0 1 0 0 1 1 1 0                                     Rn               Rd




Vector variant

SHLL{2} <Vd>.<Ta>, <Vn>.<Tb>, #<shift>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if size == ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = 64;
 integer part = UInt(Q);
 integer elements = datasize DIV esize;

 integer shift = esize;
 boolean unsigned = FALSE; // Or TRUE without change of functionality


Assembler symbols

2                Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                 64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                 the following values:

                 [absent]    when Q = 0

                 [present]   when Q = 1

<Vd>             Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Ta>             Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                 8H          when size = 00

                 4S          when size = 01

                 2D          when size = 10

                 It is RESERVED when size = 11.

<Vn>             Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<Tb>             Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                 8B          when size = 00, Q = 0

                 16B         when size = 00, Q = 1

                 4H          when size = 01, Q = 0

                 8H          when size = 01, Q = 1

                 2S          when size = 10, Q = 0

                 4S          when size = 10, Q = 1

                 It is RESERVED when size = 11, Q = x.
       <shift>           Is the left shift amount, which must be equal to the source element width in bits, encoded in the
                         "size" field. It can have the following values:

                         8            when size = 00

                         16           when size = 01

                         32           when size = 10

                         It is RESERVED when size = 11.


       Operation

         CheckFPAdvSIMDEnabled64();
         bits(datasize) operand = Vpart[n, part];
         bits(2*datasize) result;
         integer element;

         for e = 0 to elements-1
              element = Int(Elem[operand, e, esize], unsigned) << shift;
              Elem[result, e, 2*esize] = element<2*esize-1:0>;

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SHLL2','-R:SHLL');
INSERT INTO "instructions" VALUES('ARM','SHRN','Shift right narrow (immediate)       (C7.3.224)




  31 30 29 28 27 26 25 24 23 22           19 18    16 15 14 13 12 11 10 9                5 4             0
  0 Q 0 0 1 1 1 1 0               !=0000      immb      1 0 0 0 0 1               Rn               Rd
                                   immh                               op


Vector variant

SHRN{2} <Vd>.<Tb>, <Vn>.<Ta>, #<shift>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);

 if immh == ''0000'' then SEE "Advanced SIMD modified immediate";
 if immh<3> == ''1'' then ReservedValue();
 integer esize = 8 << HighestSetBit(immh);
 integer datasize = 64;
 integer part = UInt(Q);
 integer elements = datasize DIV esize;

 integer shift = (2 * esize) - UInt(immh:immb);
 boolean round = (op == ''1'');


Assembler symbols

2               Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                the following values:

                [absent]    when Q = 0

                [present]   when Q = 1

<Vd>            Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Tb>            Is an arrangement specifier, encoded in the "immh:Q" field. It can have the following values:

                8B          when immh = 0001, Q = 0

                16B         when immh = 0001, Q = 1

                4H          when immh = 001x, Q = 0

                8H          when immh = 001x, Q = 1

                2S          when immh = 01xx, Q = 0

                4S          when immh = 01xx, Q = 1

                See Advanced SIMD modified immediate on page C4-213 when immh = 0000, Q = x.

                It is RESERVED when immh = 1xxx, Q = x.

<Vn>            Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<Ta>            Is an arrangement specifier, encoded in the "immh" field. It can have the following values:

                8H          when immh = 0001

                4S          when immh = 001x

                2D          when immh = 01xx

                See Advanced SIMD modified immediate on page C4-213 when immh = 0000.
                         It is RESERVED when immh = 1xxx.

       <shift>           Is the right shift amount, in the range 1 to the destination element width in bits, encoded in the
                         "immh:immb" field. It can have the following values:

                         (16-UInt(immh:immb))when immh = 0001

                         (32-UInt(immh:immb))when immh = 001x

                         (64-UInt(immh:immb))when immh = 01xx

                         See Advanced SIMD modified immediate on page C4-213 when immh = 0000.

                         It is RESERVED when immh = 1xxx.


       Operation

         CheckFPAdvSIMDEnabled64();
         bits(datasize*2) operand = V[n];
         bits(datasize) result;
         integer round_const = if round then (1 << (shift - 1)) else 0;
         integer element;

         for e = 0 to elements-1
              element = (UInt(Elem[operand, e, 2*esize]) + round_const) >> shift;
              Elem[result, e, esize] = element<esize-1:0>;

         Vpart[d, part] = result;');
INSERT INTO "instructions" VALUES('ARM','SHRN2','-R:SHRN');
INSERT INTO "instructions" VALUES('ARM','SHSUB','Signed halving subtract       (C7.3.225)




  31 30 29 28 27 26 25 24 23 22 21 20           16 15 14 13 12 11 10 9                 5 4           0
  0 Q 0 0 1 1 1 0 size 1                  Rm         0 0 1 0 0 1               Rn              Rd
        U


Three registers of the same type variant

SHSUB <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


Decode for this encoding

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rm);
 if size == ''11'' then ReservedValue();
 integer esize = 8 << UInt(size);
 integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;
 boolean unsigned = (U == ''1'');


Assembler symbols

<Vd>           Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>            Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

               8B          when size = 00, Q = 0

               16B         when size = 00, Q = 1

               4H          when size = 01, Q = 0

               8H          when size = 01, Q = 1

               2S          when size = 10, Q = 0

               4S          when size = 10, Q = 1

               It is RESERVED when size = 11, Q = x.

<Vn>           Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>           Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];
 bits(datasize) result;
 integer element1;
 integer element2;
 integer diff;

 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     element2 = Int(Elem[operand2, e, esize], unsigned);
     diff = element1 - element2;
     Elem[result, e, esize] = diff<esize:1>;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SLI','       Shift left and insert (immediate)       (C7.3.226)


       Scalar


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 1 1 1 1 1 1 1 0              !=0000     immb      0 1 0 1 0 1             Rn             Rd
                                            immh


       Scalar variant

       SLI <V><d>, <V><n>, #<shift>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh<3> != ''1'' then ReservedValue();
         integer esize = 8 << 3;
         integer datasize = esize;
         integer elements = 1;

         integer shift = UInt(immh:immb) - esize;


       Vector


           31 30 29 28 27 26 25 24 23 22          19 18    16 15 14 13 12 11 10 9               5 4          0
            0 Q 1 0 1 1 1 1 0              !=0000     immb      0 1 0 1 0 1             Rn             Rd
                                            immh


       Vector variant

       SLI <Vd>.<T>, <Vn>.<T>, #<shift>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if immh == ''0000'' then SEE "Advanced SIMD modified immediate";
         if immh<3>:Q == ''10'' then ReservedValue();
         integer esize = 8 << HighestSetBit(immh);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         integer shift = UInt(immh:immb) - esize;


       Assembler symbols

       <V>               Is a width specifier, encoded in the "immh" field. It can have the following values:

                         D           when immh = 1xxx

                         It is RESERVED when immh = 0xxx.

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.
<T>           Is an arrangement specifier, encoded in the "immh:Q" field. It can have the following values:

              8B           when immh = 0001, Q = 0

              16B          when immh = 0001, Q = 1

              4H           when immh = 001x, Q = 0

              8H           when immh = 001x, Q = 1

              2S           when immh = 01xx, Q = 0

              4S           when immh = 01xx, Q = 1

              2D           when immh = 1xxx, Q = 1

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000, Q = x.

              It is RESERVED when immh = 1xxx, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.

<shift>       For the scalar variant: is the left shift amount, in the range 0 to 63, encoded in the "immh:immb"
              field. It can have the following values:

              (UInt(immh:immb)-64)when immh = 1xxx

              It is RESERVED when immh = 0xxx.

              For the vector variant: is the left shift amount, in the range 0 to the element width in bits minus 1,
              encoded in the "immh:immb" field. It can have the following values:

              (UInt(immh:immb)-8)when immh = 0001

              (UInt(immh:immb)-16)when immh = 001x

              (UInt(immh:immb)-32)when immh = 01xx

              (UInt(immh:immb)-64)when immh = 1xxx

              See Advanced SIMD modified immediate on page C4-213 when immh = 0000.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand   = V[n];
 bits(datasize) operand2 = V[d];
 bits(datasize) result;
 bits(esize) mask = LSL(Ones(esize), shift);
 bits(esize) shifted;

 for e = 0 to elements-1
     shifted = LSL(Elem[operand, e, esize], shift);
     Elem[result, e, esize] = (Elem[operand2, e, esize] AND NOT(mask)) OR shifted;
 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SMAX','      Signed maximum (vector)       (C7.3.227)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4             0
           0 Q 0 0 1 1 1 0 size 1                  Rm         0 1 1 0 0 1               Rn              Rd
                 U                                                        o1


      Three registers of the same type variant

      SMAX <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        integer element1;
        integer element2;
        integer maxmin;

        for e = 0 to elements-1
             element1 = Int(Elem[operand1, e, esize], unsigned);
             element2 = Int(Elem[operand2, e, esize], unsigned);
             maxmin = if minimum then Min(element1, element2) else Max(element1, element2);
   Elem[result, e, esize] = maxmin<esize-1:0>;

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SMAXP','      Signed maximum pairwise       (C7.3.228)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4             0
           0 Q 0 0 1 1 1 0 size 1                  Rm         1 0 1 0 0 1               Rn              Rd
                 U                                                        o1


      Three registers of the same type variant

      SMAXP <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        bits(2*datasize) concat = operand2:operand1;
        integer element1;
        integer element2;
        integer maxmin;

        for e = 0 to elements-1
             element1 = Int(Elem[concat, 2*e, esize], unsigned);
             element2 = Int(Elem[concat, (2*e)+1, esize], unsigned);
             maxmin = if minimum then Min(element1, element2) else Max(element1, element2);
   Elem[result, e, esize] = maxmin<esize-1:0>;

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SMAXV','      Signed maximum across vector       (C7.3.229)




          31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4            0
           0 Q 0 0 1 1 1 0 size 1 1 0 0 0 0 1 0 1 0 1 0                                  Rn               Rd
                 U                                         op


      Advanced SIMD variant

      SMAXV <V><d>, <Vn>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);

        if size:Q == ''100'' then ReservedValue();
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean min = (op == ''1'');


      Assembler symbols

      <V>               Is the destination width specifier, encoded in the "size" field. It can have the following values:

                        B           when size = 00

                        H           when size = 01

                        S           when size = 10

                        It is RESERVED when size = 11.

      <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

      <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        4S          when size = 10, Q = 1

                        It is RESERVED when:

                        .      size = 10, Q = 0.

                        .      size = 11, Q = x.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand = V[n];
        integer maxmin;
        integer element;

maxmin = Int(Elem[operand, 0, esize], unsigned);
for e = 1 to elements-1
    element = Int(Elem[operand, e, esize], unsigned);
    maxmin = if min then Min(maxmin, element) else Max(maxmin, element);

V[d] = maxmin<esize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','SMIN','      Signed minimum (vector)       (C7.3.230)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4             0
           0 Q 0 0 1 1 1 0 size 1                  Rm         0 1 1 0 1 1               Rn              Rd
                 U                                                        o1


      Three registers of the same type variant

      SMIN <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        integer element1;
        integer element2;
        integer maxmin;

        for e = 0 to elements-1
             element1 = Int(Elem[operand1, e, esize], unsigned);
             element2 = Int(Elem[operand2, e, esize], unsigned);
             maxmin = if minimum then Min(element1, element2) else Max(element1, element2);
   Elem[result, e, esize] = maxmin<esize-1:0>;

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SMINP','      Signed minimum pairwise       (C7.3.231)




          31 30 29 28 27 26 25 24 23 22 21 20            16 15 14 13 12 11 10 9               5 4             0
           0 Q 0 0 1 1 1 0 size 1                  Rm         1 0 1 0 1 1               Rn              Rd
                 U                                                        o1


      Three registers of the same type variant

      SMINP <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);
        integer m = UInt(Rm);
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean minimum = (o1 == ''1'');


      Assembler symbols

      <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        2S          when size = 10, Q = 0

                        4S          when size = 10, Q = 1

                        It is RESERVED when size = 11, Q = x.

      <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

      <Vm>              Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand1 = V[n];
        bits(datasize) operand2 = V[m];
        bits(datasize) result;
        bits(2*datasize) concat = operand2:operand1;
        integer element1;
        integer element2;
        integer maxmin;

        for e = 0 to elements-1
             element1 = Int(Elem[concat, 2*e, esize], unsigned);
             element2 = Int(Elem[concat, (2*e)+1, esize], unsigned);
             maxmin = if minimum then Min(element1, element2) else Max(element1, element2);
   Elem[result, e, esize] = maxmin<esize-1:0>;

V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SMINV','      Signed minimum across vector       (C7.3.232)




          31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                    5 4            0
           0 Q 0 0 1 1 1 0 size 1 1 0 0 0 1 1 0 1 0 1 0                                  Rn               Rd
                 U                                         op


      Advanced SIMD variant

      SMINV <V><d>, <Vn>.<T>


      Decode for this encoding

        integer d = UInt(Rd);
        integer n = UInt(Rn);

        if size:Q == ''100'' then ReservedValue();
        if size == ''11'' then ReservedValue();
        integer esize = 8 << UInt(size);
        integer datasize = if Q == ''1'' then 128 else 64;
        integer elements = datasize DIV esize;

        boolean unsigned = (U == ''1'');
        boolean min = (op == ''1'');


      Assembler symbols

      <V>               Is the destination width specifier, encoded in the "size" field. It can have the following values:

                        B           when size = 00

                        H           when size = 01

                        S           when size = 10

                        It is RESERVED when size = 11.

      <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

      <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

      <T>               Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                        8B          when size = 00, Q = 0

                        16B         when size = 00, Q = 1

                        4H          when size = 01, Q = 0

                        8H          when size = 01, Q = 1

                        4S          when size = 10, Q = 1

                        It is RESERVED when:

                        .      size = 10, Q = 0.

                        .      size = 11, Q = x.


      Operation

        CheckFPAdvSIMDEnabled64();
        bits(datasize) operand = V[n];
        integer maxmin;
        integer element;

maxmin = Int(Elem[operand, 0, esize], unsigned);
for e = 1 to elements-1
    element = Int(Elem[operand, e, esize], unsigned);
    maxmin = if min then Min(maxmin, element) else Max(maxmin, element);

V[d] = maxmin<esize-1:0>;');
INSERT INTO "instructions" VALUES('ARM','SMLAL','       Signed multiply-add long (vector, by element)       (C7.3.233)




           31 30 29 28 27 26 25 24 23 22 21 20 19           16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 1 size L M                   Rm        0 0 1 0 H 0               Rn               Rd
                  U                                                 o2


       Vector variant

       SMLAL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);        Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean unsigned = (U == ''1'');
         boolean sub_op = (o2 == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1
              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              It is RESERVED when:

              .      size = 00, Q = x.

              .      size = 11, Q = x.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "size:M:Rm" field. It can have
              the following values:

              0:Rm        when size = 01

              M:Rm        when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

              Restricted to V0-V15 when element size <Ts> is H.

<Ts>          Is an element size specifier, encoded in the "size" field. It can have the following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<index>       Is the element index encoded in the "size:L:H:M" field. It can have the following values:

              H:L:M       when size = 01

              H:L         when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize)   operand1 = Vpart[n, part];
 bits(idxdsize)   operand2 = V[m];
 bits(2*datasize) operand3 = V[d];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 bits(2*esize) product;

 element2 = Int(Elem[operand2, index, esize], unsigned);
 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     product = (element1 * element2)<2*esize-1:0>;
     if sub_op then
         Elem[result, e, 2*esize] = Elem[operand3, e, 2*esize] - product;
     else
         Elem[result, e, 2*esize] = Elem[operand3, e, 2*esize] + product;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SMLAL2','-R:SMLAL');
INSERT INTO "instructions" VALUES('ARM','SMLSL','       Signed multiply-subtract long (vector, by element)       (C7.3.235)




           31 30 29 28 27 26 25 24 23 22 21 20 19           16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 1 size L M                   Rm        0 1 1 0 H 0               Rn               Rd
                  U                                                 o2


       Vector variant

       SMLSL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);        Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean unsigned = (U == ''1'');
         boolean sub_op = (o2 == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1
              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              It is RESERVED when:

              .      size = 00, Q = x.

              .      size = 11, Q = x.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "size:M:Rm" field. It can have
              the following values:

              0:Rm        when size = 01

              M:Rm        when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

              Restricted to V0-V15 when element size <Ts> is H.

<Ts>          Is an element size specifier, encoded in the "size" field. It can have the following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<index>       Is the element index encoded in the "size:L:H:M" field. It can have the following values:

              H:L:M       when size = 01

              H:L         when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize)   operand1 = Vpart[n, part];
 bits(idxdsize)   operand2 = V[m];
 bits(2*datasize) operand3 = V[d];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 bits(2*esize) product;

 element2 = Int(Elem[operand2, index, esize], unsigned);
 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     product = (element1 * element2)<2*esize-1:0>;
     if sub_op then
         Elem[result, e, 2*esize] = Elem[operand3, e, 2*esize] - product;
     else
         Elem[result, e, 2*esize] = Elem[operand3, e, 2*esize] + product;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SMLSL2','-R:SMLSL');
INSERT INTO "instructions" VALUES('ARM','SMOV','       Signed move vector element to general-purpose register       (C7.3.237)




           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9               5 4              0
            0 Q 0 0 1 1 1 0 0 0 0                   imm5        0 0 1 0 1 1              Rn             Rd




       32-bit variant

       Applies when Q = 0.

       SMOV <Wd>, <Vn>.<Ts>[<index>]


       64-bit variant

       Applies when Q = 1.

       SMOV <Xd>, <Vn>.<Ts>[<index>]


       Decode for all variants of this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer size;
         case Q:imm5 of
              when ''xxxxx1'' size = 0;        // SMOV [WX]d, Vn.B
              when ''xxxx10'' size = 1;        // SMOV [WX]d, Vn.H
              when ''1xx100'' size = 2;        // SMOV Xd, Vn.S
              otherwise        UnallocatedEncoding();

         integer idxdsize = if imm5<4> == ''1'' then 128 else 64;
         integer index = UInt(imm5<4:size+1>);
         integer esize = 8 << size;
         integer datasize = if Q == ''1'' then 64 else 32;


       Assembler symbols

       <Wd>              Is the 32-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Xd>              Is the 64-bit name of the general-purpose destination register, encoded in the "Rd" field.

       <Vn>              Is the name of the SIMD&FP source register, encoded in the "Rn" field.

       <Ts>              For the 32-bit variant: is an element size specifier, encoded in the "imm5" field. It can have the
                         following values:

                         B           when imm5 = xxxx1

                         H           when imm5 = xxx10

                         It is RESERVED when imm5 = xxx00.

                         For the 64-bit variant: is an element size specifier, encoded in the "imm5" field. It can have the
                         following values:

                         B           when imm5 = xxxx1

                         H           when imm5 = xxx10

                         S           when imm5 = xx100

                         It is RESERVED when imm5 = xx000.
<index>       For the 32-bit variant: is the element index encoded in the "imm5" field. It can have the following
              values:

              imm5<4:1>  when imm5 = xxxx1

              imm5<4:2>  when imm5 = xxx10

              It is RESERVED when imm5 = xxx00.

              For the 64-bit variant: is the element index encoded in the "imm5" field. It can have the following
              values:

              imm5<4:1>  when imm5 = xxxx1

              imm5<4:2>  when imm5 = xxx10

              imm5<4:3>  when imm5 = xx100

              It is RESERVED when imm5 = xx000.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(idxdsize) operand = V[n];

 X[d] = SignExtend(Elem[operand, index, esize], datasize);');
INSERT INTO "instructions" VALUES('ARM','SMULL2','       Signed multiply long (vector, by element)       (C7.3.238)




           31 30 29 28 27 26 25 24 23 22 21 20 19           16 15 14 13 12 11 10 9                5 4             0
            0 Q 0 0 1 1 1 1 size L M                   Rm        1 0 1 0 H 0               Rn               Rd
                  U


       Vector variant

       SMULL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);        Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
         integer elements = datasize DIV esize;
         boolean unsigned = (U == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1
              It is RESERVED when:

              .      size = 00, Q = x.

              .      size = 11, Q = x.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "size:M:Rm" field. It can have
              the following values:

              0:Rm        when size = 01

              M:Rm        when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

              Restricted to V0-V15 when element size <Ts> is H.

<Ts>          Is an element size specifier, encoded in the "size" field. It can have the following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<index>       Is the element index encoded in the "size:L:H:M" field. It can have the following values:

              H:L:M       when size = 01

              H:L         when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.


Operation

 CheckFPAdvSIMDEnabled64();
 bits(datasize)   operand1 = Vpart[n, part];
 bits(idxdsize)   operand2 = V[m];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 bits(2*esize) product;

 element2 = Int(Elem[operand2, index, esize], unsigned);
 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     product = (element1 * element2)<2*esize-1:0>;
     Elem[result, e, 2*esize] = product;

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SQABS','       Signed saturating absolute value       (C7.3.240)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
            0 1 0 1 1 1 1 0 size 1 0 0 0 0 0 0 1 1 1 1 0                                  Rn             Rd
                  U


       Scalar variant

       SQABS <V><d>, <V><n>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         integer esize = 8 << UInt(size);
         integer datasize = esize;
         integer elements = 1;

         boolean neg = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10 9                   5 4          0
            0 Q 0 0 1 1 1 0 size 1 0 0 0 0 0 0 1 1 1 1 0                                  Rn             Rd
                  U


       Vector variant

       SQABS <Vd>.<T>, <Vn>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);

         if size:Q == ''110'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;

         boolean neg = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "size" field. It can have the following values:

                         B           when size = 00

                         H           when size = 01

                         S           when size = 10

                         D           when size = 11

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <n>               Is the number of the SIMD&FP source register, encoded in the "Rn" field.
<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              4H          when size = 01, Q = 0

              8H          when size = 01, Q = 1

              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              2D          when size = 11, Q = 1

              It is RESERVED when size = 11, Q = 0.

<Vn>          Is the name of the SIMD&FP source register, encoded in the "Rn" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand = V[n];
 bits(datasize) result;
 integer element;
 boolean sat;

 for e = 0 to elements-1
     element = SInt(Elem[operand, e, esize]);
     if neg then
         element = -element;
     else
         element = Abs(element);
     (Elem[result, e, esize], sat) = SignedSatQ(element, esize);
     if sat then FPSR.QC = ''1'';

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SQADD','       Signed saturating add       (C7.3.241)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4          0
            0 1 0 1 1 1 1 0 size 1                   Rm         0 0 0 0 1 1               Rn             Rd
                  U


       Scalar variant

       SQADD <V><d>, <V><n>, <V><m>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         integer esize = 8 << UInt(size);
         integer datasize = esize;
         integer elements = 1;
         boolean unsigned = (U == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20             16 15 14 13 12 11 10 9                5 4          0
            0 Q 0 0 1 1 1 0 size 1                   Rm         0 0 0 0 1 1               Rn             Rd
                  U


       Vector variant

       SQADD <Vd>.<T>, <Vn>.<T>, <Vm>.<T>


       Decode for this encoding

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rm);
         if size:Q == ''110'' then ReservedValue();
         integer esize = 8 << UInt(size);
         integer datasize = if Q == ''1'' then 128 else 64;
         integer elements = datasize DIV esize;
         boolean unsigned = (U == ''1'');


       Assembler symbols

       <V>               Is a width specifier, encoded in the "size" field. It can have the following values:

                         B           when size = 00

                         H           when size = 01

                         S           when size = 10

                         D           when size = 11

       <d>               Is the number of the SIMD&FP destination register, in the "Rd" field.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <m>               Is the number of the second SIMD&FP source register, encoded in the "Rm" field.
<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              8B          when size = 00, Q = 0

              16B         when size = 00, Q = 1

              4H          when size = 01, Q = 0

              8H          when size = 01, Q = 1

              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              2D          when size = 11, Q = 1

              It is RESERVED when size = 11, Q = 0.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "Rm" field.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize) operand1 = V[n];
 bits(datasize) operand2 = V[m];
 bits(datasize) result;
 integer element1;
 integer element2;
 integer sum;
 boolean sat;

 for e = 0 to elements-1
     element1 = Int(Elem[operand1, e, esize], unsigned);
     element2 = Int(Elem[operand2, e, esize], unsigned);
     sum = element1 + element2;
     (Elem[result, e, esize], sat) = SatQ(sum, esize, unsigned);
    if sat then FPSR.QC = ''1'';

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SQDMLAL','       Signed saturating doubling multiply-add long (by element)       (C7.3.242)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 1 0 1 1 1 1 1 size L M                Rm       0 0 1 1 H 0            Rn     Rd
                                                               o2


       Scalar variant

       SQDMLAL <Va><d>, <Vb><n>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);     Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = esize;
         integer elements = 1;
         integer part = 0;

         boolean sub_op = (o2 == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 Q 0 0 1 1 1 1 size L M                Rm       0 0 1 1 H 0            Rn     Rd
                                                               o2


       Vector variant

       SQDMLAL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);     Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = 64;
         integer part = UInt(Q);
 integer elements = datasize DIV esize;

 boolean sub_op = (o2 == ''1'');


Assembler symbols

2             Is the second and upper half specifier. If present it causes the operation to be performed on the upper
              64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
              the following values:

              [absent]    when Q = 0

              [present]   when Q = 1

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<Ta>          Is an arrangement specifier, encoded in the "size" field. It can have the following values:

              4S          when size = 01

              2D          when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<Vn>          Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

<Tb>          Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              4H          when size = 01, Q = 0

              8H          when size = 01, Q = 1

              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              It is RESERVED when:

              .      size = 00, Q = x.

              .      size = 11, Q = x.

<Va>          Is the destination width specifier, encoded in the "size" field. It can have the following values:

              S           when size = 01

              D           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<d>           Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<Vb>          Is the source width specifier, encoded in the "size" field. It can have the following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vm>          Is the name of the second SIMD&FP source register, encoded in the "size:M:Rm" field. It can have
              the following values:

              0:Rm        when size = 01
                         M:Rm        when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

                         Restricted to V0-V15 when element size <Ts> is H.

       <Ts>              For the scalar variant: is the element width specifier, encoded in the "size" field. It can have the
                         following values:

                         H           when size = 01

                         S           when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

                         For the vector variant: is an element size specifier, encoded in the "size" field. It can have the
                         following values:

                         H           when size = 01

                         S           when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

       <index>           For the scalar variant: is the element index, encoded in the "size:L:H:M" field. It can have the
                         following values:

                         H:L:M       when size = 01

                         H:L         when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

                         For the vector variant: is the element index encoded in the "size:L:H:M" field. It can have the
                         following values:

                         H:L:M       when size = 01

                         H:L         when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.


       Operation for all encodings

         CheckFPAdvSIMDEnabled64();
         bits(datasize)      operand1 = Vpart[n, part];
         bits(idxdsize)      operand2 = V[m];
         bits(2*datasize) operand3 = V[d];
         bits(2*datasize) result;
         integer element1;
         integer element2;
         bits(2*esize) product;
         integer accum;
         boolean sat1;
         boolean sat2;

         element2 = SInt(Elem[operand2, index, esize]);
         for e = 0 to elements-1
    element1 = SInt(Elem[operand1, e, esize]);
    (product, sat1) = SignedSatQ(2 * element1 * element2, 2*esize);
    if sub_op then
        accum = SInt(Elem[operand3, e, 2*esize]) - SInt(product);
    else
        accum = SInt(Elem[operand3, e, 2*esize]) + SInt(product);
    (Elem[result, e, 2*esize], sat2) = SignedSatQ(accum, 2*esize);
    if sat1 || sat2 then FPSR.QC = ''1'';

 V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SQDMLAL2','-R:SQDMLAL');
INSERT INTO "instructions" VALUES('ARM','SQDMLSL','Signed saturating doubling multiply-subtract long (by element)       (C7.3.244)


Scalar


  31 30 29 28 27 26 25 24 23 22 21 20 19        16 15 14 13 12 11 10 9                 5 4          0
  0 1 0 1 1 1 1 1 size L M                 Rm       0 1 1 1 H 0                Rn             Rd
                                                       o2


Scalar variant

SQDMLSL <Va><d>, <Vb><n>, <Vm>.<Ts>[<index>]


Decode for this encoding

 integer idxdsize = if H == ''1'' then 128 else 64;
 integer index;
 bit Rmhi;
 case size of
     when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
     when ''10'' index = UInt(H:L);    Rmhi = M;
     otherwise UnallocatedEncoding();

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rmhi:Rm);

 integer esize = 8 << UInt(size);
 integer datasize = esize;
 integer elements = 1;
 integer part = 0;

 boolean sub_op = (o2 == ''1'');


Vector


  31 30 29 28 27 26 25 24 23 22 21 20 19        16 15 14 13 12 11 10 9                 5 4          0
  0 Q 0 0 1 1 1 1 size L M                 Rm       0 1 1 1 H 0                Rn             Rd
                                                       o2


Vector variant

SQDMLSL{2} <Vd>.<Ta>, <Vn>.<Tb>, <Vm>.<Ts>[<index>]


Decode for this encoding

 integer idxdsize = if H == ''1'' then 128 else 64;
 integer index;
 bit Rmhi;
 case size of
     when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
     when ''10'' index = UInt(H:L);    Rmhi = M;
     otherwise UnallocatedEncoding();

 integer d = UInt(Rd);
 integer n = UInt(Rn);
 integer m = UInt(Rmhi:Rm);

 integer esize = 8 << UInt(size);
 integer datasize = 64;
 integer part = UInt(Q);
         integer elements = datasize DIV esize;

         boolean sub_op = (o2 == ''1'');


       Assembler symbols

       2                 Is the second and upper half specifier. If present it causes the operation to be performed on the upper
                         64 bits of the registers holding the narrower elements, and is encoded in the "Q" field. It can have
                         the following values:

                         [absent]    when Q = 0

                         [present]   when Q = 1

       <Vd>              Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

       <Ta>              Is an arrangement specifier, encoded in the "size" field. It can have the following values:

                         4S          when size = 01

                         2D          when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

       <Vn>              Is the name of the first SIMD&FP source register, encoded in the "Rn" field.

       <Tb>              Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

                         4H          when size = 01, Q = 0

                         8H          when size = 01, Q = 1

                         2S          when size = 10, Q = 0

                         4S          when size = 10, Q = 1

                         It is RESERVED when:

                         .      size = 00, Q = x.

                         .      size = 11, Q = x.

       <Va>              Is the destination width specifier, encoded in the "size" field. It can have the following values:

                         S           when size = 01

                         D           when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

       <d>               Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

       <Vb>              Is the source width specifier, encoded in the "size" field. It can have the following values:

                         H           when size = 01

                         S           when size = 10

                         It is RESERVED when:

                         .      size = 00.

                         .      size = 11.

       <n>               Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

       <Vm>              Is the name of the second SIMD&FP source register, encoded in the "size:M:Rm" field. It can have
                         the following values:

                         0:Rm        when size = 01
              M:Rm        when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

              Restricted to V0-V15 when element size <Ts> is H.

<Ts>          For the scalar variant: is the element width specifier, encoded in the "size" field. It can have the
              following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

              For the vector variant: is an element size specifier, encoded in the "size" field. It can have the
              following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<index>       For the scalar variant: is the element index, encoded in the "size:L:H:M" field. It can have the
              following values:

              H:L:M       when size = 01

              H:L         when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

              For the vector variant: is the element index encoded in the "size:L:H:M" field. It can have the
              following values:

              H:L:M       when size = 01

              H:L         when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.


Operation for all encodings

 CheckFPAdvSIMDEnabled64();
 bits(datasize)   operand1 = Vpart[n, part];
 bits(idxdsize)   operand2 = V[m];
 bits(2*datasize) operand3 = V[d];
 bits(2*datasize) result;
 integer element1;
 integer element2;
 bits(2*esize) product;
 integer accum;
 boolean sat1;
 boolean sat2;

 element2 = SInt(Elem[operand2, index, esize]);
 for e = 0 to elements-1
              element1 = SInt(Elem[operand1, e, esize]);
              (product, sat1) = SignedSatQ(2 * element1 * element2, 2*esize);
              if sub_op then
                   accum = SInt(Elem[operand3, e, 2*esize]) - SInt(product);
              else
                   accum = SInt(Elem[operand3, e, 2*esize]) + SInt(product);
              (Elem[result, e, 2*esize], sat2) = SignedSatQ(accum, 2*esize);
              if sat1 || sat2 then FPSR.QC = ''1'';

         V[d] = result;');
INSERT INTO "instructions" VALUES('ARM','SQDMLSL2','-R:SQDMLSL');
INSERT INTO "instructions" VALUES('ARM','SQDMULH','       Signed saturating doubling multiply returning high half (by element)       (C7.3.246)


       Scalar


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 1 0 1 1 1 1 1 size L M                Rm       1 1 0 0 H 0            Rn     Rd
                                                                      op


       Scalar variant

       SQDMULH <V><d>, <V><n>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);     Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = esize;
         integer elements = 1;

         boolean round = (op == ''1'');


       Vector


           31 30 29 28 27 26 25 24 23 22 21 20 19       16 15 14 13 12 11 10 9         5 4    0
            0 Q 0 0 1 1 1 1 size L M                Rm       1 1 0 0 H 0            Rn     Rd
                                                                      op


       Vector variant

       SQDMULH <Vd>.<T>, <Vn>.<T>, <Vm>.<Ts>[<index>]


       Decode for this encoding

         integer idxdsize = if H == ''1'' then 128 else 64;
         integer index;
         bit Rmhi;
         case size of
              when ''01'' index = UInt(H:L:M); Rmhi = ''0'';
              when ''10'' index = UInt(H:L);     Rmhi = M;
              otherwise UnallocatedEncoding();

         integer d = UInt(Rd);
         integer n = UInt(Rn);
         integer m = UInt(Rmhi:Rm);

         integer esize = 8 << UInt(size);
         integer datasize = if Q == ''1'' then 128 else 64;
 integer elements = datasize DIV esize;

 boolean round = (op == ''1'');


Assembler symbols

<V>           Is a width specifier, encoded in the "size" field. It can have the following values:

              H           when size = 01

              S           when size = 10

              It is RESERVED when:

              .      size = 00.

              .      size = 11.

<d>           Is the number of the SIMD&FP destination register, encoded in the "Rd" field.

<n>           Is the number of the first SIMD&FP source register, encoded in the "Rn" field.

<Vd>          Is the name of the SIMD&FP destination register, encoded in the "Rd" field.

<T>           Is an arrangement specifier, encoded in the "size:Q" field. It can have the following values:

              4H          when size = 01, Q = 0

              8H          when size = 01, Q = 1

              2S          when size = 10, Q = 0

              4S          when size = 10, Q = 1

              It i