const _swan = require("../../__antmove_baidu/api/index.js")(swan);
let isArray = Array.isArray;

Promise.all = function(arr) {
    return new Promise(function(resolve, reject) {
        if (!isArray(arr)) {
            return reject(new TypeError("Promise.all accepts an array"));
        }

        var args = Array.prototype.slice.call(arr);
        if (args.length === 0) return resolve([]);
        var remaining = args.length;

        function res(i, val) {
            try {
                if (
                    val &&
                    (typeof val === "object" || typeof val === "function")
                ) {
                    var then = val.then;

                    if (typeof then === "function") {
                        then.call(
                            val,
                            function(val) {
                                res(i, val);
                            },
                            reject
                        );
                        return;
                    }
                }

                args[i] = val;

                if (--remaining === 0) {
                    resolve(args);
                }
            } catch (ex) {
                reject(ex);
            }
        }

        for (var i = 0; i < args.length; i++) {
            res(i, args[i]);
        }
    });
};
