import type {
  FlattenNode,
  Projected,
  RenderNodeProps,
  TreeData,
  UniqueIdentifier,
  VirtualConfig,
} from '../types';
import { TreeDataDispatchPayload } from './treeDataReducer';

export type OnTreeDataChange<T = any> = (
  treeData: TreeData<T>,
  event: TreeDataDispatchPayload,
) => void;

export interface ControlledState {
  /**
   * 隐藏默认的添加按钮
   */
  hideAdd?: boolean;
  /**
   * 隐藏默认的删除按钮
   */
  hideRemove?: boolean;
  /**
   * 禁用拖拽
   */
  disableDrag?: boolean;
  /**
   * 缩进宽度
   */
  indentationWidth?: number;
  /**
   * 选中 ID 变更回调
   */
  onSelectedIdsChange?: (selectedIds: UniqueIdentifier[]) => void;
}

/**
 * @title 组件状态
 */
export interface State<T = any> extends ControlledState {
  /**
   * @title 树形数据
   */
  treeData: TreeData;
  /**
   * @title 选中的节点 ID 数组
   */
  selectedIds?: UniqueIdentifier[];
  /**
   * @title 激活的节点 ID
   */
  activeId?: UniqueIdentifier;
  /**
   * @title 拖拽悬浮的节点 ID
   */
  overId?: UniqueIdentifier;
  /**
   * @title 左侧偏移量
   */
  offsetLeft: number;
  /**
   * @title 当前位置信息
   */
  currentPosition?: {
    /**
     * @title 父节点 ID
     */
    parentId: UniqueIdentifier | null;
    /**
     * @title 悬浮节点 ID
     */
    overId: UniqueIdentifier;
  };
  /**
   * @title 树形数据改变回调函数
   * @param treeData - 改变后的树形数据
   */
  onTreeDataChange?: OnTreeDataChange;
  /**
   * @title 渲染节点内容函数
   * @param node - 节点数据
   */
  renderContent: RenderNodeProps;
  /**
   * @title 渲染节点额外内容函数
   * @param node - 节点数据
   */
  renderExtra: RenderNodeProps;
  /**
   * 是否可拖动的函数规则，如果返回false，本次拖动会被禁用，默认允许自由拖动
   */
  sortableRule?: (data: {
    activeNode: FlattenNode<T>;
    targetNode: FlattenNode<T>;
    projected: Projected;
  }) => boolean;
  /**
   * 虚拟滚动配置
   */
  virtual?: VirtualConfig;
}

export const initialDragState: Pick<
  State,
  'offsetLeft' | 'overId' | 'activeId' | 'currentPosition'
> = {
  offsetLeft: 0,
  overId: null,
  activeId: null,
  currentPosition: null,
};

export const initialState: State = {
  indentationWidth: 24,
  treeData: [],
  selectedIds: [],
  renderContent: undefined,
  renderExtra: undefined,
  hideAdd: false,
  virtual: false,
  disableDrag: false,
  hideRemove: false,
  ...initialDragState,
};
