const strokeWidth = 2.2;
const iconSize = '13px';

export const CommandIcon = () => (
  <svg
    fill="none"
    height={iconSize}
    stroke="currentColor"
    strokeLinecap="round"
    strokeLinejoin="round"
    strokeWidth={strokeWidth}
    viewBox="0 0 24 24"
    width={iconSize}
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M18 3a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3 3 3 0 0 0 3-3 3 3 0 0 0-3-3H6a3 3 0 0 0-3 3 3 3 0 0 0 3 3 3 3 0 0 0 3-3V6a3 3 0 0 0-3-3 3 3 0 0 0-3 3 3 3 0 0 0 3 3h12a3 3 0 0 0 3-3 3 3 0 0 0-3-3z"></path>
  </svg>
);
export const ControlIcon = () => (
  <svg
    className="lucide lucide-chevron-up"
    fill="none"
    height={iconSize}
    stroke="currentColor"
    strokeLinecap="round"
    strokeLinejoin="round"
    strokeWidth={strokeWidth}
    viewBox="0 0 24 24"
    width={iconSize}
    xmlns="http://www.w3.org/2000/svg"
  >
    <polyline points="18 15 12 9 6 15"></polyline>
  </svg>
);
export const ShiftIcon = () => (
  <svg
    className="lucide lucide-chevron-up"
    fill="none"
    height={iconSize}
    stroke="currentColor"
    strokeLinecap="round"
    strokeLinejoin="round"
    strokeWidth={strokeWidth}
    viewBox="0 0 24 24"
    width={iconSize}
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M9 18v-6H5l7-7 7 7h-4v6H9z"></path>
  </svg>
);

export const AltIcon = () => (
  <svg
    className="lucide lucide-chevron-up"
    fill="none"
    stroke="currentColor"
    strokeLinecap="round"
    strokeLinejoin="round"
    height={iconSize}
    strokeWidth={strokeWidth}
    width={iconSize}
    viewBox="0 0 24 24"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path d="M3 3h6l6 18h6"></path>
    <path d="M14 3h7"></path>
  </svg>
);

export const ChevronRightIcon = ({ className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    height={iconSize}
    width={iconSize}
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth={strokeWidth}
    strokeLinecap="round"
    strokeLinejoin="round"
    className={`lucide lucide-chevron-right ${className}`}
  >
    <polyline points="9 18 15 12 9 6" />
  </svg>
);
