import { ColumnItemList } from '@ant-design/pro-editor';
import { createStyles } from 'antd-style';
import { memo } from 'react';
import { Flexbox } from 'react-layout-kit';

const useStyle = createStyles(({ token, css, cx, prefixCls }) => {
  const prefix = `${prefixCls}-${token?.editorPrefix}-column-list`;
  return {
    content: cx(
      `${prefix}-content`,
      css`
        flex: 1;
        width: 100%;
        height: 24px;
        font-size: 12px;
        border-radius: 2px;
        min-width: 48px;
      `,
    ),
    header: cx(
      `${prefix}-header`,
      css`
        color: ${token.colorTextTertiary};
        padding-left: 8px;
      `,
    ),
  };
});

interface HeaderProps {
  columns: ColumnItemList<any>;
}
export const Header = memo<HeaderProps>(({ columns }) => {
  const { styles, cx } = useStyle();

  return (
    <Flexbox horizontal align={'center'} gap={4}>
      {columns.map((item, index) => (
        <div key={`${item.dataIndex}-${index}`} className={cx(styles.content, styles.header)}>
          {item.title}
        </div>
      ))}
    </Flexbox>
  );
});
