---
title: Why ProEditor?
group: 快速上手
---

# Why ProEditor?

在各大组件库都趋于成熟的 2023 年，我们为什么要推出 ProEditor ？

## 🤔 前言：现在的前端组件库没活了？

在 antd、ProComponents 如此成熟的现在，前端开发的效能远比过去快十倍、百倍，体验也是抬升了好几个台阶，那么是不是说现在的组件库已经彻底没啥好做的了？

如果仔细分析下这些组件库中的组件，更多侧重于内容的展示与轻量编辑，不太有组件涉及相对复杂的编辑。典型例子正如如操作系统中的文件操作，涉及到多种输入模态（键盘、鼠标）、多种交互方式（框选、右键菜单、快捷键等）。

我们曾经讨论过为什么不在 antd 和 ProComponents 中做这样的组件，结论则是：「比较小众，成本又高，权衡后觉得不适合做」。的确，「编辑」在前端可谓是一个相对小众，开发成本通常比较高的领域。 不遇到还好，一旦遇到，逃不过一通巨量代码的研发。而大部分的设计师并没有深入研究过「编辑」场景，做出来的组件用户体验往往不够理想。

### 🌰 拿一个例子聊聊复杂的重「编辑」组件

概述往往没有体感，我们拿一个例子聊聊复杂的重「编辑」组件。 比如，如果要实现一个 ColumnList 这样一个「可排序列表」组件，它存在以下几个方面的复杂度：

1. **基础的增删改状态管理**： 需要支持基础的项的增加和删除，同时需要处理用户的点击事件添加或删除列表项，更新列表的数据等，这些功能远比一个展示列表要复杂得多；
2. **拖拽排序的逻辑实现**：单纯的拖拽排序还需要处理用户拖拽事件，计算拖拽的位置，更新列表的顺序，以及将排序后的数据处理状态等等。这些操作都需要比较复杂的逻辑和代码实现，估计能难倒一片开发；
3. **拖拽状态的交互指示**：当用户在拖拽列表项时，往往需要提供一些视觉上的指示，比如高亮显示拖拽的位置，或者在拖拽过程中显示一个覆盖层。这些指示同样需要额外的代码实现，否则用户的拖拽体验会很差。搞得定 1、2，但这一项又能扑街一片；
4. **受控与非受控模式**：作为一个组件，最理想的是同时支持受控与非受控的模式，在 1、2、3 的基础上，你还需要考虑怎么同时兼容受控与非受控。怎么样，是不是头皮该发麻了？
5. **组件的可扩展性**： 作为通用化的组件，必定需要相应的自定义方案，为接入各种业务场景提供可行性，编辑类组件和展示类组件的一个很大区别，则在于编辑类组件除了提供展示上的可扩展性，也要做好编辑能力的可扩展性（数据编辑的原子操作）。

### 更复杂的「用户输入」

除了组件层面，还有诸多原子化的操作能力是当今的前端仍未系统解决的。比如快捷键、键盘方向键切换焦点、键盘与鼠标同时作用的选取（shift 多选、cmd 复选）、撤销重做、鼠标框选……

上述用户的交互输入，在「操作系统」与大部分效率工具（文档三件套、代码编辑器、Sketch、PS ）可谓是基础中的基础，而在号称 “一统终端” 的 Web 里却是「奢侈品」级别的能力。

## 🕹「编辑」领域下的 「antd」

我们期待 ProEditor 成为「编辑」领域下和 antd 类似的基础库，前端同学可以借助 ProEditor 简单快速地实现一些复杂操作交互的组件，且体验默认优秀。这也是为什么将这个组件库称为「ProEditor」的原因。

为了达成上述目标，我们设定了以下原则：

- **自然编辑**：支持用户最自然的交互，包括但不限于鼠标多选、反选、快捷键等；
- **灵活开放**：所有能力均支持原子化输出，包括但不限于组件、hooks、工具函数等；
- **默认好用**：在 antd 基础组件上更进一步，交互体验上达到默认好用；

## 💡 使用建议

### 什么场景下，你不应该使用 ProEditor

如果你的场景是：

1. **官网首页、文档页**：这类场景基本不涉及任何用户的重交互操作，ProEditor 并不适用；
2. **标准的中后台的 CRUD 场景**：这类场景请考虑直接使用 [antd](http://ant.design/) 与 [ProComponents](https://procomponents.ant.design/)；
3. **技术栈不是 React** ： 这类场景请考虑你所用的技术栈中的相关组件， ProEditor 的只聚焦于 React 生态；

### 什么场景下，你可以使用 ProEditor

1. **存在较多复杂编辑操作的场景**：例如各种画布、编辑器场景，你可以使用 ProEditor 中的一些原子组件（DraggablePanel 等）来提升你的开发效率；
2. **组件可视化编辑场景**： 例如你需要一个类似 [Kitchen 智能表格](https://www.yuque.com/kitchen/changelog/3.1.0) 的组件可视化编辑器，你可以尝试使用 ProEditor 提供的组件装配器范式来实现；
