---
category: Components
type: General
title: Typography
cols: 1
cover: https://gw.alipayobjects.com/zos/alicdn/GOM1KQ24O/Typography.svg
---

Basic text writing, including headings, body text, lists, and more.

## When To Use

- When need to display a title or paragraph contents in Articles/Blogs/Notes.
- When you need copyable/editable/ellipsis texts.


## API

Typography.Text

| Property | Description | Type | Default Value |
| --- | --- | --- | --- |
| Code | Code style | boolean         | false         |
| Copyable | Config copy. Can set copy text and callback when is an object | boolean         | false         |
| Delete | Deleted line style | boolean         | false         |
| Disabled | Disabled content | boolean         | false         |
| Editable | Editable. Can control edit state when is object | boolean         | false         |
| Ellipsis | Display ellipsis when text overflows. Should set width when ellipsis needed | boolean         | false         |
| Mark | Marked style | boolean         | false         |
| Keyboard | Keyboard  style | boolean         | false         
| Underline | Underlined  style | boolean         | false         |
| OnChange | Trigger when user edits the content | boolean         | false         |
| Strong | Bold style | boolean         | false         |
| Type | Content type `secondary` `warning` `danger` | string         | -         |

Typography.Title

| Property | Description | Type | Default Value |
| --- | --- | --- | --- |
| Code | Code style | boolean         | false         |
| Copyable | Config copy. Can set copy text and callback when is an object | boolean         | false         |
| Delete | Deleted line style | boolean         | false         |
| Disabled | Disabled content | boolean         | false         |
| Editable | Editable. Can control edit state when is object | boolean         | false         |
| Ellipsis | Display ellipsis when text overflows. Should set width when ellipsis needed | boolean         | false         |
| Level | Set content importance. Match with `h1`, `h2`, `h3`, `h4` | int         | 1         |
| Mark | Marked style | boolean         | false         |
| Underline | Underlined  style | boolean         | false         |
| OnChange | Trigger when user edits the content | boolean         | false         |
| Type | Content type `secondary` `warning` `danger` | string         | -         |

Typography.Paragraph

| Property | Description | Type | Default Value |
| --- | --- | --- | --- |
| Code | Code style | boolean         | false         |
| Copyable | Config copy. Can set copy text and callback when is an object | boolean         | false         |
| Delete | Deleted line style | boolean         | false         |
| Disabled | Disabled content | boolean         | false         |
| Editable | Editable. Can control edit state when is object | boolean         | false         |
| Ellipsis | Display ellipsis when text overflows. Should set width when ellipsis needed | boolean         | false         |
| Mark | Marked style | boolean         | false         |
| Underline | Underlined  style | boolean         | false         |
| OnChange | Trigger when user edits the content | boolean         | false         |
| Strong | Bold style | boolean         | false         |
| Type | Content type `secondary` `warning` `danger` | string         | -         |


