---
order: 2
title: 国际化
---

国际化是指组件库内置的适应国际上主要地区语言的默认配置，包括文本翻译和日期格式，以及一些组件的默认配置，如日期组件中配置一周的第一天是星期几、月份是否在年份前面等等。

`Ant Design Blazor` 的国际化由内置的 `LocaleProvider` 静态类来提供，可对不同 UI 线程设置该线程的区域语言包，语言包内嵌在程序集中。

另外，我们还提供了站点级别的本地化组件，请参考[本地化](docs/localization)。

## 默认语言

组件默认会在程序调用 `Services.AddAntDesign()` 时自动从环境中获取区域语言作为默认语言。因此，不同的运行环境就有不同的设置：

- Blazor WebAssembly： 会从访问者的浏览器语言设置中获取默认语言。注意并不是从系统操作系统或服务端获取。
- Blazor 服务端静态/交互渲染： 会根据运行该服务的操作系统环境中的语言来作为默认语言，而不是根据用户的请求来设置。
- Blazor WebApp Auto 模式：则在静态阶段从服务器系统获取，在WebAssembly阶段从浏览器获取，因此需要注意保持语言一致，避免切换的问题。
- Blazor Hybrid 会从客户端中获取默认语言。

如果需要手动设置默认语言，可以在初始化时进行配置，也可以在运行中随时修改，请参考下面的方案。


## 全局配置

在应用运行的入口处设置

```csharp

service.AddAntDesign();

// 设置默认语言
LocaleProvider.DefaultLanguage = "en-US";
```

## 运行时修改

```csharp

@code {

    private void ChangeLocale()
    {
        LocaleProvider.SetLocale("en-US");
        StateHasChanged();
    }
}
```

## 语言包设置

当设置的语言没有内置的语言包时，我们会按照 父区域性 => 默认语言 => "en-US" 的顺序选择后备语言。(有关父区域性的概念解释，参见[全球化和本地化术语](https://docs.microsoft.com/zh-cn/aspnet/core/fundamentals/localization?view=aspnetcore-5.0#globalization-and-localization-terms)，推荐阅读该页面的英语版本)

可以通过 `LocaleProvider.DefaultLanguage = "languageName"` 设置默认语言。

您也可以通过 `LocaleProvider.SetLocale` 方法添加语言包。

```csharp
// 设置默认语言
LocaleProvider.DefaultLanguage = "en-US";

// 创建一个 `Locale` 对象
var zhHK = new Locale { ... };
// 设置额外的语言
LocaleProvider.SetLocale("zh-HK", zhHK); 
```

注意：`en-US` 是语言包名称，以下表格也遵循同样的规则。

## 内置语言

| 语言             | 语言包名 |
| ---------------- | ------ |
| 阿拉伯           | ar-EG  |
| 亞美尼亞         | hy-AM  |
| 保加利亚语       | bg-BG  |
| 加泰罗尼亚语     | ca-ES  |
| 捷克语           | cs-CZ  |
| 丹麦语             | da-DK    |
| 德语             | de-DE  |
| 希腊语           | el-GR  |
| 英语             | en-GB  |
| 英语（美式）     | en-US  |
| 西班牙语         | es-ES  |
| 爱沙尼亚语       | et-EE  |
| 波斯语           | fa-IR  |
| 芬兰语           | fi-FI  |
| 法语（比利时）   | fr-BE  |
| 法语             | fr-FR  |
| 希伯来语         | he-IL  |
| 印地语           | hi-IN  |
| 克罗地亚语       | hr-HR  |
| 匈牙利           | hu-HU  |
| 冰岛语           | is-IS  |
| 印度尼西亚语     | id-ID  |
| 意大利语         | it-IT  |
| 日语             | ja-JP  |
| 格鲁吉亚语       | ka-GE  |
| 卡纳达语         | kn-IN  |
| 韩语/朝鲜语      | ko-KR  |
| 库尔德语         | ku-IQ |
| 拉脱维亚语       | lv-LV    |
| 马来语          | ms-MY |
| 蒙古语             | mn-MN    |
| 挪威             | nb-NO  |
| 尼泊尔语         | ne-NP  |
| 荷兰语（比利时） | nl-BE  |
| 荷兰语           | nl-NL  |
| 波兰语           | pl-PL  |
| 葡萄牙语(巴西)   | pt-BR  |
| 葡萄牙语         | pt-PT  |
| 斯洛伐克语       | sk-SK  |
| 塞尔维亚         | sr-RS  |
| 斯洛文尼亚       | sl-SI  |
| 瑞典语           | sv-SE  |
| 泰米尔语         | ta-IN  |
| 泰语             | th-TH  |
| 土耳其语         | tr-TR  |
| 罗马尼亚语       | ro-RO  |
| 俄罗斯语         | ru-RU  |
| 乌克兰语         | uk-UA  |
| 越南语           | vi-VN  |
| 简体中文         | zh-CN  |
| 繁体中文         | zh-TW  |

当然，我们并不精通所有的语言，如果你发现翻译有误，请提交 PR 帮助我们改进。