﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Collections.Generic;

namespace AntDesign
{
    internal static class ColorHelper
    {
        public static string GetBackgroundStyle(Color color) => _colors[color];

        private static readonly Dictionary<Color, string> _colors = new()
        {
            { Color.None, "" },
            { Color.Red1, "background-color: #fff1f0; border-color: #fff1f0; color: rgba(0,0,0,0.85);" },
            { Color.Red2, "background-color: #ffccc7; border-color: #ffccc7; color: rgba(0,0,0,0.85);" },
            { Color.Red3, "background-color: #ffa39e; border-color: #ffa39e; color: rgba(0,0,0,0.85);" },
            { Color.Red4, "background-color: #ff7875; border-color: #ff7875; color: rgba(0,0,0,0.85);" },
            { Color.Red5, "background-color: #ff4d4f; border-color: #ff4d4f; color: rgba(0,0,0,0.85);" },
            { Color.Red6, "background-color: #f5222d; border-color: #f5222d; color: rgb(255,255,255);" },
            { Color.Red7, "background-color: #cf1322; border-color: #cf1322; color: rgb(255,255,255);" },
            { Color.Red8, "background-color: #a8071a; border-color: #a8071a; color: rgb(255,255,255);" },
            { Color.Red9, "background-color: #820014; border-color: #820014; color: rgb(255,255,255);" },
            { Color.Red10, "background-color: #5c0011; border-color: #5c0011; color: rgb(255,255,255);" },
            { Color.Volcano1, "background-color: #fff2e8; border-color: #fff2e8; color: rgba(0,0,0,0.85);" },
            { Color.Volcano2, "background-color: #ffd8bf; border-color: #ffd8bf; color: rgba(0,0,0,0.85);" },
            { Color.Volcano3, "background-color: #ffbb96; border-color: #ffbb96; color: rgba(0,0,0,0.85);" },
            { Color.Volcano4, "background-color: #ff9c6e; border-color: #ff9c6e; color: rgba(0,0,0,0.85);" },
            { Color.Volcano5, "background-color: #ff7a45; border-color: #ff7a45; color: rgba(0,0,0,0.85);" },
            { Color.Volcano6, "background-color: #fa541c; border-color: #fa541c; color: rgb(255,255,255);" },
            { Color.Volcano7, "background-color: #d4380d; border-color: #d4380d; color: rgb(255,255,255);" },
            { Color.Volcano8, "background-color: #ad2102; border-color: #ad2102; color: rgb(255,255,255);" },
            { Color.Volcano9, "background-color: #871400; border-color: #871400; color: rgb(255,255,255);" },
            { Color.Volcano10, "background-color: #610b00; border-color: #610b00; color: rgb(255,255,255);" },
            { Color.Orange1, "background-color: #fff7e6; border-color: #fff7e6; color: rgba(0,0,0,0.85);" },
            { Color.Orange2, "background-color: #ffe7ba; border-color: #ffe7ba; color: rgba(0,0,0,0.85);" },
            { Color.Orange3, "background-color: #ffd591; border-color: #ffd591; color: rgba(0,0,0,0.85);" },
            { Color.Orange4, "background-color: #ffc069; border-color: #ffc069; color: rgba(0,0,0,0.85);" },
            { Color.Orange5, "background-color: #ffa940; border-color: #ffa940; color: rgba(0,0,0,0.85);" },
            { Color.Orange6, "background-color: #fa8c16; border-color: #fa8c16; color: rgb(255,255,255);" },
            { Color.Orange7, "background-color: #d46b08; border-color: #d46b08; color: rgb(255,255,255);" },
            { Color.Orange8, "background-color: #ad4e00; border-color: #ad4e00; color: rgb(255,255,255);" },
            { Color.Orange9, "background-color: #873800; border-color: #873800; color: rgb(255,255,255);" },
            { Color.Orange10, "background-color: #612500; border-color: #612500; color: rgb(255,255,255);" },
            { Color.Gold1, "background-color: #fffbe6; border-color: #fffbe6; color: rgba(0,0,0,0.85);" },
            { Color.Gold2, "background-color: #fff1b8; border-color: #fff1b8; color: rgba(0,0,0,0.85);" },
            { Color.Gold3, "background-color: #ffe58f; border-color: #ffe58f; color: rgba(0,0,0,0.85);" },
            { Color.Gold4, "background-color: #ffd666; border-color: #ffd666; color: rgba(0,0,0,0.85);" },
            { Color.Gold5, "background-color: #ffc53d; border-color: #ffc53d; color: rgba(0,0,0,0.85);" },
            { Color.Gold6, "background-color: #faad14; border-color: #faad14; color: rgb(255,255,255);" },
            { Color.Gold7, "background-color: #d48806; border-color: #d48806; color: rgb(255,255,255);" },
            { Color.Gold8, "background-color: #ad6800; border-color: #ad6800; color: rgb(255,255,255);" },
            { Color.Gold9, "background-color: #874d00; border-color: #874d00; color: rgb(255,255,255);" },
            { Color.Gold10, "background-color: #613400; border-color: #613400; color: rgb(255,255,255);" },
            { Color.Yellow1, "background-color: #feffe6; border-color: #feffe6; color: rgba(0,0,0,0.85);" },
            { Color.Yellow2, "background-color: #ffffb8; border-color: #ffffb8; color: rgba(0,0,0,0.85);" },
            { Color.Yellow3, "background-color: #fffb8f; border-color: #fffb8f; color: rgba(0,0,0,0.85);" },
            { Color.Yellow4, "background-color: #fff566; border-color: #fff566; color: rgba(0,0,0,0.85);" },
            { Color.Yellow5, "background-color: #ffec3d; border-color: #ffec3d; color: rgba(0,0,0,0.85);" },
            { Color.Yellow6, "background-color: #fadb14; border-color: #fadb14; color: rgba(0,0,0,0.85);" },
            { Color.Yellow7, "background-color: #d4b106; border-color: #d4b106; color: rgb(255,255,255);" },
            { Color.Yellow8, "background-color: #ad8b00; border-color: #ad8b00; color: rgb(255,255,255);" },
            { Color.Yellow9, "background-color: #876800; border-color: #876800; color: rgb(255,255,255);" },
            { Color.Yellow10, "background-color: #614700; border-color: #614700; color: rgb(255,255,255);" },
            { Color.Lime1, "background-color: #fcffe6; border-color: #fcffe6; color: rgba(0,0,0,0.85);" },
            { Color.Lime2, "background-color: #f4ffb8; border-color: #f4ffb8; color: rgba(0,0,0,0.85);" },
            { Color.Lime3, "background-color: #eaff8f; border-color: #eaff8f; color: rgba(0,0,0,0.85);" },
            { Color.Lime4, "background-color: #d3f261; border-color: #d3f261; color: rgba(0,0,0,0.85);" },
            { Color.Lime5, "background-color: #bae637; border-color: #bae637; color: rgba(0,0,0,0.85);" },
            { Color.Lime6, "background-color: #a0d911; border-color: #a0d911; color: rgb(255,255,255);" },
            { Color.Lime7, "background-color: #7cb305; border-color: #7cb305; color: rgb(255,255,255);" },
            { Color.Lime8, "background-color: #5b8c00; border-color: #5b8c00; color: rgb(255,255,255);" },
            { Color.Lime9, "background-color: #3f6600; border-color: #3f6600; color: rgb(255,255,255);" },
            { Color.Lime10, "background-color: #254000; border-color: #254000; color: rgb(255,255,255);" },
            { Color.Green1, "background-color: #f6ffed; border-color: #f6ffed; color: rgba(0,0,0,0.85);" },
            { Color.Green2, "background-color: #d9f7be; border-color: #d9f7be; color: rgba(0,0,0,0.85);" },
            { Color.Green3, "background-color: #b7eb8f; border-color: #b7eb8f; color: rgba(0,0,0,0.85);" },
            { Color.Green4, "background-color: #95de64; border-color: #95de64; color: rgba(0,0,0,0.85);" },
            { Color.Green5, "background-color: #73d13d; border-color: #73d13d; color: rgba(0,0,0,0.85);" },
            { Color.Green6, "background-color: #52c41a; border-color: #52c41a; color: rgb(255,255,255);" },
            { Color.Green7, "background-color: #389e0d; border-color: #389e0d; color: rgb(255,255,255);" },
            { Color.Green8, "background-color: #237804; border-color: #237804; color: rgb(255,255,255);" },
            { Color.Green9, "background-color: #135200; border-color: #135200; color: rgb(255,255,255);" },
            { Color.Green10, "background-color: #092b00; border-color: #092b00; color: rgb(255,255,255);" },
            { Color.Cyan1, "background-color: #e6fffb; border-color: #e6fffb; color: rgba(0,0,0,0.85);" },
            { Color.Cyan2, "background-color: #b5f5ec; border-color: #b5f5ec; color: rgba(0,0,0,0.85);" },
            { Color.Cyan3, "background-color: #87e8de; border-color: #87e8de; color: rgba(0,0,0,0.85);" },
            { Color.Cyan4, "background-color: #5cdbd3; border-color: #5cdbd3; color: rgba(0,0,0,0.85);" },
            { Color.Cyan5, "background-color: #36cfc9; border-color: #36cfc9; color: rgba(0,0,0,0.85);" },
            { Color.Cyan6, "background-color: #13c2c2; border-color: #13c2c2; color: rgb(255,255,255);" },
            { Color.Cyan7, "background-color: #08979c; border-color: #08979c; color: rgb(255,255,255);" },
            { Color.Cyan8, "background-color: #006d75; border-color: #006d75; color: rgb(255,255,255);" },
            { Color.Cyan9, "background-color: #00474f; border-color: #00474f; color: rgb(255,255,255);" },
            { Color.Cyan10, "background-color: #002329; border-color: #002329; color: rgb(255,255,255);" },
            { Color.Blue1, "background-color: #e6f7ff; border-color: #e6f7ff; color: rgba(0,0,0,0.85);" },
            { Color.Blue2, "background-color: #bae7ff; border-color: #bae7ff; color: rgba(0,0,0,0.85);" },
            { Color.Blue3, "background-color: #91d5ff; border-color: #91d5ff; color: rgba(0,0,0,0.85);" },
            { Color.Blue4, "background-color: #69c0ff; border-color: #69c0ff; color: rgba(0,0,0,0.85);" },
            { Color.Blue5, "background-color: #40a9ff; border-color: #40a9ff; color: rgba(0,0,0,0.85);" },
            { Color.Blue6, "background-color: #1890ff; border-color: #1890ff; color: rgb(255,255,255);" },
            { Color.Blue7, "background-color: #096dd9; border-color: #096dd9; color: rgb(255,255,255);" },
            { Color.Blue8, "background-color: #0050b3; border-color: #0050b3; color: rgb(255,255,255);" },
            { Color.Blue9, "background-color: #003a8c; border-color: #003a8c; color: rgb(255,255,255);" },
            { Color.Blue10, "background-color: #002766; border-color: #002766; color: rgb(255,255,255);" },
            { Color.Geekblue1, "background-color: #f0f5ff; border-color: #f0f5ff; color: rgba(0,0,0,0.85);" },
            { Color.Geekblue2, "background-color: #d6e4ff; border-color: #d6e4ff; color: rgba(0,0,0,0.85);" },
            { Color.Geekblue3, "background-color: #adc6ff; border-color: #adc6ff; color: rgba(0,0,0,0.85);" },
            { Color.Geekblue4, "background-color: #85a5ff; border-color: #85a5ff; color: rgba(0,0,0,0.85);" },
            { Color.Geekblue5, "background-color: #597ef7; border-color: #597ef7; color: rgba(0,0,0,0.85);" },
            { Color.Geekblue6, "background-color: #2f54eb; border-color: #2f54eb; color: rgb(255,255,255);" },
            { Color.Geekblue7, "background-color: #1d39c4; border-color: #1d39c4; color: rgb(255,255,255);" },
            { Color.Geekblue8, "background-color: #10239e; border-color: #10239e; color: rgb(255,255,255);" },
            { Color.Geekblue9, "background-color: #061178; border-color: #061178; color: rgb(255,255,255);" },
            { Color.Geekblue10, "background-color: #030852; border-color: #030852; color: rgb(255,255,255);" },
            { Color.Purple1, "background-color: #f9f0ff; border-color: #f9f0ff; color: rgba(0,0,0,0.85);" },
            { Color.Purple2, "background-color: #efdbff; border-color: #efdbff; color: rgba(0,0,0,0.85);" },
            { Color.Purple3, "background-color: #d3adf7; border-color: #d3adf7; color: rgba(0,0,0,0.85);" },
            { Color.Purple4, "background-color: #b37feb; border-color: #b37feb; color: rgba(0,0,0,0.85);" },
            { Color.Purple5, "background-color: #9254de; border-color: #9254de; color: rgba(0,0,0,0.85);" },
            { Color.Purple6, "background-color: #722ed1; border-color: #722ed1; color: rgb(255,255,255);" },
            { Color.Purple7, "background-color: #531dab; border-color: #531dab; color: rgb(255,255,255);" },
            { Color.Purple8, "background-color: #391085; border-color: #391085; color: rgb(255,255,255);" },
            { Color.Purple9, "background-color: #22075e; border-color: #22075e; color: rgb(255,255,255);" },
            { Color.Purple10, "background-color: #120338; border-color: #120338; color: rgb(255,255,255);" },
            { Color.Magenta1, "background-color: #fff0f6; border-color: #fff0f6; color: rgba(0,0,0,0.85);" },
            { Color.Magenta2, "background-color: #ffd6e7; border-color: #ffd6e7; color: rgba(0,0,0,0.85);" },
            { Color.Magenta3, "background-color: #ffadd2; border-color: #ffadd2; color: rgba(0,0,0,0.85);" },
            { Color.Magenta4, "background-color: #ff85c0; border-color: #ff85c0; color: rgba(0,0,0,0.85);" },
            { Color.Magenta5, "background-color: #f759ab; border-color: #f759ab; color: rgba(0,0,0,0.85);" },
            { Color.Magenta6, "background-color: #eb2f96; border-color: #eb2f96; color: rgb(255,255,255);" },
            { Color.Magenta7, "background-color: #c41d7f; border-color: #c41d7f; color: rgb(255,255,255);" },
            { Color.Magenta8, "background-color: #9e1068; border-color: #9e1068; color: rgb(255,255,255);" },
            { Color.Magenta9, "background-color: #780650; border-color: #780650; color: rgb(255,255,255);" },
            { Color.Magenta10, "background-color: #520339; border-color: #520339; color: rgb(255,255,255);" },
            { Color.Gray1, "background-color: #ffffff; border-color: #ffffff; color: rgba(0,0,0,0.85);" },
            { Color.Gray2, "background-color: #fafafa; border-color: #fafafa; color: rgba(0,0,0,0.85);" },
            { Color.Gray3, "background-color: #f5f5f5; border-color: #f5f5f5; color: rgba(0,0,0,0.85);" },
            { Color.Gray4, "background-color: #f0f0f0; border-color: #f0f0f0; color: rgba(0,0,0,0.85);" },
            { Color.Gray5, "background-color: #d9d9d9; border-color: #d9d9d9; color: rgba(0,0,0,0.85);" },
            { Color.Gray6, "background-color: #bfbfbf; border-color: #bfbfbf; color: rgb(255,255,255);" },
            { Color.Gray7, "background-color: #8c8c8c; border-color: #8c8c8c; color: rgb(255,255,255);" },
            { Color.Gray8, "background-color: #595959; border-color: #595959; color: rgb(255,255,255);" },
            { Color.Gray9, "background-color: #434343; border-color: #434343; color: rgb(255,255,255);" },
            { Color.Gray10, "background-color: #262626; border-color: #262626; color: rgb(255,255,255);" },
            { Color.Gray11, "background-color: #1f1f1f; border-color: #1f1f1f; color: rgb(255,255,255);" },
            { Color.Gray12, "background-color: #141414; border-color: #141414; color: rgb(255,255,255);" },
            { Color.Gray13, "background-color: #000000; border-color: #000000; color: rgb(255,255,255);" },
        };
    }
}
