# Ansopedia Contributing Guide

👋 We're so excited you're interested in helping with Ansopedia! We happy to help you get started, even if you don't have any previous open-source experience :)

- [Code of Conduct](#code-of-conduct)
- [Contributing](#contributing)
  - [Becoming a collaborator](#becoming-a-collaborator)
- [Getting started](#getting-started)
- [Commit Guidelines](#commit-guidelines)

## Code of Conduct

By participating in this project, you agree to uphold our [Code of Conduct](./CODE_OF_CONDUCT.md). Please take a moment to review it to ensure a welcoming and inclusive environment for everyone.

## Contributing

- A **Contributor** is any individual who creates an issue/PR, comments on an issue/PR, or contributes in some other way.
- A **Collaborator** is a contributor with write access to the repository. See [here](#becoming-a-collaborator) on how to become a collaborator.

You can find more details and guides about Collaborating with this repository through our [Collaborator Guide](./COLLABORATOR_GUIDE.md).

### Becoming a Collaborator

A collaborator of the Ansopedia and its repository is a member of the Ansopedia Team.

The Platform Team is responsible for the technical development of the Ansopedia; thus, it is expected
that team members have significant knowledge about modern Web Technologies and Web Standards.

Note that regular contributors do not need to become "Collaborators" as any contribution is appreciated (even without a status), and a Collaborator status
is a formality that comes with obligations.

If you're an active contributor seeking to become a member, we recommend you contact one of the existing Team Members for guidance.

<details>
  <summary><b>What's the process for becoming a Collaborator?</b></summary>

- You must be actively contributing to this repository.
- Contributions must include significant code reviews or code contributions.
- A nomination must be done by an existing Team Member of the Website Team with an Issue
  - The Issue must explain and describe why the nominated person is a good addition to the team
  - The Issue must contain links to relevant contributions through:
    - Code Reviews
    - Comments on Issues and PRs
    - Authoring of PRs or Issues
    - Comments or Authoring of Discussions
- The nomination must have at least three existing members of the Website Team agree with the nomination.
  - This can be done through commenting with "agreement" (showing support) or reacting to the Issue with a :+1: (Thumbs-up Emoji)
- The Issue must be open for at least 72 hours without an objection from an existing member of the Website Team
  - The nomination cannot pass until all open objections are resolved.
  - Objections from the TSC or Core Collaborators are also counted as valid objections.

</details>

## Getting started

The steps below will give you a general idea of how to prepare your local environment for the Ansopedia and general steps
for getting things done and landing your contribution.

1. Click the fork button in the top right to clone the [Ansopedia Repository](https://github.com/ansopedia/creator-studio/fork)

2. Clone your fork using SSH, GitHub CLI, or HTTPS.

   ```bash
   git clone git@github.com:ansopedia/creator-studio.git # SSH
   git clone https://github.com/ansopedia/creator-studio.git # HTTPS
   gh repo clone ansopedia/creator-studio # GitHub CLI
   ```

3. Change into the creator-studio directory.

   ```bash
   cd creator-studio
   ```

4. Create a remote to keep your fork and local clone up-to-date.

   ```bash
   git remote add upstream git@github.com:ansopedia/creator-studio.git # SSH
   git remote add upstream https://github.com/ansopedia/creator-studio.git # HTTPS
   gh repo sync ansopedia/creator-studio # GitHub CLI
   ```

5. Create a new branch for your work.

   ```bash
   git checkout -b <name-of-your-branch>
   ```

6. Run the following to install the dependencies and start a local preview of your work.

   ```bash
   pnpm i # installs this project's dependencies
   pnpm dev # starts a development environment
   ```

   The project should now be running on http://localhost:3000.

7. Perform your changes.

8. Run `pnpm prettier:fix` to confirm that linting and formatting are passing.

   ```bash
   pnpm prettier:fix
   ```

9. Once you're happy with your changes, add and commit them to your branch, then push the branch to your fork.

   ```bash
   git add .
   git commit #let commitizen handle the commit
   git push -u origin name-of-your-branch
   ```

## Commit Guidelines

This project follows the [Conventional Commits][] specification.

Commits should be signed. You can read more about [Commit Signing][] here.

### Commit Message Guidelines

- Commit messages must include a "type" as described on Conventional Commits
- Commit messages **must** start with a capital letter
- Commit messages **must not** end with a period `.`
- Commit messages **must** be in English
- Commit messages **must** be written in the present tense

### Naming Conventions for Branches

- `feature/[issue-number]-[short-description]`: A new feature
- `fix/[issue-number]-[short-description]`: A bug fix
- `docs/[issue-number]-[short-description]`: Documentation only changes
- `refactor/[issue-number]-[short-description]`: A code change that neither fixes a bug nor adds a feature
- `test/[issue-number]-[short-description]`: Adding missing tests
- `chore/[issue-number]-[short-description]`: Changes to the build process or auxiliary tools and libraries such as documentation generation

### Pre-commit Hooks

This project uses [Husky][] for Git pre-commit hooks.

### When merging

- Please make sure that all discussions are resolved.

## License

By contributing, you agree that your contributions will be licensed under the project's [LICENSE](./LICENSE).
