# C++ Insights Examples {#examples}

Here are some examples to give you an impression what C++ Insights can show you.

C++11:
* [Braced array initialization](@ref example_braced_array_initialization)
* [Braced (uniform) initialization](@ref example_braced_uniform_initialization)
* [auto](@ref example_auto)
* [range based for loop](@ref example_range_based_for_loop)
* [Lambda with static invoker](@ref example_lambda_with_static_invoke)
* [Implicit conversions](@ref example_implicit_conversions)
* [auto, uniform initialization and the equal sign](@ref example_auto_uniform_initialization_and_the_equal_sign)
* [Recursive template](@ref example_recursive_template)


C++14:
* [Braced return value and decltype(auto)](@ref example_braced_return_value_and_decltype_auto)
* [Generic lambda](@ref example_generic_lambda)


C++17:
* [Structured bindings](@ref example_structured_bindings)

In case, you're missing an example, feel free to open a [pull request](https://github.com/andreasfertig/cppinsights-web/pulls).

