/**
 * Updates the tabindex and respects tab index set by the page author.
 * @param $elem
 * @param disabled
 */
export function updateTabindex($elem: HTMLElement, disabled: boolean) {
	$elem.tabIndex = disabled ? -1 : $elem.tabIndex < 0 ? 0 : $elem.tabIndex;
}

/**
 * All possible aria roles.
 * Compiled from https://www.w3.org/WAI/PF/aria/roles
 */
export type AriaRole =
	| "alert"
	| "alertdialog"
	| "application"
	| "article"
	| "banner"
	| "button"
	| "checkbox"
	| "columnheader"
	| "combobox"
	| "command"
	| "complementary"
	| "composite"
	| "contentinfo"
	| "definition"
	| "dialog"
	| "directory"
	| "document"
	| "form"
	| "grid"
	| "gridcell"
	| "group"
	| "heading"
	| "img"
	| "input"
	| "landmark"
	| "link"
	| "list"
	| "listbox"
	| "listitem"
	| "log"
	| "main"
	| "marquee"
	| "math"
	| "menu"
	| "menubar"
	| "menuitem"
	| "menuitemcheckbox"
	| "menuitemradio"
	| "navigation"
	| "note"
	| "option"
	| "paragraph"
	| "presentation"
	| "progressbar"
	| "radio"
	| "radiogroup"
	| "range"
	| "region"
	| "roletype"
	| "row"
	| "rowgroup"
	| "rowheader"
	| "scrollbar"
	| "search"
	| "section"
	| "sectionhead"
	| "select"
	| "separator"
	| "slider"
	| "spinbutton"
	| "status"
	| "structure"
	| "tab"
	| "tablist"
	| "tabpanel"
	| "textbox"
	| "timer"
	| "toolbar"
	| "tooltip"
	| "tree"
	| "treegrid"
	| "treeitem"
	| "widget"
	| "window";
