
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-title)

# ➤ wl-title

Indicate the start of a new section.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property | Attribute | Type         | Default   | Description                                      |
|----------|-----------|--------------|-----------|--------------------------------------------------|
| `level`  | `level`   | `TitleLevel` | 1         | Level of the title.                              |
| `nowrap` | `nowrap`  | `boolean`    | false     | Caps the title element with ellipsis if overflowing. |
| `role`   | `role`    | `AriaRole`   | "heading" | Role of the title.                               |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#slots)

## ➤ Slots

| Name | Description      |
|------|------------------|
|      | Default content. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property                    | Description                  |
|-----------------------------|------------------------------|
| `--title-font-family`       | Font family                  |
| `--title-font-size-level-1` | Font size of heading level 1 |
| `--title-font-size-level-2` | Font size of heading level 2 |
| `--title-font-size-level-3` | Font size of heading level 3 |
| `--title-font-size-level-4` | Font size of heading level 4 |
| `--title-font-size-level-5` | Font size of heading level 5 |
| `--title-font-size-level-6` | Font size of heading level 6 |
| `--title-font-weight`       | Font weight                  |
| `--title-line-height`       | Line height                  |
| `--title-margin`            | Margin                       |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/title) to try the demo.

<a href="https://weightless.dev/elements/title" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-title.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).