
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-tab)

# ➤ wl-tab

Organize navigation between groups of content.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property      | Attribute      | Type                  | Default | Description                                      |
|---------------|----------------|-----------------------|---------|--------------------------------------------------|
| `ariaChecked` | `aria-checked` | `string`              |         | Aria checked attribute.                          |
| `checked`     | `checked`      | `boolean`             | false   | Checks the switch.                               |
| `disabled`    | `disabled`     | `boolean`             | false   | Disables the element.                            |
| `name`        | `name`         | `string \| undefined` |         | Name of the native form element.                 |
| `readonly`    | `readonly`     | `boolean`             | false   | Makes the element readonly (disabled but tabbable) |
| `required`    | `required`     | `boolean`             | false   | Makes the element required in a form context.    |
| `role`        | `role`         | `AriaRole`            | "tab"   | Role of the tab.                                 |
| `value`       | `value`        | `string`              | ""      | Value of the form element.                       |
| `vertical`    | `vertical`     | `boolean`             | false   | Vertical tab style.                              |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#events)

## ➤ Events

| Event    | Description                                      |
|----------|--------------------------------------------------|
| `change` | Dispatched when the checked property changes due to a user interaction. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#slots)

## ➤ Slots

| Name     | Description      |
|----------|------------------|
|          | Default content. |
| `before` | Default content. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property                          | Description                              |
|-----------------------------------|------------------------------------------|
| `--tab-before-margin`             | Margin of the before slot                |
| `--tab-before-margin-vertical`    | margin of the before slot when vertical  |
| `--tab-bg`                        | default background                       |
| `--tab-bg-active`                 | background when active                   |
| `--tab-bg-active-filled`          | background when active and filled        |
| `--tab-bg-active-hover`           | background when active and hover         |
| `--tab-bg-active-hover-filled`    | background when active, hover and filled |
| `--tab-bg-disabled`               | background when disabled                 |
| `--tab-bg-disabled-filled`        | background when disabled and filled      |
| `--tab-bg-filled`                 | default background when filled           |
| `--tab-bg-hover`                  | background when hover                    |
| `--tab-bg-hover-filled`           | background when hover and filled         |
| `--tab-color`                     | default color                            |
| `--tab-color-active`              | color when active                        |
| `--tab-color-active-filled`       | color when active and filled             |
| `--tab-color-active-hover`        | color when active and hover              |
| `--tab-color-active-hover-filled` | color when active, hover and filled      |
| `--tab-color-disabled`            | color when disabled                      |
| `--tab-color-disabled-filled`     | color when disabled and filled           |
| `--tab-color-filled`              | default color when filled                |
| `--tab-color-hover`               | color when hover                         |
| `--tab-color-hover-filled`        | color when hover and filled              |
| `--tab-opacity-disabled`          | opacity when disabled                    |
| `--tab-padding`                   | Padding                                  |
| `--tab-padding-vertical`          | Padding when vertical                    |
| `--tab-transition`                | transition                               |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/tabs) to try the demo.

<a href="https://weightless.dev/elements/tabs" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-tabs.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).
