
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-switch)

# ➤ wl-switch

Turn an option on or off.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property      | Attribute      | Type                  | Default    | Description                                      |
|---------------|----------------|-----------------------|------------|--------------------------------------------------|
| `ariaChecked` | `aria-checked` | `string`              |            | Aria checked attribute.                          |
| `checked`     | `checked`      | `boolean`             | false      | Checks the switch.                               |
| `disabled`    | `disabled`     | `boolean`             | false      | Disables the element.                            |
| `name`        | `name`         | `string \| undefined` |            | Name of the native form element.                 |
| `readonly`    | `readonly`     | `boolean`             | false      | Makes the element readonly (disabled but tabbable) |
| `required`    | `required`     | `boolean`             | false      | Makes the element required in a form context.    |
| `role`        | `role`         | `AriaRole`            | "checkbox" | Role of the switch.                              |
| `value`       | `value`        | `string`              | ""         | Value of the form element.                       |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#events)

## ➤ Events

| Event    | Description                                      |
|----------|--------------------------------------------------|
| `change` | Dispatched when the checked property changes due to a user interaction. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property                          | Description                          |
|-----------------------------------|--------------------------------------|
| `--switch-bg`                     | Default background                   |
| `--switch-bg-checked`             | Background when checked              |
| `--switch-bg-disabled`            | Background when disabled             |
| `--switch-bg-disabled-checked`    | Background when disabled and checked |
| `--switch-border-radius`          | Border radius                        |
| `--switch-color`                  | Default color                        |
| `--switch-color-checked`          | Color when checked                   |
| `--switch-color-disabled`         | Color when disabled                  |
| `--switch-color-disabled-checked` | Color when disabled and checked      |
| `--switch-height`                 | Height                               |
| `--switch-knob-border-radius`     | Border radius of the knob            |
| `--switch-knob-elevation`         | Box shadow of the knob               |
| `--switch-knob-size`              | Width and height of the knob         |
| `--switch-knob-transition`        | Transition of the knob               |
| `--switch-ripple-transform`       | Transform of the ripple              |
| `--switch-transition`             | Transition                           |
| `--switch-width`                  | Width                                |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/switch) to try the demo.

<a href="https://weightless.dev/elements/switch" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-switch.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).
