
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-ripple)

# ➤ wl-ripple

Indicate touch actions.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property          | Attribute         | Type          | Default        | Description                                    |
|-------------------|-------------------|---------------|----------------|------------------------------------------------|
| `autoRelease`     | `autoRelease`     | `boolean`     | false          | Releases the ripple after it has been spawned. |
| `centered`        | `centered`        | `boolean`     | false          | Makes ripple appear from the center.           |
| `disabled`        | `disabled`        | `boolean`     | false          | Disables the ripple.                           |
| `focusable`       | `focusable`       | `boolean`     | false          | Allows focusin to spawn a ripple.              |
| `initialDuration` | `initialDuration` | `number`      | 350            | Initial animation duration.                    |
| `overlay`         | `overlay`         | `boolean`     | false          | Overlays the ripple.                           |
| `releaseDuration` | `releaseDuration` | `number`      | 500            | Fade out animation duration.                   |
| `role`            | `role`            | `AriaRole`    | "presentation" | Role of the ripple.                            |
| `target`          | `target`          | `EventTarget` |                | Target for the spawn ripple events.            |
| `unbounded`       | `unbounded`       | `boolean`     | false          | Makes the ripple visible outside the bounds.   |
| `x`               |                   | `number`      | **required**   |                                                |
| `y`               |                   | `number`      | **required**   |                                                |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property           | Description |
|--------------------|-------------|
| `--ripple-color`   | Color.      |
| `--ripple-opacity` | Opacity.    |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/ripple) to try the demo.

<a href="https://weightless.dev/elements/ripple" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-ripple.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).