
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-radio)

# ➤ wl-radio

Select one option from a set.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property      | Attribute      | Type                  | Default | Description                                      |
|---------------|----------------|-----------------------|---------|--------------------------------------------------|
| `ariaChecked` | `aria-checked` | `string`              |         | Aria checked attribute.                          |
| `checked`     | `checked`      | `boolean`             | false   | Checks the switch.                               |
| `disabled`    | `disabled`     | `boolean`             | false   | Disables the element.                            |
| `name`        | `name`         | `string \| undefined` |         | Name of the native form element.                 |
| `readonly`    | `readonly`     | `boolean`             | false   | Makes the element readonly (disabled but tabbable) |
| `required`    | `required`     | `boolean`             | false   | Makes the element required in a form context.    |
| `role`        | `role`         | `AriaRole`            | "radio" | Role of the radio behavior.                      |
| `value`       | `value`        | `string`              | ""      | Value of the form element.                       |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#events)

## ➤ Events

| Event    | Description                                      |
|----------|--------------------------------------------------|
| `change` | Dispatched when the checked property changes due to a user interaction. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property                         | Description                            |
|----------------------------------|----------------------------------------|
| `--radio-bg`                     | Default background                     |
| `--radio-bg-checked`             | Background when checked                |
| `--radio-bg-disabled`            | Background when disabled and checked   |
| `--radio-bg-disabled-checked`    | Background when disabled and checked   |
| `--radio-border-config`          | Border configuration (width and style) |
| `--radio-border-radius`          | Border radius                          |
| `--radio-color`                  | Default color                          |
| `--radio-color-checked`          | Color when checked                     |
| `--radio-color-disabled`         | Color when disabled                    |
| `--radio-color-disabled-checked` | Color when disabled and checked        |
| `--radio-dot-border-radius`      | Border radius of the dot               |
| `--radio-dot-size`               | Size of the dot                        |
| `--radio-dot-transition`         | Transition of the dot                  |
| `--radio-ripple-transform`       | Transform of the ripple                |
| `--radio-size`                   | Width and height                       |
| `--radio-transition`             | Transition                             |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/radio) to try the demo.

<a href="https://weightless.dev/elements/radio" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-radio.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).