
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-list-item)

# ➤ wl-list-item

Display an item in a list.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property    | Attribute   | Type                   | Default    | Description                                      |
|-------------|-------------|------------------------|------------|--------------------------------------------------|
| `clickable` | `clickable` | `boolean`              | false      | Makes the element clickable.                     |
| `disabled`  | `disabled`  | `boolean`              | false      | Disables the element.                            |
| `name`      | `name`      | `string \| undefined`  |            | Name of the native form element.                 |
| `noRipple`  | `noRipple`  | `boolean`              | false      | Deactivates the ripple.                          |
| `readonly`  | `readonly`  | `boolean`              | false      | Makes the element readonly (disabled but tabbable) |
| `required`  | `required`  | `boolean`              | false      | Makes the element required in a form context.    |
| `role`      | `role`      | `AriaRole`             | "listitem" | Role of the list item.                           |
| `type`      | `type`      | `"button" \| "submit"` | "submit"   | Type of the button.                              |
| `value`     | `value`     | `string`               | ""         | Value of the form element.                       |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#slots)

## ➤ Slots

| Name     | Description      |
|----------|------------------|
|          | Default content. |
| `after`  | Right content.   |
| `before` | Left content.    |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property                         | Description                      |
|----------------------------------|----------------------------------|
| `--list-item-after-align-self`   | Alignment of the after slot      |
| `--list-item-after-margin`       | Margin of the after slot         |
| `--list-item-before-align-self`  | Alignment of the before slot     |
| `--list-item-before-margin`      | Margin of the before slot        |
| `--list-item-bg`                 | Default background               |
| `--list-item-bg-active`          | Background when active           |
| `--list-item-bg-active-hover`    | Background when active and hover |
| `--list-item-bg-disabled`        | Background when disabled         |
| `--list-item-bg-hover`           | Background when hover            |
| `--list-item-border-radius`      | Border radius                    |
| `--list-item-color`              | Default color                    |
| `--list-item-color-active`       | Color when active                |
| `--list-item-color-active-hover` | Color when active and hover      |
| `--list-item-color-disabled`     | Color when disabled              |
| `--list-item-color-hover`        | Color when hover                 |
| `--list-item-opacity-disabled`   | Opacity when disabled            |
| `--list-item-padding`            | Padding                          |
| `--list-item-transition`         | Transition                       |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/list-item) to try the demo.

<a href="https://weightless.dev/elements/list-item" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-list-item.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).