
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-icon)

# ➤ wl-icon

Symbols for common actions and items.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property | Attribute | Type       | Default        | Description        |
|----------|-----------|------------|----------------|--------------------|
| `role`   | `role`    | `AriaRole` | "presentation" | Roles of the icon. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#slots)

## ➤ Slots

| Name | Description       |
|------|-------------------|
|      | Name of the icon. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property      | Description      |
|---------------|------------------|
| `--icon-font` | Font family      |
| `--icon-size` | Width and height |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/icon) to try the demo.

<a href="https://weightless.dev/elements/icon" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-icon.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#-load-the-icon-font)

## ➤ ⚠️ Load the icon font

Currently the `wl-icon` has not been designed with no configuration in mind. If you don't provide your own icon font via the `--icon-font` CSS variable you need to load the default google font material icons. You can do that by inserting the following link in the `head` tag of your `index.html` file. Check out the available icons [here](https://material.io/tools/icons/).

```html
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
```


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).