
[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#wl-button)

# ➤ wl-button

Allow users to take actions, and make choices, with a single tap.


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#properties)

## ➤ Properties

| Property   | Attribute  | Type                   | Default  | Description                                      |
|------------|------------|------------------------|----------|--------------------------------------------------|
| `disabled` | `disabled` | `boolean`              | false    | Disables the element.                            |
| `fab`      | `fab`      | `boolean`              | false    | Makes the button round and squared.              |
| `flat`     | `flat`     | `boolean`              | false    | Makes the button flat.                           |
| `inverted` | `inverted` | `boolean`              | false    | Inverts the colors of the button.                |
| `name`     | `name`     | `string \| undefined`  |          | Name of the native form element.                 |
| `noRipple` | `noRipple` | `boolean`              | false    | Deactivates the ripple.                          |
| `outlined` | `outlined` | `boolean`              | false    | Makes the button outlined.                       |
| `readonly` | `readonly` | `boolean`              | false    | Makes the element readonly (disabled but tabbable) |
| `required` | `required` | `boolean`              | false    | Makes the element required in a form context.    |
| `role`     | `role`     | `AriaRole`             | "button" | Role of the button.                              |
| `type`     | `type`     | `"button" \| "submit"` | "submit" | Type of the button.                              |
| `value`    | `value`    | `string`               | ""       | Value of the form element.                       |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#slots)

## ➤ Slots

| Name | Description      |
|------|------------------|
|      | Default content. |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#css-custom-properties)

## ➤ CSS Custom Properties

| Property                      | Description                                      |
|-------------------------------|--------------------------------------------------|
| `--button-bg`                 | Default background                               |
| `--button-bg-active`          | Background when :active                          |
| `--button-bg-active-flat`     | Background when :active and flat attribute is present. |
| `--button-bg-disabled`        | Background when disabled                         |
| `--button-bg-hover`           | Background when :hover or :focus                 |
| `--button-border-outlined`    | Border when outlined attribute is present        |
| `--button-border-radius`      | Border radius                                    |
| `--button-color`              | Default color                                    |
| `--button-color-active`       | Button color when :active                        |
| `--button-color-disabled`     | Color when disabled                              |
| `--button-color-hover`        | Color when :hover or :focus                      |
| `--button-fab-size`           | Size of the button when fab attribute is present. |
| `--button-font-family`        | Font family                                      |
| `--button-font-size`          | Font size                                        |
| `--button-letter-spacing`     | Letter spacing                                   |
| `--button-padding`            | Padding                                          |
| `--button-shadow-color`       | Default shadow color                             |
| `--button-shadow-color-hover` | Shadow color when :hover or :focus               |
| `--button-transition`         | Transition                                       |



[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#usage)

## ➤ Usage

Go [here](https://weightless.dev/elements/button) to try the demo.

<a href="https://weightless.dev/elements/button" align="center">
  <img src="https://raw.githubusercontent.com/andreasbm/elements/master/screenshots/wl-button.png" width="700" />
</a>


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#contributors)

## ➤ Contributors
	

| [<img alt="Andreas Mehlsen" src="https://avatars1.githubusercontent.com/u/6267397?s=460&v=4" width="100">](https://twitter.com/andreasmehlsen) | [<img alt="You?" src="https://joeschmoe.io/api/v1/random" width="100">](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |
|:--------------------------------------------------:|:--------------------------------------------------:|
| [Andreas Mehlsen](https://twitter.com/andreasmehlsen) | [You?](https://github.com/andreasbm/weightless/blob/master/CONTRIBUTING.md) |


[![-----------------------------------------------------](https://raw.githubusercontent.com/andreasbm/readme/master/assets/lines/colored.png)](#license)

## ➤ License
	
Licensed under [MIT](https://opensource.org/licenses/MIT).