---
id: introduction
sidebar_position: 1
slug: /
---

# Introduction

Analog is a fullstack meta-framework for building applications and websites with [Angular](https://angular.dev).

Similar to other meta-frameworks such as Next.JS, Nuxt, SvelteKit, Qwik City, and others, Analog provides a similar experience, building on top of Angular.

## Features

- Supports Vite/Vitest/Playwright
- Server and deployment integrations powered by [Nitro](https://nitro.unjs.io)
- [File-based routing](/docs/features/routing/overview)
- [Server-side data fetching](/docs/features/data-fetching/server-side-data-fetching)
- [Support for using Markdown as content routes](/docs/features/routing/content)
- [API/server routes](/docs/features/api/overview)
- Hybrid [SSR](/docs/features/server/server-side-rendering)/[SSG support](/docs/features/server/static-site-generation)
- Supports Angular CLI/[Nx workspaces](/docs/integrations/nx)
- Supports [Angular components](/docs/packages/astro-angular/overview) with Astro

## Support Us

- Visit and Star the [GitHub Repo](https://github.com/analogjs/analog)
- Join the [Discord](https://chat.analogjs.org)
- Follow us on [Twitter](https://twitter.com/analogjs)
- Become a [Sponsor](/docs/sponsoring)
